"""add Project.timestamp_created

Revision ID: efa89c30e0a4
Revises: 97f444d47249
Create Date: 2023-12-20 10:06:52.139917

"""
from datetime import datetime
from datetime import timezone

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "efa89c30e0a4"
down_revision = "97f444d47249"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("project", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "timestamp_created",
                sa.DateTime(timezone=True),
                nullable=False,
                server_default=str(datetime(2000, 1, 1, tzinfo=timezone.utc)),
            )
        )

    with op.batch_alter_table("project", schema=None) as batch_op:
        batch_op.alter_column("timestamp_created", server_default=None)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("project", schema=None) as batch_op:
        batch_op.drop_column("timestamp_created")

    # ### end Alembic commands ###
