from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="heapgeneratorq",
    version="0.1.0",
    author="Devank U",
    author_email="devank@example.com",
    description="A comprehensive collection of algorithms and data structures implementations",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/DevankU/heapgeneratorq",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Intended Audience :: Education",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Education",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.7",
    install_requires=[],
    package_data={
        "heapgeneratorq": ["*.py"],
    },
    include_package_data=True,
)
