/*
 * Decompiled with CFR 0.152.
 */
package ca.dmoj.java;

import ca.dmoj.java.BigDecimalDisallowedException;
import ca.dmoj.java.BigIntegerDisallowedException;
import ca.dmoj.java.UnsafePrintStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;

public class SubmissionAgent {
    private static Throwable lastError;

    public static void premain(String string, Instrumentation instrumentation) throws UnsupportedEncodingException {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        if (string != null) {
            for (String string3 : string.split(",")) {
                if (string3.equals("unicode")) {
                    bl = true;
                }
                if (string3.equals("nobigmath")) {
                    bl2 = true;
                }
                if (!string3.startsWith("policy:")) continue;
                string2 = string3.split("policy:")[1];
            }
        }
        if (string2 == null) {
            throw new IllegalStateException("must specify policy file");
        }
        if (!new File(string2).exists()) {
            throw new IllegalStateException("policy file does not exist: " + string2);
        }
        final Thread thread = Thread.currentThread();
        if (bl2) {
            instrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
                    RuntimeException runtimeException = null;
                    if (string.equals("java/math/BigInteger")) {
                        runtimeException = new BigIntegerDisallowedException();
                    } else if (string.equals("java/math/BigDecimal")) {
                        runtimeException = new BigDecimalDisallowedException();
                    }
                    if (runtimeException != null) {
                        thread.getUncaughtExceptionHandler().uncaughtException(thread, runtimeException);
                    }
                    return byArray;
                }
            });
        }
        if (System.console() == null) {
            System.setOut(new UnsafePrintStream(new FileOutputStream(FileDescriptor.out), bl));
        } else {
            System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out), true));
        }
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                lastError = throwable;
                System.exit(1);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.flush();
                System.err.flush();
                try {
                    PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream("state")));
                    if (lastError != null) {
                        printStream.println(lastError.getClass().getName());
                    } else {
                        printStream.println("OK!");
                    }
                    printStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }));
        System.setProperty("java.security.policy", string2);
        System.setSecurityManager(new SecurityManager());
    }
}

