/*
 * Decompiled with CFR 0.152.
 */
package ca.dmoj.java;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class UnsafePrintStream
extends PrintStream {
    private BufferedWriter writer;
    private OutputStreamWriter bin;
    private OutputStream out;
    private boolean trouble;

    public UnsafePrintStream(OutputStream outputStream, boolean bl) throws UnsupportedEncodingException {
        super(new ByteArrayOutputStream());
        this.out = outputStream;
        this.bin = new OutputStreamWriter(outputStream, bl ? "UTF-8" : "ASCII");
        this.writer = new BufferedWriter(this.bin, 4096);
    }

    @Override
    public boolean checkError() {
        return this.trouble;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    @Override
    public void write(int n) {
        try {
            this.writer.write(n);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.flush();
        try {
            this.out.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    private void write(char[] cArray) {
        try {
            this.writer.write(cArray);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    private void newLine() {
        try {
            this.writer.write(10);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    @Override
    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(int n) {
        this.write(String.valueOf(n));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] cArray) {
        this.write(cArray);
    }

    @Override
    public void print(String string) {
        this.write(string == null ? "null" : string);
    }

    @Override
    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    @Override
    public void println() {
        this.newLine();
    }

    @Override
    public void println(boolean bl) {
        this.print(bl);
        this.newLine();
    }

    @Override
    public void println(char c) {
        this.print(c);
        this.newLine();
    }

    @Override
    public void println(int n) {
        this.print(n);
        this.newLine();
    }

    @Override
    public void println(long l) {
        this.print(l);
        this.newLine();
    }

    @Override
    public void println(float f) {
        this.print(f);
        this.newLine();
    }

    @Override
    public void println(double d) {
        this.print(d);
        this.newLine();
    }

    @Override
    public void println(char[] cArray) {
        this.print(cArray);
        this.newLine();
    }

    @Override
    public void println(String string) {
        this.print(string);
        this.newLine();
    }

    @Override
    public void println(Object object) {
        this.print(String.valueOf(object));
        this.newLine();
    }
}

