# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BranchProtectionArgs', 'BranchProtection']

@pulumi.input_type
class BranchProtectionArgs:
    def __init__(__self__, *,
                 pattern: pulumi.Input[_builtins.str],
                 repository_id: pulumi.Input[_builtins.str],
                 allows_deletions: Optional[pulumi.Input[_builtins.bool]] = None,
                 allows_force_pushes: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_push_bypassers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lock_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_conversation_resolution: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_signed_commits: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_linear_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_pull_request_reviews: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]]] = None,
                 required_status_checks: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]]] = None,
                 restrict_pushes: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]]] = None):
        """
        The set of arguments for constructing a BranchProtection resource.
        :param pulumi.Input[_builtins.str] pattern: Identifies the protection rule pattern.
        :param pulumi.Input[_builtins.str] repository_id: The name or node ID of the repository associated with this branch protection rule.
        :param pulumi.Input[_builtins.bool] allows_deletions: Boolean, setting this to `true` to allow the branch to be deleted.
        :param pulumi.Input[_builtins.bool] allows_force_pushes: Boolean, setting this to `true` to allow force pushes on the branch to everyone. Set it to `false` if you specify `force_push_bypassers`.
        :param pulumi.Input[_builtins.bool] enforce_admins: Boolean, setting this to `true` enforces status checks for repository administrators.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] force_push_bypassers: The list of actor Names/IDs that are allowed to bypass force push restrictions. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams. If the list is not empty, `allows_force_pushes` should be set to `false`.
        :param pulumi.Input[_builtins.bool] lock_branch: Boolean, Setting this to `true` will make the branch read-only and preventing any pushes to it. Defaults to `false`
        :param pulumi.Input[_builtins.bool] require_conversation_resolution: Boolean, setting this to `true` requires all conversations on code must be resolved before a pull request can be merged.
        :param pulumi.Input[_builtins.bool] require_signed_commits: Boolean, setting this to `true` requires all commits to be signed with GPG.
        :param pulumi.Input[_builtins.bool] required_linear_history: Boolean, setting this to `true` enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]] required_pull_request_reviews: Enforce restrictions for pull request reviews. See Required Pull Request Reviews below for details.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]] required_status_checks: Enforce restrictions for required status checks. See Required Status Checks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]] restrict_pushes: Restrict pushes to matching branches. See Restrict Pushes below for details.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "repository_id", repository_id)
        if allows_deletions is not None:
            pulumi.set(__self__, "allows_deletions", allows_deletions)
        if allows_force_pushes is not None:
            pulumi.set(__self__, "allows_force_pushes", allows_force_pushes)
        if enforce_admins is not None:
            pulumi.set(__self__, "enforce_admins", enforce_admins)
        if force_push_bypassers is not None:
            pulumi.set(__self__, "force_push_bypassers", force_push_bypassers)
        if lock_branch is not None:
            pulumi.set(__self__, "lock_branch", lock_branch)
        if require_conversation_resolution is not None:
            pulumi.set(__self__, "require_conversation_resolution", require_conversation_resolution)
        if require_signed_commits is not None:
            pulumi.set(__self__, "require_signed_commits", require_signed_commits)
        if required_linear_history is not None:
            pulumi.set(__self__, "required_linear_history", required_linear_history)
        if required_pull_request_reviews is not None:
            pulumi.set(__self__, "required_pull_request_reviews", required_pull_request_reviews)
        if required_status_checks is not None:
            pulumi.set(__self__, "required_status_checks", required_status_checks)
        if restrict_pushes is not None:
            pulumi.set(__self__, "restrict_pushes", restrict_pushes)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the protection rule pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name or node ID of the repository associated with this branch protection rule.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="allowsDeletions")
    def allows_deletions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` to allow the branch to be deleted.
        """
        return pulumi.get(self, "allows_deletions")

    @allows_deletions.setter
    def allows_deletions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allows_deletions", value)

    @_builtins.property
    @pulumi.getter(name="allowsForcePushes")
    def allows_force_pushes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` to allow force pushes on the branch to everyone. Set it to `false` if you specify `force_push_bypassers`.
        """
        return pulumi.get(self, "allows_force_pushes")

    @allows_force_pushes.setter
    def allows_force_pushes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allows_force_pushes", value)

    @_builtins.property
    @pulumi.getter(name="enforceAdmins")
    def enforce_admins(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` enforces status checks for repository administrators.
        """
        return pulumi.get(self, "enforce_admins")

    @enforce_admins.setter
    def enforce_admins(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_admins", value)

    @_builtins.property
    @pulumi.getter(name="forcePushBypassers")
    def force_push_bypassers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of actor Names/IDs that are allowed to bypass force push restrictions. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams. If the list is not empty, `allows_force_pushes` should be set to `false`.
        """
        return pulumi.get(self, "force_push_bypassers")

    @force_push_bypassers.setter
    def force_push_bypassers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "force_push_bypassers", value)

    @_builtins.property
    @pulumi.getter(name="lockBranch")
    def lock_branch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, Setting this to `true` will make the branch read-only and preventing any pushes to it. Defaults to `false`
        """
        return pulumi.get(self, "lock_branch")

    @lock_branch.setter
    def lock_branch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lock_branch", value)

    @_builtins.property
    @pulumi.getter(name="requireConversationResolution")
    def require_conversation_resolution(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` requires all conversations on code must be resolved before a pull request can be merged.
        """
        return pulumi.get(self, "require_conversation_resolution")

    @require_conversation_resolution.setter
    def require_conversation_resolution(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_conversation_resolution", value)

    @_builtins.property
    @pulumi.getter(name="requireSignedCommits")
    def require_signed_commits(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` requires all commits to be signed with GPG.
        """
        return pulumi.get(self, "require_signed_commits")

    @require_signed_commits.setter
    def require_signed_commits(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_signed_commits", value)

    @_builtins.property
    @pulumi.getter(name="requiredLinearHistory")
    def required_linear_history(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch
        """
        return pulumi.get(self, "required_linear_history")

    @required_linear_history.setter
    def required_linear_history(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required_linear_history", value)

    @_builtins.property
    @pulumi.getter(name="requiredPullRequestReviews")
    def required_pull_request_reviews(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]]]:
        """
        Enforce restrictions for pull request reviews. See Required Pull Request Reviews below for details.
        """
        return pulumi.get(self, "required_pull_request_reviews")

    @required_pull_request_reviews.setter
    def required_pull_request_reviews(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]]]):
        pulumi.set(self, "required_pull_request_reviews", value)

    @_builtins.property
    @pulumi.getter(name="requiredStatusChecks")
    def required_status_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]]]:
        """
        Enforce restrictions for required status checks. See Required Status Checks below for details.
        """
        return pulumi.get(self, "required_status_checks")

    @required_status_checks.setter
    def required_status_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]]]):
        pulumi.set(self, "required_status_checks", value)

    @_builtins.property
    @pulumi.getter(name="restrictPushes")
    def restrict_pushes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]]]:
        """
        Restrict pushes to matching branches. See Restrict Pushes below for details.
        """
        return pulumi.get(self, "restrict_pushes")

    @restrict_pushes.setter
    def restrict_pushes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]]]):
        pulumi.set(self, "restrict_pushes", value)


@pulumi.input_type
class _BranchProtectionState:
    def __init__(__self__, *,
                 allows_deletions: Optional[pulumi.Input[_builtins.bool]] = None,
                 allows_force_pushes: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_push_bypassers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lock_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 require_conversation_resolution: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_signed_commits: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_linear_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_pull_request_reviews: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]]] = None,
                 required_status_checks: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]]] = None,
                 restrict_pushes: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]]] = None):
        """
        Input properties used for looking up and filtering BranchProtection resources.
        :param pulumi.Input[_builtins.bool] allows_deletions: Boolean, setting this to `true` to allow the branch to be deleted.
        :param pulumi.Input[_builtins.bool] allows_force_pushes: Boolean, setting this to `true` to allow force pushes on the branch to everyone. Set it to `false` if you specify `force_push_bypassers`.
        :param pulumi.Input[_builtins.bool] enforce_admins: Boolean, setting this to `true` enforces status checks for repository administrators.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] force_push_bypassers: The list of actor Names/IDs that are allowed to bypass force push restrictions. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams. If the list is not empty, `allows_force_pushes` should be set to `false`.
        :param pulumi.Input[_builtins.bool] lock_branch: Boolean, Setting this to `true` will make the branch read-only and preventing any pushes to it. Defaults to `false`
        :param pulumi.Input[_builtins.str] pattern: Identifies the protection rule pattern.
        :param pulumi.Input[_builtins.str] repository_id: The name or node ID of the repository associated with this branch protection rule.
        :param pulumi.Input[_builtins.bool] require_conversation_resolution: Boolean, setting this to `true` requires all conversations on code must be resolved before a pull request can be merged.
        :param pulumi.Input[_builtins.bool] require_signed_commits: Boolean, setting this to `true` requires all commits to be signed with GPG.
        :param pulumi.Input[_builtins.bool] required_linear_history: Boolean, setting this to `true` enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]] required_pull_request_reviews: Enforce restrictions for pull request reviews. See Required Pull Request Reviews below for details.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]] required_status_checks: Enforce restrictions for required status checks. See Required Status Checks below for details.
        :param pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]] restrict_pushes: Restrict pushes to matching branches. See Restrict Pushes below for details.
        """
        if allows_deletions is not None:
            pulumi.set(__self__, "allows_deletions", allows_deletions)
        if allows_force_pushes is not None:
            pulumi.set(__self__, "allows_force_pushes", allows_force_pushes)
        if enforce_admins is not None:
            pulumi.set(__self__, "enforce_admins", enforce_admins)
        if force_push_bypassers is not None:
            pulumi.set(__self__, "force_push_bypassers", force_push_bypassers)
        if lock_branch is not None:
            pulumi.set(__self__, "lock_branch", lock_branch)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if require_conversation_resolution is not None:
            pulumi.set(__self__, "require_conversation_resolution", require_conversation_resolution)
        if require_signed_commits is not None:
            pulumi.set(__self__, "require_signed_commits", require_signed_commits)
        if required_linear_history is not None:
            pulumi.set(__self__, "required_linear_history", required_linear_history)
        if required_pull_request_reviews is not None:
            pulumi.set(__self__, "required_pull_request_reviews", required_pull_request_reviews)
        if required_status_checks is not None:
            pulumi.set(__self__, "required_status_checks", required_status_checks)
        if restrict_pushes is not None:
            pulumi.set(__self__, "restrict_pushes", restrict_pushes)

    @_builtins.property
    @pulumi.getter(name="allowsDeletions")
    def allows_deletions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` to allow the branch to be deleted.
        """
        return pulumi.get(self, "allows_deletions")

    @allows_deletions.setter
    def allows_deletions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allows_deletions", value)

    @_builtins.property
    @pulumi.getter(name="allowsForcePushes")
    def allows_force_pushes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` to allow force pushes on the branch to everyone. Set it to `false` if you specify `force_push_bypassers`.
        """
        return pulumi.get(self, "allows_force_pushes")

    @allows_force_pushes.setter
    def allows_force_pushes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allows_force_pushes", value)

    @_builtins.property
    @pulumi.getter(name="enforceAdmins")
    def enforce_admins(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` enforces status checks for repository administrators.
        """
        return pulumi.get(self, "enforce_admins")

    @enforce_admins.setter
    def enforce_admins(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce_admins", value)

    @_builtins.property
    @pulumi.getter(name="forcePushBypassers")
    def force_push_bypassers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of actor Names/IDs that are allowed to bypass force push restrictions. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams. If the list is not empty, `allows_force_pushes` should be set to `false`.
        """
        return pulumi.get(self, "force_push_bypassers")

    @force_push_bypassers.setter
    def force_push_bypassers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "force_push_bypassers", value)

    @_builtins.property
    @pulumi.getter(name="lockBranch")
    def lock_branch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, Setting this to `true` will make the branch read-only and preventing any pushes to it. Defaults to `false`
        """
        return pulumi.get(self, "lock_branch")

    @lock_branch.setter
    def lock_branch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lock_branch", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the protection rule pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name or node ID of the repository associated with this branch protection rule.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="requireConversationResolution")
    def require_conversation_resolution(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` requires all conversations on code must be resolved before a pull request can be merged.
        """
        return pulumi.get(self, "require_conversation_resolution")

    @require_conversation_resolution.setter
    def require_conversation_resolution(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_conversation_resolution", value)

    @_builtins.property
    @pulumi.getter(name="requireSignedCommits")
    def require_signed_commits(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` requires all commits to be signed with GPG.
        """
        return pulumi.get(self, "require_signed_commits")

    @require_signed_commits.setter
    def require_signed_commits(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_signed_commits", value)

    @_builtins.property
    @pulumi.getter(name="requiredLinearHistory")
    def required_linear_history(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean, setting this to `true` enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch
        """
        return pulumi.get(self, "required_linear_history")

    @required_linear_history.setter
    def required_linear_history(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required_linear_history", value)

    @_builtins.property
    @pulumi.getter(name="requiredPullRequestReviews")
    def required_pull_request_reviews(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]]]:
        """
        Enforce restrictions for pull request reviews. See Required Pull Request Reviews below for details.
        """
        return pulumi.get(self, "required_pull_request_reviews")

    @required_pull_request_reviews.setter
    def required_pull_request_reviews(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredPullRequestReviewArgs']]]]):
        pulumi.set(self, "required_pull_request_reviews", value)

    @_builtins.property
    @pulumi.getter(name="requiredStatusChecks")
    def required_status_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]]]:
        """
        Enforce restrictions for required status checks. See Required Status Checks below for details.
        """
        return pulumi.get(self, "required_status_checks")

    @required_status_checks.setter
    def required_status_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRequiredStatusCheckArgs']]]]):
        pulumi.set(self, "required_status_checks", value)

    @_builtins.property
    @pulumi.getter(name="restrictPushes")
    def restrict_pushes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]]]:
        """
        Restrict pushes to matching branches. See Restrict Pushes below for details.
        """
        return pulumi.get(self, "restrict_pushes")

    @restrict_pushes.setter
    def restrict_pushes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BranchProtectionRestrictPushArgs']]]]):
        pulumi.set(self, "restrict_pushes", value)


@pulumi.type_token("github:index/branchProtection:BranchProtection")
class BranchProtection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows_deletions: Optional[pulumi.Input[_builtins.bool]] = None,
                 allows_force_pushes: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_push_bypassers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lock_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 require_conversation_resolution: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_signed_commits: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_linear_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_pull_request_reviews: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredPullRequestReviewArgs', 'BranchProtectionRequiredPullRequestReviewArgsDict']]]]] = None,
                 required_status_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredStatusCheckArgs', 'BranchProtectionRequiredStatusCheckArgsDict']]]]] = None,
                 restrict_pushes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRestrictPushArgs', 'BranchProtectionRestrictPushArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example_repository = github.Repository("example", name="test")
        example = github.get_user(username="example")
        example_team = github.Team("example", name="Example Name")
        # Protect the main branch of the foo repository. Additionally, require that
        # the "ci/travis" context to be passing and only allow the engineers team merge
        # to the branch.
        example_branch_protection = github.BranchProtection("example",
            repository_id=example_repository.node_id,
            pattern="main",
            enforce_admins=True,
            allows_deletions=True,
            required_status_checks=[{
                "strict": False,
                "contexts": ["ci/travis"],
            }],
            required_pull_request_reviews=[{
                "dismiss_stale_reviews": True,
                "restrict_dismissals": True,
                "dismissal_restrictions": [
                    example.node_id,
                    example_team.node_id,
                    "/exampleuser",
                    "exampleorganization/exampleteam",
                ],
            }],
            restrict_pushes=[{
                "push_allowances": [
                    example.node_id,
                    "/exampleuser",
                    "exampleorganization/exampleteam",
                ],
            }],
            force_push_bypassers=[
                example.node_id,
                "/exampleuser",
                "exampleorganization/exampleteam",
            ])
        example_team_repository = github.TeamRepository("example",
            team_id=example_team.id,
            repository=example_repository.name,
            permission="pull")
        ```

        ## Import

        GitHub Branch Protection can be imported using an ID made up of `repository:pattern`, e.g.

        ```sh
        $ pulumi import github:index/branchProtection:BranchProtection terraform terraform:main
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allows_deletions: Boolean, setting this to `true` to allow the branch to be deleted.
        :param pulumi.Input[_builtins.bool] allows_force_pushes: Boolean, setting this to `true` to allow force pushes on the branch to everyone. Set it to `false` if you specify `force_push_bypassers`.
        :param pulumi.Input[_builtins.bool] enforce_admins: Boolean, setting this to `true` enforces status checks for repository administrators.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] force_push_bypassers: The list of actor Names/IDs that are allowed to bypass force push restrictions. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams. If the list is not empty, `allows_force_pushes` should be set to `false`.
        :param pulumi.Input[_builtins.bool] lock_branch: Boolean, Setting this to `true` will make the branch read-only and preventing any pushes to it. Defaults to `false`
        :param pulumi.Input[_builtins.str] pattern: Identifies the protection rule pattern.
        :param pulumi.Input[_builtins.str] repository_id: The name or node ID of the repository associated with this branch protection rule.
        :param pulumi.Input[_builtins.bool] require_conversation_resolution: Boolean, setting this to `true` requires all conversations on code must be resolved before a pull request can be merged.
        :param pulumi.Input[_builtins.bool] require_signed_commits: Boolean, setting this to `true` requires all commits to be signed with GPG.
        :param pulumi.Input[_builtins.bool] required_linear_history: Boolean, setting this to `true` enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredPullRequestReviewArgs', 'BranchProtectionRequiredPullRequestReviewArgsDict']]]] required_pull_request_reviews: Enforce restrictions for pull request reviews. See Required Pull Request Reviews below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredStatusCheckArgs', 'BranchProtectionRequiredStatusCheckArgsDict']]]] required_status_checks: Enforce restrictions for required status checks. See Required Status Checks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRestrictPushArgs', 'BranchProtectionRestrictPushArgsDict']]]] restrict_pushes: Restrict pushes to matching branches. See Restrict Pushes below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BranchProtectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example_repository = github.Repository("example", name="test")
        example = github.get_user(username="example")
        example_team = github.Team("example", name="Example Name")
        # Protect the main branch of the foo repository. Additionally, require that
        # the "ci/travis" context to be passing and only allow the engineers team merge
        # to the branch.
        example_branch_protection = github.BranchProtection("example",
            repository_id=example_repository.node_id,
            pattern="main",
            enforce_admins=True,
            allows_deletions=True,
            required_status_checks=[{
                "strict": False,
                "contexts": ["ci/travis"],
            }],
            required_pull_request_reviews=[{
                "dismiss_stale_reviews": True,
                "restrict_dismissals": True,
                "dismissal_restrictions": [
                    example.node_id,
                    example_team.node_id,
                    "/exampleuser",
                    "exampleorganization/exampleteam",
                ],
            }],
            restrict_pushes=[{
                "push_allowances": [
                    example.node_id,
                    "/exampleuser",
                    "exampleorganization/exampleteam",
                ],
            }],
            force_push_bypassers=[
                example.node_id,
                "/exampleuser",
                "exampleorganization/exampleteam",
            ])
        example_team_repository = github.TeamRepository("example",
            team_id=example_team.id,
            repository=example_repository.name,
            permission="pull")
        ```

        ## Import

        GitHub Branch Protection can be imported using an ID made up of `repository:pattern`, e.g.

        ```sh
        $ pulumi import github:index/branchProtection:BranchProtection terraform terraform:main
        ```

        :param str resource_name: The name of the resource.
        :param BranchProtectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BranchProtectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows_deletions: Optional[pulumi.Input[_builtins.bool]] = None,
                 allows_force_pushes: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_admins: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_push_bypassers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lock_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 require_conversation_resolution: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_signed_commits: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_linear_history: Optional[pulumi.Input[_builtins.bool]] = None,
                 required_pull_request_reviews: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredPullRequestReviewArgs', 'BranchProtectionRequiredPullRequestReviewArgsDict']]]]] = None,
                 required_status_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredStatusCheckArgs', 'BranchProtectionRequiredStatusCheckArgsDict']]]]] = None,
                 restrict_pushes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRestrictPushArgs', 'BranchProtectionRestrictPushArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BranchProtectionArgs.__new__(BranchProtectionArgs)

            __props__.__dict__["allows_deletions"] = allows_deletions
            __props__.__dict__["allows_force_pushes"] = allows_force_pushes
            __props__.__dict__["enforce_admins"] = enforce_admins
            __props__.__dict__["force_push_bypassers"] = force_push_bypassers
            __props__.__dict__["lock_branch"] = lock_branch
            if pattern is None and not opts.urn:
                raise TypeError("Missing required property 'pattern'")
            __props__.__dict__["pattern"] = pattern
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["require_conversation_resolution"] = require_conversation_resolution
            __props__.__dict__["require_signed_commits"] = require_signed_commits
            __props__.__dict__["required_linear_history"] = required_linear_history
            __props__.__dict__["required_pull_request_reviews"] = required_pull_request_reviews
            __props__.__dict__["required_status_checks"] = required_status_checks
            __props__.__dict__["restrict_pushes"] = restrict_pushes
        super(BranchProtection, __self__).__init__(
            'github:index/branchProtection:BranchProtection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allows_deletions: Optional[pulumi.Input[_builtins.bool]] = None,
            allows_force_pushes: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_admins: Optional[pulumi.Input[_builtins.bool]] = None,
            force_push_bypassers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            lock_branch: Optional[pulumi.Input[_builtins.bool]] = None,
            pattern: Optional[pulumi.Input[_builtins.str]] = None,
            repository_id: Optional[pulumi.Input[_builtins.str]] = None,
            require_conversation_resolution: Optional[pulumi.Input[_builtins.bool]] = None,
            require_signed_commits: Optional[pulumi.Input[_builtins.bool]] = None,
            required_linear_history: Optional[pulumi.Input[_builtins.bool]] = None,
            required_pull_request_reviews: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredPullRequestReviewArgs', 'BranchProtectionRequiredPullRequestReviewArgsDict']]]]] = None,
            required_status_checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredStatusCheckArgs', 'BranchProtectionRequiredStatusCheckArgsDict']]]]] = None,
            restrict_pushes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRestrictPushArgs', 'BranchProtectionRestrictPushArgsDict']]]]] = None) -> 'BranchProtection':
        """
        Get an existing BranchProtection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allows_deletions: Boolean, setting this to `true` to allow the branch to be deleted.
        :param pulumi.Input[_builtins.bool] allows_force_pushes: Boolean, setting this to `true` to allow force pushes on the branch to everyone. Set it to `false` if you specify `force_push_bypassers`.
        :param pulumi.Input[_builtins.bool] enforce_admins: Boolean, setting this to `true` enforces status checks for repository administrators.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] force_push_bypassers: The list of actor Names/IDs that are allowed to bypass force push restrictions. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams. If the list is not empty, `allows_force_pushes` should be set to `false`.
        :param pulumi.Input[_builtins.bool] lock_branch: Boolean, Setting this to `true` will make the branch read-only and preventing any pushes to it. Defaults to `false`
        :param pulumi.Input[_builtins.str] pattern: Identifies the protection rule pattern.
        :param pulumi.Input[_builtins.str] repository_id: The name or node ID of the repository associated with this branch protection rule.
        :param pulumi.Input[_builtins.bool] require_conversation_resolution: Boolean, setting this to `true` requires all conversations on code must be resolved before a pull request can be merged.
        :param pulumi.Input[_builtins.bool] require_signed_commits: Boolean, setting this to `true` requires all commits to be signed with GPG.
        :param pulumi.Input[_builtins.bool] required_linear_history: Boolean, setting this to `true` enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredPullRequestReviewArgs', 'BranchProtectionRequiredPullRequestReviewArgsDict']]]] required_pull_request_reviews: Enforce restrictions for pull request reviews. See Required Pull Request Reviews below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRequiredStatusCheckArgs', 'BranchProtectionRequiredStatusCheckArgsDict']]]] required_status_checks: Enforce restrictions for required status checks. See Required Status Checks below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BranchProtectionRestrictPushArgs', 'BranchProtectionRestrictPushArgsDict']]]] restrict_pushes: Restrict pushes to matching branches. See Restrict Pushes below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BranchProtectionState.__new__(_BranchProtectionState)

        __props__.__dict__["allows_deletions"] = allows_deletions
        __props__.__dict__["allows_force_pushes"] = allows_force_pushes
        __props__.__dict__["enforce_admins"] = enforce_admins
        __props__.__dict__["force_push_bypassers"] = force_push_bypassers
        __props__.__dict__["lock_branch"] = lock_branch
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["require_conversation_resolution"] = require_conversation_resolution
        __props__.__dict__["require_signed_commits"] = require_signed_commits
        __props__.__dict__["required_linear_history"] = required_linear_history
        __props__.__dict__["required_pull_request_reviews"] = required_pull_request_reviews
        __props__.__dict__["required_status_checks"] = required_status_checks
        __props__.__dict__["restrict_pushes"] = restrict_pushes
        return BranchProtection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowsDeletions")
    def allows_deletions(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean, setting this to `true` to allow the branch to be deleted.
        """
        return pulumi.get(self, "allows_deletions")

    @_builtins.property
    @pulumi.getter(name="allowsForcePushes")
    def allows_force_pushes(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean, setting this to `true` to allow force pushes on the branch to everyone. Set it to `false` if you specify `force_push_bypassers`.
        """
        return pulumi.get(self, "allows_force_pushes")

    @_builtins.property
    @pulumi.getter(name="enforceAdmins")
    def enforce_admins(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean, setting this to `true` enforces status checks for repository administrators.
        """
        return pulumi.get(self, "enforce_admins")

    @_builtins.property
    @pulumi.getter(name="forcePushBypassers")
    def force_push_bypassers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of actor Names/IDs that are allowed to bypass force push restrictions. Actor names must either begin with a "/" for users or the organization name followed by a "/" for teams. If the list is not empty, `allows_force_pushes` should be set to `false`.
        """
        return pulumi.get(self, "force_push_bypassers")

    @_builtins.property
    @pulumi.getter(name="lockBranch")
    def lock_branch(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean, Setting this to `true` will make the branch read-only and preventing any pushes to it. Defaults to `false`
        """
        return pulumi.get(self, "lock_branch")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the protection rule pattern.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name or node ID of the repository associated with this branch protection rule.
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="requireConversationResolution")
    def require_conversation_resolution(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean, setting this to `true` requires all conversations on code must be resolved before a pull request can be merged.
        """
        return pulumi.get(self, "require_conversation_resolution")

    @_builtins.property
    @pulumi.getter(name="requireSignedCommits")
    def require_signed_commits(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean, setting this to `true` requires all commits to be signed with GPG.
        """
        return pulumi.get(self, "require_signed_commits")

    @_builtins.property
    @pulumi.getter(name="requiredLinearHistory")
    def required_linear_history(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean, setting this to `true` enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch
        """
        return pulumi.get(self, "required_linear_history")

    @_builtins.property
    @pulumi.getter(name="requiredPullRequestReviews")
    def required_pull_request_reviews(self) -> pulumi.Output[Optional[Sequence['outputs.BranchProtectionRequiredPullRequestReview']]]:
        """
        Enforce restrictions for pull request reviews. See Required Pull Request Reviews below for details.
        """
        return pulumi.get(self, "required_pull_request_reviews")

    @_builtins.property
    @pulumi.getter(name="requiredStatusChecks")
    def required_status_checks(self) -> pulumi.Output[Optional[Sequence['outputs.BranchProtectionRequiredStatusCheck']]]:
        """
        Enforce restrictions for required status checks. See Required Status Checks below for details.
        """
        return pulumi.get(self, "required_status_checks")

    @_builtins.property
    @pulumi.getter(name="restrictPushes")
    def restrict_pushes(self) -> pulumi.Output[Optional[Sequence['outputs.BranchProtectionRestrictPush']]]:
        """
        Restrict pushes to matching branches. See Restrict Pushes below for details.
        """
        return pulumi.get(self, "restrict_pushes")

