# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetActionsRegistrationTokenResult',
    'AwaitableGetActionsRegistrationTokenResult',
    'get_actions_registration_token',
    'get_actions_registration_token_output',
]

@pulumi.output_type
class GetActionsRegistrationTokenResult:
    """
    A collection of values returned by getActionsRegistrationToken.
    """
    def __init__(__self__, expires_at=None, id=None, repository=None, token=None):
        if expires_at and not isinstance(expires_at, int):
            raise TypeError("Expected argument 'expires_at' to be a int")
        pulumi.set(__self__, "expires_at", expires_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> _builtins.int:
        """
        The token expiration date.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The token that has been retrieved.
        """
        return pulumi.get(self, "token")


class AwaitableGetActionsRegistrationTokenResult(GetActionsRegistrationTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActionsRegistrationTokenResult(
            expires_at=self.expires_at,
            id=self.id,
            repository=self.repository,
            token=self.token)


def get_actions_registration_token(repository: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActionsRegistrationTokenResult:
    """
    Use this data source to retrieve a GitHub Actions repository registration token. This token can then be used to register a self-hosted runner.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_actions_registration_token(repository="example_repo")
    ```


    :param _builtins.str repository: Name of the repository to get a GitHub Actions registration token for.
    """
    __args__ = dict()
    __args__['repository'] = repository
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getActionsRegistrationToken:getActionsRegistrationToken', __args__, opts=opts, typ=GetActionsRegistrationTokenResult).value

    return AwaitableGetActionsRegistrationTokenResult(
        expires_at=pulumi.get(__ret__, 'expires_at'),
        id=pulumi.get(__ret__, 'id'),
        repository=pulumi.get(__ret__, 'repository'),
        token=pulumi.get(__ret__, 'token'))
def get_actions_registration_token_output(repository: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetActionsRegistrationTokenResult]:
    """
    Use this data source to retrieve a GitHub Actions repository registration token. This token can then be used to register a self-hosted runner.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_actions_registration_token(repository="example_repo")
    ```


    :param _builtins.str repository: Name of the repository to get a GitHub Actions registration token for.
    """
    __args__ = dict()
    __args__['repository'] = repository
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getActionsRegistrationToken:getActionsRegistrationToken', __args__, opts=opts, typ=GetActionsRegistrationTokenResult)
    return __ret__.apply(lambda __response__: GetActionsRegistrationTokenResult(
        expires_at=pulumi.get(__response__, 'expires_at'),
        id=pulumi.get(__response__, 'id'),
        repository=pulumi.get(__response__, 'repository'),
        token=pulumi.get(__response__, 'token')))
