# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetOrganizationRepositoryRolesResult',
    'AwaitableGetOrganizationRepositoryRolesResult',
    'get_organization_repository_roles',
    'get_organization_repository_roles_output',
]

@pulumi.output_type
class GetOrganizationRepositoryRolesResult:
    """
    A collection of values returned by getOrganizationRepositoryRoles.
    """
    def __init__(__self__, id=None, roles=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetOrganizationRepositoryRolesRoleResult']:
        """
        (Set of Object, see schema) Available organization repository roles.
        """
        return pulumi.get(self, "roles")


class AwaitableGetOrganizationRepositoryRolesResult(GetOrganizationRepositoryRolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationRepositoryRolesResult(
            id=self.id,
            roles=self.roles)


def get_organization_repository_roles(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationRepositoryRolesResult:
    """
    Lookup all custom repository roles in an organization.

    > **Note**: Custom organization repository roles are currently only available in GitHub Enterprise Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_repository_roles()
    ```

    ## Nested Schema for `roles`

    ### Read-Only

    - `role_id` (Number) The ID of the organization repository role.
    - `name` (String) The name of the organization repository role.
    - `description` (String) The description of the organization repository role.
    - `base_role` (String) The system role from which this role inherits permissions.
    - `permissions` (Set of String) The permissions included in this role.
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getOrganizationRepositoryRoles:getOrganizationRepositoryRoles', __args__, opts=opts, typ=GetOrganizationRepositoryRolesResult).value

    return AwaitableGetOrganizationRepositoryRolesResult(
        id=pulumi.get(__ret__, 'id'),
        roles=pulumi.get(__ret__, 'roles'))
def get_organization_repository_roles_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationRepositoryRolesResult]:
    """
    Lookup all custom repository roles in an organization.

    > **Note**: Custom organization repository roles are currently only available in GitHub Enterprise Cloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_repository_roles()
    ```

    ## Nested Schema for `roles`

    ### Read-Only

    - `role_id` (Number) The ID of the organization repository role.
    - `name` (String) The name of the organization repository role.
    - `description` (String) The description of the organization repository role.
    - `base_role` (String) The system role from which this role inherits permissions.
    - `permissions` (Set of String) The permissions included in this role.
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getOrganizationRepositoryRoles:getOrganizationRepositoryRoles', __args__, opts=opts, typ=GetOrganizationRepositoryRolesResult)
    return __ret__.apply(lambda __response__: GetOrganizationRepositoryRolesResult(
        id=pulumi.get(__response__, 'id'),
        roles=pulumi.get(__response__, 'roles')))
