# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetOrganizationRoleTeamsResult',
    'AwaitableGetOrganizationRoleTeamsResult',
    'get_organization_role_teams',
    'get_organization_role_teams_output',
]

@pulumi.output_type
class GetOrganizationRoleTeamsResult:
    """
    A collection of values returned by getOrganizationRoleTeams.
    """
    def __init__(__self__, id=None, role_id=None, teams=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if role_id and not isinstance(role_id, int):
            raise TypeError("Expected argument 'role_id' to be a int")
        pulumi.set(__self__, "role_id", role_id)
        if teams and not isinstance(teams, list):
            raise TypeError("Expected argument 'teams' to be a list")
        pulumi.set(__self__, "teams", teams)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> _builtins.int:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Sequence['outputs.GetOrganizationRoleTeamsTeamResult']:
        """
        (Set of Object, see schema) Teams assigned to the organization role.
        """
        return pulumi.get(self, "teams")


class AwaitableGetOrganizationRoleTeamsResult(GetOrganizationRoleTeamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationRoleTeamsResult(
            id=self.id,
            role_id=self.role_id,
            teams=self.teams)


def get_organization_role_teams(role_id: Optional[_builtins.int] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationRoleTeamsResult:
    """
    Lookup all teams assigned to a custom organization role.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_role_teams(role_id=1234)
    ```

    ## Nested Schema for `teams`

    ### Read-Only

    - `team_id` (Number) The ID of the team.
    - `slug` (String) The Slug of the team name.
    - `name` (String) The name of the team.
    - `permission` (String) The permission that the team will have for its repositories.


    :param _builtins.int role_id: The ID of the organization role.
    """
    __args__ = dict()
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getOrganizationRoleTeams:getOrganizationRoleTeams', __args__, opts=opts, typ=GetOrganizationRoleTeamsResult).value

    return AwaitableGetOrganizationRoleTeamsResult(
        id=pulumi.get(__ret__, 'id'),
        role_id=pulumi.get(__ret__, 'role_id'),
        teams=pulumi.get(__ret__, 'teams'))
def get_organization_role_teams_output(role_id: Optional[pulumi.Input[_builtins.int]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationRoleTeamsResult]:
    """
    Lookup all teams assigned to a custom organization role.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_role_teams(role_id=1234)
    ```

    ## Nested Schema for `teams`

    ### Read-Only

    - `team_id` (Number) The ID of the team.
    - `slug` (String) The Slug of the team name.
    - `name` (String) The name of the team.
    - `permission` (String) The permission that the team will have for its repositories.


    :param _builtins.int role_id: The ID of the organization role.
    """
    __args__ = dict()
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getOrganizationRoleTeams:getOrganizationRoleTeams', __args__, opts=opts, typ=GetOrganizationRoleTeamsResult)
    return __ret__.apply(lambda __response__: GetOrganizationRoleTeamsResult(
        id=pulumi.get(__response__, 'id'),
        role_id=pulumi.get(__response__, 'role_id'),
        teams=pulumi.get(__response__, 'teams')))
