# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetOrganizationRoleUsersResult',
    'AwaitableGetOrganizationRoleUsersResult',
    'get_organization_role_users',
    'get_organization_role_users_output',
]

@pulumi.output_type
class GetOrganizationRoleUsersResult:
    """
    A collection of values returned by getOrganizationRoleUsers.
    """
    def __init__(__self__, id=None, role_id=None, users=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if role_id and not isinstance(role_id, int):
            raise TypeError("Expected argument 'role_id' to be a int")
        pulumi.set(__self__, "role_id", role_id)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> _builtins.int:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetOrganizationRoleUsersUserResult']:
        """
        (Set of Object, see schema) Users assigned to the organization role.
        """
        return pulumi.get(self, "users")


class AwaitableGetOrganizationRoleUsersResult(GetOrganizationRoleUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationRoleUsersResult(
            id=self.id,
            role_id=self.role_id,
            users=self.users)


def get_organization_role_users(role_id: Optional[_builtins.int] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationRoleUsersResult:
    """
    Lookup all users assigned to a custom organization role.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_role_users(role_id=1234)
    ```

    ## Nested Schema for `users`

    ### Read-Only

    - `user_id` (Number) The ID of the user.
    - `login` (String) The login for the GitHub user account.


    :param _builtins.int role_id: The ID of the organization role.
    """
    __args__ = dict()
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getOrganizationRoleUsers:getOrganizationRoleUsers', __args__, opts=opts, typ=GetOrganizationRoleUsersResult).value

    return AwaitableGetOrganizationRoleUsersResult(
        id=pulumi.get(__ret__, 'id'),
        role_id=pulumi.get(__ret__, 'role_id'),
        users=pulumi.get(__ret__, 'users'))
def get_organization_role_users_output(role_id: Optional[pulumi.Input[_builtins.int]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationRoleUsersResult]:
    """
    Lookup all users assigned to a custom organization role.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_organization_role_users(role_id=1234)
    ```

    ## Nested Schema for `users`

    ### Read-Only

    - `user_id` (Number) The ID of the user.
    - `login` (String) The login for the GitHub user account.


    :param _builtins.int role_id: The ID of the organization role.
    """
    __args__ = dict()
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getOrganizationRoleUsers:getOrganizationRoleUsers', __args__, opts=opts, typ=GetOrganizationRoleUsersResult)
    return __ret__.apply(lambda __response__: GetOrganizationRoleUsersResult(
        id=pulumi.get(__response__, 'id'),
        role_id=pulumi.get(__response__, 'role_id'),
        users=pulumi.get(__response__, 'users')))
