# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetRepositoryMilestoneResult',
    'AwaitableGetRepositoryMilestoneResult',
    'get_repository_milestone',
    'get_repository_milestone_output',
]

@pulumi.output_type
class GetRepositoryMilestoneResult:
    """
    A collection of values returned by getRepositoryMilestone.
    """
    def __init__(__self__, description=None, due_date=None, id=None, number=None, owner=None, repository=None, state=None, title=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if due_date and not isinstance(due_date, str):
            raise TypeError("Expected argument 'due_date' to be a str")
        pulumi.set(__self__, "due_date", due_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if number and not isinstance(number, int):
            raise TypeError("Expected argument 'number' to be a int")
        pulumi.set(__self__, "number", number)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the milestone.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dueDate")
    def due_date(self) -> _builtins.str:
        """
        The milestone due date (in ISO-8601 `yyyy-mm-dd` format).
        """
        return pulumi.get(self, "due_date")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def number(self) -> _builtins.int:
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the milestone.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Title of the milestone.
        """
        return pulumi.get(self, "title")


class AwaitableGetRepositoryMilestoneResult(GetRepositoryMilestoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryMilestoneResult(
            description=self.description,
            due_date=self.due_date,
            id=self.id,
            number=self.number,
            owner=self.owner,
            repository=self.repository,
            state=self.state,
            title=self.title)


def get_repository_milestone(number: Optional[_builtins.int] = None,
                             owner: Optional[_builtins.str] = None,
                             repository: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryMilestoneResult:
    """
    Use this data source to retrieve information about a specific GitHub milestone in a repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_repository_milestone(owner="example-owner",
        repository="example-repository",
        number=1)
    ```


    :param _builtins.int number: The number of the milestone.
    :param _builtins.str owner: Owner of the repository.
    :param _builtins.str repository: Name of the repository to retrieve the milestone from.
    """
    __args__ = dict()
    __args__['number'] = number
    __args__['owner'] = owner
    __args__['repository'] = repository
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getRepositoryMilestone:getRepositoryMilestone', __args__, opts=opts, typ=GetRepositoryMilestoneResult).value

    return AwaitableGetRepositoryMilestoneResult(
        description=pulumi.get(__ret__, 'description'),
        due_date=pulumi.get(__ret__, 'due_date'),
        id=pulumi.get(__ret__, 'id'),
        number=pulumi.get(__ret__, 'number'),
        owner=pulumi.get(__ret__, 'owner'),
        repository=pulumi.get(__ret__, 'repository'),
        state=pulumi.get(__ret__, 'state'),
        title=pulumi.get(__ret__, 'title'))
def get_repository_milestone_output(number: Optional[pulumi.Input[_builtins.int]] = None,
                                    owner: Optional[pulumi.Input[_builtins.str]] = None,
                                    repository: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryMilestoneResult]:
    """
    Use this data source to retrieve information about a specific GitHub milestone in a repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_repository_milestone(owner="example-owner",
        repository="example-repository",
        number=1)
    ```


    :param _builtins.int number: The number of the milestone.
    :param _builtins.str owner: Owner of the repository.
    :param _builtins.str repository: Name of the repository to retrieve the milestone from.
    """
    __args__ = dict()
    __args__['number'] = number
    __args__['owner'] = owner
    __args__['repository'] = repository
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getRepositoryMilestone:getRepositoryMilestone', __args__, opts=opts, typ=GetRepositoryMilestoneResult)
    return __ret__.apply(lambda __response__: GetRepositoryMilestoneResult(
        description=pulumi.get(__response__, 'description'),
        due_date=pulumi.get(__response__, 'due_date'),
        id=pulumi.get(__response__, 'id'),
        number=pulumi.get(__response__, 'number'),
        owner=pulumi.get(__response__, 'owner'),
        repository=pulumi.get(__response__, 'repository'),
        state=pulumi.get(__response__, 'state'),
        title=pulumi.get(__response__, 'title')))
