# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationCustomPropertiesArgs', 'OrganizationCustomProperties']

@pulumi.input_type
class OrganizationCustomPropertiesArgs:
    def __init__(__self__, *,
                 property_name: pulumi.Input[_builtins.str],
                 allowed_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 value_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationCustomProperties resource.
        :param pulumi.Input[_builtins.str] property_name: The name of the custom property.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_values: List of allowed values for the custom property. Only applicable when `value_type` is `single_select` or `multi_select`.
        :param pulumi.Input[_builtins.str] default_value: The default value of the custom property.
        :param pulumi.Input[_builtins.str] description: The description of the custom property.
        :param pulumi.Input[_builtins.bool] required: Whether the custom property is required. Defaults to `false`.
        :param pulumi.Input[_builtins.str] value_type: The type of the custom property. Can be one of `string`, `single_select`, `multi_select`, or `true_false`. Defaults to `string`.
        """
        pulumi.set(__self__, "property_name", property_name)
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property_name", value)

    @_builtins.property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed values for the custom property. Only applicable when `value_type` is `single_select` or `multi_select`.
        """
        return pulumi.get(self, "allowed_values")

    @allowed_values.setter
    def allowed_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_values", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default value of the custom property.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the custom property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the custom property is required. Defaults to `false`.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the custom property. Can be one of `string`, `single_select`, `multi_select`, or `true_false`. Defaults to `string`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class _OrganizationCustomPropertiesState:
    def __init__(__self__, *,
                 allowed_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 property_name: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 value_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationCustomProperties resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_values: List of allowed values for the custom property. Only applicable when `value_type` is `single_select` or `multi_select`.
        :param pulumi.Input[_builtins.str] default_value: The default value of the custom property.
        :param pulumi.Input[_builtins.str] description: The description of the custom property.
        :param pulumi.Input[_builtins.str] property_name: The name of the custom property.
        :param pulumi.Input[_builtins.bool] required: Whether the custom property is required. Defaults to `false`.
        :param pulumi.Input[_builtins.str] value_type: The type of the custom property. Can be one of `string`, `single_select`, `multi_select`, or `true_false`. Defaults to `string`.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed values for the custom property. Only applicable when `value_type` is `single_select` or `multi_select`.
        """
        return pulumi.get(self, "allowed_values")

    @allowed_values.setter
    def allowed_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_values", value)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default value of the custom property.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the custom property.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property_name", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the custom property is required. Defaults to `false`.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the custom property. Can be one of `string`, `single_select`, `multi_select`, or `true_false`. Defaults to `string`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value_type", value)


@pulumi.type_token("github:index/organizationCustomProperties:OrganizationCustomProperties")
class OrganizationCustomProperties(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 property_name: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 value_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage custom properties for a GitHub organization.

        Custom properties enable you to add metadata to repositories within your organization. You can use custom properties to add context about repositories, such as who owns them, when they expire, or compliance requirements.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        environment = github.OrganizationCustomProperties("environment",
            property_name="environment",
            value_type="single_select",
            required=True,
            description="The deployment environment for this repository",
            default_value="development",
            allowed_values=[
                "development",
                "staging",
                "production",
            ])
        ```

        ### Text Property

        ```python
        import pulumi
        import pulumi_github as github

        owner = github.OrganizationCustomProperties("owner",
            property_name="owner",
            value_type="string",
            required=True,
            description="The team or individual responsible for this repository")
        ```

        ### Boolean Property

        ```python
        import pulumi
        import pulumi_github as github

        archived = github.OrganizationCustomProperties("archived",
            property_name="archived",
            value_type="true_false",
            required=False,
            description="Whether this repository is archived",
            default_value="false")
        ```

        ## Import

        Organization custom properties can be imported using the property name:

        ```sh
        $ pulumi import github:index/organizationCustomProperties:OrganizationCustomProperties environment environment
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_values: List of allowed values for the custom property. Only applicable when `value_type` is `single_select` or `multi_select`.
        :param pulumi.Input[_builtins.str] default_value: The default value of the custom property.
        :param pulumi.Input[_builtins.str] description: The description of the custom property.
        :param pulumi.Input[_builtins.str] property_name: The name of the custom property.
        :param pulumi.Input[_builtins.bool] required: Whether the custom property is required. Defaults to `false`.
        :param pulumi.Input[_builtins.str] value_type: The type of the custom property. Can be one of `string`, `single_select`, `multi_select`, or `true_false`. Defaults to `string`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationCustomPropertiesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage custom properties for a GitHub organization.

        Custom properties enable you to add metadata to repositories within your organization. You can use custom properties to add context about repositories, such as who owns them, when they expire, or compliance requirements.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        environment = github.OrganizationCustomProperties("environment",
            property_name="environment",
            value_type="single_select",
            required=True,
            description="The deployment environment for this repository",
            default_value="development",
            allowed_values=[
                "development",
                "staging",
                "production",
            ])
        ```

        ### Text Property

        ```python
        import pulumi
        import pulumi_github as github

        owner = github.OrganizationCustomProperties("owner",
            property_name="owner",
            value_type="string",
            required=True,
            description="The team or individual responsible for this repository")
        ```

        ### Boolean Property

        ```python
        import pulumi
        import pulumi_github as github

        archived = github.OrganizationCustomProperties("archived",
            property_name="archived",
            value_type="true_false",
            required=False,
            description="Whether this repository is archived",
            default_value="false")
        ```

        ## Import

        Organization custom properties can be imported using the property name:

        ```sh
        $ pulumi import github:index/organizationCustomProperties:OrganizationCustomProperties environment environment
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationCustomPropertiesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationCustomPropertiesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_value: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 property_name: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 value_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationCustomPropertiesArgs.__new__(OrganizationCustomPropertiesArgs)

            __props__.__dict__["allowed_values"] = allowed_values
            __props__.__dict__["default_value"] = default_value
            __props__.__dict__["description"] = description
            if property_name is None and not opts.urn:
                raise TypeError("Missing required property 'property_name'")
            __props__.__dict__["property_name"] = property_name
            __props__.__dict__["required"] = required
            __props__.__dict__["value_type"] = value_type
        super(OrganizationCustomProperties, __self__).__init__(
            'github:index/organizationCustomProperties:OrganizationCustomProperties',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_value: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            property_name: Optional[pulumi.Input[_builtins.str]] = None,
            required: Optional[pulumi.Input[_builtins.bool]] = None,
            value_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationCustomProperties':
        """
        Get an existing OrganizationCustomProperties resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_values: List of allowed values for the custom property. Only applicable when `value_type` is `single_select` or `multi_select`.
        :param pulumi.Input[_builtins.str] default_value: The default value of the custom property.
        :param pulumi.Input[_builtins.str] description: The description of the custom property.
        :param pulumi.Input[_builtins.str] property_name: The name of the custom property.
        :param pulumi.Input[_builtins.bool] required: Whether the custom property is required. Defaults to `false`.
        :param pulumi.Input[_builtins.str] value_type: The type of the custom property. Can be one of `string`, `single_select`, `multi_select`, or `true_false`. Defaults to `string`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationCustomPropertiesState.__new__(_OrganizationCustomPropertiesState)

        __props__.__dict__["allowed_values"] = allowed_values
        __props__.__dict__["default_value"] = default_value
        __props__.__dict__["description"] = description
        __props__.__dict__["property_name"] = property_name
        __props__.__dict__["required"] = required
        __props__.__dict__["value_type"] = value_type
        return OrganizationCustomProperties(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of allowed values for the custom property. Only applicable when `value_type` is `single_select` or `multi_select`.
        """
        return pulumi.get(self, "allowed_values")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Output[_builtins.str]:
        """
        The default value of the custom property.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the custom property.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "property_name")

    @_builtins.property
    @pulumi.getter
    def required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the custom property is required. Defaults to `false`.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the custom property. Can be one of `string`, `single_select`, `multi_select`, or `true_false`. Defaults to `string`.
        """
        return pulumi.get(self, "value_type")

