# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationRoleArgs', 'OrganizationRole']

@pulumi.input_type
class OrganizationRoleArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 base_role: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationRole resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: The permissions included in this role.
        :param pulumi.Input[_builtins.str] base_role: The system role from which this role inherits permissions.
        :param pulumi.Input[_builtins.str] description: The description of the organization role.
        :param pulumi.Input[_builtins.str] name: The name of the organization role.
        """
        pulumi.set(__self__, "permissions", permissions)
        if base_role is not None:
            pulumi.set(__self__, "base_role", base_role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The permissions included in this role.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="baseRole")
    def base_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system role from which this role inherits permissions.
        """
        return pulumi.get(self, "base_role")

    @base_role.setter
    def base_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_role", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the organization role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the organization role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OrganizationRoleState:
    def __init__(__self__, *,
                 base_role: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering OrganizationRole resources.
        :param pulumi.Input[_builtins.str] base_role: The system role from which this role inherits permissions.
        :param pulumi.Input[_builtins.str] description: The description of the organization role.
        :param pulumi.Input[_builtins.str] name: The name of the organization role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: The permissions included in this role.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        """
        if base_role is not None:
            pulumi.set(__self__, "base_role", base_role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter(name="baseRole")
    def base_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system role from which this role inherits permissions.
        """
        return pulumi.get(self, "base_role")

    @base_role.setter
    def base_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_role", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the organization role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the organization role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The permissions included in this role.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "role_id", value)


@pulumi.type_token("github:index/organizationRole:OrganizationRole")
class OrganizationRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_role: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manage a custom organization role.

        > **Note**: Custom organization roles are currently only available in GitHub Enterprise Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.OrganizationRole("example",
            name="example",
            base_role="read",
            permissions=[
                "read_organization_custom_org_role",
                "read_organization_custom_repo_role",
            ])
        ```

        ## Import

        A custom organization role can be imported using its ID.

        ```sh
        $ pulumi import github:index/organizationRole:OrganizationRole example 1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_role: The system role from which this role inherits permissions.
        :param pulumi.Input[_builtins.str] description: The description of the organization role.
        :param pulumi.Input[_builtins.str] name: The name of the organization role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: The permissions included in this role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a custom organization role.

        > **Note**: Custom organization roles are currently only available in GitHub Enterprise Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.OrganizationRole("example",
            name="example",
            base_role="read",
            permissions=[
                "read_organization_custom_org_role",
                "read_organization_custom_repo_role",
            ])
        ```

        ## Import

        A custom organization role can be imported using its ID.

        ```sh
        $ pulumi import github:index/organizationRole:OrganizationRole example 1234
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_role: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationRoleArgs.__new__(OrganizationRoleArgs)

            __props__.__dict__["base_role"] = base_role
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["role_id"] = None
        super(OrganizationRole, __self__).__init__(
            'github:index/organizationRole:OrganizationRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_role: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'OrganizationRole':
        """
        Get an existing OrganizationRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_role: The system role from which this role inherits permissions.
        :param pulumi.Input[_builtins.str] description: The description of the organization role.
        :param pulumi.Input[_builtins.str] name: The name of the organization role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: The permissions included in this role.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationRoleState.__new__(_OrganizationRoleState)

        __props__.__dict__["base_role"] = base_role
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["role_id"] = role_id
        return OrganizationRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="baseRole")
    def base_role(self) -> pulumi.Output[_builtins.str]:
        """
        The system role from which this role inherits permissions.
        """
        return pulumi.get(self, "base_role")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the organization role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the organization role.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The permissions included in this role.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

