# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationRoleTeamAssignmentArgs', 'OrganizationRoleTeamAssignment']

@pulumi.input_type
class OrganizationRoleTeamAssignmentArgs:
    def __init__(__self__, *,
                 role_id: pulumi.Input[_builtins.str],
                 team_slug: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrganizationRoleTeamAssignment resource.
        :param pulumi.Input[_builtins.str] role_id: The GitHub organization role id
        :param pulumi.Input[_builtins.str] team_slug: The GitHub team slug
        """
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "team_slug", team_slug)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[_builtins.str]:
        """
        The GitHub organization role id
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="teamSlug")
    def team_slug(self) -> pulumi.Input[_builtins.str]:
        """
        The GitHub team slug
        """
        return pulumi.get(self, "team_slug")

    @team_slug.setter
    def team_slug(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "team_slug", value)


@pulumi.input_type
class _OrganizationRoleTeamAssignmentState:
    def __init__(__self__, *,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 team_slug: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationRoleTeamAssignment resources.
        :param pulumi.Input[_builtins.str] role_id: The GitHub organization role id
        :param pulumi.Input[_builtins.str] team_slug: The GitHub team slug
        """
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if team_slug is not None:
            pulumi.set(__self__, "team_slug", team_slug)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GitHub organization role id
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="teamSlug")
    def team_slug(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GitHub team slug
        """
        return pulumi.get(self, "team_slug")

    @team_slug.setter
    def team_slug(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_slug", value)


@pulumi.type_token("github:index/organizationRoleTeamAssignment:OrganizationRoleTeamAssignment")
class OrganizationRoleTeamAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 team_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource manages relationships between teams and organization roles
        in your GitHub organization. This works on predefined roles, and custom roles, where the latter is an Enterprise feature.

        Creating this resource assigns the role to a team.

        The organization role and team must both belong to the same organization
        on GitHub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        test_team = github.Team("test-team", name="test-team")
        test_team_role_assignment = github.OrganizationRoleTeamAssignment("test-team-role-assignment",
            team_slug=test_team.slug,
            role_id="8132")
        ```

        ## Import

        GitHub Team Organization Role Assignment can be imported using an ID made up of `team_slug:role_id`

        ```sh
        $ pulumi import github:index/organizationRoleTeamAssignment:OrganizationRoleTeamAssignment role_assignment test-team:8132
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] role_id: The GitHub organization role id
        :param pulumi.Input[_builtins.str] team_slug: The GitHub team slug
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationRoleTeamAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource manages relationships between teams and organization roles
        in your GitHub organization. This works on predefined roles, and custom roles, where the latter is an Enterprise feature.

        Creating this resource assigns the role to a team.

        The organization role and team must both belong to the same organization
        on GitHub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        test_team = github.Team("test-team", name="test-team")
        test_team_role_assignment = github.OrganizationRoleTeamAssignment("test-team-role-assignment",
            team_slug=test_team.slug,
            role_id="8132")
        ```

        ## Import

        GitHub Team Organization Role Assignment can be imported using an ID made up of `team_slug:role_id`

        ```sh
        $ pulumi import github:index/organizationRoleTeamAssignment:OrganizationRoleTeamAssignment role_assignment test-team:8132
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationRoleTeamAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationRoleTeamAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 team_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationRoleTeamAssignmentArgs.__new__(OrganizationRoleTeamAssignmentArgs)

            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
            if team_slug is None and not opts.urn:
                raise TypeError("Missing required property 'team_slug'")
            __props__.__dict__["team_slug"] = team_slug
        super(OrganizationRoleTeamAssignment, __self__).__init__(
            'github:index/organizationRoleTeamAssignment:OrganizationRoleTeamAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None,
            team_slug: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationRoleTeamAssignment':
        """
        Get an existing OrganizationRoleTeamAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] role_id: The GitHub organization role id
        :param pulumi.Input[_builtins.str] team_slug: The GitHub team slug
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationRoleTeamAssignmentState.__new__(_OrganizationRoleTeamAssignmentState)

        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["team_slug"] = team_slug
        return OrganizationRoleTeamAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.str]:
        """
        The GitHub organization role id
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="teamSlug")
    def team_slug(self) -> pulumi.Output[_builtins.str]:
        """
        The GitHub team slug
        """
        return pulumi.get(self, "team_slug")

