# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationRoleUserArgs', 'OrganizationRoleUser']

@pulumi.input_type
class OrganizationRoleUserArgs:
    def __init__(__self__, *,
                 login: pulumi.Input[_builtins.str],
                 role_id: pulumi.Input[_builtins.int]):
        """
        The set of arguments for constructing a OrganizationRoleUser resource.
        :param pulumi.Input[_builtins.str] login: The login for the GitHub user account.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        """
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Input[_builtins.str]:
        """
        The login for the GitHub user account.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "role_id", value)


@pulumi.input_type
class _OrganizationRoleUserState:
    def __init__(__self__, *,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering OrganizationRoleUser resources.
        :param pulumi.Input[_builtins.str] login: The login for the GitHub user account.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        """
        if login is not None:
            pulumi.set(__self__, "login", login)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The login for the GitHub user account.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "role_id", value)


@pulumi.type_token("github:index/organizationRoleUser:OrganizationRoleUser")
class OrganizationRoleUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manage an association between an organization role and a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.OrganizationRoleUser("example",
            role_id=1234,
            login="example-user")
        ```

        ## Import

        An organization role user association can be imported using the role ID and the user login separated by a `:`.

        ```sh
        $ pulumi import github:index/organizationRoleUser:OrganizationRoleUser example "1234:example-user"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] login: The login for the GitHub user account.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationRoleUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage an association between an organization role and a user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.OrganizationRoleUser("example",
            role_id=1234,
            login="example-user")
        ```

        ## Import

        An organization role user association can be imported using the role ID and the user login separated by a `:`.

        ```sh
        $ pulumi import github:index/organizationRoleUser:OrganizationRoleUser example "1234:example-user"
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationRoleUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationRoleUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationRoleUserArgs.__new__(OrganizationRoleUserArgs)

            if login is None and not opts.urn:
                raise TypeError("Missing required property 'login'")
            __props__.__dict__["login"] = login
            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
        super(OrganizationRoleUser, __self__).__init__(
            'github:index/organizationRoleUser:OrganizationRoleUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            login: Optional[pulumi.Input[_builtins.str]] = None,
            role_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'OrganizationRoleUser':
        """
        Get an existing OrganizationRoleUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] login: The login for the GitHub user account.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationRoleUserState.__new__(_OrganizationRoleUserState)

        __props__.__dict__["login"] = login
        __props__.__dict__["role_id"] = role_id
        return OrganizationRoleUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[_builtins.str]:
        """
        The login for the GitHub user account.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

