# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 app_auth: Optional[pulumi.Input['ProviderAppAuthArgs']] = None,
                 base_url: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 retryable_errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 write_delay_ms: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input['ProviderAppAuthArgs'] app_auth: The GitHub App credentials used to connect to GitHub. Conflicts with `token`. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        :param pulumi.Input[_builtins.str] base_url: The GitHub Base API URL
        :param pulumi.Input[_builtins.bool] insecure: Enable `insecure` mode for testing purposes
        :param pulumi.Input[_builtins.int] max_retries: Number of times to retry a request after receiving an error status codeDefaults to 3
        :param pulumi.Input[_builtins.str] organization: The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts.
        :param pulumi.Input[_builtins.str] owner: The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts.
        :param pulumi.Input[_builtins.bool] parallel_requests: Allow the provider to make parallel API calls to GitHub. You may want to set it to true when you have a private Github Enterprise without strict rate limits. While it is possible to enable this setting on github.com, github.com's best practices recommend using serialization to avoid hitting abuse rate limitsDefaults to false if not set
        :param pulumi.Input[_builtins.int] read_delay_ms: Amount of time in milliseconds to sleep in between non-write requests to GitHub API. Defaults to 0ms if not set.
        :param pulumi.Input[_builtins.int] retry_delay_ms: Amount of time in milliseconds to sleep in between requests to GitHub API after an error response. Defaults to 1000ms or 1s if not set, the max_retries must be set to greater than zero.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] retryable_errors: Allow the provider to retry after receiving an error status code, the max_retries should be set for this to workDefaults to [500, 502, 503, 504]
        :param pulumi.Input[_builtins.str] token: The OAuth token used to connect to GitHub. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        :param pulumi.Input[_builtins.int] write_delay_ms: Amount of time in milliseconds to sleep in between writes to GitHub API. Defaults to 1000ms or 1s if not set.
        """
        if app_auth is not None:
            pulumi.set(__self__, "app_auth", app_auth)
        if base_url is None:
            base_url = (_utilities.get_env('GITHUB_BASE_URL') or 'https://api.github.com/')
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if organization is not None:
            warnings.warn("""Use owner (or GITHUB_OWNER) instead of organization (or GITHUB_ORGANIZATION)""", DeprecationWarning)
            pulumi.log.warn("""organization is deprecated: Use owner (or GITHUB_OWNER) instead of organization (or GITHUB_ORGANIZATION)""")
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if parallel_requests is not None:
            pulumi.set(__self__, "parallel_requests", parallel_requests)
        if read_delay_ms is not None:
            pulumi.set(__self__, "read_delay_ms", read_delay_ms)
        if retry_delay_ms is not None:
            pulumi.set(__self__, "retry_delay_ms", retry_delay_ms)
        if retryable_errors is not None:
            pulumi.set(__self__, "retryable_errors", retryable_errors)
        if token is None:
            token = _utilities.get_env('GITHUB_TOKEN')
        if token is not None:
            pulumi.set(__self__, "token", token)
        if write_delay_ms is not None:
            pulumi.set(__self__, "write_delay_ms", write_delay_ms)

    @_builtins.property
    @pulumi.getter(name="appAuth")
    def app_auth(self) -> Optional[pulumi.Input['ProviderAppAuthArgs']]:
        """
        The GitHub App credentials used to connect to GitHub. Conflicts with `token`. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        """
        return pulumi.get(self, "app_auth")

    @app_auth.setter
    def app_auth(self, value: Optional[pulumi.Input['ProviderAppAuthArgs']]):
        pulumi.set(self, "app_auth", value)

    @_builtins.property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GitHub Base API URL
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_url", value)

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable `insecure` mode for testing purposes
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of times to retry a request after receiving an error status codeDefaults to 3
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use owner (or GITHUB_OWNER) instead of organization (or GITHUB_ORGANIZATION)""")
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="parallelRequests")
    def parallel_requests(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the provider to make parallel API calls to GitHub. You may want to set it to true when you have a private Github Enterprise without strict rate limits. While it is possible to enable this setting on github.com, github.com's best practices recommend using serialization to avoid hitting abuse rate limitsDefaults to false if not set
        """
        return pulumi.get(self, "parallel_requests")

    @parallel_requests.setter
    def parallel_requests(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "parallel_requests", value)

    @_builtins.property
    @pulumi.getter(name="readDelayMs")
    def read_delay_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time in milliseconds to sleep in between non-write requests to GitHub API. Defaults to 0ms if not set.
        """
        return pulumi.get(self, "read_delay_ms")

    @read_delay_ms.setter
    def read_delay_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_delay_ms", value)

    @_builtins.property
    @pulumi.getter(name="retryDelayMs")
    def retry_delay_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time in milliseconds to sleep in between requests to GitHub API after an error response. Defaults to 1000ms or 1s if not set, the max_retries must be set to greater than zero.
        """
        return pulumi.get(self, "retry_delay_ms")

    @retry_delay_ms.setter
    def retry_delay_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_delay_ms", value)

    @_builtins.property
    @pulumi.getter(name="retryableErrors")
    def retryable_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Allow the provider to retry after receiving an error status code, the max_retries should be set for this to workDefaults to [500, 502, 503, 504]
        """
        return pulumi.get(self, "retryable_errors")

    @retryable_errors.setter
    def retryable_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "retryable_errors", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OAuth token used to connect to GitHub. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="writeDelayMs")
    def write_delay_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time in milliseconds to sleep in between writes to GitHub API. Defaults to 1000ms or 1s if not set.
        """
        return pulumi.get(self, "write_delay_ms")

    @write_delay_ms.setter
    def write_delay_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "write_delay_ms", value)


@pulumi.type_token("pulumi:providers:github")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_auth: Optional[pulumi.Input[Union['ProviderAppAuthArgs', 'ProviderAppAuthArgsDict']]] = None,
                 base_url: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 retryable_errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 write_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The provider type for the github package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProviderAppAuthArgs', 'ProviderAppAuthArgsDict']] app_auth: The GitHub App credentials used to connect to GitHub. Conflicts with `token`. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        :param pulumi.Input[_builtins.str] base_url: The GitHub Base API URL
        :param pulumi.Input[_builtins.bool] insecure: Enable `insecure` mode for testing purposes
        :param pulumi.Input[_builtins.int] max_retries: Number of times to retry a request after receiving an error status codeDefaults to 3
        :param pulumi.Input[_builtins.str] organization: The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts.
        :param pulumi.Input[_builtins.str] owner: The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts.
        :param pulumi.Input[_builtins.bool] parallel_requests: Allow the provider to make parallel API calls to GitHub. You may want to set it to true when you have a private Github Enterprise without strict rate limits. While it is possible to enable this setting on github.com, github.com's best practices recommend using serialization to avoid hitting abuse rate limitsDefaults to false if not set
        :param pulumi.Input[_builtins.int] read_delay_ms: Amount of time in milliseconds to sleep in between non-write requests to GitHub API. Defaults to 0ms if not set.
        :param pulumi.Input[_builtins.int] retry_delay_ms: Amount of time in milliseconds to sleep in between requests to GitHub API after an error response. Defaults to 1000ms or 1s if not set, the max_retries must be set to greater than zero.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] retryable_errors: Allow the provider to retry after receiving an error status code, the max_retries should be set for this to workDefaults to [500, 502, 503, 504]
        :param pulumi.Input[_builtins.str] token: The OAuth token used to connect to GitHub. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        :param pulumi.Input[_builtins.int] write_delay_ms: Amount of time in milliseconds to sleep in between writes to GitHub API. Defaults to 1000ms or 1s if not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the github package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_auth: Optional[pulumi.Input[Union['ProviderAppAuthArgs', 'ProviderAppAuthArgsDict']]] = None,
                 base_url: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 read_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 retry_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 retryable_errors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 write_delay_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["app_auth"] = pulumi.Output.from_input(app_auth).apply(pulumi.runtime.to_json) if app_auth is not None else None
            if base_url is None:
                base_url = (_utilities.get_env('GITHUB_BASE_URL') or 'https://api.github.com/')
            __props__.__dict__["base_url"] = base_url
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["organization"] = organization
            __props__.__dict__["owner"] = owner
            __props__.__dict__["parallel_requests"] = pulumi.Output.from_input(parallel_requests).apply(pulumi.runtime.to_json) if parallel_requests is not None else None
            __props__.__dict__["read_delay_ms"] = pulumi.Output.from_input(read_delay_ms).apply(pulumi.runtime.to_json) if read_delay_ms is not None else None
            __props__.__dict__["retry_delay_ms"] = pulumi.Output.from_input(retry_delay_ms).apply(pulumi.runtime.to_json) if retry_delay_ms is not None else None
            __props__.__dict__["retryable_errors"] = pulumi.Output.from_input(retryable_errors).apply(pulumi.runtime.to_json) if retryable_errors is not None else None
            if token is None:
                token = _utilities.get_env('GITHUB_TOKEN')
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["write_delay_ms"] = pulumi.Output.from_input(write_delay_ms).apply(pulumi.runtime.to_json) if write_delay_ms is not None else None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'github',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GitHub Base API URL
        """
        return pulumi.get(self, "base_url")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use owner (or GITHUB_OWNER) instead of organization (or GITHUB_ORGANIZATION)""")
    def organization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OAuth token used to connect to GitHub. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        """
        return pulumi.get(self, "token")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:github/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

