# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ReleaseArgs', 'Release']

@pulumi.input_type
class ReleaseArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[_builtins.str],
                 tag_name: pulumi.Input[_builtins.str],
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 discussion_category_name: Optional[pulumi.Input[_builtins.str]] = None,
                 draft: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate_release_notes: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 prerelease: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_commitish: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Release resource.
        :param pulumi.Input[_builtins.str] repository: The name of the repository.
        :param pulumi.Input[_builtins.str] tag_name: The name of the tag.
        :param pulumi.Input[_builtins.str] body: Text describing the contents of the tag.
        :param pulumi.Input[_builtins.str] discussion_category_name: If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see [Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).
        :param pulumi.Input[_builtins.bool] draft: Set to `false` to create a published release.
        :param pulumi.Input[_builtins.bool] generate_release_notes: Set to `true` to automatically generate the name and body for this release. If `name` is specified, the specified `name` will be used; otherwise, a name will be automatically generated. If `body` is specified, the `body` will be pre-pended to the automatically generated notes.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.bool] prerelease: Set to `false` to identify the release as a full release.
        :param pulumi.Input[_builtins.str] target_commitish: The branch name or commit SHA the tag is created from. Defaults to the default branch of the repository.
        """
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "tag_name", tag_name)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if discussion_category_name is not None:
            pulumi.set(__self__, "discussion_category_name", discussion_category_name)
        if draft is not None:
            pulumi.set(__self__, "draft", draft)
        if generate_release_notes is not None:
            pulumi.set(__self__, "generate_release_notes", generate_release_notes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prerelease is not None:
            pulumi.set(__self__, "prerelease", prerelease)
        if target_commitish is not None:
            pulumi.set(__self__, "target_commitish", target_commitish)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the tag.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Text describing the contents of the tag.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="discussionCategoryName")
    def discussion_category_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see [Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).
        """
        return pulumi.get(self, "discussion_category_name")

    @discussion_category_name.setter
    def discussion_category_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discussion_category_name", value)

    @_builtins.property
    @pulumi.getter
    def draft(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `false` to create a published release.
        """
        return pulumi.get(self, "draft")

    @draft.setter
    def draft(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "draft", value)

    @_builtins.property
    @pulumi.getter(name="generateReleaseNotes")
    def generate_release_notes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to automatically generate the name and body for this release. If `name` is specified, the specified `name` will be used; otherwise, a name will be automatically generated. If `body` is specified, the `body` will be pre-pended to the automatically generated notes.
        """
        return pulumi.get(self, "generate_release_notes")

    @generate_release_notes.setter
    def generate_release_notes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_release_notes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the release.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def prerelease(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `false` to identify the release as a full release.
        """
        return pulumi.get(self, "prerelease")

    @prerelease.setter
    def prerelease(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prerelease", value)

    @_builtins.property
    @pulumi.getter(name="targetCommitish")
    def target_commitish(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The branch name or commit SHA the tag is created from. Defaults to the default branch of the repository.
        """
        return pulumi.get(self, "target_commitish")

    @target_commitish.setter
    def target_commitish(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_commitish", value)


@pulumi.input_type
class _ReleaseState:
    def __init__(__self__, *,
                 assets_url: Optional[pulumi.Input[_builtins.str]] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 discussion_category_name: Optional[pulumi.Input[_builtins.str]] = None,
                 draft: Optional[pulumi.Input[_builtins.bool]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_release_notes: Optional[pulumi.Input[_builtins.bool]] = None,
                 html_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 prerelease: Optional[pulumi.Input[_builtins.bool]] = None,
                 published_at: Optional[pulumi.Input[_builtins.str]] = None,
                 release_id: Optional[pulumi.Input[_builtins.int]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tarball_url: Optional[pulumi.Input[_builtins.str]] = None,
                 target_commitish: Optional[pulumi.Input[_builtins.str]] = None,
                 upload_url: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 zipball_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Release resources.
        :param pulumi.Input[_builtins.str] assets_url: URL that can be provided to API calls displaying the attached assets to this release.
        :param pulumi.Input[_builtins.str] body: Text describing the contents of the tag.
        :param pulumi.Input[_builtins.str] created_at: This is the date of the commit used for the release, and not the date when the release was drafted or published.
        :param pulumi.Input[_builtins.str] discussion_category_name: If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see [Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).
        :param pulumi.Input[_builtins.bool] draft: Set to `false` to create a published release.
        :param pulumi.Input[_builtins.bool] generate_release_notes: Set to `true` to automatically generate the name and body for this release. If `name` is specified, the specified `name` will be used; otherwise, a name will be automatically generated. If `body` is specified, the `body` will be pre-pended to the automatically generated notes.
        :param pulumi.Input[_builtins.str] html_url: URL of the release in GitHub.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.str] node_id: GraphQL global node id for use with v4 API
        :param pulumi.Input[_builtins.bool] prerelease: Set to `false` to identify the release as a full release.
        :param pulumi.Input[_builtins.str] published_at: This is the date when the release was published. This will be empty if the release is a draft.
        :param pulumi.Input[_builtins.int] release_id: The ID of the release.
        :param pulumi.Input[_builtins.str] repository: The name of the repository.
        :param pulumi.Input[_builtins.str] tag_name: The name of the tag.
        :param pulumi.Input[_builtins.str] tarball_url: URL that can be provided to API calls to fetch the release TAR archive.
        :param pulumi.Input[_builtins.str] target_commitish: The branch name or commit SHA the tag is created from. Defaults to the default branch of the repository.
        :param pulumi.Input[_builtins.str] upload_url: URL that can be provided to API calls to upload assets.
        :param pulumi.Input[_builtins.str] url: URL that can be provided to API calls that reference this release.
        :param pulumi.Input[_builtins.str] zipball_url: URL that can be provided to API calls to fetch the release ZIP archive.
        """
        if assets_url is not None:
            pulumi.set(__self__, "assets_url", assets_url)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if discussion_category_name is not None:
            pulumi.set(__self__, "discussion_category_name", discussion_category_name)
        if draft is not None:
            pulumi.set(__self__, "draft", draft)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if generate_release_notes is not None:
            pulumi.set(__self__, "generate_release_notes", generate_release_notes)
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if prerelease is not None:
            pulumi.set(__self__, "prerelease", prerelease)
        if published_at is not None:
            pulumi.set(__self__, "published_at", published_at)
        if release_id is not None:
            pulumi.set(__self__, "release_id", release_id)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)
        if tarball_url is not None:
            pulumi.set(__self__, "tarball_url", tarball_url)
        if target_commitish is not None:
            pulumi.set(__self__, "target_commitish", target_commitish)
        if upload_url is not None:
            pulumi.set(__self__, "upload_url", upload_url)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if zipball_url is not None:
            pulumi.set(__self__, "zipball_url", zipball_url)

    @_builtins.property
    @pulumi.getter(name="assetsUrl")
    def assets_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that can be provided to API calls displaying the attached assets to this release.
        """
        return pulumi.get(self, "assets_url")

    @assets_url.setter
    def assets_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assets_url", value)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Text describing the contents of the tag.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the date of the commit used for the release, and not the date when the release was drafted or published.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="discussionCategoryName")
    def discussion_category_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see [Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).
        """
        return pulumi.get(self, "discussion_category_name")

    @discussion_category_name.setter
    def discussion_category_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discussion_category_name", value)

    @_builtins.property
    @pulumi.getter
    def draft(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `false` to create a published release.
        """
        return pulumi.get(self, "draft")

    @draft.setter
    def draft(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "draft", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="generateReleaseNotes")
    def generate_release_notes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to automatically generate the name and body for this release. If `name` is specified, the specified `name` will be used; otherwise, a name will be automatically generated. If `body` is specified, the `body` will be pre-pended to the automatically generated notes.
        """
        return pulumi.get(self, "generate_release_notes")

    @generate_release_notes.setter
    def generate_release_notes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_release_notes", value)

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the release in GitHub.
        """
        return pulumi.get(self, "html_url")

    @html_url.setter
    def html_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the release.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        GraphQL global node id for use with v4 API
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter
    def prerelease(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `false` to identify the release as a full release.
        """
        return pulumi.get(self, "prerelease")

    @prerelease.setter
    def prerelease(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prerelease", value)

    @_builtins.property
    @pulumi.getter(name="publishedAt")
    def published_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the date when the release was published. This will be empty if the release is a draft.
        """
        return pulumi.get(self, "published_at")

    @published_at.setter
    def published_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "published_at", value)

    @_builtins.property
    @pulumi.getter(name="releaseId")
    def release_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the release.
        """
        return pulumi.get(self, "release_id")

    @release_id.setter
    def release_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "release_id", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the tag.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter(name="tarballUrl")
    def tarball_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that can be provided to API calls to fetch the release TAR archive.
        """
        return pulumi.get(self, "tarball_url")

    @tarball_url.setter
    def tarball_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tarball_url", value)

    @_builtins.property
    @pulumi.getter(name="targetCommitish")
    def target_commitish(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The branch name or commit SHA the tag is created from. Defaults to the default branch of the repository.
        """
        return pulumi.get(self, "target_commitish")

    @target_commitish.setter
    def target_commitish(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_commitish", value)

    @_builtins.property
    @pulumi.getter(name="uploadUrl")
    def upload_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that can be provided to API calls to upload assets.
        """
        return pulumi.get(self, "upload_url")

    @upload_url.setter
    def upload_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upload_url", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that can be provided to API calls that reference this release.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="zipballUrl")
    def zipball_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that can be provided to API calls to fetch the release ZIP archive.
        """
        return pulumi.get(self, "zipball_url")

    @zipball_url.setter
    def zipball_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zipball_url", value)


@pulumi.type_token("github:index/release:Release")
class Release(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 discussion_category_name: Optional[pulumi.Input[_builtins.str]] = None,
                 draft: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate_release_notes: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 prerelease: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_commitish: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage a release in a specific
        GitHub repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        repo = github.Repository("repo",
            name="repo",
            description="GitHub repo managed by Terraform",
            private=False)
        example = github.Release("example",
            repository=repo.name,
            tag_name="v1.0.0")
        ```

        ### On Non-Default Branch

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            name="repo",
            auto_init=True)
        example_branch = github.Branch("example",
            repository=example.name,
            branch="branch_name",
            source_branch=example.default_branch)
        example_release = github.Release("example",
            repository=example.name,
            tag_name="v1.0.0",
            target_commitish=example_branch.branch,
            draft=False,
            prerelease=False)
        ```

        ## Import

        This resource can be imported using the `name` of the repository, combined with the `id` of the release, and a `:` character for separating components, e.g.

        ```sh
        $ pulumi import github:index/release:Release example repo:12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: Text describing the contents of the tag.
        :param pulumi.Input[_builtins.str] discussion_category_name: If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see [Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).
        :param pulumi.Input[_builtins.bool] draft: Set to `false` to create a published release.
        :param pulumi.Input[_builtins.bool] generate_release_notes: Set to `true` to automatically generate the name and body for this release. If `name` is specified, the specified `name` will be used; otherwise, a name will be automatically generated. If `body` is specified, the `body` will be pre-pended to the automatically generated notes.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.bool] prerelease: Set to `false` to identify the release as a full release.
        :param pulumi.Input[_builtins.str] repository: The name of the repository.
        :param pulumi.Input[_builtins.str] tag_name: The name of the tag.
        :param pulumi.Input[_builtins.str] target_commitish: The branch name or commit SHA the tag is created from. Defaults to the default branch of the repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage a release in a specific
        GitHub repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        repo = github.Repository("repo",
            name="repo",
            description="GitHub repo managed by Terraform",
            private=False)
        example = github.Release("example",
            repository=repo.name,
            tag_name="v1.0.0")
        ```

        ### On Non-Default Branch

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            name="repo",
            auto_init=True)
        example_branch = github.Branch("example",
            repository=example.name,
            branch="branch_name",
            source_branch=example.default_branch)
        example_release = github.Release("example",
            repository=example.name,
            tag_name="v1.0.0",
            target_commitish=example_branch.branch,
            draft=False,
            prerelease=False)
        ```

        ## Import

        This resource can be imported using the `name` of the repository, combined with the `id` of the release, and a `:` character for separating components, e.g.

        ```sh
        $ pulumi import github:index/release:Release example repo:12345678
        ```

        :param str resource_name: The name of the resource.
        :param ReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 discussion_category_name: Optional[pulumi.Input[_builtins.str]] = None,
                 draft: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate_release_notes: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 prerelease: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_commitish: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReleaseArgs.__new__(ReleaseArgs)

            __props__.__dict__["body"] = body
            __props__.__dict__["discussion_category_name"] = discussion_category_name
            __props__.__dict__["draft"] = draft
            __props__.__dict__["generate_release_notes"] = generate_release_notes
            __props__.__dict__["name"] = name
            __props__.__dict__["prerelease"] = prerelease
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            if tag_name is None and not opts.urn:
                raise TypeError("Missing required property 'tag_name'")
            __props__.__dict__["tag_name"] = tag_name
            __props__.__dict__["target_commitish"] = target_commitish
            __props__.__dict__["assets_url"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["html_url"] = None
            __props__.__dict__["node_id"] = None
            __props__.__dict__["published_at"] = None
            __props__.__dict__["release_id"] = None
            __props__.__dict__["tarball_url"] = None
            __props__.__dict__["upload_url"] = None
            __props__.__dict__["url"] = None
            __props__.__dict__["zipball_url"] = None
        super(Release, __self__).__init__(
            'github:index/release:Release',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assets_url: Optional[pulumi.Input[_builtins.str]] = None,
            body: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            discussion_category_name: Optional[pulumi.Input[_builtins.str]] = None,
            draft: Optional[pulumi.Input[_builtins.bool]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            generate_release_notes: Optional[pulumi.Input[_builtins.bool]] = None,
            html_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_id: Optional[pulumi.Input[_builtins.str]] = None,
            prerelease: Optional[pulumi.Input[_builtins.bool]] = None,
            published_at: Optional[pulumi.Input[_builtins.str]] = None,
            release_id: Optional[pulumi.Input[_builtins.int]] = None,
            repository: Optional[pulumi.Input[_builtins.str]] = None,
            tag_name: Optional[pulumi.Input[_builtins.str]] = None,
            tarball_url: Optional[pulumi.Input[_builtins.str]] = None,
            target_commitish: Optional[pulumi.Input[_builtins.str]] = None,
            upload_url: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            zipball_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Release':
        """
        Get an existing Release resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assets_url: URL that can be provided to API calls displaying the attached assets to this release.
        :param pulumi.Input[_builtins.str] body: Text describing the contents of the tag.
        :param pulumi.Input[_builtins.str] created_at: This is the date of the commit used for the release, and not the date when the release was drafted or published.
        :param pulumi.Input[_builtins.str] discussion_category_name: If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see [Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).
        :param pulumi.Input[_builtins.bool] draft: Set to `false` to create a published release.
        :param pulumi.Input[_builtins.bool] generate_release_notes: Set to `true` to automatically generate the name and body for this release. If `name` is specified, the specified `name` will be used; otherwise, a name will be automatically generated. If `body` is specified, the `body` will be pre-pended to the automatically generated notes.
        :param pulumi.Input[_builtins.str] html_url: URL of the release in GitHub.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.str] node_id: GraphQL global node id for use with v4 API
        :param pulumi.Input[_builtins.bool] prerelease: Set to `false` to identify the release as a full release.
        :param pulumi.Input[_builtins.str] published_at: This is the date when the release was published. This will be empty if the release is a draft.
        :param pulumi.Input[_builtins.int] release_id: The ID of the release.
        :param pulumi.Input[_builtins.str] repository: The name of the repository.
        :param pulumi.Input[_builtins.str] tag_name: The name of the tag.
        :param pulumi.Input[_builtins.str] tarball_url: URL that can be provided to API calls to fetch the release TAR archive.
        :param pulumi.Input[_builtins.str] target_commitish: The branch name or commit SHA the tag is created from. Defaults to the default branch of the repository.
        :param pulumi.Input[_builtins.str] upload_url: URL that can be provided to API calls to upload assets.
        :param pulumi.Input[_builtins.str] url: URL that can be provided to API calls that reference this release.
        :param pulumi.Input[_builtins.str] zipball_url: URL that can be provided to API calls to fetch the release ZIP archive.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReleaseState.__new__(_ReleaseState)

        __props__.__dict__["assets_url"] = assets_url
        __props__.__dict__["body"] = body
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["discussion_category_name"] = discussion_category_name
        __props__.__dict__["draft"] = draft
        __props__.__dict__["etag"] = etag
        __props__.__dict__["generate_release_notes"] = generate_release_notes
        __props__.__dict__["html_url"] = html_url
        __props__.__dict__["name"] = name
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["prerelease"] = prerelease
        __props__.__dict__["published_at"] = published_at
        __props__.__dict__["release_id"] = release_id
        __props__.__dict__["repository"] = repository
        __props__.__dict__["tag_name"] = tag_name
        __props__.__dict__["tarball_url"] = tarball_url
        __props__.__dict__["target_commitish"] = target_commitish
        __props__.__dict__["upload_url"] = upload_url
        __props__.__dict__["url"] = url
        __props__.__dict__["zipball_url"] = zipball_url
        return Release(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assetsUrl")
    def assets_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL that can be provided to API calls displaying the attached assets to this release.
        """
        return pulumi.get(self, "assets_url")

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Text describing the contents of the tag.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        This is the date of the commit used for the release, and not the date when the release was drafted or published.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="discussionCategoryName")
    def discussion_category_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see [Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository).
        """
        return pulumi.get(self, "discussion_category_name")

    @_builtins.property
    @pulumi.getter
    def draft(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to `false` to create a published release.
        """
        return pulumi.get(self, "draft")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="generateReleaseNotes")
    def generate_release_notes(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to `true` to automatically generate the name and body for this release. If `name` is specified, the specified `name` will be used; otherwise, a name will be automatically generated. If `body` is specified, the `body` will be pre-pended to the automatically generated notes.
        """
        return pulumi.get(self, "generate_release_notes")

    @_builtins.property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the release in GitHub.
        """
        return pulumi.get(self, "html_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the release.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[_builtins.str]:
        """
        GraphQL global node id for use with v4 API
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def prerelease(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to `false` to identify the release as a full release.
        """
        return pulumi.get(self, "prerelease")

    @_builtins.property
    @pulumi.getter(name="publishedAt")
    def published_at(self) -> pulumi.Output[_builtins.str]:
        """
        This is the date when the release was published. This will be empty if the release is a draft.
        """
        return pulumi.get(self, "published_at")

    @_builtins.property
    @pulumi.getter(name="releaseId")
    def release_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the release.
        """
        return pulumi.get(self, "release_id")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the tag.
        """
        return pulumi.get(self, "tag_name")

    @_builtins.property
    @pulumi.getter(name="tarballUrl")
    def tarball_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL that can be provided to API calls to fetch the release TAR archive.
        """
        return pulumi.get(self, "tarball_url")

    @_builtins.property
    @pulumi.getter(name="targetCommitish")
    def target_commitish(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The branch name or commit SHA the tag is created from. Defaults to the default branch of the repository.
        """
        return pulumi.get(self, "target_commitish")

    @_builtins.property
    @pulumi.getter(name="uploadUrl")
    def upload_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL that can be provided to API calls to upload assets.
        """
        return pulumi.get(self, "upload_url")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        URL that can be provided to API calls that reference this release.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="zipballUrl")
    def zipball_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL that can be provided to API calls to fetch the release ZIP archive.
        """
        return pulumi.get(self, "zipball_url")

