# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RepositoryCustomPropertyArgs', 'RepositoryCustomProperty']

@pulumi.input_type
class RepositoryCustomPropertyArgs:
    def __init__(__self__, *,
                 property_name: pulumi.Input[_builtins.str],
                 property_type: pulumi.Input[_builtins.str],
                 property_values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 repository: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a RepositoryCustomProperty resource.
        :param pulumi.Input[_builtins.str] property_name: Name of the custom property. Note that a pre-requisiste for this resource is that a custom property of this name has already been defined on the organization level
        :param pulumi.Input[_builtins.str] property_type: Type of the custom property. Can be one of `single_select`, `multi_select`, `string`, or `true_false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_values: Value of the custom property in the form of an array. Properties of type `single_select`, `string`, and `true_false` are represented as a string array of length 1
        :param pulumi.Input[_builtins.str] repository: The repository of the environment.
        """
        pulumi.set(__self__, "property_name", property_name)
        pulumi.set(__self__, "property_type", property_type)
        pulumi.set(__self__, "property_values", property_values)
        pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the custom property. Note that a pre-requisiste for this resource is that a custom property of this name has already been defined on the organization level
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property_name", value)

    @_builtins.property
    @pulumi.getter(name="propertyType")
    def property_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the custom property. Can be one of `single_select`, `multi_select`, `string`, or `true_false`
        """
        return pulumi.get(self, "property_type")

    @property_type.setter
    def property_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property_type", value)

    @_builtins.property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Value of the custom property in the form of an array. Properties of type `single_select`, `string`, and `true_false` are represented as a string array of length 1
        """
        return pulumi.get(self, "property_values")

    @property_values.setter
    def property_values(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "property_values", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Input[_builtins.str]:
        """
        The repository of the environment.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository", value)


@pulumi.input_type
class _RepositoryCustomPropertyState:
    def __init__(__self__, *,
                 property_name: Optional[pulumi.Input[_builtins.str]] = None,
                 property_type: Optional[pulumi.Input[_builtins.str]] = None,
                 property_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RepositoryCustomProperty resources.
        :param pulumi.Input[_builtins.str] property_name: Name of the custom property. Note that a pre-requisiste for this resource is that a custom property of this name has already been defined on the organization level
        :param pulumi.Input[_builtins.str] property_type: Type of the custom property. Can be one of `single_select`, `multi_select`, `string`, or `true_false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_values: Value of the custom property in the form of an array. Properties of type `single_select`, `string`, and `true_false` are represented as a string array of length 1
        :param pulumi.Input[_builtins.str] repository: The repository of the environment.
        """
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)
        if property_type is not None:
            pulumi.set(__self__, "property_type", property_type)
        if property_values is not None:
            pulumi.set(__self__, "property_values", property_values)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the custom property. Note that a pre-requisiste for this resource is that a custom property of this name has already been defined on the organization level
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property_name", value)

    @_builtins.property
    @pulumi.getter(name="propertyType")
    def property_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the custom property. Can be one of `single_select`, `multi_select`, `string`, or `true_false`
        """
        return pulumi.get(self, "property_type")

    @property_type.setter
    def property_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property_type", value)

    @_builtins.property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Value of the custom property in the form of an array. Properties of type `single_select`, `string`, and `true_false` are represented as a string array of length 1
        """
        return pulumi.get(self, "property_values")

    @property_values.setter
    def property_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "property_values", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The repository of the environment.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)


@pulumi.type_token("github:index/repositoryCustomProperty:RepositoryCustomProperty")
class RepositoryCustomProperty(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 property_name: Optional[pulumi.Input[_builtins.str]] = None,
                 property_type: Optional[pulumi.Input[_builtins.str]] = None,
                 property_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage a specific custom property for a GitHub repository.

        ## Example Usage

        > Note that this assumes there already is a custom property defined on the org level called `my-cool-property` of type `string`

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            name="example",
            description="My awesome codebase")
        string = github.RepositoryCustomProperty("string",
            repository=example.name,
            property_name="my-cool-property",
            property_type="string",
            property_values=["test"])
        ```

        ## Import

        GitHub Repository Custom Property can be imported using an ID made up of a comibnation of the names of the organization, repository, custom property separated by a `:` character, e.g.

        ```sh
        $ pulumi import github:index/repositoryCustomProperty:RepositoryCustomProperty example <organization-name>:<repo-name>:<custom-property-name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] property_name: Name of the custom property. Note that a pre-requisiste for this resource is that a custom property of this name has already been defined on the organization level
        :param pulumi.Input[_builtins.str] property_type: Type of the custom property. Can be one of `single_select`, `multi_select`, `string`, or `true_false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_values: Value of the custom property in the form of an array. Properties of type `single_select`, `string`, and `true_false` are represented as a string array of length 1
        :param pulumi.Input[_builtins.str] repository: The repository of the environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryCustomPropertyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage a specific custom property for a GitHub repository.

        ## Example Usage

        > Note that this assumes there already is a custom property defined on the org level called `my-cool-property` of type `string`

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example",
            name="example",
            description="My awesome codebase")
        string = github.RepositoryCustomProperty("string",
            repository=example.name,
            property_name="my-cool-property",
            property_type="string",
            property_values=["test"])
        ```

        ## Import

        GitHub Repository Custom Property can be imported using an ID made up of a comibnation of the names of the organization, repository, custom property separated by a `:` character, e.g.

        ```sh
        $ pulumi import github:index/repositoryCustomProperty:RepositoryCustomProperty example <organization-name>:<repo-name>:<custom-property-name>
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryCustomPropertyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryCustomPropertyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 property_name: Optional[pulumi.Input[_builtins.str]] = None,
                 property_type: Optional[pulumi.Input[_builtins.str]] = None,
                 property_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryCustomPropertyArgs.__new__(RepositoryCustomPropertyArgs)

            if property_name is None and not opts.urn:
                raise TypeError("Missing required property 'property_name'")
            __props__.__dict__["property_name"] = property_name
            if property_type is None and not opts.urn:
                raise TypeError("Missing required property 'property_type'")
            __props__.__dict__["property_type"] = property_type
            if property_values is None and not opts.urn:
                raise TypeError("Missing required property 'property_values'")
            __props__.__dict__["property_values"] = property_values
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
        super(RepositoryCustomProperty, __self__).__init__(
            'github:index/repositoryCustomProperty:RepositoryCustomProperty',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            property_name: Optional[pulumi.Input[_builtins.str]] = None,
            property_type: Optional[pulumi.Input[_builtins.str]] = None,
            property_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            repository: Optional[pulumi.Input[_builtins.str]] = None) -> 'RepositoryCustomProperty':
        """
        Get an existing RepositoryCustomProperty resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] property_name: Name of the custom property. Note that a pre-requisiste for this resource is that a custom property of this name has already been defined on the organization level
        :param pulumi.Input[_builtins.str] property_type: Type of the custom property. Can be one of `single_select`, `multi_select`, `string`, or `true_false`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] property_values: Value of the custom property in the form of an array. Properties of type `single_select`, `string`, and `true_false` are represented as a string array of length 1
        :param pulumi.Input[_builtins.str] repository: The repository of the environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryCustomPropertyState.__new__(_RepositoryCustomPropertyState)

        __props__.__dict__["property_name"] = property_name
        __props__.__dict__["property_type"] = property_type
        __props__.__dict__["property_values"] = property_values
        __props__.__dict__["repository"] = repository
        return RepositoryCustomProperty(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the custom property. Note that a pre-requisiste for this resource is that a custom property of this name has already been defined on the organization level
        """
        return pulumi.get(self, "property_name")

    @_builtins.property
    @pulumi.getter(name="propertyType")
    def property_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the custom property. Can be one of `single_select`, `multi_select`, `string`, or `true_false`
        """
        return pulumi.get(self, "property_type")

    @_builtins.property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Value of the custom property in the form of an array. Properties of type `single_select`, `string`, and `true_false` are represented as a string array of length 1
        """
        return pulumi.get(self, "property_values")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Output[_builtins.str]:
        """
        The repository of the environment.
        """
        return pulumi.get(self, "repository")

