# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RepositoryFileArgs', 'RepositoryFile']

@pulumi.input_type
class RepositoryFileArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 file: pulumi.Input[_builtins.str],
                 repository: pulumi.Input[_builtins.str],
                 autocreate_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 autocreate_branch_source_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 autocreate_branch_source_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_author: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_email: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a RepositoryFile resource.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.str] repository: The repository to create the file in.
        :param pulumi.Input[_builtins.bool] autocreate_branch: Automatically create the branch if it could not be found. Defaults to false. Subsequent reads if the branch is deleted will occur from 'autocreate_branch_source_branch'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_branch: The branch name to start from, if 'autocreate_branch' is set. Defaults to 'main'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_sha: The commit hash to start from, if 'autocreate_branch' is set. Defaults to the tip of 'autocreate_branch_source_branch'. If provided, 'autocreate_branch_source_branch' is ignored.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to the repository's default branch).
               The branch must already exist, it will only be created automatically if 'autocreate_branch' is set true.
        :param pulumi.Input[_builtins.str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_message: The commit message when creating, updating or deleting the managed file.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files. If set to `true` it will overwrite an existing file with the same name. If set to `false` it will fail if there is an existing file with the same name.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "repository", repository)
        if autocreate_branch is not None:
            pulumi.set(__self__, "autocreate_branch", autocreate_branch)
        if autocreate_branch_source_branch is not None:
            pulumi.set(__self__, "autocreate_branch_source_branch", autocreate_branch_source_branch)
        if autocreate_branch_source_sha is not None:
            pulumi.set(__self__, "autocreate_branch_source_sha", autocreate_branch_source_sha)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_author is not None:
            pulumi.set(__self__, "commit_author", commit_author)
        if commit_email is not None:
            pulumi.set(__self__, "commit_email", commit_email)
        if commit_message is not None:
            pulumi.set(__self__, "commit_message", commit_message)
        if overwrite_on_create is not None:
            pulumi.set(__self__, "overwrite_on_create", overwrite_on_create)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> pulumi.Input[_builtins.str]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Input[_builtins.str]:
        """
        The repository to create the file in.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="autocreateBranch")
    def autocreate_branch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically create the branch if it could not be found. Defaults to false. Subsequent reads if the branch is deleted will occur from 'autocreate_branch_source_branch'.
        """
        return pulumi.get(self, "autocreate_branch")

    @autocreate_branch.setter
    def autocreate_branch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autocreate_branch", value)

    @_builtins.property
    @pulumi.getter(name="autocreateBranchSourceBranch")
    def autocreate_branch_source_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The branch name to start from, if 'autocreate_branch' is set. Defaults to 'main'.
        """
        return pulumi.get(self, "autocreate_branch_source_branch")

    @autocreate_branch_source_branch.setter
    def autocreate_branch_source_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autocreate_branch_source_branch", value)

    @_builtins.property
    @pulumi.getter(name="autocreateBranchSourceSha")
    def autocreate_branch_source_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit hash to start from, if 'autocreate_branch' is set. Defaults to the tip of 'autocreate_branch_source_branch'. If provided, 'autocreate_branch_source_branch' is ignored.
        """
        return pulumi.get(self, "autocreate_branch_source_sha")

    @autocreate_branch_source_sha.setter
    def autocreate_branch_source_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autocreate_branch_source_sha", value)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git branch (defaults to the repository's default branch).
        The branch must already exist, it will only be created automatically if 'autocreate_branch' is set true.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch", value)

    @_builtins.property
    @pulumi.getter(name="commitAuthor")
    def commit_author(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_author")

    @commit_author.setter
    def commit_author(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_author", value)

    @_builtins.property
    @pulumi.getter(name="commitEmail")
    def commit_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_email")

    @commit_email.setter
    def commit_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_email", value)

    @_builtins.property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit message when creating, updating or deleting the managed file.
        """
        return pulumi.get(self, "commit_message")

    @commit_message.setter
    def commit_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_message", value)

    @_builtins.property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable overwriting existing files. If set to `true` it will overwrite an existing file with the same name. If set to `false` it will fail if there is an existing file with the same name.
        """
        return pulumi.get(self, "overwrite_on_create")

    @overwrite_on_create.setter
    def overwrite_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overwrite_on_create", value)


@pulumi.input_type
class _RepositoryFileState:
    def __init__(__self__, *,
                 autocreate_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 autocreate_branch_source_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 autocreate_branch_source_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_author: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_email: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 ref: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 sha: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RepositoryFile resources.
        :param pulumi.Input[_builtins.bool] autocreate_branch: Automatically create the branch if it could not be found. Defaults to false. Subsequent reads if the branch is deleted will occur from 'autocreate_branch_source_branch'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_branch: The branch name to start from, if 'autocreate_branch' is set. Defaults to 'main'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_sha: The commit hash to start from, if 'autocreate_branch' is set. Defaults to the tip of 'autocreate_branch_source_branch'. If provided, 'autocreate_branch_source_branch' is ignored.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to the repository's default branch).
               The branch must already exist, it will only be created automatically if 'autocreate_branch' is set true.
        :param pulumi.Input[_builtins.str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_message: The commit message when creating, updating or deleting the managed file.
        :param pulumi.Input[_builtins.str] commit_sha: The SHA of the commit that modified the file.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files. If set to `true` it will overwrite an existing file with the same name. If set to `false` it will fail if there is an existing file with the same name.
        :param pulumi.Input[_builtins.str] ref: The name of the commit/branch/tag.
        :param pulumi.Input[_builtins.str] repository: The repository to create the file in.
        :param pulumi.Input[_builtins.str] sha: The SHA blob of the file.
        """
        if autocreate_branch is not None:
            pulumi.set(__self__, "autocreate_branch", autocreate_branch)
        if autocreate_branch_source_branch is not None:
            pulumi.set(__self__, "autocreate_branch_source_branch", autocreate_branch_source_branch)
        if autocreate_branch_source_sha is not None:
            pulumi.set(__self__, "autocreate_branch_source_sha", autocreate_branch_source_sha)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_author is not None:
            pulumi.set(__self__, "commit_author", commit_author)
        if commit_email is not None:
            pulumi.set(__self__, "commit_email", commit_email)
        if commit_message is not None:
            pulumi.set(__self__, "commit_message", commit_message)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if overwrite_on_create is not None:
            pulumi.set(__self__, "overwrite_on_create", overwrite_on_create)
        if ref is not None:
            pulumi.set(__self__, "ref", ref)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if sha is not None:
            pulumi.set(__self__, "sha", sha)

    @_builtins.property
    @pulumi.getter(name="autocreateBranch")
    def autocreate_branch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically create the branch if it could not be found. Defaults to false. Subsequent reads if the branch is deleted will occur from 'autocreate_branch_source_branch'.
        """
        return pulumi.get(self, "autocreate_branch")

    @autocreate_branch.setter
    def autocreate_branch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autocreate_branch", value)

    @_builtins.property
    @pulumi.getter(name="autocreateBranchSourceBranch")
    def autocreate_branch_source_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The branch name to start from, if 'autocreate_branch' is set. Defaults to 'main'.
        """
        return pulumi.get(self, "autocreate_branch_source_branch")

    @autocreate_branch_source_branch.setter
    def autocreate_branch_source_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autocreate_branch_source_branch", value)

    @_builtins.property
    @pulumi.getter(name="autocreateBranchSourceSha")
    def autocreate_branch_source_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit hash to start from, if 'autocreate_branch' is set. Defaults to the tip of 'autocreate_branch_source_branch'. If provided, 'autocreate_branch_source_branch' is ignored.
        """
        return pulumi.get(self, "autocreate_branch_source_sha")

    @autocreate_branch_source_sha.setter
    def autocreate_branch_source_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autocreate_branch_source_sha", value)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git branch (defaults to the repository's default branch).
        The branch must already exist, it will only be created automatically if 'autocreate_branch' is set true.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch", value)

    @_builtins.property
    @pulumi.getter(name="commitAuthor")
    def commit_author(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_author")

    @commit_author.setter
    def commit_author(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_author", value)

    @_builtins.property
    @pulumi.getter(name="commitEmail")
    def commit_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_email")

    @commit_email.setter
    def commit_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_email", value)

    @_builtins.property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The commit message when creating, updating or deleting the managed file.
        """
        return pulumi.get(self, "commit_message")

    @commit_message.setter
    def commit_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_message", value)

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SHA of the commit that modified the file.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_sha", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file", value)

    @_builtins.property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable overwriting existing files. If set to `true` it will overwrite an existing file with the same name. If set to `false` it will fail if there is an existing file with the same name.
        """
        return pulumi.get(self, "overwrite_on_create")

    @overwrite_on_create.setter
    def overwrite_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overwrite_on_create", value)

    @_builtins.property
    @pulumi.getter
    def ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the commit/branch/tag.
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The repository to create the file in.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter
    def sha(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SHA blob of the file.
        """
        return pulumi.get(self, "sha")

    @sha.setter
    def sha(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sha", value)


@pulumi.type_token("github:index/repositoryFile:RepositoryFile")
class RepositoryFile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autocreate_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 autocreate_branch_source_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 autocreate_branch_source_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_author: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_email: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage files within a
        GitHub repository.

        ## Example Usage

        ### Existing Branch
        ```python
        import pulumi
        import pulumi_github as github

        foo = github.Repository("foo",
            name="tf-acc-test-%s",
            auto_init=True)
        foo_repository_file = github.RepositoryFile("foo",
            repository=foo.name,
            branch="main",
            file=".gitignore",
            content="**/*.tfstate",
            commit_message="Managed by Pulumi",
            commit_author="Terraform User",
            commit_email="terraform@example.com",
            overwrite_on_create=True)
        ```

        ### Auto Created Branch
        ```python
        import pulumi
        import pulumi_github as github

        foo = github.Repository("foo",
            name="tf-acc-test-%s",
            auto_init=True)
        foo_repository_file = github.RepositoryFile("foo",
            repository=foo.name,
            branch="does/not/exist",
            file=".gitignore",
            content="**/*.tfstate",
            commit_message="Managed by Pulumi",
            commit_author="Terraform User",
            commit_email="terraform@example.com",
            overwrite_on_create=True,
            autocreate_branch=True)
        ```

        ## Import

        Repository files can be imported using a combination of the `repo` and `file`, e.g.

        ```sh
        $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore
        ```
        To import a file from a branch other than the default branch, append `:` and the branch name, e.g.

        ```sh
        $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore:dev
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] autocreate_branch: Automatically create the branch if it could not be found. Defaults to false. Subsequent reads if the branch is deleted will occur from 'autocreate_branch_source_branch'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_branch: The branch name to start from, if 'autocreate_branch' is set. Defaults to 'main'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_sha: The commit hash to start from, if 'autocreate_branch' is set. Defaults to the tip of 'autocreate_branch_source_branch'. If provided, 'autocreate_branch_source_branch' is ignored.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to the repository's default branch).
               The branch must already exist, it will only be created automatically if 'autocreate_branch' is set true.
        :param pulumi.Input[_builtins.str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_message: The commit message when creating, updating or deleting the managed file.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files. If set to `true` it will overwrite an existing file with the same name. If set to `false` it will fail if there is an existing file with the same name.
        :param pulumi.Input[_builtins.str] repository: The repository to create the file in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage files within a
        GitHub repository.

        ## Example Usage

        ### Existing Branch
        ```python
        import pulumi
        import pulumi_github as github

        foo = github.Repository("foo",
            name="tf-acc-test-%s",
            auto_init=True)
        foo_repository_file = github.RepositoryFile("foo",
            repository=foo.name,
            branch="main",
            file=".gitignore",
            content="**/*.tfstate",
            commit_message="Managed by Pulumi",
            commit_author="Terraform User",
            commit_email="terraform@example.com",
            overwrite_on_create=True)
        ```

        ### Auto Created Branch
        ```python
        import pulumi
        import pulumi_github as github

        foo = github.Repository("foo",
            name="tf-acc-test-%s",
            auto_init=True)
        foo_repository_file = github.RepositoryFile("foo",
            repository=foo.name,
            branch="does/not/exist",
            file=".gitignore",
            content="**/*.tfstate",
            commit_message="Managed by Pulumi",
            commit_author="Terraform User",
            commit_email="terraform@example.com",
            overwrite_on_create=True,
            autocreate_branch=True)
        ```

        ## Import

        Repository files can be imported using a combination of the `repo` and `file`, e.g.

        ```sh
        $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore
        ```
        To import a file from a branch other than the default branch, append `:` and the branch name, e.g.

        ```sh
        $ pulumi import github:index/repositoryFile:RepositoryFile gitignore example/.gitignore:dev
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autocreate_branch: Optional[pulumi.Input[_builtins.bool]] = None,
                 autocreate_branch_source_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 autocreate_branch_source_sha: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_author: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_email: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryFileArgs.__new__(RepositoryFileArgs)

            __props__.__dict__["autocreate_branch"] = autocreate_branch
            __props__.__dict__["autocreate_branch_source_branch"] = autocreate_branch_source_branch
            __props__.__dict__["autocreate_branch_source_sha"] = autocreate_branch_source_sha
            __props__.__dict__["branch"] = branch
            __props__.__dict__["commit_author"] = commit_author
            __props__.__dict__["commit_email"] = commit_email
            __props__.__dict__["commit_message"] = commit_message
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if file is None and not opts.urn:
                raise TypeError("Missing required property 'file'")
            __props__.__dict__["file"] = file
            __props__.__dict__["overwrite_on_create"] = overwrite_on_create
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            __props__.__dict__["commit_sha"] = None
            __props__.__dict__["ref"] = None
            __props__.__dict__["sha"] = None
        super(RepositoryFile, __self__).__init__(
            'github:index/repositoryFile:RepositoryFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autocreate_branch: Optional[pulumi.Input[_builtins.bool]] = None,
            autocreate_branch_source_branch: Optional[pulumi.Input[_builtins.str]] = None,
            autocreate_branch_source_sha: Optional[pulumi.Input[_builtins.str]] = None,
            branch: Optional[pulumi.Input[_builtins.str]] = None,
            commit_author: Optional[pulumi.Input[_builtins.str]] = None,
            commit_email: Optional[pulumi.Input[_builtins.str]] = None,
            commit_message: Optional[pulumi.Input[_builtins.str]] = None,
            commit_sha: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            file: Optional[pulumi.Input[_builtins.str]] = None,
            overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
            ref: Optional[pulumi.Input[_builtins.str]] = None,
            repository: Optional[pulumi.Input[_builtins.str]] = None,
            sha: Optional[pulumi.Input[_builtins.str]] = None) -> 'RepositoryFile':
        """
        Get an existing RepositoryFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] autocreate_branch: Automatically create the branch if it could not be found. Defaults to false. Subsequent reads if the branch is deleted will occur from 'autocreate_branch_source_branch'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_branch: The branch name to start from, if 'autocreate_branch' is set. Defaults to 'main'.
        :param pulumi.Input[_builtins.str] autocreate_branch_source_sha: The commit hash to start from, if 'autocreate_branch' is set. Defaults to the tip of 'autocreate_branch_source_branch'. If provided, 'autocreate_branch_source_branch' is ignored.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to the repository's default branch).
               The branch must already exist, it will only be created automatically if 'autocreate_branch' is set true.
        :param pulumi.Input[_builtins.str] commit_author: Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_email: Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        :param pulumi.Input[_builtins.str] commit_message: The commit message when creating, updating or deleting the managed file.
        :param pulumi.Input[_builtins.str] commit_sha: The SHA of the commit that modified the file.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files. If set to `true` it will overwrite an existing file with the same name. If set to `false` it will fail if there is an existing file with the same name.
        :param pulumi.Input[_builtins.str] ref: The name of the commit/branch/tag.
        :param pulumi.Input[_builtins.str] repository: The repository to create the file in.
        :param pulumi.Input[_builtins.str] sha: The SHA blob of the file.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryFileState.__new__(_RepositoryFileState)

        __props__.__dict__["autocreate_branch"] = autocreate_branch
        __props__.__dict__["autocreate_branch_source_branch"] = autocreate_branch_source_branch
        __props__.__dict__["autocreate_branch_source_sha"] = autocreate_branch_source_sha
        __props__.__dict__["branch"] = branch
        __props__.__dict__["commit_author"] = commit_author
        __props__.__dict__["commit_email"] = commit_email
        __props__.__dict__["commit_message"] = commit_message
        __props__.__dict__["commit_sha"] = commit_sha
        __props__.__dict__["content"] = content
        __props__.__dict__["file"] = file
        __props__.__dict__["overwrite_on_create"] = overwrite_on_create
        __props__.__dict__["ref"] = ref
        __props__.__dict__["repository"] = repository
        __props__.__dict__["sha"] = sha
        return RepositoryFile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autocreateBranch")
    def autocreate_branch(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatically create the branch if it could not be found. Defaults to false. Subsequent reads if the branch is deleted will occur from 'autocreate_branch_source_branch'.
        """
        return pulumi.get(self, "autocreate_branch")

    @_builtins.property
    @pulumi.getter(name="autocreateBranchSourceBranch")
    def autocreate_branch_source_branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The branch name to start from, if 'autocreate_branch' is set. Defaults to 'main'.
        """
        return pulumi.get(self, "autocreate_branch_source_branch")

    @_builtins.property
    @pulumi.getter(name="autocreateBranchSourceSha")
    def autocreate_branch_source_sha(self) -> pulumi.Output[_builtins.str]:
        """
        The commit hash to start from, if 'autocreate_branch' is set. Defaults to the tip of 'autocreate_branch_source_branch'. If provided, 'autocreate_branch_source_branch' is ignored.
        """
        return pulumi.get(self, "autocreate_branch_source_sha")

    @_builtins.property
    @pulumi.getter
    def branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Git branch (defaults to the repository's default branch).
        The branch must already exist, it will only be created automatically if 'autocreate_branch' is set true.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commitAuthor")
    def commit_author(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Committer author name to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This maybe useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_author")

    @_builtins.property
    @pulumi.getter(name="commitEmail")
    def commit_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Committer email address to use. **NOTE:** GitHub app users may omit author and email information so GitHub can verify commits as the GitHub App. This may be useful when a branch protection rule requires signed commits.
        """
        return pulumi.get(self, "commit_email")

    @_builtins.property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> pulumi.Output[_builtins.str]:
        """
        The commit message when creating, updating or deleting the managed file.
        """
        return pulumi.get(self, "commit_message")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> pulumi.Output[_builtins.str]:
        """
        The SHA of the commit that modified the file.
        """
        return pulumi.get(self, "commit_sha")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def file(self) -> pulumi.Output[_builtins.str]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable overwriting existing files. If set to `true` it will overwrite an existing file with the same name. If set to `false` it will fail if there is an existing file with the same name.
        """
        return pulumi.get(self, "overwrite_on_create")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the commit/branch/tag.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Output[_builtins.str]:
        """
        The repository to create the file in.
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def sha(self) -> pulumi.Output[_builtins.str]:
        """
        The SHA blob of the file.
        """
        return pulumi.get(self, "sha")

