# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserGpgKeyArgs', 'UserGpgKey']

@pulumi.input_type
class UserGpgKeyArgs:
    def __init__(__self__, *,
                 armored_public_key: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a UserGpgKey resource.
        :param pulumi.Input[_builtins.str] armored_public_key: Your public GPG key, generated in ASCII-armored format.
               See [Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/) for help on creating a GPG key.
        """
        pulumi.set(__self__, "armored_public_key", armored_public_key)

    @_builtins.property
    @pulumi.getter(name="armoredPublicKey")
    def armored_public_key(self) -> pulumi.Input[_builtins.str]:
        """
        Your public GPG key, generated in ASCII-armored format.
        See [Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/) for help on creating a GPG key.
        """
        return pulumi.get(self, "armored_public_key")

    @armored_public_key.setter
    def armored_public_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "armored_public_key", value)


@pulumi.input_type
class _UserGpgKeyState:
    def __init__(__self__, *,
                 armored_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserGpgKey resources.
        :param pulumi.Input[_builtins.str] armored_public_key: Your public GPG key, generated in ASCII-armored format.
               See [Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/) for help on creating a GPG key.
        :param pulumi.Input[_builtins.str] key_id: The key ID of the GPG key, e.g. `3262EFF25BA0D270`
        """
        if armored_public_key is not None:
            pulumi.set(__self__, "armored_public_key", armored_public_key)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="armoredPublicKey")
    def armored_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your public GPG key, generated in ASCII-armored format.
        See [Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/) for help on creating a GPG key.
        """
        return pulumi.get(self, "armored_public_key")

    @armored_public_key.setter
    def armored_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "armored_public_key", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key ID of the GPG key, e.g. `3262EFF25BA0D270`
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)


@pulumi.type_token("github:index/userGpgKey:UserGpgKey")
class UserGpgKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 armored_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GitHub user's GPG key resource.

        This resource allows you to add/remove GPG keys from your user account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.UserGpgKey("example", armored_public_key=\"\"\"-----BEGIN PGP PUBLIC KEY BLOCK-----
        ...
        -----END PGP PUBLIC KEY BLOCK-----\"\"\")
        ```

        ## Import

        GPG keys are not importable due to the fact that [API](https://developer.github.com/v3/users/gpg_keys/#gpg-keys)

        does not return previously uploaded GPG key.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] armored_public_key: Your public GPG key, generated in ASCII-armored format.
               See [Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/) for help on creating a GPG key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserGpgKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GitHub user's GPG key resource.

        This resource allows you to add/remove GPG keys from your user account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.UserGpgKey("example", armored_public_key=\"\"\"-----BEGIN PGP PUBLIC KEY BLOCK-----
        ...
        -----END PGP PUBLIC KEY BLOCK-----\"\"\")
        ```

        ## Import

        GPG keys are not importable due to the fact that [API](https://developer.github.com/v3/users/gpg_keys/#gpg-keys)

        does not return previously uploaded GPG key.

        :param str resource_name: The name of the resource.
        :param UserGpgKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserGpgKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 armored_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserGpgKeyArgs.__new__(UserGpgKeyArgs)

            if armored_public_key is None and not opts.urn:
                raise TypeError("Missing required property 'armored_public_key'")
            __props__.__dict__["armored_public_key"] = armored_public_key
            __props__.__dict__["etag"] = None
            __props__.__dict__["key_id"] = None
        super(UserGpgKey, __self__).__init__(
            'github:index/userGpgKey:UserGpgKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            armored_public_key: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserGpgKey':
        """
        Get an existing UserGpgKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] armored_public_key: Your public GPG key, generated in ASCII-armored format.
               See [Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/) for help on creating a GPG key.
        :param pulumi.Input[_builtins.str] key_id: The key ID of the GPG key, e.g. `3262EFF25BA0D270`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserGpgKeyState.__new__(_UserGpgKeyState)

        __props__.__dict__["armored_public_key"] = armored_public_key
        __props__.__dict__["etag"] = etag
        __props__.__dict__["key_id"] = key_id
        return UserGpgKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="armoredPublicKey")
    def armored_public_key(self) -> pulumi.Output[_builtins.str]:
        """
        Your public GPG key, generated in ASCII-armored format.
        See [Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/) for help on creating a GPG key.
        """
        return pulumi.get(self, "armored_public_key")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The key ID of the GPG key, e.g. `3262EFF25BA0D270`
        """
        return pulumi.get(self, "key_id")

