"""
Main interface for ec2 service type definitions.

Usage::

    from mypy_boto3.ec2.type_defs import TagTypeDef

    data: TagTypeDef = {...}
"""
from datetime import datetime
import sys
from typing import Any, IO, List, Union

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal
if sys.version_info >= (3, 8):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


__all__ = (
    "TagTypeDef",
    "VpcPeeringConnectionStateReasonTypeDef",
    "CidrBlockTypeDef",
    "Ipv6CidrBlockTypeDef",
    "VpcPeeringConnectionOptionsDescriptionTypeDef",
    "VpcPeeringConnectionVpcInfoTypeDef",
    "VpcPeeringConnectionTypeDef",
    "AcceptVpcPeeringConnectionResultTypeDef",
    "AssignedPrivateIpAddressTypeDef",
    "AssignPrivateIpAddressesResultTypeDef",
    "AssociateAddressResultTypeDef",
    "RouteTableAssociationStateTypeDef",
    "AssociateRouteTableResultTypeDef",
    "AttachClassicLinkVpcResultTypeDef",
    "AttachNetworkInterfaceResultTypeDef",
    "AttributeBooleanValueTypeDef",
    "AttributeValueTypeDef",
    "BlobAttributeValueTypeDef",
    "EbsBlockDeviceTypeDef",
    "BlockDeviceMappingTypeDef",
    "CapacityReservationTargetTypeDef",
    "CapacityReservationSpecificationTypeDef",
    "ClientAcceptReservedInstancesExchangeQuoteResponseTypeDef",
    "ClientAcceptReservedInstancesExchangeQuoteTargetConfigurationsTypeDef",
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTypeDef",
    "ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    "ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    "ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    "ClientAcceptTransitGatewayVpcAttachmentResponseTypeDef",
    "ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef",
    "ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulTypeDef",
    "ClientAcceptVpcEndpointConnectionsResponseTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef",
    "ClientAcceptVpcPeeringConnectionResponseTypeDef",
    "ClientAdvertiseByoipCidrResponseByoipCidrTypeDef",
    "ClientAdvertiseByoipCidrResponseTypeDef",
    "ClientAllocateAddressResponseTypeDef",
    "ClientAllocateHostsResponseTypeDef",
    "ClientAllocateHostsTagSpecificationsTagsTypeDef",
    "ClientAllocateHostsTagSpecificationsTypeDef",
    "ClientApplySecurityGroupsToClientVpnTargetNetworkResponseTypeDef",
    "ClientAssignIpv6AddressesResponseTypeDef",
    "ClientAssignPrivateIpAddressesResponseAssignedPrivateIpAddressesTypeDef",
    "ClientAssignPrivateIpAddressesResponseTypeDef",
    "ClientAssociateAddressResponseTypeDef",
    "ClientAssociateClientVpnTargetNetworkResponseStatusTypeDef",
    "ClientAssociateClientVpnTargetNetworkResponseTypeDef",
    "ClientAssociateIamInstanceProfileIamInstanceProfileTypeDef",
    "ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    "ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef",
    "ClientAssociateIamInstanceProfileResponseTypeDef",
    "ClientAssociateRouteTableResponseAssociationStateTypeDef",
    "ClientAssociateRouteTableResponseTypeDef",
    "ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    "ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    "ClientAssociateSubnetCidrBlockResponseTypeDef",
    "ClientAssociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef",
    "ClientAssociateTransitGatewayMulticastDomainResponseAssociationsTypeDef",
    "ClientAssociateTransitGatewayMulticastDomainResponseTypeDef",
    "ClientAssociateTransitGatewayRouteTableResponseAssociationTypeDef",
    "ClientAssociateTransitGatewayRouteTableResponseTypeDef",
    "ClientAssociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef",
    "ClientAssociateVpcCidrBlockResponseCidrBlockAssociationTypeDef",
    "ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    "ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    "ClientAssociateVpcCidrBlockResponseTypeDef",
    "ClientAttachClassicLinkVpcResponseTypeDef",
    "ClientAttachNetworkInterfaceResponseTypeDef",
    "ClientAttachVolumeResponseTypeDef",
    "ClientAttachVpnGatewayResponseVpcAttachmentTypeDef",
    "ClientAttachVpnGatewayResponseTypeDef",
    "ClientAuthorizeClientVpnIngressResponseStatusTypeDef",
    "ClientAuthorizeClientVpnIngressResponseTypeDef",
    "ClientAuthorizeSecurityGroupEgressIpPermissionsIpRangesTypeDef",
    "ClientAuthorizeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef",
    "ClientAuthorizeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef",
    "ClientAuthorizeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef",
    "ClientAuthorizeSecurityGroupEgressIpPermissionsTypeDef",
    "ClientAuthorizeSecurityGroupIngressIpPermissionsIpRangesTypeDef",
    "ClientAuthorizeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef",
    "ClientAuthorizeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef",
    "ClientAuthorizeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef",
    "ClientAuthorizeSecurityGroupIngressIpPermissionsTypeDef",
    "ClientBundleInstanceResponseBundleTaskBundleTaskErrorTypeDef",
    "ClientBundleInstanceResponseBundleTaskStorageS3TypeDef",
    "ClientBundleInstanceResponseBundleTaskStorageTypeDef",
    "ClientBundleInstanceResponseBundleTaskTypeDef",
    "ClientBundleInstanceResponseTypeDef",
    "ClientBundleInstanceStorageS3TypeDef",
    "ClientBundleInstanceStorageTypeDef",
    "ClientCancelBundleTaskResponseBundleTaskBundleTaskErrorTypeDef",
    "ClientCancelBundleTaskResponseBundleTaskStorageS3TypeDef",
    "ClientCancelBundleTaskResponseBundleTaskStorageTypeDef",
    "ClientCancelBundleTaskResponseBundleTaskTypeDef",
    "ClientCancelBundleTaskResponseTypeDef",
    "ClientCancelCapacityReservationResponseTypeDef",
    "ClientCancelImportTaskResponseTypeDef",
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef",
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef",
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef",
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsTypeDef",
    "ClientCancelReservedInstancesListingResponseTypeDef",
    "ClientCancelSpotFleetRequestsResponseSuccessfulFleetRequestsTypeDef",
    "ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsErrorTypeDef",
    "ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsTypeDef",
    "ClientCancelSpotFleetRequestsResponseTypeDef",
    "ClientCancelSpotInstanceRequestsResponseCancelledSpotInstanceRequestsTypeDef",
    "ClientCancelSpotInstanceRequestsResponseTypeDef",
    "ClientConfirmProductInstanceResponseTypeDef",
    "ClientCopyFpgaImageResponseTypeDef",
    "ClientCopyImageResponseTypeDef",
    "ClientCopySnapshotResponseTagsTypeDef",
    "ClientCopySnapshotResponseTypeDef",
    "ClientCopySnapshotTagSpecificationsTagsTypeDef",
    "ClientCopySnapshotTagSpecificationsTypeDef",
    "ClientCreateCapacityReservationResponseCapacityReservationTagsTypeDef",
    "ClientCreateCapacityReservationResponseCapacityReservationTypeDef",
    "ClientCreateCapacityReservationResponseTypeDef",
    "ClientCreateCapacityReservationTagSpecificationsTagsTypeDef",
    "ClientCreateCapacityReservationTagSpecificationsTypeDef",
    "ClientCreateClientVpnEndpointAuthenticationOptionsActiveDirectoryTypeDef",
    "ClientCreateClientVpnEndpointAuthenticationOptionsMutualAuthenticationTypeDef",
    "ClientCreateClientVpnEndpointAuthenticationOptionsTypeDef",
    "ClientCreateClientVpnEndpointConnectionLogOptionsTypeDef",
    "ClientCreateClientVpnEndpointResponseStatusTypeDef",
    "ClientCreateClientVpnEndpointResponseTypeDef",
    "ClientCreateClientVpnEndpointTagSpecificationsTagsTypeDef",
    "ClientCreateClientVpnEndpointTagSpecificationsTypeDef",
    "ClientCreateClientVpnRouteResponseStatusTypeDef",
    "ClientCreateClientVpnRouteResponseTypeDef",
    "ClientCreateCustomerGatewayResponseCustomerGatewayTagsTypeDef",
    "ClientCreateCustomerGatewayResponseCustomerGatewayTypeDef",
    "ClientCreateCustomerGatewayResponseTypeDef",
    "ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    "ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef",
    "ClientCreateDefaultSubnetResponseSubnetTagsTypeDef",
    "ClientCreateDefaultSubnetResponseSubnetTypeDef",
    "ClientCreateDefaultSubnetResponseTypeDef",
    "ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef",
    "ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetTypeDef",
    "ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    "ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef",
    "ClientCreateDefaultVpcResponseVpcTagsTypeDef",
    "ClientCreateDefaultVpcResponseVpcTypeDef",
    "ClientCreateDefaultVpcResponseTypeDef",
    "ClientCreateDhcpOptionsDhcpConfigurationsTypeDef",
    "ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef",
    "ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef",
    "ClientCreateDhcpOptionsResponseDhcpOptionsTagsTypeDef",
    "ClientCreateDhcpOptionsResponseDhcpOptionsTypeDef",
    "ClientCreateDhcpOptionsResponseTypeDef",
    "ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayAttachmentsTypeDef",
    "ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTagsTypeDef",
    "ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTypeDef",
    "ClientCreateEgressOnlyInternetGatewayResponseTypeDef",
    "ClientCreateFleetLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    "ClientCreateFleetLaunchTemplateConfigsOverridesPlacementTypeDef",
    "ClientCreateFleetLaunchTemplateConfigsOverridesTypeDef",
    "ClientCreateFleetLaunchTemplateConfigsTypeDef",
    "ClientCreateFleetOnDemandOptionsCapacityReservationOptionsTypeDef",
    "ClientCreateFleetOnDemandOptionsTypeDef",
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesTypeDef",
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesTypeDef",
    "ClientCreateFleetResponseErrorsTypeDef",
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesTypeDef",
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesTypeDef",
    "ClientCreateFleetResponseInstancesTypeDef",
    "ClientCreateFleetResponseTypeDef",
    "ClientCreateFleetSpotOptionsTypeDef",
    "ClientCreateFleetTagSpecificationsTagsTypeDef",
    "ClientCreateFleetTagSpecificationsTypeDef",
    "ClientCreateFleetTargetCapacitySpecificationTypeDef",
    "ClientCreateFlowLogsResponseUnsuccessfulErrorTypeDef",
    "ClientCreateFlowLogsResponseUnsuccessfulTypeDef",
    "ClientCreateFlowLogsResponseTypeDef",
    "ClientCreateFpgaImageInputStorageLocationTypeDef",
    "ClientCreateFpgaImageLogsStorageLocationTypeDef",
    "ClientCreateFpgaImageResponseTypeDef",
    "ClientCreateFpgaImageTagSpecificationsTagsTypeDef",
    "ClientCreateFpgaImageTagSpecificationsTypeDef",
    "ClientCreateImageBlockDeviceMappingsEbsTypeDef",
    "ClientCreateImageBlockDeviceMappingsTypeDef",
    "ClientCreateImageResponseTypeDef",
    "ClientCreateInstanceExportTaskExportToS3TaskTypeDef",
    "ClientCreateInstanceExportTaskResponseExportTaskExportToS3TaskTypeDef",
    "ClientCreateInstanceExportTaskResponseExportTaskInstanceExportDetailsTypeDef",
    "ClientCreateInstanceExportTaskResponseExportTaskTagsTypeDef",
    "ClientCreateInstanceExportTaskResponseExportTaskTypeDef",
    "ClientCreateInstanceExportTaskResponseTypeDef",
    "ClientCreateInternetGatewayResponseInternetGatewayAttachmentsTypeDef",
    "ClientCreateInternetGatewayResponseInternetGatewayTagsTypeDef",
    "ClientCreateInternetGatewayResponseInternetGatewayTypeDef",
    "ClientCreateInternetGatewayResponseTypeDef",
    "ClientCreateKeyPairResponseTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataCpuOptionsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataCreditSpecificationTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataHibernationOptionsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataIamInstanceProfileTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataLicenseSpecificationsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataMetadataOptionsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataMonitoringTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataPlacementTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTagsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTypeDef",
    "ClientCreateLaunchTemplateLaunchTemplateDataTypeDef",
    "ClientCreateLaunchTemplateResponseLaunchTemplateTagsTypeDef",
    "ClientCreateLaunchTemplateResponseLaunchTemplateTypeDef",
    "ClientCreateLaunchTemplateResponseTypeDef",
    "ClientCreateLaunchTemplateTagSpecificationsTagsTypeDef",
    "ClientCreateLaunchTemplateTagSpecificationsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef",
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTypeDef",
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionTypeDef",
    "ClientCreateLaunchTemplateVersionResponseTypeDef",
    "ClientCreateLocalGatewayRouteResponseRouteTypeDef",
    "ClientCreateLocalGatewayRouteResponseTypeDef",
    "ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef",
    "ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef",
    "ClientCreateLocalGatewayRouteTableVpcAssociationResponseTypeDef",
    "ClientCreateNatGatewayResponseNatGatewayNatGatewayAddressesTypeDef",
    "ClientCreateNatGatewayResponseNatGatewayProvisionedBandwidthTypeDef",
    "ClientCreateNatGatewayResponseNatGatewayTagsTypeDef",
    "ClientCreateNatGatewayResponseNatGatewayTypeDef",
    "ClientCreateNatGatewayResponseTypeDef",
    "ClientCreateNetworkAclEntryIcmpTypeCodeTypeDef",
    "ClientCreateNetworkAclEntryPortRangeTypeDef",
    "ClientCreateNetworkAclResponseNetworkAclAssociationsTypeDef",
    "ClientCreateNetworkAclResponseNetworkAclEntriesIcmpTypeCodeTypeDef",
    "ClientCreateNetworkAclResponseNetworkAclEntriesPortRangeTypeDef",
    "ClientCreateNetworkAclResponseNetworkAclEntriesTypeDef",
    "ClientCreateNetworkAclResponseNetworkAclTagsTypeDef",
    "ClientCreateNetworkAclResponseNetworkAclTypeDef",
    "ClientCreateNetworkAclResponseTypeDef",
    "ClientCreateNetworkInterfaceIpv6AddressesTypeDef",
    "ClientCreateNetworkInterfacePermissionResponseInterfacePermissionPermissionStateTypeDef",
    "ClientCreateNetworkInterfacePermissionResponseInterfacePermissionTypeDef",
    "ClientCreateNetworkInterfacePermissionResponseTypeDef",
    "ClientCreateNetworkInterfacePrivateIpAddressesTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceAssociationTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceAttachmentTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceGroupsTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceIpv6AddressesTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesAssociationTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceTagSetTypeDef",
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceTypeDef",
    "ClientCreateNetworkInterfaceResponseTypeDef",
    "ClientCreateReservedInstancesListingPriceSchedulesTypeDef",
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef",
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef",
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef",
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsTypeDef",
    "ClientCreateReservedInstancesListingResponseTypeDef",
    "ClientCreateRouteResponseTypeDef",
    "ClientCreateRouteTableResponseRouteTableAssociationsAssociationStateTypeDef",
    "ClientCreateRouteTableResponseRouteTableAssociationsTypeDef",
    "ClientCreateRouteTableResponseRouteTablePropagatingVgwsTypeDef",
    "ClientCreateRouteTableResponseRouteTableRoutesTypeDef",
    "ClientCreateRouteTableResponseRouteTableTagsTypeDef",
    "ClientCreateRouteTableResponseRouteTableTypeDef",
    "ClientCreateRouteTableResponseTypeDef",
    "ClientCreateSecurityGroupResponseTypeDef",
    "ClientCreateSnapshotResponseTagsTypeDef",
    "ClientCreateSnapshotResponseTypeDef",
    "ClientCreateSnapshotTagSpecificationsTagsTypeDef",
    "ClientCreateSnapshotTagSpecificationsTypeDef",
    "ClientCreateSnapshotsInstanceSpecificationTypeDef",
    "ClientCreateSnapshotsResponseSnapshotsTagsTypeDef",
    "ClientCreateSnapshotsResponseSnapshotsTypeDef",
    "ClientCreateSnapshotsResponseTypeDef",
    "ClientCreateSnapshotsTagSpecificationsTagsTypeDef",
    "ClientCreateSnapshotsTagSpecificationsTypeDef",
    "ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef",
    "ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef",
    "ClientCreateSpotDatafeedSubscriptionResponseTypeDef",
    "ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    "ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef",
    "ClientCreateSubnetResponseSubnetTagsTypeDef",
    "ClientCreateSubnetResponseSubnetTypeDef",
    "ClientCreateSubnetResponseTypeDef",
    "ClientCreateTagsTagsTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTagsTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTypeDef",
    "ClientCreateTrafficMirrorFilterResponseTypeDef",
    "ClientCreateTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef",
    "ClientCreateTrafficMirrorFilterRuleResponseTypeDef",
    "ClientCreateTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    "ClientCreateTrafficMirrorFilterTagSpecificationsTagsTypeDef",
    "ClientCreateTrafficMirrorFilterTagSpecificationsTypeDef",
    "ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef",
    "ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef",
    "ClientCreateTrafficMirrorSessionResponseTypeDef",
    "ClientCreateTrafficMirrorSessionTagSpecificationsTagsTypeDef",
    "ClientCreateTrafficMirrorSessionTagSpecificationsTypeDef",
    "ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTagsTypeDef",
    "ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTypeDef",
    "ClientCreateTrafficMirrorTargetResponseTypeDef",
    "ClientCreateTrafficMirrorTargetTagSpecificationsTagsTypeDef",
    "ClientCreateTrafficMirrorTargetTagSpecificationsTypeDef",
    "ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef",
    "ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef",
    "ClientCreateTransitGatewayMulticastDomainResponseTypeDef",
    "ClientCreateTransitGatewayMulticastDomainTagSpecificationsTagsTypeDef",
    "ClientCreateTransitGatewayMulticastDomainTagSpecificationsTypeDef",
    "ClientCreateTransitGatewayOptionsTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentResponseTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentTagSpecificationsTagsTypeDef",
    "ClientCreateTransitGatewayPeeringAttachmentTagSpecificationsTypeDef",
    "ClientCreateTransitGatewayResponseTransitGatewayOptionsTypeDef",
    "ClientCreateTransitGatewayResponseTransitGatewayTagsTypeDef",
    "ClientCreateTransitGatewayResponseTransitGatewayTypeDef",
    "ClientCreateTransitGatewayResponseTypeDef",
    "ClientCreateTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef",
    "ClientCreateTransitGatewayRouteResponseRouteTypeDef",
    "ClientCreateTransitGatewayRouteResponseTypeDef",
    "ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef",
    "ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef",
    "ClientCreateTransitGatewayRouteTableResponseTypeDef",
    "ClientCreateTransitGatewayRouteTableTagSpecificationsTagsTypeDef",
    "ClientCreateTransitGatewayRouteTableTagSpecificationsTypeDef",
    "ClientCreateTransitGatewayTagSpecificationsTagsTypeDef",
    "ClientCreateTransitGatewayTagSpecificationsTypeDef",
    "ClientCreateTransitGatewayVpcAttachmentOptionsTypeDef",
    "ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    "ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    "ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    "ClientCreateTransitGatewayVpcAttachmentResponseTypeDef",
    "ClientCreateTransitGatewayVpcAttachmentTagSpecificationsTagsTypeDef",
    "ClientCreateTransitGatewayVpcAttachmentTagSpecificationsTypeDef",
    "ClientCreateVolumeResponseAttachmentsTypeDef",
    "ClientCreateVolumeResponseTagsTypeDef",
    "ClientCreateVolumeResponseTypeDef",
    "ClientCreateVolumeTagSpecificationsTagsTypeDef",
    "ClientCreateVolumeTagSpecificationsTypeDef",
    "ClientCreateVpcEndpointConnectionNotificationResponseConnectionNotificationTypeDef",
    "ClientCreateVpcEndpointConnectionNotificationResponseTypeDef",
    "ClientCreateVpcEndpointResponseVpcEndpointDnsEntriesTypeDef",
    "ClientCreateVpcEndpointResponseVpcEndpointGroupsTypeDef",
    "ClientCreateVpcEndpointResponseVpcEndpointLastErrorTypeDef",
    "ClientCreateVpcEndpointResponseVpcEndpointTagsTypeDef",
    "ClientCreateVpcEndpointResponseVpcEndpointTypeDef",
    "ClientCreateVpcEndpointResponseTypeDef",
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationPrivateDnsNameConfigurationTypeDef",
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationServiceTypeTypeDef",
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTagsTypeDef",
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTypeDef",
    "ClientCreateVpcEndpointServiceConfigurationResponseTypeDef",
    "ClientCreateVpcEndpointServiceConfigurationTagSpecificationsTagsTypeDef",
    "ClientCreateVpcEndpointServiceConfigurationTagSpecificationsTypeDef",
    "ClientCreateVpcEndpointTagSpecificationsTagsTypeDef",
    "ClientCreateVpcEndpointTagSpecificationsTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef",
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef",
    "ClientCreateVpcPeeringConnectionResponseTypeDef",
    "ClientCreateVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef",
    "ClientCreateVpcResponseVpcCidrBlockAssociationSetTypeDef",
    "ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    "ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef",
    "ClientCreateVpcResponseVpcTagsTypeDef",
    "ClientCreateVpcResponseVpcTypeDef",
    "ClientCreateVpcResponseTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsIKEVersionsTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    "ClientCreateVpnConnectionOptionsTunnelOptionsTypeDef",
    "ClientCreateVpnConnectionOptionsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionRoutesTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionTagsTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef",
    "ClientCreateVpnConnectionResponseVpnConnectionTypeDef",
    "ClientCreateVpnConnectionResponseTypeDef",
    "ClientCreateVpnGatewayResponseVpnGatewayTagsTypeDef",
    "ClientCreateVpnGatewayResponseVpnGatewayVpcAttachmentsTypeDef",
    "ClientCreateVpnGatewayResponseVpnGatewayTypeDef",
    "ClientCreateVpnGatewayResponseTypeDef",
    "ClientDeleteClientVpnEndpointResponseStatusTypeDef",
    "ClientDeleteClientVpnEndpointResponseTypeDef",
    "ClientDeleteClientVpnRouteResponseStatusTypeDef",
    "ClientDeleteClientVpnRouteResponseTypeDef",
    "ClientDeleteEgressOnlyInternetGatewayResponseTypeDef",
    "ClientDeleteFleetsResponseSuccessfulFleetDeletionsTypeDef",
    "ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsErrorTypeDef",
    "ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsTypeDef",
    "ClientDeleteFleetsResponseTypeDef",
    "ClientDeleteFlowLogsResponseUnsuccessfulErrorTypeDef",
    "ClientDeleteFlowLogsResponseUnsuccessfulTypeDef",
    "ClientDeleteFlowLogsResponseTypeDef",
    "ClientDeleteFpgaImageResponseTypeDef",
    "ClientDeleteLaunchTemplateResponseLaunchTemplateTagsTypeDef",
    "ClientDeleteLaunchTemplateResponseLaunchTemplateTypeDef",
    "ClientDeleteLaunchTemplateResponseTypeDef",
    "ClientDeleteLaunchTemplateVersionsResponseSuccessfullyDeletedLaunchTemplateVersionsTypeDef",
    "ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsResponseErrorTypeDef",
    "ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsTypeDef",
    "ClientDeleteLaunchTemplateVersionsResponseTypeDef",
    "ClientDeleteLocalGatewayRouteResponseRouteTypeDef",
    "ClientDeleteLocalGatewayRouteResponseTypeDef",
    "ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef",
    "ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef",
    "ClientDeleteLocalGatewayRouteTableVpcAssociationResponseTypeDef",
    "ClientDeleteNatGatewayResponseTypeDef",
    "ClientDeleteNetworkInterfacePermissionResponseTypeDef",
    "ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsErrorTypeDef",
    "ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsTypeDef",
    "ClientDeleteQueuedReservedInstancesResponseSuccessfulQueuedPurchaseDeletionsTypeDef",
    "ClientDeleteQueuedReservedInstancesResponseTypeDef",
    "ClientDeleteTagsTagsTypeDef",
    "ClientDeleteTrafficMirrorFilterResponseTypeDef",
    "ClientDeleteTrafficMirrorFilterRuleResponseTypeDef",
    "ClientDeleteTrafficMirrorSessionResponseTypeDef",
    "ClientDeleteTrafficMirrorTargetResponseTypeDef",
    "ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef",
    "ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef",
    "ClientDeleteTransitGatewayMulticastDomainResponseTypeDef",
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTypeDef",
    "ClientDeleteTransitGatewayResponseTransitGatewayOptionsTypeDef",
    "ClientDeleteTransitGatewayResponseTransitGatewayTagsTypeDef",
    "ClientDeleteTransitGatewayResponseTransitGatewayTypeDef",
    "ClientDeleteTransitGatewayResponseTypeDef",
    "ClientDeleteTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef",
    "ClientDeleteTransitGatewayRouteResponseRouteTypeDef",
    "ClientDeleteTransitGatewayRouteResponseTypeDef",
    "ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef",
    "ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef",
    "ClientDeleteTransitGatewayRouteTableResponseTypeDef",
    "ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    "ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    "ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    "ClientDeleteTransitGatewayVpcAttachmentResponseTypeDef",
    "ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulErrorTypeDef",
    "ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulTypeDef",
    "ClientDeleteVpcEndpointConnectionNotificationsResponseTypeDef",
    "ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulErrorTypeDef",
    "ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulTypeDef",
    "ClientDeleteVpcEndpointServiceConfigurationsResponseTypeDef",
    "ClientDeleteVpcEndpointsResponseUnsuccessfulErrorTypeDef",
    "ClientDeleteVpcEndpointsResponseUnsuccessfulTypeDef",
    "ClientDeleteVpcEndpointsResponseTypeDef",
    "ClientDeleteVpcPeeringConnectionResponseTypeDef",
    "ClientDeprovisionByoipCidrResponseByoipCidrTypeDef",
    "ClientDeprovisionByoipCidrResponseTypeDef",
    "ClientDeregisterTransitGatewayMulticastGroupMembersResponseDeregisteredMulticastGroupMembersTypeDef",
    "ClientDeregisterTransitGatewayMulticastGroupMembersResponseTypeDef",
    "ClientDeregisterTransitGatewayMulticastGroupSourcesResponseDeregisteredMulticastGroupSourcesTypeDef",
    "ClientDeregisterTransitGatewayMulticastGroupSourcesResponseTypeDef",
    "ClientDescribeAccountAttributesResponseAccountAttributesAttributeValuesTypeDef",
    "ClientDescribeAccountAttributesResponseAccountAttributesTypeDef",
    "ClientDescribeAccountAttributesResponseTypeDef",
    "ClientDescribeAddressesFiltersTypeDef",
    "ClientDescribeAddressesResponseAddressesTagsTypeDef",
    "ClientDescribeAddressesResponseAddressesTypeDef",
    "ClientDescribeAddressesResponseTypeDef",
    "ClientDescribeAggregateIdFormatResponseStatusesTypeDef",
    "ClientDescribeAggregateIdFormatResponseTypeDef",
    "ClientDescribeAvailabilityZonesFiltersTypeDef",
    "ClientDescribeAvailabilityZonesResponseAvailabilityZonesMessagesTypeDef",
    "ClientDescribeAvailabilityZonesResponseAvailabilityZonesTypeDef",
    "ClientDescribeAvailabilityZonesResponseTypeDef",
    "ClientDescribeBundleTasksFiltersTypeDef",
    "ClientDescribeBundleTasksResponseBundleTasksBundleTaskErrorTypeDef",
    "ClientDescribeBundleTasksResponseBundleTasksStorageS3TypeDef",
    "ClientDescribeBundleTasksResponseBundleTasksStorageTypeDef",
    "ClientDescribeBundleTasksResponseBundleTasksTypeDef",
    "ClientDescribeBundleTasksResponseTypeDef",
    "ClientDescribeByoipCidrsResponseByoipCidrsTypeDef",
    "ClientDescribeByoipCidrsResponseTypeDef",
    "ClientDescribeCapacityReservationsFiltersTypeDef",
    "ClientDescribeCapacityReservationsResponseCapacityReservationsTagsTypeDef",
    "ClientDescribeCapacityReservationsResponseCapacityReservationsTypeDef",
    "ClientDescribeCapacityReservationsResponseTypeDef",
    "ClientDescribeClassicLinkInstancesFiltersTypeDef",
    "ClientDescribeClassicLinkInstancesResponseInstancesGroupsTypeDef",
    "ClientDescribeClassicLinkInstancesResponseInstancesTagsTypeDef",
    "ClientDescribeClassicLinkInstancesResponseInstancesTypeDef",
    "ClientDescribeClassicLinkInstancesResponseTypeDef",
    "ClientDescribeClientVpnAuthorizationRulesFiltersTypeDef",
    "ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesStatusTypeDef",
    "ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesTypeDef",
    "ClientDescribeClientVpnAuthorizationRulesResponseTypeDef",
    "ClientDescribeClientVpnConnectionsFiltersTypeDef",
    "ClientDescribeClientVpnConnectionsResponseConnectionsStatusTypeDef",
    "ClientDescribeClientVpnConnectionsResponseConnectionsTypeDef",
    "ClientDescribeClientVpnConnectionsResponseTypeDef",
    "ClientDescribeClientVpnEndpointsFiltersTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAssociatedTargetNetworksTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsActiveDirectoryTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsMutualAuthenticationTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsConnectionLogOptionsTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsStatusTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTagsTypeDef",
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTypeDef",
    "ClientDescribeClientVpnEndpointsResponseTypeDef",
    "ClientDescribeClientVpnRoutesFiltersTypeDef",
    "ClientDescribeClientVpnRoutesResponseRoutesStatusTypeDef",
    "ClientDescribeClientVpnRoutesResponseRoutesTypeDef",
    "ClientDescribeClientVpnRoutesResponseTypeDef",
    "ClientDescribeClientVpnTargetNetworksFiltersTypeDef",
    "ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksStatusTypeDef",
    "ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksTypeDef",
    "ClientDescribeClientVpnTargetNetworksResponseTypeDef",
    "ClientDescribeCoipPoolsFiltersTypeDef",
    "ClientDescribeCoipPoolsResponseCoipPoolsTagsTypeDef",
    "ClientDescribeCoipPoolsResponseCoipPoolsTypeDef",
    "ClientDescribeCoipPoolsResponseTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesImageTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesVolumeTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksImportVolumeImageTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksImportVolumeVolumeTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksImportVolumeTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksTagsTypeDef",
    "ClientDescribeConversionTasksResponseConversionTasksTypeDef",
    "ClientDescribeConversionTasksResponseTypeDef",
    "ClientDescribeCustomerGatewaysFiltersTypeDef",
    "ClientDescribeCustomerGatewaysResponseCustomerGatewaysTagsTypeDef",
    "ClientDescribeCustomerGatewaysResponseCustomerGatewaysTypeDef",
    "ClientDescribeCustomerGatewaysResponseTypeDef",
    "ClientDescribeDhcpOptionsFiltersTypeDef",
    "ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef",
    "ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef",
    "ClientDescribeDhcpOptionsResponseDhcpOptionsTagsTypeDef",
    "ClientDescribeDhcpOptionsResponseDhcpOptionsTypeDef",
    "ClientDescribeDhcpOptionsResponseTypeDef",
    "ClientDescribeEgressOnlyInternetGatewaysFiltersTypeDef",
    "ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysAttachmentsTypeDef",
    "ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTagsTypeDef",
    "ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTypeDef",
    "ClientDescribeEgressOnlyInternetGatewaysResponseTypeDef",
    "ClientDescribeElasticGpusFiltersTypeDef",
    "ClientDescribeElasticGpusResponseElasticGpuSetElasticGpuHealthTypeDef",
    "ClientDescribeElasticGpusResponseElasticGpuSetTagsTypeDef",
    "ClientDescribeElasticGpusResponseElasticGpuSetTypeDef",
    "ClientDescribeElasticGpusResponseTypeDef",
    "ClientDescribeExportImageTasksFiltersTypeDef",
    "ClientDescribeExportImageTasksResponseExportImageTasksS3ExportLocationTypeDef",
    "ClientDescribeExportImageTasksResponseExportImageTasksTypeDef",
    "ClientDescribeExportImageTasksResponseTypeDef",
    "ClientDescribeExportTasksFiltersTypeDef",
    "ClientDescribeExportTasksResponseExportTasksExportToS3TaskTypeDef",
    "ClientDescribeExportTasksResponseExportTasksInstanceExportDetailsTypeDef",
    "ClientDescribeExportTasksResponseExportTasksTagsTypeDef",
    "ClientDescribeExportTasksResponseExportTasksTypeDef",
    "ClientDescribeExportTasksResponseTypeDef",
    "ClientDescribeFastSnapshotRestoresFiltersTypeDef",
    "ClientDescribeFastSnapshotRestoresResponseFastSnapshotRestoresTypeDef",
    "ClientDescribeFastSnapshotRestoresResponseTypeDef",
    "ClientDescribeFleetHistoryResponseHistoryRecordsEventInformationTypeDef",
    "ClientDescribeFleetHistoryResponseHistoryRecordsTypeDef",
    "ClientDescribeFleetHistoryResponseTypeDef",
    "ClientDescribeFleetInstancesFiltersTypeDef",
    "ClientDescribeFleetInstancesResponseActiveInstancesTypeDef",
    "ClientDescribeFleetInstancesResponseTypeDef",
    "ClientDescribeFleetsFiltersTypeDef",
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesTypeDef",
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesTypeDef",
    "ClientDescribeFleetsResponseFleetsErrorsTypeDef",
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesTypeDef",
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesTypeDef",
    "ClientDescribeFleetsResponseFleetsInstancesTypeDef",
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesPlacementTypeDef",
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesTypeDef",
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsTypeDef",
    "ClientDescribeFleetsResponseFleetsOnDemandOptionsCapacityReservationOptionsTypeDef",
    "ClientDescribeFleetsResponseFleetsOnDemandOptionsTypeDef",
    "ClientDescribeFleetsResponseFleetsSpotOptionsTypeDef",
    "ClientDescribeFleetsResponseFleetsTagsTypeDef",
    "ClientDescribeFleetsResponseFleetsTargetCapacitySpecificationTypeDef",
    "ClientDescribeFleetsResponseFleetsTypeDef",
    "ClientDescribeFleetsResponseTypeDef",
    "ClientDescribeFlowLogsFiltersTypeDef",
    "ClientDescribeFlowLogsResponseFlowLogsTypeDef",
    "ClientDescribeFlowLogsResponseTypeDef",
    "ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef",
    "ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef",
    "ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeTypeDef",
    "ClientDescribeFpgaImageAttributeResponseTypeDef",
    "ClientDescribeFpgaImagesFiltersTypeDef",
    "ClientDescribeFpgaImagesResponseFpgaImagesPciIdTypeDef",
    "ClientDescribeFpgaImagesResponseFpgaImagesProductCodesTypeDef",
    "ClientDescribeFpgaImagesResponseFpgaImagesStateTypeDef",
    "ClientDescribeFpgaImagesResponseFpgaImagesTagsTypeDef",
    "ClientDescribeFpgaImagesResponseFpgaImagesTypeDef",
    "ClientDescribeFpgaImagesResponseTypeDef",
    "ClientDescribeHostReservationOfferingsFiltersTypeDef",
    "ClientDescribeHostReservationOfferingsResponseOfferingSetTypeDef",
    "ClientDescribeHostReservationOfferingsResponseTypeDef",
    "ClientDescribeHostReservationsFiltersTypeDef",
    "ClientDescribeHostReservationsResponseHostReservationSetTagsTypeDef",
    "ClientDescribeHostReservationsResponseHostReservationSetTypeDef",
    "ClientDescribeHostReservationsResponseTypeDef",
    "ClientDescribeHostsFiltersTypeDef",
    "ClientDescribeHostsResponseHostsAvailableCapacityAvailableInstanceCapacityTypeDef",
    "ClientDescribeHostsResponseHostsAvailableCapacityTypeDef",
    "ClientDescribeHostsResponseHostsHostPropertiesTypeDef",
    "ClientDescribeHostsResponseHostsInstancesTypeDef",
    "ClientDescribeHostsResponseHostsTagsTypeDef",
    "ClientDescribeHostsResponseHostsTypeDef",
    "ClientDescribeHostsResponseTypeDef",
    "ClientDescribeIamInstanceProfileAssociationsFiltersTypeDef",
    "ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsIamInstanceProfileTypeDef",
    "ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsTypeDef",
    "ClientDescribeIamInstanceProfileAssociationsResponseTypeDef",
    "ClientDescribeIdFormatResponseStatusesTypeDef",
    "ClientDescribeIdFormatResponseTypeDef",
    "ClientDescribeIdentityIdFormatResponseStatusesTypeDef",
    "ClientDescribeIdentityIdFormatResponseTypeDef",
    "ClientDescribeImageAttributeResponseBlockDeviceMappingsEbsTypeDef",
    "ClientDescribeImageAttributeResponseBlockDeviceMappingsTypeDef",
    "ClientDescribeImageAttributeResponseDescriptionTypeDef",
    "ClientDescribeImageAttributeResponseKernelIdTypeDef",
    "ClientDescribeImageAttributeResponseLaunchPermissionsTypeDef",
    "ClientDescribeImageAttributeResponseProductCodesTypeDef",
    "ClientDescribeImageAttributeResponseRamdiskIdTypeDef",
    "ClientDescribeImageAttributeResponseSriovNetSupportTypeDef",
    "ClientDescribeImageAttributeResponseTypeDef",
    "ClientDescribeImagesFiltersTypeDef",
    "ClientDescribeImagesResponseImagesBlockDeviceMappingsEbsTypeDef",
    "ClientDescribeImagesResponseImagesBlockDeviceMappingsTypeDef",
    "ClientDescribeImagesResponseImagesProductCodesTypeDef",
    "ClientDescribeImagesResponseImagesStateReasonTypeDef",
    "ClientDescribeImagesResponseImagesTagsTypeDef",
    "ClientDescribeImagesResponseImagesTypeDef",
    "ClientDescribeImagesResponseTypeDef",
    "ClientDescribeImportImageTasksFiltersTypeDef",
    "ClientDescribeImportImageTasksResponseImportImageTasksLicenseSpecificationsTypeDef",
    "ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsUserBucketTypeDef",
    "ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsTypeDef",
    "ClientDescribeImportImageTasksResponseImportImageTasksTagsTypeDef",
    "ClientDescribeImportImageTasksResponseImportImageTasksTypeDef",
    "ClientDescribeImportImageTasksResponseTypeDef",
    "ClientDescribeImportSnapshotTasksFiltersTypeDef",
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailUserBucketTypeDef",
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailTypeDef",
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTagsTypeDef",
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTypeDef",
    "ClientDescribeImportSnapshotTasksResponseTypeDef",
    "ClientDescribeInstanceAttributeResponseBlockDeviceMappingsEbsTypeDef",
    "ClientDescribeInstanceAttributeResponseBlockDeviceMappingsTypeDef",
    "ClientDescribeInstanceAttributeResponseDisableApiTerminationTypeDef",
    "ClientDescribeInstanceAttributeResponseEbsOptimizedTypeDef",
    "ClientDescribeInstanceAttributeResponseEnaSupportTypeDef",
    "ClientDescribeInstanceAttributeResponseGroupsTypeDef",
    "ClientDescribeInstanceAttributeResponseInstanceInitiatedShutdownBehaviorTypeDef",
    "ClientDescribeInstanceAttributeResponseInstanceTypeTypeDef",
    "ClientDescribeInstanceAttributeResponseKernelIdTypeDef",
    "ClientDescribeInstanceAttributeResponseProductCodesTypeDef",
    "ClientDescribeInstanceAttributeResponseRamdiskIdTypeDef",
    "ClientDescribeInstanceAttributeResponseRootDeviceNameTypeDef",
    "ClientDescribeInstanceAttributeResponseSourceDestCheckTypeDef",
    "ClientDescribeInstanceAttributeResponseSriovNetSupportTypeDef",
    "ClientDescribeInstanceAttributeResponseUserDataTypeDef",
    "ClientDescribeInstanceAttributeResponseTypeDef",
    "ClientDescribeInstanceCreditSpecificationsFiltersTypeDef",
    "ClientDescribeInstanceCreditSpecificationsResponseInstanceCreditSpecificationsTypeDef",
    "ClientDescribeInstanceCreditSpecificationsResponseTypeDef",
    "ClientDescribeInstanceStatusFiltersTypeDef",
    "ClientDescribeInstanceStatusResponseInstanceStatusesEventsTypeDef",
    "ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStateTypeDef",
    "ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusDetailsTypeDef",
    "ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusTypeDef",
    "ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusDetailsTypeDef",
    "ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusTypeDef",
    "ClientDescribeInstanceStatusResponseInstanceStatusesTypeDef",
    "ClientDescribeInstanceStatusResponseTypeDef",
    "ClientDescribeInstanceTypeOfferingsFiltersTypeDef",
    "ClientDescribeInstanceTypeOfferingsResponseInstanceTypeOfferingsTypeDef",
    "ClientDescribeInstanceTypeOfferingsResponseTypeDef",
    "ClientDescribeInstanceTypesFiltersTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesEbsInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasMemoryInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusMemoryInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoAcceleratorsTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoDisksTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesMemoryInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesNetworkInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesPlacementGroupInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesProcessorInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesVCpuInfoTypeDef",
    "ClientDescribeInstanceTypesResponseInstanceTypesTypeDef",
    "ClientDescribeInstanceTypesResponseTypeDef",
    "ClientDescribeInstancesFiltersTypeDef",
    "ClientDescribeInstancesResponseReservationsGroupsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsEbsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesCpuOptionsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesElasticGpuAssociationsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesElasticInferenceAcceleratorAssociationsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesHibernationOptionsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesIamInstanceProfileTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesLicensesTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesMetadataOptionsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesMonitoringTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAssociationTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAttachmentTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesGroupsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesIpv6AddressesTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesPlacementTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesProductCodesTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesSecurityGroupsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesStateReasonTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesStateTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesTagsTypeDef",
    "ClientDescribeInstancesResponseReservationsInstancesTypeDef",
    "ClientDescribeInstancesResponseReservationsTypeDef",
    "ClientDescribeInstancesResponseTypeDef",
    "ClientDescribeInternetGatewaysFiltersTypeDef",
    "ClientDescribeInternetGatewaysResponseInternetGatewaysAttachmentsTypeDef",
    "ClientDescribeInternetGatewaysResponseInternetGatewaysTagsTypeDef",
    "ClientDescribeInternetGatewaysResponseInternetGatewaysTypeDef",
    "ClientDescribeInternetGatewaysResponseTypeDef",
    "ClientDescribeIpv6PoolsFiltersTypeDef",
    "ClientDescribeIpv6PoolsResponseIpv6PoolsPoolCidrBlocksTypeDef",
    "ClientDescribeIpv6PoolsResponseIpv6PoolsTagsTypeDef",
    "ClientDescribeIpv6PoolsResponseIpv6PoolsTypeDef",
    "ClientDescribeIpv6PoolsResponseTypeDef",
    "ClientDescribeKeyPairsFiltersTypeDef",
    "ClientDescribeKeyPairsResponseKeyPairsTagsTypeDef",
    "ClientDescribeKeyPairsResponseKeyPairsTypeDef",
    "ClientDescribeKeyPairsResponseTypeDef",
    "ClientDescribeLaunchTemplateVersionsFiltersTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCpuOptionsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCreditSpecificationTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataHibernationOptionsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataIamInstanceProfileTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataLicenseSpecificationsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMetadataOptionsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMonitoringTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataPlacementTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTagsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsTypeDef",
    "ClientDescribeLaunchTemplateVersionsResponseTypeDef",
    "ClientDescribeLaunchTemplatesFiltersTypeDef",
    "ClientDescribeLaunchTemplatesResponseLaunchTemplatesTagsTypeDef",
    "ClientDescribeLaunchTemplatesResponseLaunchTemplatesTypeDef",
    "ClientDescribeLaunchTemplatesResponseTypeDef",
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsFiltersTypeDef",
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTagsTypeDef",
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTypeDef",
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseTypeDef",
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsFiltersTypeDef",
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTagsTypeDef",
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTypeDef",
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseTypeDef",
    "ClientDescribeLocalGatewayRouteTablesFiltersTypeDef",
    "ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTagsTypeDef",
    "ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTypeDef",
    "ClientDescribeLocalGatewayRouteTablesResponseTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsFiltersTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTagsTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfacesFiltersTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTagsTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTypeDef",
    "ClientDescribeLocalGatewayVirtualInterfacesResponseTypeDef",
    "ClientDescribeLocalGatewaysFiltersTypeDef",
    "ClientDescribeLocalGatewaysResponseLocalGatewaysTagsTypeDef",
    "ClientDescribeLocalGatewaysResponseLocalGatewaysTypeDef",
    "ClientDescribeLocalGatewaysResponseTypeDef",
    "ClientDescribeMovingAddressesFiltersTypeDef",
    "ClientDescribeMovingAddressesResponseMovingAddressStatusesTypeDef",
    "ClientDescribeMovingAddressesResponseTypeDef",
    "ClientDescribeNatGatewaysFiltersTypeDef",
    "ClientDescribeNatGatewaysResponseNatGatewaysNatGatewayAddressesTypeDef",
    "ClientDescribeNatGatewaysResponseNatGatewaysProvisionedBandwidthTypeDef",
    "ClientDescribeNatGatewaysResponseNatGatewaysTagsTypeDef",
    "ClientDescribeNatGatewaysResponseNatGatewaysTypeDef",
    "ClientDescribeNatGatewaysResponseTypeDef",
    "ClientDescribeNetworkAclsFiltersTypeDef",
    "ClientDescribeNetworkAclsResponseNetworkAclsAssociationsTypeDef",
    "ClientDescribeNetworkAclsResponseNetworkAclsEntriesIcmpTypeCodeTypeDef",
    "ClientDescribeNetworkAclsResponseNetworkAclsEntriesPortRangeTypeDef",
    "ClientDescribeNetworkAclsResponseNetworkAclsEntriesTypeDef",
    "ClientDescribeNetworkAclsResponseNetworkAclsTagsTypeDef",
    "ClientDescribeNetworkAclsResponseNetworkAclsTypeDef",
    "ClientDescribeNetworkAclsResponseTypeDef",
    "ClientDescribeNetworkInterfaceAttributeResponseAttachmentTypeDef",
    "ClientDescribeNetworkInterfaceAttributeResponseDescriptionTypeDef",
    "ClientDescribeNetworkInterfaceAttributeResponseGroupsTypeDef",
    "ClientDescribeNetworkInterfaceAttributeResponseSourceDestCheckTypeDef",
    "ClientDescribeNetworkInterfaceAttributeResponseTypeDef",
    "ClientDescribeNetworkInterfacePermissionsFiltersTypeDef",
    "ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsPermissionStateTypeDef",
    "ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsTypeDef",
    "ClientDescribeNetworkInterfacePermissionsResponseTypeDef",
    "ClientDescribeNetworkInterfacesFiltersTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesAssociationTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesAttachmentTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesGroupsTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesIpv6AddressesTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesAssociationTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesTagSetTypeDef",
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesTypeDef",
    "ClientDescribeNetworkInterfacesResponseTypeDef",
    "ClientDescribePlacementGroupsFiltersTypeDef",
    "ClientDescribePlacementGroupsResponsePlacementGroupsTagsTypeDef",
    "ClientDescribePlacementGroupsResponsePlacementGroupsTypeDef",
    "ClientDescribePlacementGroupsResponseTypeDef",
    "ClientDescribePrefixListsFiltersTypeDef",
    "ClientDescribePrefixListsResponsePrefixListsTypeDef",
    "ClientDescribePrefixListsResponseTypeDef",
    "ClientDescribePrincipalIdFormatResponsePrincipalsStatusesTypeDef",
    "ClientDescribePrincipalIdFormatResponsePrincipalsTypeDef",
    "ClientDescribePrincipalIdFormatResponseTypeDef",
    "ClientDescribePublicIpv4PoolsFiltersTypeDef",
    "ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsPoolAddressRangesTypeDef",
    "ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTagsTypeDef",
    "ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTypeDef",
    "ClientDescribePublicIpv4PoolsResponseTypeDef",
    "ClientDescribeRegionsFiltersTypeDef",
    "ClientDescribeRegionsResponseRegionsTypeDef",
    "ClientDescribeRegionsResponseTypeDef",
    "ClientDescribeReservedInstancesFiltersTypeDef",
    "ClientDescribeReservedInstancesListingsFiltersTypeDef",
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsInstanceCountsTypeDef",
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsPriceSchedulesTypeDef",
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTagsTypeDef",
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTypeDef",
    "ClientDescribeReservedInstancesListingsResponseTypeDef",
    "ClientDescribeReservedInstancesModificationsFiltersTypeDef",
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTargetConfigurationTypeDef",
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTypeDef",
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsReservedInstancesIdsTypeDef",
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsTypeDef",
    "ClientDescribeReservedInstancesModificationsResponseTypeDef",
    "ClientDescribeReservedInstancesOfferingsFiltersTypeDef",
    "ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsPricingDetailsTypeDef",
    "ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsRecurringChargesTypeDef",
    "ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsTypeDef",
    "ClientDescribeReservedInstancesOfferingsResponseTypeDef",
    "ClientDescribeReservedInstancesResponseReservedInstancesRecurringChargesTypeDef",
    "ClientDescribeReservedInstancesResponseReservedInstancesTagsTypeDef",
    "ClientDescribeReservedInstancesResponseReservedInstancesTypeDef",
    "ClientDescribeReservedInstancesResponseTypeDef",
    "ClientDescribeRouteTablesFiltersTypeDef",
    "ClientDescribeRouteTablesResponseRouteTablesAssociationsAssociationStateTypeDef",
    "ClientDescribeRouteTablesResponseRouteTablesAssociationsTypeDef",
    "ClientDescribeRouteTablesResponseRouteTablesPropagatingVgwsTypeDef",
    "ClientDescribeRouteTablesResponseRouteTablesRoutesTypeDef",
    "ClientDescribeRouteTablesResponseRouteTablesTagsTypeDef",
    "ClientDescribeRouteTablesResponseRouteTablesTypeDef",
    "ClientDescribeRouteTablesResponseTypeDef",
    "ClientDescribeScheduledInstanceAvailabilityFiltersTypeDef",
    "ClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef",
    "ClientDescribeScheduledInstanceAvailabilityRecurrenceTypeDef",
    "ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetRecurrenceTypeDef",
    "ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetTypeDef",
    "ClientDescribeScheduledInstanceAvailabilityResponseTypeDef",
    "ClientDescribeScheduledInstancesFiltersTypeDef",
    "ClientDescribeScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef",
    "ClientDescribeScheduledInstancesResponseScheduledInstanceSetTypeDef",
    "ClientDescribeScheduledInstancesResponseTypeDef",
    "ClientDescribeScheduledInstancesSlotStartTimeRangeTypeDef",
    "ClientDescribeSecurityGroupReferencesResponseSecurityGroupReferenceSetTypeDef",
    "ClientDescribeSecurityGroupReferencesResponseTypeDef",
    "ClientDescribeSecurityGroupsFiltersTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpRangesTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpv6RangesTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressPrefixListIdsTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressUserIdGroupPairsTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpRangesTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpv6RangesTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsPrefixListIdsTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsUserIdGroupPairsTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsTagsTypeDef",
    "ClientDescribeSecurityGroupsResponseSecurityGroupsTypeDef",
    "ClientDescribeSecurityGroupsResponseTypeDef",
    "ClientDescribeSnapshotAttributeResponseCreateVolumePermissionsTypeDef",
    "ClientDescribeSnapshotAttributeResponseProductCodesTypeDef",
    "ClientDescribeSnapshotAttributeResponseTypeDef",
    "ClientDescribeSnapshotsFiltersTypeDef",
    "ClientDescribeSnapshotsResponseSnapshotsTagsTypeDef",
    "ClientDescribeSnapshotsResponseSnapshotsTypeDef",
    "ClientDescribeSnapshotsResponseTypeDef",
    "ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef",
    "ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef",
    "ClientDescribeSpotDatafeedSubscriptionResponseTypeDef",
    "ClientDescribeSpotFleetInstancesResponseActiveInstancesTypeDef",
    "ClientDescribeSpotFleetInstancesResponseTypeDef",
    "ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsEventInformationTypeDef",
    "ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsTypeDef",
    "ClientDescribeSpotFleetRequestHistoryResponseTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTagsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTagsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTypeDef",
    "ClientDescribeSpotFleetRequestsResponseTypeDef",
    "ClientDescribeSpotInstanceRequestsFiltersTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsFaultTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsStatusTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTagsTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTypeDef",
    "ClientDescribeSpotInstanceRequestsResponseTypeDef",
    "ClientDescribeSpotPriceHistoryFiltersTypeDef",
    "ClientDescribeSpotPriceHistoryResponseSpotPriceHistoryTypeDef",
    "ClientDescribeSpotPriceHistoryResponseTypeDef",
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressUserIdGroupPairsTypeDef",
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressTypeDef",
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsUserIdGroupPairsTypeDef",
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsTypeDef",
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetTypeDef",
    "ClientDescribeStaleSecurityGroupsResponseTypeDef",
    "ClientDescribeSubnetsFiltersTypeDef",
    "ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    "ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetTypeDef",
    "ClientDescribeSubnetsResponseSubnetsTagsTypeDef",
    "ClientDescribeSubnetsResponseSubnetsTypeDef",
    "ClientDescribeSubnetsResponseTypeDef",
    "ClientDescribeTagsFiltersTypeDef",
    "ClientDescribeTagsResponseTagsTypeDef",
    "ClientDescribeTagsResponseTypeDef",
    "ClientDescribeTrafficMirrorFiltersFiltersTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesDestinationPortRangeTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesSourcePortRangeTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesDestinationPortRangeTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesSourcePortRangeTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTagsTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTypeDef",
    "ClientDescribeTrafficMirrorFiltersResponseTypeDef",
    "ClientDescribeTrafficMirrorSessionsFiltersTypeDef",
    "ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTagsTypeDef",
    "ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTypeDef",
    "ClientDescribeTrafficMirrorSessionsResponseTypeDef",
    "ClientDescribeTrafficMirrorTargetsFiltersTypeDef",
    "ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTagsTypeDef",
    "ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTypeDef",
    "ClientDescribeTrafficMirrorTargetsResponseTypeDef",
    "ClientDescribeTransitGatewayAttachmentsFiltersTypeDef",
    "ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsAssociationTypeDef",
    "ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTagsTypeDef",
    "ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTypeDef",
    "ClientDescribeTransitGatewayAttachmentsResponseTypeDef",
    "ClientDescribeTransitGatewayMulticastDomainsFiltersTypeDef",
    "ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTagsTypeDef",
    "ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTypeDef",
    "ClientDescribeTransitGatewayMulticastDomainsResponseTypeDef",
    "ClientDescribeTransitGatewayPeeringAttachmentsFiltersTypeDef",
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsAccepterTgwInfoTypeDef",
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsRequesterTgwInfoTypeDef",
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsStatusTypeDef",
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTagsTypeDef",
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTypeDef",
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTypeDef",
    "ClientDescribeTransitGatewayRouteTablesFiltersTypeDef",
    "ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTagsTypeDef",
    "ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTypeDef",
    "ClientDescribeTransitGatewayRouteTablesResponseTypeDef",
    "ClientDescribeTransitGatewayVpcAttachmentsFiltersTypeDef",
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsOptionsTypeDef",
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTagsTypeDef",
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTypeDef",
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTypeDef",
    "ClientDescribeTransitGatewaysFiltersTypeDef",
    "ClientDescribeTransitGatewaysResponseTransitGatewaysOptionsTypeDef",
    "ClientDescribeTransitGatewaysResponseTransitGatewaysTagsTypeDef",
    "ClientDescribeTransitGatewaysResponseTransitGatewaysTypeDef",
    "ClientDescribeTransitGatewaysResponseTypeDef",
    "ClientDescribeVolumeAttributeResponseAutoEnableIOTypeDef",
    "ClientDescribeVolumeAttributeResponseProductCodesTypeDef",
    "ClientDescribeVolumeAttributeResponseTypeDef",
    "ClientDescribeVolumeStatusFiltersTypeDef",
    "ClientDescribeVolumeStatusResponseVolumeStatusesActionsTypeDef",
    "ClientDescribeVolumeStatusResponseVolumeStatusesAttachmentStatusesTypeDef",
    "ClientDescribeVolumeStatusResponseVolumeStatusesEventsTypeDef",
    "ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusDetailsTypeDef",
    "ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusTypeDef",
    "ClientDescribeVolumeStatusResponseVolumeStatusesTypeDef",
    "ClientDescribeVolumeStatusResponseTypeDef",
    "ClientDescribeVolumesFiltersTypeDef",
    "ClientDescribeVolumesModificationsFiltersTypeDef",
    "ClientDescribeVolumesModificationsResponseVolumesModificationsTypeDef",
    "ClientDescribeVolumesModificationsResponseTypeDef",
    "ClientDescribeVolumesResponseVolumesAttachmentsTypeDef",
    "ClientDescribeVolumesResponseVolumesTagsTypeDef",
    "ClientDescribeVolumesResponseVolumesTypeDef",
    "ClientDescribeVolumesResponseTypeDef",
    "ClientDescribeVpcAttributeResponseEnableDnsHostnamesTypeDef",
    "ClientDescribeVpcAttributeResponseEnableDnsSupportTypeDef",
    "ClientDescribeVpcAttributeResponseTypeDef",
    "ClientDescribeVpcClassicLinkDnsSupportResponseVpcsTypeDef",
    "ClientDescribeVpcClassicLinkDnsSupportResponseTypeDef",
    "ClientDescribeVpcClassicLinkFiltersTypeDef",
    "ClientDescribeVpcClassicLinkResponseVpcsTagsTypeDef",
    "ClientDescribeVpcClassicLinkResponseVpcsTypeDef",
    "ClientDescribeVpcClassicLinkResponseTypeDef",
    "ClientDescribeVpcEndpointConnectionNotificationsFiltersTypeDef",
    "ClientDescribeVpcEndpointConnectionNotificationsResponseConnectionNotificationSetTypeDef",
    "ClientDescribeVpcEndpointConnectionNotificationsResponseTypeDef",
    "ClientDescribeVpcEndpointConnectionsFiltersTypeDef",
    "ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsDnsEntriesTypeDef",
    "ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsTypeDef",
    "ClientDescribeVpcEndpointConnectionsResponseTypeDef",
    "ClientDescribeVpcEndpointServiceConfigurationsFiltersTypeDef",
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsPrivateDnsNameConfigurationTypeDef",
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsServiceTypeTypeDef",
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTagsTypeDef",
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTypeDef",
    "ClientDescribeVpcEndpointServiceConfigurationsResponseTypeDef",
    "ClientDescribeVpcEndpointServicePermissionsFiltersTypeDef",
    "ClientDescribeVpcEndpointServicePermissionsResponseAllowedPrincipalsTypeDef",
    "ClientDescribeVpcEndpointServicePermissionsResponseTypeDef",
    "ClientDescribeVpcEndpointServicesFiltersTypeDef",
    "ClientDescribeVpcEndpointServicesResponseServiceDetailsServiceTypeTypeDef",
    "ClientDescribeVpcEndpointServicesResponseServiceDetailsTagsTypeDef",
    "ClientDescribeVpcEndpointServicesResponseServiceDetailsTypeDef",
    "ClientDescribeVpcEndpointServicesResponseTypeDef",
    "ClientDescribeVpcEndpointsFiltersTypeDef",
    "ClientDescribeVpcEndpointsResponseVpcEndpointsDnsEntriesTypeDef",
    "ClientDescribeVpcEndpointsResponseVpcEndpointsGroupsTypeDef",
    "ClientDescribeVpcEndpointsResponseVpcEndpointsLastErrorTypeDef",
    "ClientDescribeVpcEndpointsResponseVpcEndpointsTagsTypeDef",
    "ClientDescribeVpcEndpointsResponseVpcEndpointsTypeDef",
    "ClientDescribeVpcEndpointsResponseTypeDef",
    "ClientDescribeVpcPeeringConnectionsFiltersTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoCidrBlockSetTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoIpv6CidrBlockSetTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoPeeringOptionsTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoCidrBlockSetTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoIpv6CidrBlockSetTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoPeeringOptionsTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsStatusTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTagsTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTypeDef",
    "ClientDescribeVpcPeeringConnectionsResponseTypeDef",
    "ClientDescribeVpcsFiltersTypeDef",
    "ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetCidrBlockStateTypeDef",
    "ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetTypeDef",
    "ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    "ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetTypeDef",
    "ClientDescribeVpcsResponseVpcsTagsTypeDef",
    "ClientDescribeVpcsResponseVpcsTypeDef",
    "ClientDescribeVpcsResponseTypeDef",
    "ClientDescribeVpnConnectionsFiltersTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsIkeVersionsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsRoutesTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsTagsTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsVgwTelemetryTypeDef",
    "ClientDescribeVpnConnectionsResponseVpnConnectionsTypeDef",
    "ClientDescribeVpnConnectionsResponseTypeDef",
    "ClientDescribeVpnGatewaysFiltersTypeDef",
    "ClientDescribeVpnGatewaysResponseVpnGatewaysTagsTypeDef",
    "ClientDescribeVpnGatewaysResponseVpnGatewaysVpcAttachmentsTypeDef",
    "ClientDescribeVpnGatewaysResponseVpnGatewaysTypeDef",
    "ClientDescribeVpnGatewaysResponseTypeDef",
    "ClientDetachClassicLinkVpcResponseTypeDef",
    "ClientDetachVolumeResponseTypeDef",
    "ClientDisableEbsEncryptionByDefaultResponseTypeDef",
    "ClientDisableFastSnapshotRestoresResponseSuccessfulTypeDef",
    "ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef",
    "ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef",
    "ClientDisableFastSnapshotRestoresResponseUnsuccessfulTypeDef",
    "ClientDisableFastSnapshotRestoresResponseTypeDef",
    "ClientDisableTransitGatewayRouteTablePropagationResponsePropagationTypeDef",
    "ClientDisableTransitGatewayRouteTablePropagationResponseTypeDef",
    "ClientDisableVpcClassicLinkDnsSupportResponseTypeDef",
    "ClientDisableVpcClassicLinkResponseTypeDef",
    "ClientDisassociateClientVpnTargetNetworkResponseStatusTypeDef",
    "ClientDisassociateClientVpnTargetNetworkResponseTypeDef",
    "ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    "ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef",
    "ClientDisassociateIamInstanceProfileResponseTypeDef",
    "ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    "ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    "ClientDisassociateSubnetCidrBlockResponseTypeDef",
    "ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef",
    "ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsTypeDef",
    "ClientDisassociateTransitGatewayMulticastDomainResponseTypeDef",
    "ClientDisassociateTransitGatewayRouteTableResponseAssociationTypeDef",
    "ClientDisassociateTransitGatewayRouteTableResponseTypeDef",
    "ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef",
    "ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationTypeDef",
    "ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    "ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    "ClientDisassociateVpcCidrBlockResponseTypeDef",
    "ClientEnableEbsEncryptionByDefaultResponseTypeDef",
    "ClientEnableFastSnapshotRestoresResponseSuccessfulTypeDef",
    "ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef",
    "ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef",
    "ClientEnableFastSnapshotRestoresResponseUnsuccessfulTypeDef",
    "ClientEnableFastSnapshotRestoresResponseTypeDef",
    "ClientEnableTransitGatewayRouteTablePropagationResponsePropagationTypeDef",
    "ClientEnableTransitGatewayRouteTablePropagationResponseTypeDef",
    "ClientEnableVpcClassicLinkDnsSupportResponseTypeDef",
    "ClientEnableVpcClassicLinkResponseTypeDef",
    "ClientExportClientVpnClientCertificateRevocationListResponseStatusTypeDef",
    "ClientExportClientVpnClientCertificateRevocationListResponseTypeDef",
    "ClientExportClientVpnClientConfigurationResponseTypeDef",
    "ClientExportImageResponseS3ExportLocationTypeDef",
    "ClientExportImageResponseTypeDef",
    "ClientExportImageS3ExportLocationTypeDef",
    "ClientExportTransitGatewayRoutesFiltersTypeDef",
    "ClientExportTransitGatewayRoutesResponseTypeDef",
    "ClientGetAssociatedIpv6PoolCidrsResponseIpv6CidrAssociationsTypeDef",
    "ClientGetAssociatedIpv6PoolCidrsResponseTypeDef",
    "ClientGetCapacityReservationUsageResponseInstanceUsagesTypeDef",
    "ClientGetCapacityReservationUsageResponseTypeDef",
    "ClientGetCoipPoolUsageFiltersTypeDef",
    "ClientGetCoipPoolUsageResponseCoipAddressUsagesTypeDef",
    "ClientGetCoipPoolUsageResponseTypeDef",
    "ClientGetConsoleOutputResponseTypeDef",
    "ClientGetConsoleScreenshotResponseTypeDef",
    "ClientGetDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef",
    "ClientGetDefaultCreditSpecificationResponseTypeDef",
    "ClientGetEbsDefaultKmsKeyIdResponseTypeDef",
    "ClientGetEbsEncryptionByDefaultResponseTypeDef",
    "ClientGetHostReservationPurchasePreviewResponsePurchaseTypeDef",
    "ClientGetHostReservationPurchasePreviewResponseTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCpuOptionsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCreditSpecificationTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataHibernationOptionsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataIamInstanceProfileTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataLicenseSpecificationsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataMetadataOptionsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataMonitoringTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataPlacementTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTagsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTypeDef",
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataTypeDef",
    "ClientGetLaunchTemplateDataResponseTypeDef",
    "ClientGetPasswordDataResponseTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueRollupTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetReservationValueTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueRollupTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetReservationValueTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTargetConfigurationTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTypeDef",
    "ClientGetReservedInstancesExchangeQuoteResponseTypeDef",
    "ClientGetReservedInstancesExchangeQuoteTargetConfigurationsTypeDef",
    "ClientGetTransitGatewayAttachmentPropagationsFiltersTypeDef",
    "ClientGetTransitGatewayAttachmentPropagationsResponseTransitGatewayAttachmentPropagationsTypeDef",
    "ClientGetTransitGatewayAttachmentPropagationsResponseTypeDef",
    "ClientGetTransitGatewayMulticastDomainAssociationsFiltersTypeDef",
    "ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsSubnetTypeDef",
    "ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsTypeDef",
    "ClientGetTransitGatewayMulticastDomainAssociationsResponseTypeDef",
    "ClientGetTransitGatewayRouteTableAssociationsFiltersTypeDef",
    "ClientGetTransitGatewayRouteTableAssociationsResponseAssociationsTypeDef",
    "ClientGetTransitGatewayRouteTableAssociationsResponseTypeDef",
    "ClientGetTransitGatewayRouteTablePropagationsFiltersTypeDef",
    "ClientGetTransitGatewayRouteTablePropagationsResponseTransitGatewayRouteTablePropagationsTypeDef",
    "ClientGetTransitGatewayRouteTablePropagationsResponseTypeDef",
    "ClientImportClientVpnClientCertificateRevocationListResponseTypeDef",
    "ClientImportImageClientDataTypeDef",
    "ClientImportImageDiskContainersUserBucketTypeDef",
    "ClientImportImageDiskContainersTypeDef",
    "ClientImportImageLicenseSpecificationsTypeDef",
    "ClientImportImageResponseLicenseSpecificationsTypeDef",
    "ClientImportImageResponseSnapshotDetailsUserBucketTypeDef",
    "ClientImportImageResponseSnapshotDetailsTypeDef",
    "ClientImportImageResponseTypeDef",
    "ClientImportInstanceDiskImagesImageTypeDef",
    "ClientImportInstanceDiskImagesVolumeTypeDef",
    "ClientImportInstanceDiskImagesTypeDef",
    "ClientImportInstanceLaunchSpecificationPlacementTypeDef",
    "ClientImportInstanceLaunchSpecificationUserDataTypeDef",
    "ClientImportInstanceLaunchSpecificationTypeDef",
    "ClientImportInstanceResponseConversionTaskImportInstanceVolumesImageTypeDef",
    "ClientImportInstanceResponseConversionTaskImportInstanceVolumesVolumeTypeDef",
    "ClientImportInstanceResponseConversionTaskImportInstanceVolumesTypeDef",
    "ClientImportInstanceResponseConversionTaskImportInstanceTypeDef",
    "ClientImportInstanceResponseConversionTaskImportVolumeImageTypeDef",
    "ClientImportInstanceResponseConversionTaskImportVolumeVolumeTypeDef",
    "ClientImportInstanceResponseConversionTaskImportVolumeTypeDef",
    "ClientImportInstanceResponseConversionTaskTagsTypeDef",
    "ClientImportInstanceResponseConversionTaskTypeDef",
    "ClientImportInstanceResponseTypeDef",
    "ClientImportKeyPairResponseTypeDef",
    "ClientImportSnapshotClientDataTypeDef",
    "ClientImportSnapshotDiskContainerUserBucketTypeDef",
    "ClientImportSnapshotDiskContainerTypeDef",
    "ClientImportSnapshotResponseSnapshotTaskDetailUserBucketTypeDef",
    "ClientImportSnapshotResponseSnapshotTaskDetailTypeDef",
    "ClientImportSnapshotResponseTypeDef",
    "ClientImportVolumeImageTypeDef",
    "ClientImportVolumeResponseConversionTaskImportInstanceVolumesImageTypeDef",
    "ClientImportVolumeResponseConversionTaskImportInstanceVolumesVolumeTypeDef",
    "ClientImportVolumeResponseConversionTaskImportInstanceVolumesTypeDef",
    "ClientImportVolumeResponseConversionTaskImportInstanceTypeDef",
    "ClientImportVolumeResponseConversionTaskImportVolumeImageTypeDef",
    "ClientImportVolumeResponseConversionTaskImportVolumeVolumeTypeDef",
    "ClientImportVolumeResponseConversionTaskImportVolumeTypeDef",
    "ClientImportVolumeResponseConversionTaskTagsTypeDef",
    "ClientImportVolumeResponseConversionTaskTypeDef",
    "ClientImportVolumeResponseTypeDef",
    "ClientImportVolumeVolumeTypeDef",
    "ClientModifyCapacityReservationResponseTypeDef",
    "ClientModifyClientVpnEndpointConnectionLogOptionsTypeDef",
    "ClientModifyClientVpnEndpointDnsServersTypeDef",
    "ClientModifyClientVpnEndpointResponseTypeDef",
    "ClientModifyDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef",
    "ClientModifyDefaultCreditSpecificationResponseTypeDef",
    "ClientModifyEbsDefaultKmsKeyIdResponseTypeDef",
    "ClientModifyFleetResponseTypeDef",
    "ClientModifyFleetTargetCapacitySpecificationTypeDef",
    "ClientModifyFpgaImageAttributeLoadPermissionAddTypeDef",
    "ClientModifyFpgaImageAttributeLoadPermissionRemoveTypeDef",
    "ClientModifyFpgaImageAttributeLoadPermissionTypeDef",
    "ClientModifyFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef",
    "ClientModifyFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef",
    "ClientModifyFpgaImageAttributeResponseFpgaImageAttributeTypeDef",
    "ClientModifyFpgaImageAttributeResponseTypeDef",
    "ClientModifyHostsResponseUnsuccessfulErrorTypeDef",
    "ClientModifyHostsResponseUnsuccessfulTypeDef",
    "ClientModifyHostsResponseTypeDef",
    "ClientModifyImageAttributeDescriptionTypeDef",
    "ClientModifyImageAttributeLaunchPermissionAddTypeDef",
    "ClientModifyImageAttributeLaunchPermissionRemoveTypeDef",
    "ClientModifyImageAttributeLaunchPermissionTypeDef",
    "ClientModifyInstanceAttributeBlockDeviceMappingsEbsTypeDef",
    "ClientModifyInstanceAttributeBlockDeviceMappingsTypeDef",
    "ClientModifyInstanceAttributeDisableApiTerminationTypeDef",
    "ClientModifyInstanceAttributeEbsOptimizedTypeDef",
    "ClientModifyInstanceAttributeEnaSupportTypeDef",
    "ClientModifyInstanceAttributeInstanceInitiatedShutdownBehaviorTypeDef",
    "ClientModifyInstanceAttributeInstanceTypeTypeDef",
    "ClientModifyInstanceAttributeKernelTypeDef",
    "ClientModifyInstanceAttributeRamdiskTypeDef",
    "ClientModifyInstanceAttributeSourceDestCheckTypeDef",
    "ClientModifyInstanceAttributeSriovNetSupportTypeDef",
    "ClientModifyInstanceAttributeUserDataTypeDef",
    "ClientModifyInstanceCapacityReservationAttributesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientModifyInstanceCapacityReservationAttributesCapacityReservationSpecificationTypeDef",
    "ClientModifyInstanceCapacityReservationAttributesResponseTypeDef",
    "ClientModifyInstanceCreditSpecificationInstanceCreditSpecificationsTypeDef",
    "ClientModifyInstanceCreditSpecificationResponseSuccessfulInstanceCreditSpecificationsTypeDef",
    "ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsErrorTypeDef",
    "ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsTypeDef",
    "ClientModifyInstanceCreditSpecificationResponseTypeDef",
    "ClientModifyInstanceEventStartTimeResponseEventTypeDef",
    "ClientModifyInstanceEventStartTimeResponseTypeDef",
    "ClientModifyInstanceMetadataOptionsResponseInstanceMetadataOptionsTypeDef",
    "ClientModifyInstanceMetadataOptionsResponseTypeDef",
    "ClientModifyInstancePlacementResponseTypeDef",
    "ClientModifyLaunchTemplateResponseLaunchTemplateTagsTypeDef",
    "ClientModifyLaunchTemplateResponseLaunchTemplateTypeDef",
    "ClientModifyLaunchTemplateResponseTypeDef",
    "ClientModifyNetworkInterfaceAttributeAttachmentTypeDef",
    "ClientModifyNetworkInterfaceAttributeDescriptionTypeDef",
    "ClientModifyNetworkInterfaceAttributeSourceDestCheckTypeDef",
    "ClientModifyReservedInstancesResponseTypeDef",
    "ClientModifyReservedInstancesTargetConfigurationsTypeDef",
    "ClientModifySnapshotAttributeCreateVolumePermissionAddTypeDef",
    "ClientModifySnapshotAttributeCreateVolumePermissionRemoveTypeDef",
    "ClientModifySnapshotAttributeCreateVolumePermissionTypeDef",
    "ClientModifySpotFleetRequestResponseTypeDef",
    "ClientModifySubnetAttributeAssignIpv6AddressOnCreationTypeDef",
    "ClientModifySubnetAttributeMapPublicIpOnLaunchTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTagsTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTypeDef",
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTypeDef",
    "ClientModifyTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    "ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    "ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    "ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef",
    "ClientModifyTrafficMirrorFilterRuleResponseTypeDef",
    "ClientModifyTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    "ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef",
    "ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef",
    "ClientModifyTrafficMirrorSessionResponseTypeDef",
    "ClientModifyTransitGatewayVpcAttachmentOptionsTypeDef",
    "ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    "ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    "ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    "ClientModifyTransitGatewayVpcAttachmentResponseTypeDef",
    "ClientModifyVolumeAttributeAutoEnableIOTypeDef",
    "ClientModifyVolumeResponseVolumeModificationTypeDef",
    "ClientModifyVolumeResponseTypeDef",
    "ClientModifyVpcAttributeEnableDnsHostnamesTypeDef",
    "ClientModifyVpcAttributeEnableDnsSupportTypeDef",
    "ClientModifyVpcEndpointConnectionNotificationResponseTypeDef",
    "ClientModifyVpcEndpointResponseTypeDef",
    "ClientModifyVpcEndpointServiceConfigurationResponseTypeDef",
    "ClientModifyVpcEndpointServicePermissionsResponseTypeDef",
    "ClientModifyVpcPeeringConnectionOptionsAccepterPeeringConnectionOptionsTypeDef",
    "ClientModifyVpcPeeringConnectionOptionsRequesterPeeringConnectionOptionsTypeDef",
    "ClientModifyVpcPeeringConnectionOptionsResponseAccepterPeeringConnectionOptionsTypeDef",
    "ClientModifyVpcPeeringConnectionOptionsResponseRequesterPeeringConnectionOptionsTypeDef",
    "ClientModifyVpcPeeringConnectionOptionsResponseTypeDef",
    "ClientModifyVpcTenancyResponseTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionRoutesTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionTagsTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef",
    "ClientModifyVpnConnectionResponseVpnConnectionTypeDef",
    "ClientModifyVpnConnectionResponseTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionRoutesTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionTagsTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionVgwTelemetryTypeDef",
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionTypeDef",
    "ClientModifyVpnTunnelCertificateResponseTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionRoutesTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionTagsTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionVgwTelemetryTypeDef",
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionTypeDef",
    "ClientModifyVpnTunnelOptionsResponseTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsIKEVersionsTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    "ClientModifyVpnTunnelOptionsTunnelOptionsTypeDef",
    "ClientMonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef",
    "ClientMonitorInstancesResponseInstanceMonitoringsTypeDef",
    "ClientMonitorInstancesResponseTypeDef",
    "ClientMoveAddressToVpcResponseTypeDef",
    "ClientProvisionByoipCidrCidrAuthorizationContextTypeDef",
    "ClientProvisionByoipCidrResponseByoipCidrTypeDef",
    "ClientProvisionByoipCidrResponseTypeDef",
    "ClientPurchaseHostReservationResponsePurchaseTypeDef",
    "ClientPurchaseHostReservationResponseTypeDef",
    "ClientPurchaseReservedInstancesOfferingLimitPriceTypeDef",
    "ClientPurchaseReservedInstancesOfferingResponseTypeDef",
    "ClientPurchaseScheduledInstancesPurchaseRequestsTypeDef",
    "ClientPurchaseScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef",
    "ClientPurchaseScheduledInstancesResponseScheduledInstanceSetTypeDef",
    "ClientPurchaseScheduledInstancesResponseTypeDef",
    "ClientRegisterImageBlockDeviceMappingsEbsTypeDef",
    "ClientRegisterImageBlockDeviceMappingsTypeDef",
    "ClientRegisterImageResponseTypeDef",
    "ClientRegisterTransitGatewayMulticastGroupMembersResponseRegisteredMulticastGroupMembersTypeDef",
    "ClientRegisterTransitGatewayMulticastGroupMembersResponseTypeDef",
    "ClientRegisterTransitGatewayMulticastGroupSourcesResponseRegisteredMulticastGroupSourcesTypeDef",
    "ClientRegisterTransitGatewayMulticastGroupSourcesResponseTypeDef",
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    "ClientRejectTransitGatewayPeeringAttachmentResponseTypeDef",
    "ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    "ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    "ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    "ClientRejectTransitGatewayVpcAttachmentResponseTypeDef",
    "ClientRejectVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef",
    "ClientRejectVpcEndpointConnectionsResponseUnsuccessfulTypeDef",
    "ClientRejectVpcEndpointConnectionsResponseTypeDef",
    "ClientRejectVpcPeeringConnectionResponseTypeDef",
    "ClientReleaseHostsResponseUnsuccessfulErrorTypeDef",
    "ClientReleaseHostsResponseUnsuccessfulTypeDef",
    "ClientReleaseHostsResponseTypeDef",
    "ClientReplaceIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    "ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    "ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationTypeDef",
    "ClientReplaceIamInstanceProfileAssociationResponseTypeDef",
    "ClientReplaceNetworkAclAssociationResponseTypeDef",
    "ClientReplaceNetworkAclEntryIcmpTypeCodeTypeDef",
    "ClientReplaceNetworkAclEntryPortRangeTypeDef",
    "ClientReplaceRouteTableAssociationResponseAssociationStateTypeDef",
    "ClientReplaceRouteTableAssociationResponseTypeDef",
    "ClientReplaceTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef",
    "ClientReplaceTransitGatewayRouteResponseRouteTypeDef",
    "ClientReplaceTransitGatewayRouteResponseTypeDef",
    "ClientRequestSpotFleetResponseTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTagsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTypeDef",
    "ClientRequestSpotFleetSpotFleetRequestConfigTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationIamInstanceProfileTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationMonitoringTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationPlacementTypeDef",
    "ClientRequestSpotInstancesLaunchSpecificationTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsFaultTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsStatusTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsTagsTypeDef",
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsTypeDef",
    "ClientRequestSpotInstancesResponseTypeDef",
    "ClientResetEbsDefaultKmsKeyIdResponseTypeDef",
    "ClientResetFpgaImageAttributeResponseTypeDef",
    "ClientRestoreAddressToClassicResponseTypeDef",
    "ClientRevokeClientVpnIngressResponseStatusTypeDef",
    "ClientRevokeClientVpnIngressResponseTypeDef",
    "ClientRevokeSecurityGroupEgressIpPermissionsIpRangesTypeDef",
    "ClientRevokeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef",
    "ClientRevokeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef",
    "ClientRevokeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef",
    "ClientRevokeSecurityGroupEgressIpPermissionsTypeDef",
    "ClientRevokeSecurityGroupIngressIpPermissionsIpRangesTypeDef",
    "ClientRevokeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef",
    "ClientRevokeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef",
    "ClientRevokeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef",
    "ClientRevokeSecurityGroupIngressIpPermissionsTypeDef",
    "ClientRunInstancesBlockDeviceMappingsEbsTypeDef",
    "ClientRunInstancesBlockDeviceMappingsTypeDef",
    "ClientRunInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientRunInstancesCapacityReservationSpecificationTypeDef",
    "ClientRunInstancesCpuOptionsTypeDef",
    "ClientRunInstancesCreditSpecificationTypeDef",
    "ClientRunInstancesElasticGpuSpecificationTypeDef",
    "ClientRunInstancesElasticInferenceAcceleratorsTypeDef",
    "ClientRunInstancesHibernationOptionsTypeDef",
    "ClientRunInstancesIamInstanceProfileTypeDef",
    "ClientRunInstancesInstanceMarketOptionsSpotOptionsTypeDef",
    "ClientRunInstancesInstanceMarketOptionsTypeDef",
    "ClientRunInstancesIpv6AddressesTypeDef",
    "ClientRunInstancesLaunchTemplateTypeDef",
    "ClientRunInstancesLicenseSpecificationsTypeDef",
    "ClientRunInstancesMetadataOptionsTypeDef",
    "ClientRunInstancesMonitoringTypeDef",
    "ClientRunInstancesNetworkInterfacesIpv6AddressesTypeDef",
    "ClientRunInstancesNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientRunInstancesNetworkInterfacesTypeDef",
    "ClientRunInstancesPlacementTypeDef",
    "ClientRunInstancesResponseGroupsTypeDef",
    "ClientRunInstancesResponseInstancesBlockDeviceMappingsEbsTypeDef",
    "ClientRunInstancesResponseInstancesBlockDeviceMappingsTypeDef",
    "ClientRunInstancesResponseInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    "ClientRunInstancesResponseInstancesCapacityReservationSpecificationTypeDef",
    "ClientRunInstancesResponseInstancesCpuOptionsTypeDef",
    "ClientRunInstancesResponseInstancesElasticGpuAssociationsTypeDef",
    "ClientRunInstancesResponseInstancesElasticInferenceAcceleratorAssociationsTypeDef",
    "ClientRunInstancesResponseInstancesHibernationOptionsTypeDef",
    "ClientRunInstancesResponseInstancesIamInstanceProfileTypeDef",
    "ClientRunInstancesResponseInstancesLicensesTypeDef",
    "ClientRunInstancesResponseInstancesMetadataOptionsTypeDef",
    "ClientRunInstancesResponseInstancesMonitoringTypeDef",
    "ClientRunInstancesResponseInstancesNetworkInterfacesAssociationTypeDef",
    "ClientRunInstancesResponseInstancesNetworkInterfacesAttachmentTypeDef",
    "ClientRunInstancesResponseInstancesNetworkInterfacesGroupsTypeDef",
    "ClientRunInstancesResponseInstancesNetworkInterfacesIpv6AddressesTypeDef",
    "ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef",
    "ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesTypeDef",
    "ClientRunInstancesResponseInstancesNetworkInterfacesTypeDef",
    "ClientRunInstancesResponseInstancesPlacementTypeDef",
    "ClientRunInstancesResponseInstancesProductCodesTypeDef",
    "ClientRunInstancesResponseInstancesSecurityGroupsTypeDef",
    "ClientRunInstancesResponseInstancesStateReasonTypeDef",
    "ClientRunInstancesResponseInstancesStateTypeDef",
    "ClientRunInstancesResponseInstancesTagsTypeDef",
    "ClientRunInstancesResponseInstancesTypeDef",
    "ClientRunInstancesResponseTypeDef",
    "ClientRunInstancesTagSpecificationsTagsTypeDef",
    "ClientRunInstancesTagSpecificationsTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationIamInstanceProfileTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationMonitoringTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressConfigsTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationPlacementTypeDef",
    "ClientRunScheduledInstancesLaunchSpecificationTypeDef",
    "ClientRunScheduledInstancesResponseTypeDef",
    "ClientSearchLocalGatewayRoutesFiltersTypeDef",
    "ClientSearchLocalGatewayRoutesResponseRoutesTypeDef",
    "ClientSearchLocalGatewayRoutesResponseTypeDef",
    "ClientSearchTransitGatewayMulticastGroupsFiltersTypeDef",
    "ClientSearchTransitGatewayMulticastGroupsResponseMulticastGroupsTypeDef",
    "ClientSearchTransitGatewayMulticastGroupsResponseTypeDef",
    "ClientSearchTransitGatewayRoutesFiltersTypeDef",
    "ClientSearchTransitGatewayRoutesResponseRoutesTransitGatewayAttachmentsTypeDef",
    "ClientSearchTransitGatewayRoutesResponseRoutesTypeDef",
    "ClientSearchTransitGatewayRoutesResponseTypeDef",
    "ClientStartInstancesResponseStartingInstancesCurrentStateTypeDef",
    "ClientStartInstancesResponseStartingInstancesPreviousStateTypeDef",
    "ClientStartInstancesResponseStartingInstancesTypeDef",
    "ClientStartInstancesResponseTypeDef",
    "ClientStartVpcEndpointServicePrivateDnsVerificationResponseTypeDef",
    "ClientStopInstancesResponseStoppingInstancesCurrentStateTypeDef",
    "ClientStopInstancesResponseStoppingInstancesPreviousStateTypeDef",
    "ClientStopInstancesResponseStoppingInstancesTypeDef",
    "ClientStopInstancesResponseTypeDef",
    "ClientTerminateClientVpnConnectionsResponseConnectionStatusesCurrentStatusTypeDef",
    "ClientTerminateClientVpnConnectionsResponseConnectionStatusesPreviousStatusTypeDef",
    "ClientTerminateClientVpnConnectionsResponseConnectionStatusesTypeDef",
    "ClientTerminateClientVpnConnectionsResponseTypeDef",
    "ClientTerminateInstancesResponseTerminatingInstancesCurrentStateTypeDef",
    "ClientTerminateInstancesResponseTerminatingInstancesPreviousStateTypeDef",
    "ClientTerminateInstancesResponseTerminatingInstancesTypeDef",
    "ClientTerminateInstancesResponseTypeDef",
    "ClientUnassignIpv6AddressesResponseTypeDef",
    "ClientUnmonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef",
    "ClientUnmonitorInstancesResponseInstanceMonitoringsTypeDef",
    "ClientUnmonitorInstancesResponseTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsIpRangesTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsIpv6RangesTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsPrefixListIdsTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsUserIdGroupPairsTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsEgressResponseTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsIngressIpPermissionsIpRangesTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsIngressIpPermissionsIpv6RangesTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsIngressIpPermissionsPrefixListIdsTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsIngressIpPermissionsUserIdGroupPairsTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsIngressIpPermissionsTypeDef",
    "ClientUpdateSecurityGroupRuleDescriptionsIngressResponseTypeDef",
    "ClientWithdrawByoipCidrResponseByoipCidrTypeDef",
    "ClientWithdrawByoipCidrResponseTypeDef",
    "CopySnapshotResultTypeDef",
    "CpuOptionsRequestTypeDef",
    "DhcpConfigurationTypeDef",
    "DhcpOptionsTypeDef",
    "CreateDhcpOptionsResultTypeDef",
    "CreateImageResultTypeDef",
    "InternetGatewayAttachmentTypeDef",
    "InternetGatewayTypeDef",
    "CreateInternetGatewayResultTypeDef",
    "NetworkAclAssociationTypeDef",
    "IcmpTypeCodeTypeDef",
    "PortRangeTypeDef",
    "NetworkAclEntryTypeDef",
    "NetworkAclTypeDef",
    "CreateNetworkAclResultTypeDef",
    "GroupIdentifierTypeDef",
    "NetworkInterfaceAssociationTypeDef",
    "NetworkInterfaceAttachmentTypeDef",
    "NetworkInterfaceIpv6AddressTypeDef",
    "NetworkInterfacePrivateIpAddressTypeDef",
    "NetworkInterfaceTypeDef",
    "CreateNetworkInterfaceResultTypeDef",
    "CreateRouteResultTypeDef",
    "PropagatingVgwTypeDef",
    "RouteTableAssociationTypeDef",
    "RouteTypeDef",
    "RouteTableTypeDef",
    "CreateRouteTableResultTypeDef",
    "CreateSecurityGroupResultTypeDef",
    "SubnetCidrBlockStateTypeDef",
    "SubnetIpv6CidrBlockAssociationTypeDef",
    "SubnetTypeDef",
    "CreateSubnetResultTypeDef",
    "CreateVolumePermissionTypeDef",
    "CreateVolumePermissionModificationsTypeDef",
    "CreateVpcPeeringConnectionResultTypeDef",
    "VpcCidrBlockStateTypeDef",
    "VpcCidrBlockAssociationTypeDef",
    "VpcIpv6CidrBlockAssociationTypeDef",
    "VpcTypeDef",
    "CreateVpcResultTypeDef",
    "CreditSpecificationRequestTypeDef",
    "DeleteVpcPeeringConnectionResultTypeDef",
    "ByoipCidrTypeDef",
    "DescribeByoipCidrsResultTypeDef",
    "CapacityReservationTypeDef",
    "DescribeCapacityReservationsResultTypeDef",
    "ClassicLinkInstanceTypeDef",
    "DescribeClassicLinkInstancesResultTypeDef",
    "ClientVpnAuthorizationRuleStatusTypeDef",
    "AuthorizationRuleTypeDef",
    "DescribeClientVpnAuthorizationRulesResultTypeDef",
    "ClientVpnConnectionStatusTypeDef",
    "ClientVpnConnectionTypeDef",
    "DescribeClientVpnConnectionsResultTypeDef",
    "AssociatedTargetNetworkTypeDef",
    "CertificateAuthenticationTypeDef",
    "DirectoryServiceAuthenticationTypeDef",
    "ClientVpnAuthenticationTypeDef",
    "ClientVpnEndpointStatusTypeDef",
    "ConnectionLogResponseOptionsTypeDef",
    "ClientVpnEndpointTypeDef",
    "DescribeClientVpnEndpointsResultTypeDef",
    "ClientVpnRouteStatusTypeDef",
    "ClientVpnRouteTypeDef",
    "DescribeClientVpnRoutesResultTypeDef",
    "AssociationStatusTypeDef",
    "TargetNetworkTypeDef",
    "DescribeClientVpnTargetNetworksResultTypeDef",
    "DescribeDhcpOptionsResultTypeDef",
    "EgressOnlyInternetGatewayTypeDef",
    "DescribeEgressOnlyInternetGatewaysResultTypeDef",
    "ExportTaskS3LocationTypeDef",
    "ExportImageTaskTypeDef",
    "DescribeExportImageTasksResultTypeDef",
    "DescribeFastSnapshotRestoreSuccessItemTypeDef",
    "DescribeFastSnapshotRestoresResultTypeDef",
    "PlacementResponseTypeDef",
    "FleetLaunchTemplateOverridesTypeDef",
    "FleetLaunchTemplateSpecificationTypeDef",
    "LaunchTemplateAndOverridesResponseTypeDef",
    "DescribeFleetErrorTypeDef",
    "DescribeFleetsInstancesTypeDef",
    "FleetLaunchTemplateConfigTypeDef",
    "CapacityReservationOptionsTypeDef",
    "OnDemandOptionsTypeDef",
    "SpotOptionsTypeDef",
    "TargetCapacitySpecificationTypeDef",
    "FleetDataTypeDef",
    "DescribeFleetsResultTypeDef",
    "FlowLogTypeDef",
    "DescribeFlowLogsResultTypeDef",
    "FpgaImageStateTypeDef",
    "PciIdTypeDef",
    "ProductCodeTypeDef",
    "FpgaImageTypeDef",
    "DescribeFpgaImagesResultTypeDef",
    "HostOfferingTypeDef",
    "DescribeHostReservationOfferingsResultTypeDef",
    "HostReservationTypeDef",
    "DescribeHostReservationsResultTypeDef",
    "InstanceCapacityTypeDef",
    "AvailableCapacityTypeDef",
    "HostInstanceTypeDef",
    "HostPropertiesTypeDef",
    "HostTypeDef",
    "DescribeHostsResultTypeDef",
    "IamInstanceProfileTypeDef",
    "IamInstanceProfileAssociationTypeDef",
    "DescribeIamInstanceProfileAssociationsResultTypeDef",
    "ImportImageLicenseConfigurationResponseTypeDef",
    "UserBucketDetailsTypeDef",
    "SnapshotDetailTypeDef",
    "ImportImageTaskTypeDef",
    "DescribeImportImageTasksResultTypeDef",
    "SnapshotTaskDetailTypeDef",
    "ImportSnapshotTaskTypeDef",
    "DescribeImportSnapshotTasksResultTypeDef",
    "InstanceCreditSpecificationTypeDef",
    "DescribeInstanceCreditSpecificationsResultTypeDef",
    "InstanceStateTypeDef",
    "InstanceStatusEventTypeDef",
    "InstanceStatusDetailsTypeDef",
    "InstanceStatusSummaryTypeDef",
    "InstanceStatusTypeDef",
    "DescribeInstanceStatusResultTypeDef",
    "CapacityReservationTargetResponseTypeDef",
    "CapacityReservationSpecificationResponseTypeDef",
    "CpuOptionsTypeDef",
    "ElasticGpuAssociationTypeDef",
    "ElasticInferenceAcceleratorAssociationTypeDef",
    "HibernationOptionsTypeDef",
    "EbsInstanceBlockDeviceTypeDef",
    "InstanceBlockDeviceMappingTypeDef",
    "InstanceMetadataOptionsResponseTypeDef",
    "InstanceIpv6AddressTypeDef",
    "InstanceNetworkInterfaceAssociationTypeDef",
    "InstanceNetworkInterfaceAttachmentTypeDef",
    "InstancePrivateIpAddressTypeDef",
    "InstanceNetworkInterfaceTypeDef",
    "LicenseConfigurationTypeDef",
    "MonitoringTypeDef",
    "PlacementTypeDef",
    "StateReasonTypeDef",
    "InstanceTypeDef",
    "ReservationTypeDef",
    "DescribeInstancesResultTypeDef",
    "DescribeInternetGatewaysResultTypeDef",
    "PoolCidrBlockTypeDef",
    "Ipv6PoolTypeDef",
    "DescribeIpv6PoolsResultTypeDef",
    "CreditSpecificationTypeDef",
    "ElasticGpuSpecificationResponseTypeDef",
    "LaunchTemplateEbsBlockDeviceTypeDef",
    "LaunchTemplateBlockDeviceMappingTypeDef",
    "LaunchTemplateCapacityReservationSpecificationResponseTypeDef",
    "LaunchTemplateCpuOptionsTypeDef",
    "LaunchTemplateElasticInferenceAcceleratorResponseTypeDef",
    "LaunchTemplateHibernationOptionsTypeDef",
    "LaunchTemplateIamInstanceProfileSpecificationTypeDef",
    "LaunchTemplateSpotMarketOptionsTypeDef",
    "LaunchTemplateInstanceMarketOptionsTypeDef",
    "LaunchTemplateInstanceMetadataOptionsTypeDef",
    "PrivateIpAddressSpecificationTypeDef",
    "LaunchTemplateInstanceNetworkInterfaceSpecificationTypeDef",
    "LaunchTemplateLicenseConfigurationTypeDef",
    "LaunchTemplatePlacementTypeDef",
    "LaunchTemplateTagSpecificationTypeDef",
    "LaunchTemplatesMonitoringTypeDef",
    "ResponseLaunchTemplateDataTypeDef",
    "LaunchTemplateVersionTypeDef",
    "DescribeLaunchTemplateVersionsResultTypeDef",
    "LaunchTemplateTypeDef",
    "DescribeLaunchTemplatesResultTypeDef",
    "MovingAddressStatusTypeDef",
    "DescribeMovingAddressesResultTypeDef",
    "NatGatewayAddressTypeDef",
    "ProvisionedBandwidthTypeDef",
    "NatGatewayTypeDef",
    "DescribeNatGatewaysResultTypeDef",
    "DescribeNetworkAclsResultTypeDef",
    "DescribeNetworkInterfaceAttributeResultTypeDef",
    "NetworkInterfacePermissionStateTypeDef",
    "NetworkInterfacePermissionTypeDef",
    "DescribeNetworkInterfacePermissionsResultTypeDef",
    "DescribeNetworkInterfacesResultTypeDef",
    "PrefixListTypeDef",
    "DescribePrefixListsResultTypeDef",
    "IdFormatTypeDef",
    "PrincipalIdFormatTypeDef",
    "DescribePrincipalIdFormatResultTypeDef",
    "PublicIpv4PoolRangeTypeDef",
    "PublicIpv4PoolTypeDef",
    "DescribePublicIpv4PoolsResultTypeDef",
    "ReservedInstancesIdTypeDef",
    "ReservedInstancesConfigurationTypeDef",
    "ReservedInstancesModificationResultTypeDef",
    "ReservedInstancesModificationTypeDef",
    "DescribeReservedInstancesModificationsResultTypeDef",
    "PricingDetailTypeDef",
    "RecurringChargeTypeDef",
    "ReservedInstancesOfferingTypeDef",
    "DescribeReservedInstancesOfferingsResultTypeDef",
    "DescribeRouteTablesResultTypeDef",
    "ScheduledInstanceRecurrenceTypeDef",
    "ScheduledInstanceAvailabilityTypeDef",
    "DescribeScheduledInstanceAvailabilityResultTypeDef",
    "ScheduledInstanceTypeDef",
    "DescribeScheduledInstancesResultTypeDef",
    "IpRangeTypeDef",
    "Ipv6RangeTypeDef",
    "PrefixListIdTypeDef",
    "UserIdGroupPairTypeDef",
    "IpPermissionTypeDef",
    "SecurityGroupTypeDef",
    "DescribeSecurityGroupsResultTypeDef",
    "DescribeSnapshotAttributeResultTypeDef",
    "SnapshotTypeDef",
    "DescribeSnapshotsResultTypeDef",
    "ActiveInstanceTypeDef",
    "DescribeSpotFleetInstancesResponseTypeDef",
    "LaunchTemplateOverridesTypeDef",
    "LaunchTemplateConfigTypeDef",
    "ClassicLoadBalancerTypeDef",
    "ClassicLoadBalancersConfigTypeDef",
    "TargetGroupTypeDef",
    "TargetGroupsConfigTypeDef",
    "LoadBalancersConfigTypeDef",
    "IamInstanceProfileSpecificationTypeDef",
    "InstanceNetworkInterfaceSpecificationTypeDef",
    "SpotFleetMonitoringTypeDef",
    "SpotFleetTagSpecificationTypeDef",
    "SpotPlacementTypeDef",
    "SpotFleetLaunchSpecificationTypeDef",
    "TagSpecificationTypeDef",
    "SpotFleetRequestConfigDataTypeDef",
    "SpotFleetRequestConfigTypeDef",
    "DescribeSpotFleetRequestsResponseTypeDef",
    "RunInstancesMonitoringEnabledTypeDef",
    "LaunchSpecificationTypeDef",
    "SpotInstanceStateFaultTypeDef",
    "SpotInstanceStatusTypeDef",
    "SpotInstanceRequestTypeDef",
    "DescribeSpotInstanceRequestsResultTypeDef",
    "SpotPriceTypeDef",
    "DescribeSpotPriceHistoryResultTypeDef",
    "StaleIpPermissionTypeDef",
    "StaleSecurityGroupTypeDef",
    "DescribeStaleSecurityGroupsResultTypeDef",
    "DescribeSubnetsResultTypeDef",
    "TagDescriptionTypeDef",
    "DescribeTagsResultTypeDef",
    "TrafficMirrorPortRangeTypeDef",
    "TrafficMirrorFilterRuleTypeDef",
    "TrafficMirrorFilterTypeDef",
    "DescribeTrafficMirrorFiltersResultTypeDef",
    "TrafficMirrorSessionTypeDef",
    "DescribeTrafficMirrorSessionsResultTypeDef",
    "TrafficMirrorTargetTypeDef",
    "DescribeTrafficMirrorTargetsResultTypeDef",
    "TransitGatewayAttachmentAssociationTypeDef",
    "TransitGatewayAttachmentTypeDef",
    "DescribeTransitGatewayAttachmentsResultTypeDef",
    "TransitGatewayRouteTableTypeDef",
    "DescribeTransitGatewayRouteTablesResultTypeDef",
    "TransitGatewayVpcAttachmentOptionsTypeDef",
    "TransitGatewayVpcAttachmentTypeDef",
    "DescribeTransitGatewayVpcAttachmentsResultTypeDef",
    "TransitGatewayOptionsTypeDef",
    "TransitGatewayTypeDef",
    "DescribeTransitGatewaysResultTypeDef",
    "DescribeVolumeAttributeResultTypeDef",
    "VolumeStatusActionTypeDef",
    "VolumeStatusAttachmentStatusTypeDef",
    "VolumeStatusEventTypeDef",
    "VolumeStatusDetailsTypeDef",
    "VolumeStatusInfoTypeDef",
    "VolumeStatusItemTypeDef",
    "DescribeVolumeStatusResultTypeDef",
    "VolumeModificationTypeDef",
    "DescribeVolumesModificationsResultTypeDef",
    "VolumeAttachmentTypeDef",
    "VolumeTypeDef",
    "DescribeVolumesResultTypeDef",
    "DescribeVpcAttributeResultTypeDef",
    "ClassicLinkDnsSupportTypeDef",
    "DescribeVpcClassicLinkDnsSupportResultTypeDef",
    "ConnectionNotificationTypeDef",
    "DescribeVpcEndpointConnectionNotificationsResultTypeDef",
    "DnsEntryTypeDef",
    "VpcEndpointConnectionTypeDef",
    "DescribeVpcEndpointConnectionsResultTypeDef",
    "PrivateDnsNameConfigurationTypeDef",
    "ServiceTypeDetailTypeDef",
    "ServiceConfigurationTypeDef",
    "DescribeVpcEndpointServiceConfigurationsResultTypeDef",
    "AllowedPrincipalTypeDef",
    "DescribeVpcEndpointServicePermissionsResultTypeDef",
    "ServiceDetailTypeDef",
    "DescribeVpcEndpointServicesResultTypeDef",
    "LastErrorTypeDef",
    "SecurityGroupIdentifierTypeDef",
    "VpcEndpointTypeDef",
    "DescribeVpcEndpointsResultTypeDef",
    "DescribeVpcPeeringConnectionsResultTypeDef",
    "DescribeVpcsResultTypeDef",
    "DetachClassicLinkVpcResultTypeDef",
    "DisableVpcClassicLinkResultTypeDef",
    "ElasticGpuSpecificationTypeDef",
    "ElasticInferenceAcceleratorTypeDef",
    "EnableVpcClassicLinkResultTypeDef",
    "FilterTypeDef",
    "Ipv6CidrAssociationTypeDef",
    "GetAssociatedIpv6PoolCidrsResultTypeDef",
    "GetConsoleOutputResultTypeDef",
    "GetPasswordDataResultTypeDef",
    "TransitGatewayAttachmentPropagationTypeDef",
    "GetTransitGatewayAttachmentPropagationsResultTypeDef",
    "TransitGatewayRouteTableAssociationTypeDef",
    "GetTransitGatewayRouteTableAssociationsResultTypeDef",
    "TransitGatewayRouteTablePropagationTypeDef",
    "GetTransitGatewayRouteTablePropagationsResultTypeDef",
    "HibernationOptionsRequestTypeDef",
    "LaunchPermissionTypeDef",
    "ImageAttributeTypeDef",
    "ImportKeyPairResultTypeDef",
    "InstanceAttributeTypeDef",
    "EbsInstanceBlockDeviceSpecificationTypeDef",
    "InstanceBlockDeviceMappingSpecificationTypeDef",
    "SpotMarketOptionsTypeDef",
    "InstanceMarketOptionsRequestTypeDef",
    "InstanceMetadataOptionsRequestTypeDef",
    "KeyPairTypeDef",
    "LaunchPermissionModificationsTypeDef",
    "LaunchTemplateSpecificationTypeDef",
    "LicenseConfigurationRequestTypeDef",
    "InstanceMonitoringTypeDef",
    "MonitorInstancesResultTypeDef",
    "NetworkInterfaceAttachmentChangesTypeDef",
    "NewDhcpConfigurationTypeDef",
    "PaginatorConfigTypeDef",
    "RegisterImageResultTypeDef",
    "RejectVpcPeeringConnectionResultTypeDef",
    "ReplaceNetworkAclAssociationResultTypeDef",
    "ReplaceRouteTableAssociationResultTypeDef",
    "ScheduledInstanceRecurrenceRequestTypeDef",
    "SlotDateTimeRangeRequestTypeDef",
    "SlotStartTimeRangeRequestTypeDef",
    "InstanceStateChangeTypeDef",
    "StartInstancesResultTypeDef",
    "StopInstancesResultTypeDef",
    "TerminateInstancesResultTypeDef",
    "UnmonitorInstancesResultTypeDef",
    "WaiterConfigTypeDef",
)

TagTypeDef = TypedDict("TagTypeDef", {"Key": str, "Value": str}, total=False)

VpcPeeringConnectionStateReasonTypeDef = TypedDict(
    "VpcPeeringConnectionStateReasonTypeDef",
    {
        "Code": Literal[
            "initiating-request",
            "pending-acceptance",
            "active",
            "deleted",
            "rejected",
            "failed",
            "expired",
            "provisioning",
            "deleting",
        ],
        "Message": str,
    },
    total=False,
)

CidrBlockTypeDef = TypedDict("CidrBlockTypeDef", {"CidrBlock": str}, total=False)

Ipv6CidrBlockTypeDef = TypedDict("Ipv6CidrBlockTypeDef", {"Ipv6CidrBlock": str}, total=False)

VpcPeeringConnectionOptionsDescriptionTypeDef = TypedDict(
    "VpcPeeringConnectionOptionsDescriptionTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

VpcPeeringConnectionVpcInfoTypeDef = TypedDict(
    "VpcPeeringConnectionVpcInfoTypeDef",
    {
        "CidrBlock": str,
        "Ipv6CidrBlockSet": List[Ipv6CidrBlockTypeDef],
        "CidrBlockSet": List[CidrBlockTypeDef],
        "OwnerId": str,
        "PeeringOptions": VpcPeeringConnectionOptionsDescriptionTypeDef,
        "VpcId": str,
        "Region": str,
    },
    total=False,
)

VpcPeeringConnectionTypeDef = TypedDict(
    "VpcPeeringConnectionTypeDef",
    {
        "AccepterVpcInfo": VpcPeeringConnectionVpcInfoTypeDef,
        "ExpirationTime": datetime,
        "RequesterVpcInfo": VpcPeeringConnectionVpcInfoTypeDef,
        "Status": VpcPeeringConnectionStateReasonTypeDef,
        "Tags": List[TagTypeDef],
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

AcceptVpcPeeringConnectionResultTypeDef = TypedDict(
    "AcceptVpcPeeringConnectionResultTypeDef",
    {"VpcPeeringConnection": VpcPeeringConnectionTypeDef},
    total=False,
)

AssignedPrivateIpAddressTypeDef = TypedDict(
    "AssignedPrivateIpAddressTypeDef", {"PrivateIpAddress": str}, total=False
)

AssignPrivateIpAddressesResultTypeDef = TypedDict(
    "AssignPrivateIpAddressesResultTypeDef",
    {
        "NetworkInterfaceId": str,
        "AssignedPrivateIpAddresses": List[AssignedPrivateIpAddressTypeDef],
    },
    total=False,
)

AssociateAddressResultTypeDef = TypedDict(
    "AssociateAddressResultTypeDef", {"AssociationId": str}, total=False
)

RouteTableAssociationStateTypeDef = TypedDict(
    "RouteTableAssociationStateTypeDef",
    {
        "State": Literal["associating", "associated", "disassociating", "disassociated", "failed"],
        "StatusMessage": str,
    },
    total=False,
)

AssociateRouteTableResultTypeDef = TypedDict(
    "AssociateRouteTableResultTypeDef",
    {"AssociationId": str, "AssociationState": RouteTableAssociationStateTypeDef},
    total=False,
)

AttachClassicLinkVpcResultTypeDef = TypedDict(
    "AttachClassicLinkVpcResultTypeDef", {"Return": bool}, total=False
)

AttachNetworkInterfaceResultTypeDef = TypedDict(
    "AttachNetworkInterfaceResultTypeDef", {"AttachmentId": str}, total=False
)

AttributeBooleanValueTypeDef = TypedDict(
    "AttributeBooleanValueTypeDef", {"Value": bool}, total=False
)

AttributeValueTypeDef = TypedDict("AttributeValueTypeDef", {"Value": str}, total=False)

BlobAttributeValueTypeDef = TypedDict(
    "BlobAttributeValueTypeDef", {"Value": Union[bytes, IO]}, total=False
)

EbsBlockDeviceTypeDef = TypedDict(
    "EbsBlockDeviceTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

BlockDeviceMappingTypeDef = TypedDict(
    "BlockDeviceMappingTypeDef",
    {"DeviceName": str, "VirtualName": str, "Ebs": EbsBlockDeviceTypeDef, "NoDevice": str},
    total=False,
)

CapacityReservationTargetTypeDef = TypedDict(
    "CapacityReservationTargetTypeDef", {"CapacityReservationId": str}, total=False
)

CapacityReservationSpecificationTypeDef = TypedDict(
    "CapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": CapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientAcceptReservedInstancesExchangeQuoteResponseTypeDef = TypedDict(
    "ClientAcceptReservedInstancesExchangeQuoteResponseTypeDef", {"ExchangeId": str}, total=False
)

ClientAcceptReservedInstancesExchangeQuoteTargetConfigurationsTypeDef = TypedDict(
    "ClientAcceptReservedInstancesExchangeQuoteTargetConfigurationsTypeDef",
    {"InstanceCount": int, "OfferingId": str},
    total=False,
)

ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef = TypedDict(
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef = TypedDict(
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef = TypedDict(
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef = TypedDict(
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef = TypedDict(
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "RequesterTgwInfo": ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef,
        "AccepterTgwInfo": ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef,
        "Status": ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "CreationTime": datetime,
        "Tags": List[
            ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientAcceptTransitGatewayPeeringAttachmentResponseTypeDef = TypedDict(
    "ClientAcceptTransitGatewayPeeringAttachmentResponseTypeDef",
    {
        "TransitGatewayPeeringAttachment": ClientAcceptTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef
    },
    total=False,
)

ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef = TypedDict(
    "ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef = TypedDict(
    "ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef = TypedDict(
    "ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "TransitGatewayId": str,
        "VpcId": str,
        "VpcOwnerId": str,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "SubnetIds": List[str],
        "CreationTime": datetime,
        "Options": ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef,
        "Tags": List[
            ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientAcceptTransitGatewayVpcAttachmentResponseTypeDef = TypedDict(
    "ClientAcceptTransitGatewayVpcAttachmentResponseTypeDef",
    {
        "TransitGatewayVpcAttachment": ClientAcceptTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef
    },
    total=False,
)

ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulTypeDef",
    {
        "Error": ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef,
        "ResourceId": str,
    },
    total=False,
)

ClientAcceptVpcEndpointConnectionsResponseTypeDef = TypedDict(
    "ClientAcceptVpcEndpointConnectionsResponseTypeDef",
    {"Unsuccessful": List[ClientAcceptVpcEndpointConnectionsResponseUnsuccessfulTypeDef]},
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef",
    {"CidrBlock": str},
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef",
    {"Ipv6CidrBlock": str},
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef",
    {
        "CidrBlock": str,
        "Ipv6CidrBlockSet": List[
            ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef
        ],
        "CidrBlockSet": List[
            ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef
        ],
        "OwnerId": str,
        "PeeringOptions": ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef,
        "VpcId": str,
        "Region": str,
    },
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef",
    {"CidrBlock": str},
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef",
    {"Ipv6CidrBlock": str},
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef",
    {
        "CidrBlock": str,
        "Ipv6CidrBlockSet": List[
            ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef
        ],
        "CidrBlockSet": List[
            ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef
        ],
        "OwnerId": str,
        "PeeringOptions": ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef,
        "VpcId": str,
        "Region": str,
    },
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef",
    {
        "Code": Literal[
            "initiating-request",
            "pending-acceptance",
            "active",
            "deleted",
            "rejected",
            "failed",
            "expired",
            "provisioning",
            "deleting",
        ],
        "Message": str,
    },
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef",
    {
        "AccepterVpcInfo": ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef,
        "ExpirationTime": datetime,
        "RequesterVpcInfo": ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef,
        "Status": ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef,
        "Tags": List[ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef],
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientAcceptVpcPeeringConnectionResponseTypeDef = TypedDict(
    "ClientAcceptVpcPeeringConnectionResponseTypeDef",
    {"VpcPeeringConnection": ClientAcceptVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef},
    total=False,
)

ClientAdvertiseByoipCidrResponseByoipCidrTypeDef = TypedDict(
    "ClientAdvertiseByoipCidrResponseByoipCidrTypeDef",
    {
        "Cidr": str,
        "Description": str,
        "StatusMessage": str,
        "State": Literal[
            "advertised",
            "deprovisioned",
            "failed-deprovision",
            "failed-provision",
            "pending-deprovision",
            "pending-provision",
            "provisioned",
            "provisioned-not-publicly-advertisable",
        ],
    },
    total=False,
)

ClientAdvertiseByoipCidrResponseTypeDef = TypedDict(
    "ClientAdvertiseByoipCidrResponseTypeDef",
    {"ByoipCidr": ClientAdvertiseByoipCidrResponseByoipCidrTypeDef},
    total=False,
)

ClientAllocateAddressResponseTypeDef = TypedDict(
    "ClientAllocateAddressResponseTypeDef",
    {
        "PublicIp": str,
        "AllocationId": str,
        "PublicIpv4Pool": str,
        "NetworkBorderGroup": str,
        "Domain": Literal["vpc", "standard"],
        "CustomerOwnedIp": str,
        "CustomerOwnedIpv4Pool": str,
    },
    total=False,
)

ClientAllocateHostsResponseTypeDef = TypedDict(
    "ClientAllocateHostsResponseTypeDef", {"HostIds": List[str]}, total=False
)

ClientAllocateHostsTagSpecificationsTagsTypeDef = TypedDict(
    "ClientAllocateHostsTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientAllocateHostsTagSpecificationsTypeDef = TypedDict(
    "ClientAllocateHostsTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientAllocateHostsTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientApplySecurityGroupsToClientVpnTargetNetworkResponseTypeDef = TypedDict(
    "ClientApplySecurityGroupsToClientVpnTargetNetworkResponseTypeDef",
    {"SecurityGroupIds": List[str]},
    total=False,
)

ClientAssignIpv6AddressesResponseTypeDef = TypedDict(
    "ClientAssignIpv6AddressesResponseTypeDef",
    {"AssignedIpv6Addresses": List[str], "NetworkInterfaceId": str},
    total=False,
)

ClientAssignPrivateIpAddressesResponseAssignedPrivateIpAddressesTypeDef = TypedDict(
    "ClientAssignPrivateIpAddressesResponseAssignedPrivateIpAddressesTypeDef",
    {"PrivateIpAddress": str},
    total=False,
)

ClientAssignPrivateIpAddressesResponseTypeDef = TypedDict(
    "ClientAssignPrivateIpAddressesResponseTypeDef",
    {
        "NetworkInterfaceId": str,
        "AssignedPrivateIpAddresses": List[
            ClientAssignPrivateIpAddressesResponseAssignedPrivateIpAddressesTypeDef
        ],
    },
    total=False,
)

ClientAssociateAddressResponseTypeDef = TypedDict(
    "ClientAssociateAddressResponseTypeDef", {"AssociationId": str}, total=False
)

ClientAssociateClientVpnTargetNetworkResponseStatusTypeDef = TypedDict(
    "ClientAssociateClientVpnTargetNetworkResponseStatusTypeDef",
    {
        "Code": Literal[
            "associating", "associated", "association-failed", "disassociating", "disassociated"
        ],
        "Message": str,
    },
    total=False,
)

ClientAssociateClientVpnTargetNetworkResponseTypeDef = TypedDict(
    "ClientAssociateClientVpnTargetNetworkResponseTypeDef",
    {"AssociationId": str, "Status": ClientAssociateClientVpnTargetNetworkResponseStatusTypeDef},
    total=False,
)

ClientAssociateIamInstanceProfileIamInstanceProfileTypeDef = TypedDict(
    "ClientAssociateIamInstanceProfileIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef = TypedDict(
    "ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    {"Arn": str, "Id": str},
    total=False,
)

ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef = TypedDict(
    "ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef",
    {
        "AssociationId": str,
        "InstanceId": str,
        "IamInstanceProfile": ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
        "Timestamp": datetime,
    },
    total=False,
)

ClientAssociateIamInstanceProfileResponseTypeDef = TypedDict(
    "ClientAssociateIamInstanceProfileResponseTypeDef",
    {
        "IamInstanceProfileAssociation": ClientAssociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef
    },
    total=False,
)

ClientAssociateRouteTableResponseAssociationStateTypeDef = TypedDict(
    "ClientAssociateRouteTableResponseAssociationStateTypeDef",
    {
        "State": Literal["associating", "associated", "disassociating", "disassociated", "failed"],
        "StatusMessage": str,
    },
    total=False,
)

ClientAssociateRouteTableResponseTypeDef = TypedDict(
    "ClientAssociateRouteTableResponseTypeDef",
    {
        "AssociationId": str,
        "AssociationState": ClientAssociateRouteTableResponseAssociationStateTypeDef,
    },
    total=False,
)

ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef = TypedDict(
    "ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef,
    },
    total=False,
)

ClientAssociateSubnetCidrBlockResponseTypeDef = TypedDict(
    "ClientAssociateSubnetCidrBlockResponseTypeDef",
    {
        "Ipv6CidrBlockAssociation": ClientAssociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef,
        "SubnetId": str,
    },
    total=False,
)

ClientAssociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef = TypedDict(
    "ClientAssociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef",
    {
        "SubnetId": str,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
    },
    total=False,
)

ClientAssociateTransitGatewayMulticastDomainResponseAssociationsTypeDef = TypedDict(
    "ClientAssociateTransitGatewayMulticastDomainResponseAssociationsTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "Subnets": List[
            ClientAssociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef
        ],
    },
    total=False,
)

ClientAssociateTransitGatewayMulticastDomainResponseTypeDef = TypedDict(
    "ClientAssociateTransitGatewayMulticastDomainResponseTypeDef",
    {"Associations": ClientAssociateTransitGatewayMulticastDomainResponseAssociationsTypeDef},
    total=False,
)

ClientAssociateTransitGatewayRouteTableResponseAssociationTypeDef = TypedDict(
    "ClientAssociateTransitGatewayRouteTableResponseAssociationTypeDef",
    {
        "TransitGatewayRouteTableId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
    },
    total=False,
)

ClientAssociateTransitGatewayRouteTableResponseTypeDef = TypedDict(
    "ClientAssociateTransitGatewayRouteTableResponseTypeDef",
    {"Association": ClientAssociateTransitGatewayRouteTableResponseAssociationTypeDef},
    total=False,
)

ClientAssociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef = TypedDict(
    "ClientAssociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientAssociateVpcCidrBlockResponseCidrBlockAssociationTypeDef = TypedDict(
    "ClientAssociateVpcCidrBlockResponseCidrBlockAssociationTypeDef",
    {
        "AssociationId": str,
        "CidrBlock": str,
        "CidrBlockState": ClientAssociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef,
    },
    total=False,
)

ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef = TypedDict(
    "ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef,
        "NetworkBorderGroup": str,
        "Ipv6Pool": str,
    },
    total=False,
)

ClientAssociateVpcCidrBlockResponseTypeDef = TypedDict(
    "ClientAssociateVpcCidrBlockResponseTypeDef",
    {
        "Ipv6CidrBlockAssociation": ClientAssociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef,
        "CidrBlockAssociation": ClientAssociateVpcCidrBlockResponseCidrBlockAssociationTypeDef,
        "VpcId": str,
    },
    total=False,
)

ClientAttachClassicLinkVpcResponseTypeDef = TypedDict(
    "ClientAttachClassicLinkVpcResponseTypeDef", {"Return": bool}, total=False
)

ClientAttachNetworkInterfaceResponseTypeDef = TypedDict(
    "ClientAttachNetworkInterfaceResponseTypeDef", {"AttachmentId": str}, total=False
)

ClientAttachVolumeResponseTypeDef = TypedDict(
    "ClientAttachVolumeResponseTypeDef",
    {
        "AttachTime": datetime,
        "Device": str,
        "InstanceId": str,
        "State": Literal["attaching", "attached", "detaching", "detached", "busy"],
        "VolumeId": str,
        "DeleteOnTermination": bool,
    },
    total=False,
)

ClientAttachVpnGatewayResponseVpcAttachmentTypeDef = TypedDict(
    "ClientAttachVpnGatewayResponseVpcAttachmentTypeDef",
    {"State": Literal["attaching", "attached", "detaching", "detached"], "VpcId": str},
    total=False,
)

ClientAttachVpnGatewayResponseTypeDef = TypedDict(
    "ClientAttachVpnGatewayResponseTypeDef",
    {"VpcAttachment": ClientAttachVpnGatewayResponseVpcAttachmentTypeDef},
    total=False,
)

ClientAuthorizeClientVpnIngressResponseStatusTypeDef = TypedDict(
    "ClientAuthorizeClientVpnIngressResponseStatusTypeDef",
    {"Code": Literal["authorizing", "active", "failed", "revoking"], "Message": str},
    total=False,
)

ClientAuthorizeClientVpnIngressResponseTypeDef = TypedDict(
    "ClientAuthorizeClientVpnIngressResponseTypeDef",
    {"Status": ClientAuthorizeClientVpnIngressResponseStatusTypeDef},
    total=False,
)

ClientAuthorizeSecurityGroupEgressIpPermissionsIpRangesTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupEgressIpPermissionsIpRangesTypeDef",
    {"CidrIp": str, "Description": str},
    total=False,
)

ClientAuthorizeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef",
    {"CidrIpv6": str, "Description": str},
    total=False,
)

ClientAuthorizeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef",
    {"Description": str, "PrefixListId": str},
    total=False,
)

ClientAuthorizeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientAuthorizeSecurityGroupEgressIpPermissionsTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupEgressIpPermissionsTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[ClientAuthorizeSecurityGroupEgressIpPermissionsIpRangesTypeDef],
        "Ipv6Ranges": List[ClientAuthorizeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef],
        "PrefixListIds": List[ClientAuthorizeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientAuthorizeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientAuthorizeSecurityGroupIngressIpPermissionsIpRangesTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupIngressIpPermissionsIpRangesTypeDef",
    {"CidrIp": str, "Description": str},
    total=False,
)

ClientAuthorizeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef",
    {"CidrIpv6": str, "Description": str},
    total=False,
)

ClientAuthorizeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef",
    {"Description": str, "PrefixListId": str},
    total=False,
)

ClientAuthorizeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientAuthorizeSecurityGroupIngressIpPermissionsTypeDef = TypedDict(
    "ClientAuthorizeSecurityGroupIngressIpPermissionsTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[ClientAuthorizeSecurityGroupIngressIpPermissionsIpRangesTypeDef],
        "Ipv6Ranges": List[ClientAuthorizeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef],
        "PrefixListIds": List[ClientAuthorizeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientAuthorizeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientBundleInstanceResponseBundleTaskBundleTaskErrorTypeDef = TypedDict(
    "ClientBundleInstanceResponseBundleTaskBundleTaskErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientBundleInstanceResponseBundleTaskStorageS3TypeDef = TypedDict(
    "ClientBundleInstanceResponseBundleTaskStorageS3TypeDef",
    {
        "AWSAccessKeyId": str,
        "Bucket": str,
        "Prefix": str,
        "UploadPolicy": bytes,
        "UploadPolicySignature": str,
    },
    total=False,
)

ClientBundleInstanceResponseBundleTaskStorageTypeDef = TypedDict(
    "ClientBundleInstanceResponseBundleTaskStorageTypeDef",
    {"S3": ClientBundleInstanceResponseBundleTaskStorageS3TypeDef},
    total=False,
)

ClientBundleInstanceResponseBundleTaskTypeDef = TypedDict(
    "ClientBundleInstanceResponseBundleTaskTypeDef",
    {
        "BundleId": str,
        "BundleTaskError": ClientBundleInstanceResponseBundleTaskBundleTaskErrorTypeDef,
        "InstanceId": str,
        "Progress": str,
        "StartTime": datetime,
        "State": Literal[
            "pending",
            "waiting-for-shutdown",
            "bundling",
            "storing",
            "cancelling",
            "complete",
            "failed",
        ],
        "Storage": ClientBundleInstanceResponseBundleTaskStorageTypeDef,
        "UpdateTime": datetime,
    },
    total=False,
)

ClientBundleInstanceResponseTypeDef = TypedDict(
    "ClientBundleInstanceResponseTypeDef",
    {"BundleTask": ClientBundleInstanceResponseBundleTaskTypeDef},
    total=False,
)

ClientBundleInstanceStorageS3TypeDef = TypedDict(
    "ClientBundleInstanceStorageS3TypeDef",
    {
        "AWSAccessKeyId": str,
        "Bucket": str,
        "Prefix": str,
        "UploadPolicy": bytes,
        "UploadPolicySignature": str,
    },
    total=False,
)

ClientBundleInstanceStorageTypeDef = TypedDict(
    "ClientBundleInstanceStorageTypeDef", {"S3": ClientBundleInstanceStorageS3TypeDef}, total=False
)

ClientCancelBundleTaskResponseBundleTaskBundleTaskErrorTypeDef = TypedDict(
    "ClientCancelBundleTaskResponseBundleTaskBundleTaskErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientCancelBundleTaskResponseBundleTaskStorageS3TypeDef = TypedDict(
    "ClientCancelBundleTaskResponseBundleTaskStorageS3TypeDef",
    {
        "AWSAccessKeyId": str,
        "Bucket": str,
        "Prefix": str,
        "UploadPolicy": bytes,
        "UploadPolicySignature": str,
    },
    total=False,
)

ClientCancelBundleTaskResponseBundleTaskStorageTypeDef = TypedDict(
    "ClientCancelBundleTaskResponseBundleTaskStorageTypeDef",
    {"S3": ClientCancelBundleTaskResponseBundleTaskStorageS3TypeDef},
    total=False,
)

ClientCancelBundleTaskResponseBundleTaskTypeDef = TypedDict(
    "ClientCancelBundleTaskResponseBundleTaskTypeDef",
    {
        "BundleId": str,
        "BundleTaskError": ClientCancelBundleTaskResponseBundleTaskBundleTaskErrorTypeDef,
        "InstanceId": str,
        "Progress": str,
        "StartTime": datetime,
        "State": Literal[
            "pending",
            "waiting-for-shutdown",
            "bundling",
            "storing",
            "cancelling",
            "complete",
            "failed",
        ],
        "Storage": ClientCancelBundleTaskResponseBundleTaskStorageTypeDef,
        "UpdateTime": datetime,
    },
    total=False,
)

ClientCancelBundleTaskResponseTypeDef = TypedDict(
    "ClientCancelBundleTaskResponseTypeDef",
    {"BundleTask": ClientCancelBundleTaskResponseBundleTaskTypeDef},
    total=False,
)

ClientCancelCapacityReservationResponseTypeDef = TypedDict(
    "ClientCancelCapacityReservationResponseTypeDef", {"Return": bool}, total=False
)

ClientCancelImportTaskResponseTypeDef = TypedDict(
    "ClientCancelImportTaskResponseTypeDef",
    {"ImportTaskId": str, "PreviousState": str, "State": str},
    total=False,
)

ClientCancelReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef = TypedDict(
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef",
    {"InstanceCount": int, "State": Literal["available", "sold", "cancelled", "pending"]},
    total=False,
)

ClientCancelReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef = TypedDict(
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef",
    {"Active": bool, "CurrencyCode": str, "Price": float, "Term": int},
    total=False,
)

ClientCancelReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef = TypedDict(
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCancelReservedInstancesListingResponseReservedInstancesListingsTypeDef = TypedDict(
    "ClientCancelReservedInstancesListingResponseReservedInstancesListingsTypeDef",
    {
        "ClientToken": str,
        "CreateDate": datetime,
        "InstanceCounts": List[
            ClientCancelReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef
        ],
        "PriceSchedules": List[
            ClientCancelReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef
        ],
        "ReservedInstancesId": str,
        "ReservedInstancesListingId": str,
        "Status": Literal["active", "pending", "cancelled", "closed"],
        "StatusMessage": str,
        "Tags": List[
            ClientCancelReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef
        ],
        "UpdateDate": datetime,
    },
    total=False,
)

ClientCancelReservedInstancesListingResponseTypeDef = TypedDict(
    "ClientCancelReservedInstancesListingResponseTypeDef",
    {
        "ReservedInstancesListings": List[
            ClientCancelReservedInstancesListingResponseReservedInstancesListingsTypeDef
        ]
    },
    total=False,
)

ClientCancelSpotFleetRequestsResponseSuccessfulFleetRequestsTypeDef = TypedDict(
    "ClientCancelSpotFleetRequestsResponseSuccessfulFleetRequestsTypeDef",
    {
        "CurrentSpotFleetRequestState": Literal[
            "submitted",
            "active",
            "cancelled",
            "failed",
            "cancelled_running",
            "cancelled_terminating",
            "modifying",
        ],
        "PreviousSpotFleetRequestState": Literal[
            "submitted",
            "active",
            "cancelled",
            "failed",
            "cancelled_running",
            "cancelled_terminating",
            "modifying",
        ],
        "SpotFleetRequestId": str,
    },
    total=False,
)

ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsErrorTypeDef = TypedDict(
    "ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsErrorTypeDef",
    {
        "Code": Literal[
            "fleetRequestIdDoesNotExist",
            "fleetRequestIdMalformed",
            "fleetRequestNotInCancellableState",
            "unexpectedError",
        ],
        "Message": str,
    },
    total=False,
)

ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsTypeDef = TypedDict(
    "ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsTypeDef",
    {
        "Error": ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsErrorTypeDef,
        "SpotFleetRequestId": str,
    },
    total=False,
)

ClientCancelSpotFleetRequestsResponseTypeDef = TypedDict(
    "ClientCancelSpotFleetRequestsResponseTypeDef",
    {
        "SuccessfulFleetRequests": List[
            ClientCancelSpotFleetRequestsResponseSuccessfulFleetRequestsTypeDef
        ],
        "UnsuccessfulFleetRequests": List[
            ClientCancelSpotFleetRequestsResponseUnsuccessfulFleetRequestsTypeDef
        ],
    },
    total=False,
)

ClientCancelSpotInstanceRequestsResponseCancelledSpotInstanceRequestsTypeDef = TypedDict(
    "ClientCancelSpotInstanceRequestsResponseCancelledSpotInstanceRequestsTypeDef",
    {
        "SpotInstanceRequestId": str,
        "State": Literal["active", "open", "closed", "cancelled", "completed"],
    },
    total=False,
)

ClientCancelSpotInstanceRequestsResponseTypeDef = TypedDict(
    "ClientCancelSpotInstanceRequestsResponseTypeDef",
    {
        "CancelledSpotInstanceRequests": List[
            ClientCancelSpotInstanceRequestsResponseCancelledSpotInstanceRequestsTypeDef
        ]
    },
    total=False,
)

ClientConfirmProductInstanceResponseTypeDef = TypedDict(
    "ClientConfirmProductInstanceResponseTypeDef", {"OwnerId": str, "Return": bool}, total=False
)

ClientCopyFpgaImageResponseTypeDef = TypedDict(
    "ClientCopyFpgaImageResponseTypeDef", {"FpgaImageId": str}, total=False
)

ClientCopyImageResponseTypeDef = TypedDict(
    "ClientCopyImageResponseTypeDef", {"ImageId": str}, total=False
)

ClientCopySnapshotResponseTagsTypeDef = TypedDict(
    "ClientCopySnapshotResponseTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCopySnapshotResponseTypeDef = TypedDict(
    "ClientCopySnapshotResponseTypeDef",
    {"SnapshotId": str, "Tags": List[ClientCopySnapshotResponseTagsTypeDef]},
    total=False,
)

ClientCopySnapshotTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCopySnapshotTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCopySnapshotTagSpecificationsTypeDef = TypedDict(
    "ClientCopySnapshotTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCopySnapshotTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateCapacityReservationResponseCapacityReservationTagsTypeDef = TypedDict(
    "ClientCreateCapacityReservationResponseCapacityReservationTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateCapacityReservationResponseCapacityReservationTypeDef = TypedDict(
    "ClientCreateCapacityReservationResponseCapacityReservationTypeDef",
    {
        "CapacityReservationId": str,
        "OwnerId": str,
        "CapacityReservationArn": str,
        "AvailabilityZoneId": str,
        "InstanceType": str,
        "InstancePlatform": Literal[
            "Linux/UNIX",
            "Red Hat Enterprise Linux",
            "SUSE Linux",
            "Windows",
            "Windows with SQL Server",
            "Windows with SQL Server Enterprise",
            "Windows with SQL Server Standard",
            "Windows with SQL Server Web",
            "Linux with SQL Server Standard",
            "Linux with SQL Server Web",
            "Linux with SQL Server Enterprise",
        ],
        "AvailabilityZone": str,
        "Tenancy": Literal["default", "dedicated"],
        "TotalInstanceCount": int,
        "AvailableInstanceCount": int,
        "EbsOptimized": bool,
        "EphemeralStorage": bool,
        "State": Literal["active", "expired", "cancelled", "pending", "failed"],
        "EndDate": datetime,
        "EndDateType": Literal["unlimited", "limited"],
        "InstanceMatchCriteria": Literal["open", "targeted"],
        "CreateDate": datetime,
        "Tags": List[ClientCreateCapacityReservationResponseCapacityReservationTagsTypeDef],
    },
    total=False,
)

ClientCreateCapacityReservationResponseTypeDef = TypedDict(
    "ClientCreateCapacityReservationResponseTypeDef",
    {"CapacityReservation": ClientCreateCapacityReservationResponseCapacityReservationTypeDef},
    total=False,
)

ClientCreateCapacityReservationTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateCapacityReservationTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateCapacityReservationTagSpecificationsTypeDef = TypedDict(
    "ClientCreateCapacityReservationTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateCapacityReservationTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateClientVpnEndpointAuthenticationOptionsActiveDirectoryTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointAuthenticationOptionsActiveDirectoryTypeDef",
    {"DirectoryId": str},
    total=False,
)

ClientCreateClientVpnEndpointAuthenticationOptionsMutualAuthenticationTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointAuthenticationOptionsMutualAuthenticationTypeDef",
    {"ClientRootCertificateChainArn": str},
    total=False,
)

ClientCreateClientVpnEndpointAuthenticationOptionsTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointAuthenticationOptionsTypeDef",
    {
        "Type": Literal["certificate-authentication", "directory-service-authentication"],
        "ActiveDirectory": ClientCreateClientVpnEndpointAuthenticationOptionsActiveDirectoryTypeDef,
        "MutualAuthentication": ClientCreateClientVpnEndpointAuthenticationOptionsMutualAuthenticationTypeDef,
    },
    total=False,
)

ClientCreateClientVpnEndpointConnectionLogOptionsTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointConnectionLogOptionsTypeDef",
    {"Enabled": bool, "CloudwatchLogGroup": str, "CloudwatchLogStream": str},
    total=False,
)

ClientCreateClientVpnEndpointResponseStatusTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointResponseStatusTypeDef",
    {"Code": Literal["pending-associate", "available", "deleting", "deleted"], "Message": str},
    total=False,
)

ClientCreateClientVpnEndpointResponseTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointResponseTypeDef",
    {
        "ClientVpnEndpointId": str,
        "Status": ClientCreateClientVpnEndpointResponseStatusTypeDef,
        "DnsName": str,
    },
    total=False,
)

ClientCreateClientVpnEndpointTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateClientVpnEndpointTagSpecificationsTypeDef = TypedDict(
    "ClientCreateClientVpnEndpointTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateClientVpnEndpointTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateClientVpnRouteResponseStatusTypeDef = TypedDict(
    "ClientCreateClientVpnRouteResponseStatusTypeDef",
    {"Code": Literal["creating", "active", "failed", "deleting"], "Message": str},
    total=False,
)

ClientCreateClientVpnRouteResponseTypeDef = TypedDict(
    "ClientCreateClientVpnRouteResponseTypeDef",
    {"Status": ClientCreateClientVpnRouteResponseStatusTypeDef},
    total=False,
)

ClientCreateCustomerGatewayResponseCustomerGatewayTagsTypeDef = TypedDict(
    "ClientCreateCustomerGatewayResponseCustomerGatewayTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateCustomerGatewayResponseCustomerGatewayTypeDef = TypedDict(
    "ClientCreateCustomerGatewayResponseCustomerGatewayTypeDef",
    {
        "BgpAsn": str,
        "CustomerGatewayId": str,
        "IpAddress": str,
        "CertificateArn": str,
        "State": str,
        "Type": str,
        "DeviceName": str,
        "Tags": List[ClientCreateCustomerGatewayResponseCustomerGatewayTagsTypeDef],
    },
    total=False,
)

ClientCreateCustomerGatewayResponseTypeDef = TypedDict(
    "ClientCreateCustomerGatewayResponseTypeDef",
    {"CustomerGateway": ClientCreateCustomerGatewayResponseCustomerGatewayTypeDef},
    total=False,
)

ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef = TypedDict(
    "ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef,
    },
    total=False,
)

ClientCreateDefaultSubnetResponseSubnetTagsTypeDef = TypedDict(
    "ClientCreateDefaultSubnetResponseSubnetTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateDefaultSubnetResponseSubnetTypeDef = TypedDict(
    "ClientCreateDefaultSubnetResponseSubnetTypeDef",
    {
        "AvailabilityZone": str,
        "AvailabilityZoneId": str,
        "AvailableIpAddressCount": int,
        "CidrBlock": str,
        "DefaultForAz": bool,
        "MapPublicIpOnLaunch": bool,
        "State": Literal["pending", "available"],
        "SubnetId": str,
        "VpcId": str,
        "OwnerId": str,
        "AssignIpv6AddressOnCreation": bool,
        "Ipv6CidrBlockAssociationSet": List[
            ClientCreateDefaultSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef
        ],
        "Tags": List[ClientCreateDefaultSubnetResponseSubnetTagsTypeDef],
        "SubnetArn": str,
        "OutpostArn": str,
    },
    total=False,
)

ClientCreateDefaultSubnetResponseTypeDef = TypedDict(
    "ClientCreateDefaultSubnetResponseTypeDef",
    {"Subnet": ClientCreateDefaultSubnetResponseSubnetTypeDef},
    total=False,
)

ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef = TypedDict(
    "ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetTypeDef = TypedDict(
    "ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "CidrBlock": str,
        "CidrBlockState": ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef,
    },
    total=False,
)

ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef = TypedDict(
    "ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef,
        "NetworkBorderGroup": str,
        "Ipv6Pool": str,
    },
    total=False,
)

ClientCreateDefaultVpcResponseVpcTagsTypeDef = TypedDict(
    "ClientCreateDefaultVpcResponseVpcTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateDefaultVpcResponseVpcTypeDef = TypedDict(
    "ClientCreateDefaultVpcResponseVpcTypeDef",
    {
        "CidrBlock": str,
        "DhcpOptionsId": str,
        "State": Literal["pending", "available"],
        "VpcId": str,
        "OwnerId": str,
        "InstanceTenancy": Literal["default", "dedicated", "host"],
        "Ipv6CidrBlockAssociationSet": List[
            ClientCreateDefaultVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef
        ],
        "CidrBlockAssociationSet": List[
            ClientCreateDefaultVpcResponseVpcCidrBlockAssociationSetTypeDef
        ],
        "IsDefault": bool,
        "Tags": List[ClientCreateDefaultVpcResponseVpcTagsTypeDef],
    },
    total=False,
)

ClientCreateDefaultVpcResponseTypeDef = TypedDict(
    "ClientCreateDefaultVpcResponseTypeDef",
    {"Vpc": ClientCreateDefaultVpcResponseVpcTypeDef},
    total=False,
)

ClientCreateDhcpOptionsDhcpConfigurationsTypeDef = TypedDict(
    "ClientCreateDhcpOptionsDhcpConfigurationsTypeDef",
    {"Key": str, "Values": List[str]},
    total=False,
)

ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef = TypedDict(
    "ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef = TypedDict(
    "ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef",
    {
        "Key": str,
        "Values": List[ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef],
    },
    total=False,
)

ClientCreateDhcpOptionsResponseDhcpOptionsTagsTypeDef = TypedDict(
    "ClientCreateDhcpOptionsResponseDhcpOptionsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateDhcpOptionsResponseDhcpOptionsTypeDef = TypedDict(
    "ClientCreateDhcpOptionsResponseDhcpOptionsTypeDef",
    {
        "DhcpConfigurations": List[
            ClientCreateDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef
        ],
        "DhcpOptionsId": str,
        "OwnerId": str,
        "Tags": List[ClientCreateDhcpOptionsResponseDhcpOptionsTagsTypeDef],
    },
    total=False,
)

ClientCreateDhcpOptionsResponseTypeDef = TypedDict(
    "ClientCreateDhcpOptionsResponseTypeDef",
    {"DhcpOptions": ClientCreateDhcpOptionsResponseDhcpOptionsTypeDef},
    total=False,
)

ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayAttachmentsTypeDef = TypedDict(
    "ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayAttachmentsTypeDef",
    {"State": Literal["attaching", "attached", "detaching", "detached"], "VpcId": str},
    total=False,
)

ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTagsTypeDef = TypedDict(
    "ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTypeDef = TypedDict(
    "ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTypeDef",
    {
        "Attachments": List[
            ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayAttachmentsTypeDef
        ],
        "EgressOnlyInternetGatewayId": str,
        "Tags": List[
            ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateEgressOnlyInternetGatewayResponseTypeDef = TypedDict(
    "ClientCreateEgressOnlyInternetGatewayResponseTypeDef",
    {
        "ClientToken": str,
        "EgressOnlyInternetGateway": ClientCreateEgressOnlyInternetGatewayResponseEgressOnlyInternetGatewayTypeDef,
    },
    total=False,
)

ClientCreateFleetLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientCreateFleetLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientCreateFleetLaunchTemplateConfigsOverridesPlacementTypeDef = TypedDict(
    "ClientCreateFleetLaunchTemplateConfigsOverridesPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "PartitionNumber": int,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
    },
    total=False,
)

ClientCreateFleetLaunchTemplateConfigsOverridesTypeDef = TypedDict(
    "ClientCreateFleetLaunchTemplateConfigsOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "MaxPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
        "Placement": ClientCreateFleetLaunchTemplateConfigsOverridesPlacementTypeDef,
    },
    total=False,
)

ClientCreateFleetLaunchTemplateConfigsTypeDef = TypedDict(
    "ClientCreateFleetLaunchTemplateConfigsTypeDef",
    {
        "LaunchTemplateSpecification": ClientCreateFleetLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef,
        "Overrides": List[ClientCreateFleetLaunchTemplateConfigsOverridesTypeDef],
    },
    total=False,
)

ClientCreateFleetOnDemandOptionsCapacityReservationOptionsTypeDef = TypedDict(
    "ClientCreateFleetOnDemandOptionsCapacityReservationOptionsTypeDef",
    {"UsageStrategy": str},
    total=False,
)

ClientCreateFleetOnDemandOptionsTypeDef = TypedDict(
    "ClientCreateFleetOnDemandOptionsTypeDef",
    {
        "AllocationStrategy": Literal["lowest-price", "prioritized"],
        "CapacityReservationOptions": ClientCreateFleetOnDemandOptionsCapacityReservationOptionsTypeDef,
        "SingleInstanceType": bool,
        "SingleAvailabilityZone": bool,
        "MinTargetCapacity": int,
        "MaxTotalPrice": str,
    },
    total=False,
)

ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef = TypedDict(
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    {"GroupName": str},
    total=False,
)

ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesTypeDef = TypedDict(
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "MaxPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
        "Placement": ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef,
    },
    total=False,
)

ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesTypeDef = TypedDict(
    "ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesTypeDef",
    {
        "LaunchTemplateSpecification": ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef,
        "Overrides": ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesOverridesTypeDef,
    },
    total=False,
)

ClientCreateFleetResponseErrorsTypeDef = TypedDict(
    "ClientCreateFleetResponseErrorsTypeDef",
    {
        "LaunchTemplateAndOverrides": ClientCreateFleetResponseErrorsLaunchTemplateAndOverridesTypeDef,
        "Lifecycle": Literal["spot", "on-demand"],
        "ErrorCode": str,
        "ErrorMessage": str,
    },
    total=False,
)

ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef = TypedDict(
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    {"GroupName": str},
    total=False,
)

ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesTypeDef = TypedDict(
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "MaxPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
        "Placement": ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef,
    },
    total=False,
)

ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesTypeDef = TypedDict(
    "ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesTypeDef",
    {
        "LaunchTemplateSpecification": ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef,
        "Overrides": ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesOverridesTypeDef,
    },
    total=False,
)

ClientCreateFleetResponseInstancesTypeDef = TypedDict(
    "ClientCreateFleetResponseInstancesTypeDef",
    {
        "LaunchTemplateAndOverrides": ClientCreateFleetResponseInstancesLaunchTemplateAndOverridesTypeDef,
        "Lifecycle": Literal["spot", "on-demand"],
        "InstanceIds": List[str],
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "Platform": str,
    },
    total=False,
)

ClientCreateFleetResponseTypeDef = TypedDict(
    "ClientCreateFleetResponseTypeDef",
    {
        "FleetId": str,
        "Errors": List[ClientCreateFleetResponseErrorsTypeDef],
        "Instances": List[ClientCreateFleetResponseInstancesTypeDef],
    },
    total=False,
)

ClientCreateFleetSpotOptionsTypeDef = TypedDict(
    "ClientCreateFleetSpotOptionsTypeDef",
    {
        "AllocationStrategy": Literal["lowest-price", "diversified", "capacity-optimized"],
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
        "InstancePoolsToUseCount": int,
        "SingleInstanceType": bool,
        "SingleAvailabilityZone": bool,
        "MinTargetCapacity": int,
        "MaxTotalPrice": str,
    },
    total=False,
)

ClientCreateFleetTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateFleetTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateFleetTagSpecificationsTypeDef = TypedDict(
    "ClientCreateFleetTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateFleetTagSpecificationsTagsTypeDef],
    },
    total=False,
)

_RequiredClientCreateFleetTargetCapacitySpecificationTypeDef = TypedDict(
    "_RequiredClientCreateFleetTargetCapacitySpecificationTypeDef", {"TotalTargetCapacity": int}
)
_OptionalClientCreateFleetTargetCapacitySpecificationTypeDef = TypedDict(
    "_OptionalClientCreateFleetTargetCapacitySpecificationTypeDef",
    {
        "OnDemandTargetCapacity": int,
        "SpotTargetCapacity": int,
        "DefaultTargetCapacityType": Literal["spot", "on-demand"],
    },
    total=False,
)


class ClientCreateFleetTargetCapacitySpecificationTypeDef(
    _RequiredClientCreateFleetTargetCapacitySpecificationTypeDef,
    _OptionalClientCreateFleetTargetCapacitySpecificationTypeDef,
):
    pass


ClientCreateFlowLogsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientCreateFlowLogsResponseUnsuccessfulErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientCreateFlowLogsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientCreateFlowLogsResponseUnsuccessfulTypeDef",
    {"Error": ClientCreateFlowLogsResponseUnsuccessfulErrorTypeDef, "ResourceId": str},
    total=False,
)

ClientCreateFlowLogsResponseTypeDef = TypedDict(
    "ClientCreateFlowLogsResponseTypeDef",
    {
        "ClientToken": str,
        "FlowLogIds": List[str],
        "Unsuccessful": List[ClientCreateFlowLogsResponseUnsuccessfulTypeDef],
    },
    total=False,
)

ClientCreateFpgaImageInputStorageLocationTypeDef = TypedDict(
    "ClientCreateFpgaImageInputStorageLocationTypeDef", {"Bucket": str, "Key": str}, total=False
)

ClientCreateFpgaImageLogsStorageLocationTypeDef = TypedDict(
    "ClientCreateFpgaImageLogsStorageLocationTypeDef", {"Bucket": str, "Key": str}, total=False
)

ClientCreateFpgaImageResponseTypeDef = TypedDict(
    "ClientCreateFpgaImageResponseTypeDef",
    {"FpgaImageId": str, "FpgaImageGlobalId": str},
    total=False,
)

ClientCreateFpgaImageTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateFpgaImageTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateFpgaImageTagSpecificationsTypeDef = TypedDict(
    "ClientCreateFpgaImageTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateFpgaImageTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateImageBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientCreateImageBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientCreateImageBlockDeviceMappingsTypeDef = TypedDict(
    "ClientCreateImageBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientCreateImageBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientCreateImageResponseTypeDef = TypedDict(
    "ClientCreateImageResponseTypeDef", {"ImageId": str}, total=False
)

ClientCreateInstanceExportTaskExportToS3TaskTypeDef = TypedDict(
    "ClientCreateInstanceExportTaskExportToS3TaskTypeDef",
    {
        "ContainerFormat": str,
        "DiskImageFormat": Literal["VMDK", "RAW", "VHD"],
        "S3Bucket": str,
        "S3Prefix": str,
    },
    total=False,
)

ClientCreateInstanceExportTaskResponseExportTaskExportToS3TaskTypeDef = TypedDict(
    "ClientCreateInstanceExportTaskResponseExportTaskExportToS3TaskTypeDef",
    {
        "ContainerFormat": str,
        "DiskImageFormat": Literal["VMDK", "RAW", "VHD"],
        "S3Bucket": str,
        "S3Key": str,
    },
    total=False,
)

ClientCreateInstanceExportTaskResponseExportTaskInstanceExportDetailsTypeDef = TypedDict(
    "ClientCreateInstanceExportTaskResponseExportTaskInstanceExportDetailsTypeDef",
    {"InstanceId": str, "TargetEnvironment": Literal["citrix", "vmware", "microsoft"]},
    total=False,
)

ClientCreateInstanceExportTaskResponseExportTaskTagsTypeDef = TypedDict(
    "ClientCreateInstanceExportTaskResponseExportTaskTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateInstanceExportTaskResponseExportTaskTypeDef = TypedDict(
    "ClientCreateInstanceExportTaskResponseExportTaskTypeDef",
    {
        "Description": str,
        "ExportTaskId": str,
        "ExportToS3Task": ClientCreateInstanceExportTaskResponseExportTaskExportToS3TaskTypeDef,
        "InstanceExportDetails": ClientCreateInstanceExportTaskResponseExportTaskInstanceExportDetailsTypeDef,
        "State": Literal["active", "cancelling", "cancelled", "completed"],
        "StatusMessage": str,
        "Tags": List[ClientCreateInstanceExportTaskResponseExportTaskTagsTypeDef],
    },
    total=False,
)

ClientCreateInstanceExportTaskResponseTypeDef = TypedDict(
    "ClientCreateInstanceExportTaskResponseTypeDef",
    {"ExportTask": ClientCreateInstanceExportTaskResponseExportTaskTypeDef},
    total=False,
)

ClientCreateInternetGatewayResponseInternetGatewayAttachmentsTypeDef = TypedDict(
    "ClientCreateInternetGatewayResponseInternetGatewayAttachmentsTypeDef",
    {"State": Literal["attaching", "attached", "detaching", "detached"], "VpcId": str},
    total=False,
)

ClientCreateInternetGatewayResponseInternetGatewayTagsTypeDef = TypedDict(
    "ClientCreateInternetGatewayResponseInternetGatewayTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateInternetGatewayResponseInternetGatewayTypeDef = TypedDict(
    "ClientCreateInternetGatewayResponseInternetGatewayTypeDef",
    {
        "Attachments": List[ClientCreateInternetGatewayResponseInternetGatewayAttachmentsTypeDef],
        "InternetGatewayId": str,
        "OwnerId": str,
        "Tags": List[ClientCreateInternetGatewayResponseInternetGatewayTagsTypeDef],
    },
    total=False,
)

ClientCreateInternetGatewayResponseTypeDef = TypedDict(
    "ClientCreateInternetGatewayResponseTypeDef",
    {"InternetGateway": ClientCreateInternetGatewayResponseInternetGatewayTypeDef},
    total=False,
)

ClientCreateKeyPairResponseTypeDef = TypedDict(
    "ClientCreateKeyPairResponseTypeDef",
    {"KeyFingerprint": str, "KeyMaterial": str, "KeyName": str, "KeyPairId": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    {
        "Encrypted": bool,
        "DeleteOnTermination": bool,
        "Iops": int,
        "KmsKeyId": str,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataCpuOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataCpuOptionsTypeDef",
    {"CoreCount": int, "ThreadsPerCore": int},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataCreditSpecificationTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataCreditSpecificationTypeDef",
    {"CpuCredits": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataElasticGpuSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    {"Type": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataElasticInferenceAcceleratorsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    {"Type": str, "Count": int},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataHibernationOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataHibernationOptionsTypeDef",
    {"Configured": bool},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataIamInstanceProfileTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    {
        "MaxPrice": str,
        "SpotInstanceType": Literal["one-time", "persistent"],
        "BlockDurationMinutes": int,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsTypeDef",
    {
        "MarketType": str,
        "SpotOptions": ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataLicenseSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataLicenseSpecificationsTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataMetadataOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataMetadataOptionsTypeDef",
    {
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataMonitoringTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataMonitoringTypeDef", {"Enabled": bool}, total=False
)

ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "InterfaceType": str,
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataPlacementTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
        "PartitionNumber": int,
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateLaunchTemplateLaunchTemplateDataTypeDef = TypedDict(
    "ClientCreateLaunchTemplateLaunchTemplateDataTypeDef",
    {
        "KernelId": str,
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientCreateLaunchTemplateLaunchTemplateDataIamInstanceProfileTypeDef,
        "BlockDeviceMappings": List[
            ClientCreateLaunchTemplateLaunchTemplateDataBlockDeviceMappingsTypeDef
        ],
        "NetworkInterfaces": List[
            ClientCreateLaunchTemplateLaunchTemplateDataNetworkInterfacesTypeDef
        ],
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KeyName": str,
        "Monitoring": ClientCreateLaunchTemplateLaunchTemplateDataMonitoringTypeDef,
        "Placement": ClientCreateLaunchTemplateLaunchTemplateDataPlacementTypeDef,
        "RamDiskId": str,
        "DisableApiTermination": bool,
        "InstanceInitiatedShutdownBehavior": Literal["stop", "terminate"],
        "UserData": str,
        "TagSpecifications": List[
            ClientCreateLaunchTemplateLaunchTemplateDataTagSpecificationsTypeDef
        ],
        "ElasticGpuSpecifications": List[
            ClientCreateLaunchTemplateLaunchTemplateDataElasticGpuSpecificationsTypeDef
        ],
        "ElasticInferenceAccelerators": List[
            ClientCreateLaunchTemplateLaunchTemplateDataElasticInferenceAcceleratorsTypeDef
        ],
        "SecurityGroupIds": List[str],
        "SecurityGroups": List[str],
        "InstanceMarketOptions": ClientCreateLaunchTemplateLaunchTemplateDataInstanceMarketOptionsTypeDef,
        "CreditSpecification": ClientCreateLaunchTemplateLaunchTemplateDataCreditSpecificationTypeDef,
        "CpuOptions": ClientCreateLaunchTemplateLaunchTemplateDataCpuOptionsTypeDef,
        "CapacityReservationSpecification": ClientCreateLaunchTemplateLaunchTemplateDataCapacityReservationSpecificationTypeDef,
        "LicenseSpecifications": List[
            ClientCreateLaunchTemplateLaunchTemplateDataLicenseSpecificationsTypeDef
        ],
        "HibernationOptions": ClientCreateLaunchTemplateLaunchTemplateDataHibernationOptionsTypeDef,
        "MetadataOptions": ClientCreateLaunchTemplateLaunchTemplateDataMetadataOptionsTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateResponseLaunchTemplateTagsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateResponseLaunchTemplateTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateLaunchTemplateResponseLaunchTemplateTypeDef = TypedDict(
    "ClientCreateLaunchTemplateResponseLaunchTemplateTypeDef",
    {
        "LaunchTemplateId": str,
        "LaunchTemplateName": str,
        "CreateTime": datetime,
        "CreatedBy": str,
        "DefaultVersionNumber": int,
        "LatestVersionNumber": int,
        "Tags": List[ClientCreateLaunchTemplateResponseLaunchTemplateTagsTypeDef],
    },
    total=False,
)

ClientCreateLaunchTemplateResponseTypeDef = TypedDict(
    "ClientCreateLaunchTemplateResponseTypeDef",
    {"LaunchTemplate": ClientCreateLaunchTemplateResponseLaunchTemplateTypeDef},
    total=False,
)

ClientCreateLaunchTemplateTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateLaunchTemplateTagSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateLaunchTemplateTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    {
        "Encrypted": bool,
        "DeleteOnTermination": bool,
        "Iops": int,
        "KmsKeyId": str,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef",
    {"CoreCount": int, "ThreadsPerCore": int},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef",
    {"CpuCredits": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    {"Type": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    {"Type": str, "Count": int},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef",
    {"Configured": bool},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    {
        "MaxPrice": str,
        "SpotInstanceType": Literal["one-time", "persistent"],
        "BlockDurationMinutes": int,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef",
    {
        "MarketType": str,
        "SpotOptions": ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef",
    {
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "InterfaceType": str,
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
        "PartitionNumber": int,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionLaunchTemplateDataTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionLaunchTemplateDataTypeDef",
    {
        "KernelId": str,
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientCreateLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef,
        "BlockDeviceMappings": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef
        ],
        "NetworkInterfaces": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef
        ],
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KeyName": str,
        "Monitoring": ClientCreateLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef,
        "Placement": ClientCreateLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef,
        "RamDiskId": str,
        "DisableApiTermination": bool,
        "InstanceInitiatedShutdownBehavior": Literal["stop", "terminate"],
        "UserData": str,
        "TagSpecifications": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef
        ],
        "ElasticGpuSpecifications": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef
        ],
        "ElasticInferenceAccelerators": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef
        ],
        "SecurityGroupIds": List[str],
        "SecurityGroups": List[str],
        "InstanceMarketOptions": ClientCreateLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef,
        "CreditSpecification": ClientCreateLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef,
        "CpuOptions": ClientCreateLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef,
        "CapacityReservationSpecification": ClientCreateLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef,
        "LicenseSpecifications": List[
            ClientCreateLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef
        ],
        "HibernationOptions": ClientCreateLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef,
        "MetadataOptions": ClientCreateLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    {
        "Encrypted": bool,
        "DeleteOnTermination": bool,
        "Iops": int,
        "KmsKeyId": str,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef",
    {"CoreCount": int, "ThreadsPerCore": int},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef",
    {"CpuCredits": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    {"Type": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    {"Type": str, "Count": int},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef",
    {"Configured": bool},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    {
        "MaxPrice": str,
        "SpotInstanceType": Literal["one-time", "persistent"],
        "BlockDurationMinutes": int,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef",
    {
        "MarketType": str,
        "SpotOptions": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef",
    {
        "State": Literal["pending", "applied"],
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "InterfaceType": str,
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
        "PartitionNumber": int,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTypeDef",
    {
        "KernelId": str,
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataIamInstanceProfileTypeDef,
        "BlockDeviceMappings": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataBlockDeviceMappingsTypeDef
        ],
        "NetworkInterfaces": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataNetworkInterfacesTypeDef
        ],
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KeyName": str,
        "Monitoring": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMonitoringTypeDef,
        "Placement": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataPlacementTypeDef,
        "RamDiskId": str,
        "DisableApiTermination": bool,
        "InstanceInitiatedShutdownBehavior": Literal["stop", "terminate"],
        "UserData": str,
        "TagSpecifications": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTagSpecificationsTypeDef
        ],
        "ElasticGpuSpecifications": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticGpuSpecificationsTypeDef
        ],
        "ElasticInferenceAccelerators": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataElasticInferenceAcceleratorsTypeDef
        ],
        "SecurityGroupIds": List[str],
        "SecurityGroups": List[str],
        "InstanceMarketOptions": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataInstanceMarketOptionsTypeDef,
        "CreditSpecification": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCreditSpecificationTypeDef,
        "CpuOptions": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCpuOptionsTypeDef,
        "CapacityReservationSpecification": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataCapacityReservationSpecificationTypeDef,
        "LicenseSpecifications": List[
            ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataLicenseSpecificationsTypeDef
        ],
        "HibernationOptions": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataHibernationOptionsTypeDef,
        "MetadataOptions": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataMetadataOptionsTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionTypeDef",
    {
        "LaunchTemplateId": str,
        "LaunchTemplateName": str,
        "VersionNumber": int,
        "VersionDescription": str,
        "CreateTime": datetime,
        "CreatedBy": str,
        "DefaultVersion": bool,
        "LaunchTemplateData": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionLaunchTemplateDataTypeDef,
    },
    total=False,
)

ClientCreateLaunchTemplateVersionResponseTypeDef = TypedDict(
    "ClientCreateLaunchTemplateVersionResponseTypeDef",
    {
        "LaunchTemplateVersion": ClientCreateLaunchTemplateVersionResponseLaunchTemplateVersionTypeDef
    },
    total=False,
)

ClientCreateLocalGatewayRouteResponseRouteTypeDef = TypedDict(
    "ClientCreateLocalGatewayRouteResponseRouteTypeDef",
    {
        "DestinationCidrBlock": str,
        "LocalGatewayVirtualInterfaceGroupId": str,
        "Type": Literal["static", "propagated"],
        "State": Literal["pending", "active", "blackhole", "deleting", "deleted"],
        "LocalGatewayRouteTableId": str,
    },
    total=False,
)

ClientCreateLocalGatewayRouteResponseTypeDef = TypedDict(
    "ClientCreateLocalGatewayRouteResponseTypeDef",
    {"Route": ClientCreateLocalGatewayRouteResponseRouteTypeDef},
    total=False,
)

ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef = TypedDict(
    "ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef = TypedDict(
    "ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef",
    {
        "LocalGatewayRouteTableVpcAssociationId": str,
        "LocalGatewayRouteTableId": str,
        "LocalGatewayId": str,
        "VpcId": str,
        "State": str,
        "Tags": List[
            ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateLocalGatewayRouteTableVpcAssociationResponseTypeDef = TypedDict(
    "ClientCreateLocalGatewayRouteTableVpcAssociationResponseTypeDef",
    {
        "LocalGatewayRouteTableVpcAssociation": ClientCreateLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef
    },
    total=False,
)

ClientCreateNatGatewayResponseNatGatewayNatGatewayAddressesTypeDef = TypedDict(
    "ClientCreateNatGatewayResponseNatGatewayNatGatewayAddressesTypeDef",
    {"AllocationId": str, "NetworkInterfaceId": str, "PrivateIp": str, "PublicIp": str},
    total=False,
)

ClientCreateNatGatewayResponseNatGatewayProvisionedBandwidthTypeDef = TypedDict(
    "ClientCreateNatGatewayResponseNatGatewayProvisionedBandwidthTypeDef",
    {
        "ProvisionTime": datetime,
        "Provisioned": str,
        "RequestTime": datetime,
        "Requested": str,
        "Status": str,
    },
    total=False,
)

ClientCreateNatGatewayResponseNatGatewayTagsTypeDef = TypedDict(
    "ClientCreateNatGatewayResponseNatGatewayTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateNatGatewayResponseNatGatewayTypeDef = TypedDict(
    "ClientCreateNatGatewayResponseNatGatewayTypeDef",
    {
        "CreateTime": datetime,
        "DeleteTime": datetime,
        "FailureCode": str,
        "FailureMessage": str,
        "NatGatewayAddresses": List[
            ClientCreateNatGatewayResponseNatGatewayNatGatewayAddressesTypeDef
        ],
        "NatGatewayId": str,
        "ProvisionedBandwidth": ClientCreateNatGatewayResponseNatGatewayProvisionedBandwidthTypeDef,
        "State": Literal["pending", "failed", "available", "deleting", "deleted"],
        "SubnetId": str,
        "VpcId": str,
        "Tags": List[ClientCreateNatGatewayResponseNatGatewayTagsTypeDef],
    },
    total=False,
)

ClientCreateNatGatewayResponseTypeDef = TypedDict(
    "ClientCreateNatGatewayResponseTypeDef",
    {"ClientToken": str, "NatGateway": ClientCreateNatGatewayResponseNatGatewayTypeDef},
    total=False,
)

ClientCreateNetworkAclEntryIcmpTypeCodeTypeDef = TypedDict(
    "ClientCreateNetworkAclEntryIcmpTypeCodeTypeDef", {"Code": int, "Type": int}, total=False
)

ClientCreateNetworkAclEntryPortRangeTypeDef = TypedDict(
    "ClientCreateNetworkAclEntryPortRangeTypeDef", {"From": int, "To": int}, total=False
)

ClientCreateNetworkAclResponseNetworkAclAssociationsTypeDef = TypedDict(
    "ClientCreateNetworkAclResponseNetworkAclAssociationsTypeDef",
    {"NetworkAclAssociationId": str, "NetworkAclId": str, "SubnetId": str},
    total=False,
)

ClientCreateNetworkAclResponseNetworkAclEntriesIcmpTypeCodeTypeDef = TypedDict(
    "ClientCreateNetworkAclResponseNetworkAclEntriesIcmpTypeCodeTypeDef",
    {"Code": int, "Type": int},
    total=False,
)

ClientCreateNetworkAclResponseNetworkAclEntriesPortRangeTypeDef = TypedDict(
    "ClientCreateNetworkAclResponseNetworkAclEntriesPortRangeTypeDef",
    {"From": int, "To": int},
    total=False,
)

ClientCreateNetworkAclResponseNetworkAclEntriesTypeDef = TypedDict(
    "ClientCreateNetworkAclResponseNetworkAclEntriesTypeDef",
    {
        "CidrBlock": str,
        "Egress": bool,
        "IcmpTypeCode": ClientCreateNetworkAclResponseNetworkAclEntriesIcmpTypeCodeTypeDef,
        "Ipv6CidrBlock": str,
        "PortRange": ClientCreateNetworkAclResponseNetworkAclEntriesPortRangeTypeDef,
        "Protocol": str,
        "RuleAction": Literal["allow", "deny"],
        "RuleNumber": int,
    },
    total=False,
)

ClientCreateNetworkAclResponseNetworkAclTagsTypeDef = TypedDict(
    "ClientCreateNetworkAclResponseNetworkAclTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateNetworkAclResponseNetworkAclTypeDef = TypedDict(
    "ClientCreateNetworkAclResponseNetworkAclTypeDef",
    {
        "Associations": List[ClientCreateNetworkAclResponseNetworkAclAssociationsTypeDef],
        "Entries": List[ClientCreateNetworkAclResponseNetworkAclEntriesTypeDef],
        "IsDefault": bool,
        "NetworkAclId": str,
        "Tags": List[ClientCreateNetworkAclResponseNetworkAclTagsTypeDef],
        "VpcId": str,
        "OwnerId": str,
    },
    total=False,
)

ClientCreateNetworkAclResponseTypeDef = TypedDict(
    "ClientCreateNetworkAclResponseTypeDef",
    {"NetworkAcl": ClientCreateNetworkAclResponseNetworkAclTypeDef},
    total=False,
)

ClientCreateNetworkInterfaceIpv6AddressesTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceIpv6AddressesTypeDef", {"Ipv6Address": str}, total=False
)

ClientCreateNetworkInterfacePermissionResponseInterfacePermissionPermissionStateTypeDef = TypedDict(
    "ClientCreateNetworkInterfacePermissionResponseInterfacePermissionPermissionStateTypeDef",
    {"State": Literal["pending", "granted", "revoking", "revoked"], "StatusMessage": str},
    total=False,
)

ClientCreateNetworkInterfacePermissionResponseInterfacePermissionTypeDef = TypedDict(
    "ClientCreateNetworkInterfacePermissionResponseInterfacePermissionTypeDef",
    {
        "NetworkInterfacePermissionId": str,
        "NetworkInterfaceId": str,
        "AwsAccountId": str,
        "AwsService": str,
        "Permission": Literal["INSTANCE-ATTACH", "EIP-ASSOCIATE"],
        "PermissionState": ClientCreateNetworkInterfacePermissionResponseInterfacePermissionPermissionStateTypeDef,
    },
    total=False,
)

ClientCreateNetworkInterfacePermissionResponseTypeDef = TypedDict(
    "ClientCreateNetworkInterfacePermissionResponseTypeDef",
    {
        "InterfacePermission": ClientCreateNetworkInterfacePermissionResponseInterfacePermissionTypeDef
    },
    total=False,
)

ClientCreateNetworkInterfacePrivateIpAddressesTypeDef = TypedDict(
    "ClientCreateNetworkInterfacePrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfaceAssociationTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceAssociationTypeDef",
    {
        "AllocationId": str,
        "AssociationId": str,
        "IpOwnerId": str,
        "PublicDnsName": str,
        "PublicIp": str,
    },
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfaceAttachmentTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceAttachmentTypeDef",
    {
        "AttachTime": datetime,
        "AttachmentId": str,
        "DeleteOnTermination": bool,
        "DeviceIndex": int,
        "InstanceId": str,
        "InstanceOwnerId": str,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
    },
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfaceGroupsTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfaceIpv6AddressesTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesAssociationTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesAssociationTypeDef",
    {
        "AllocationId": str,
        "AssociationId": str,
        "IpOwnerId": str,
        "PublicDnsName": str,
        "PublicIp": str,
    },
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesTypeDef",
    {
        "Association": ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesAssociationTypeDef,
        "Primary": bool,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
    },
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfaceTagSetTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceTagSetTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateNetworkInterfaceResponseNetworkInterfaceTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseNetworkInterfaceTypeDef",
    {
        "Association": ClientCreateNetworkInterfaceResponseNetworkInterfaceAssociationTypeDef,
        "Attachment": ClientCreateNetworkInterfaceResponseNetworkInterfaceAttachmentTypeDef,
        "AvailabilityZone": str,
        "Description": str,
        "Groups": List[ClientCreateNetworkInterfaceResponseNetworkInterfaceGroupsTypeDef],
        "InterfaceType": Literal["interface", "natGateway", "efa"],
        "Ipv6Addresses": List[
            ClientCreateNetworkInterfaceResponseNetworkInterfaceIpv6AddressesTypeDef
        ],
        "MacAddress": str,
        "NetworkInterfaceId": str,
        "OutpostArn": str,
        "OwnerId": str,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientCreateNetworkInterfaceResponseNetworkInterfacePrivateIpAddressesTypeDef
        ],
        "RequesterId": str,
        "RequesterManaged": bool,
        "SourceDestCheck": bool,
        "Status": Literal["available", "associated", "attaching", "in-use", "detaching"],
        "SubnetId": str,
        "TagSet": List[ClientCreateNetworkInterfaceResponseNetworkInterfaceTagSetTypeDef],
        "VpcId": str,
    },
    total=False,
)

ClientCreateNetworkInterfaceResponseTypeDef = TypedDict(
    "ClientCreateNetworkInterfaceResponseTypeDef",
    {"NetworkInterface": ClientCreateNetworkInterfaceResponseNetworkInterfaceTypeDef},
    total=False,
)

ClientCreateReservedInstancesListingPriceSchedulesTypeDef = TypedDict(
    "ClientCreateReservedInstancesListingPriceSchedulesTypeDef",
    {"CurrencyCode": str, "Price": float, "Term": int},
    total=False,
)

ClientCreateReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef = TypedDict(
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef",
    {"InstanceCount": int, "State": Literal["available", "sold", "cancelled", "pending"]},
    total=False,
)

ClientCreateReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef = TypedDict(
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef",
    {"Active": bool, "CurrencyCode": str, "Price": float, "Term": int},
    total=False,
)

ClientCreateReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef = TypedDict(
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateReservedInstancesListingResponseReservedInstancesListingsTypeDef = TypedDict(
    "ClientCreateReservedInstancesListingResponseReservedInstancesListingsTypeDef",
    {
        "ClientToken": str,
        "CreateDate": datetime,
        "InstanceCounts": List[
            ClientCreateReservedInstancesListingResponseReservedInstancesListingsInstanceCountsTypeDef
        ],
        "PriceSchedules": List[
            ClientCreateReservedInstancesListingResponseReservedInstancesListingsPriceSchedulesTypeDef
        ],
        "ReservedInstancesId": str,
        "ReservedInstancesListingId": str,
        "Status": Literal["active", "pending", "cancelled", "closed"],
        "StatusMessage": str,
        "Tags": List[
            ClientCreateReservedInstancesListingResponseReservedInstancesListingsTagsTypeDef
        ],
        "UpdateDate": datetime,
    },
    total=False,
)

ClientCreateReservedInstancesListingResponseTypeDef = TypedDict(
    "ClientCreateReservedInstancesListingResponseTypeDef",
    {
        "ReservedInstancesListings": List[
            ClientCreateReservedInstancesListingResponseReservedInstancesListingsTypeDef
        ]
    },
    total=False,
)

ClientCreateRouteResponseTypeDef = TypedDict(
    "ClientCreateRouteResponseTypeDef", {"Return": bool}, total=False
)

ClientCreateRouteTableResponseRouteTableAssociationsAssociationStateTypeDef = TypedDict(
    "ClientCreateRouteTableResponseRouteTableAssociationsAssociationStateTypeDef",
    {
        "State": Literal["associating", "associated", "disassociating", "disassociated", "failed"],
        "StatusMessage": str,
    },
    total=False,
)

ClientCreateRouteTableResponseRouteTableAssociationsTypeDef = TypedDict(
    "ClientCreateRouteTableResponseRouteTableAssociationsTypeDef",
    {
        "Main": bool,
        "RouteTableAssociationId": str,
        "RouteTableId": str,
        "SubnetId": str,
        "GatewayId": str,
        "AssociationState": ClientCreateRouteTableResponseRouteTableAssociationsAssociationStateTypeDef,
    },
    total=False,
)

ClientCreateRouteTableResponseRouteTablePropagatingVgwsTypeDef = TypedDict(
    "ClientCreateRouteTableResponseRouteTablePropagatingVgwsTypeDef",
    {"GatewayId": str},
    total=False,
)

ClientCreateRouteTableResponseRouteTableRoutesTypeDef = TypedDict(
    "ClientCreateRouteTableResponseRouteTableRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "DestinationIpv6CidrBlock": str,
        "DestinationPrefixListId": str,
        "EgressOnlyInternetGatewayId": str,
        "GatewayId": str,
        "InstanceId": str,
        "InstanceOwnerId": str,
        "NatGatewayId": str,
        "TransitGatewayId": str,
        "LocalGatewayId": str,
        "NetworkInterfaceId": str,
        "Origin": Literal["CreateRouteTable", "CreateRoute", "EnableVgwRoutePropagation"],
        "State": Literal["active", "blackhole"],
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientCreateRouteTableResponseRouteTableTagsTypeDef = TypedDict(
    "ClientCreateRouteTableResponseRouteTableTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateRouteTableResponseRouteTableTypeDef = TypedDict(
    "ClientCreateRouteTableResponseRouteTableTypeDef",
    {
        "Associations": List[ClientCreateRouteTableResponseRouteTableAssociationsTypeDef],
        "PropagatingVgws": List[ClientCreateRouteTableResponseRouteTablePropagatingVgwsTypeDef],
        "RouteTableId": str,
        "Routes": List[ClientCreateRouteTableResponseRouteTableRoutesTypeDef],
        "Tags": List[ClientCreateRouteTableResponseRouteTableTagsTypeDef],
        "VpcId": str,
        "OwnerId": str,
    },
    total=False,
)

ClientCreateRouteTableResponseTypeDef = TypedDict(
    "ClientCreateRouteTableResponseTypeDef",
    {"RouteTable": ClientCreateRouteTableResponseRouteTableTypeDef},
    total=False,
)

ClientCreateSecurityGroupResponseTypeDef = TypedDict(
    "ClientCreateSecurityGroupResponseTypeDef", {"GroupId": str}, total=False
)

ClientCreateSnapshotResponseTagsTypeDef = TypedDict(
    "ClientCreateSnapshotResponseTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateSnapshotResponseTypeDef = TypedDict(
    "ClientCreateSnapshotResponseTypeDef",
    {
        "DataEncryptionKeyId": str,
        "Description": str,
        "Encrypted": bool,
        "KmsKeyId": str,
        "OwnerId": str,
        "Progress": str,
        "SnapshotId": str,
        "StartTime": datetime,
        "State": Literal["pending", "completed", "error"],
        "StateMessage": str,
        "VolumeId": str,
        "VolumeSize": int,
        "OwnerAlias": str,
        "Tags": List[ClientCreateSnapshotResponseTagsTypeDef],
    },
    total=False,
)

ClientCreateSnapshotTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateSnapshotTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateSnapshotTagSpecificationsTypeDef = TypedDict(
    "ClientCreateSnapshotTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateSnapshotTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateSnapshotsInstanceSpecificationTypeDef = TypedDict(
    "ClientCreateSnapshotsInstanceSpecificationTypeDef",
    {"InstanceId": str, "ExcludeBootVolume": bool},
    total=False,
)

ClientCreateSnapshotsResponseSnapshotsTagsTypeDef = TypedDict(
    "ClientCreateSnapshotsResponseSnapshotsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateSnapshotsResponseSnapshotsTypeDef = TypedDict(
    "ClientCreateSnapshotsResponseSnapshotsTypeDef",
    {
        "Description": str,
        "Tags": List[ClientCreateSnapshotsResponseSnapshotsTagsTypeDef],
        "Encrypted": bool,
        "VolumeId": str,
        "State": Literal["pending", "completed", "error"],
        "VolumeSize": int,
        "StartTime": datetime,
        "Progress": str,
        "OwnerId": str,
        "SnapshotId": str,
    },
    total=False,
)

ClientCreateSnapshotsResponseTypeDef = TypedDict(
    "ClientCreateSnapshotsResponseTypeDef",
    {"Snapshots": List[ClientCreateSnapshotsResponseSnapshotsTypeDef]},
    total=False,
)

ClientCreateSnapshotsTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateSnapshotsTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateSnapshotsTagSpecificationsTypeDef = TypedDict(
    "ClientCreateSnapshotsTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateSnapshotsTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef = TypedDict(
    "ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef = TypedDict(
    "ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef",
    {
        "Bucket": str,
        "Fault": ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef,
        "OwnerId": str,
        "Prefix": str,
        "State": Literal["Active", "Inactive"],
    },
    total=False,
)

ClientCreateSpotDatafeedSubscriptionResponseTypeDef = TypedDict(
    "ClientCreateSpotDatafeedSubscriptionResponseTypeDef",
    {
        "SpotDatafeedSubscription": ClientCreateSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef
    },
    total=False,
)

ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef = TypedDict(
    "ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef,
    },
    total=False,
)

ClientCreateSubnetResponseSubnetTagsTypeDef = TypedDict(
    "ClientCreateSubnetResponseSubnetTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateSubnetResponseSubnetTypeDef = TypedDict(
    "ClientCreateSubnetResponseSubnetTypeDef",
    {
        "AvailabilityZone": str,
        "AvailabilityZoneId": str,
        "AvailableIpAddressCount": int,
        "CidrBlock": str,
        "DefaultForAz": bool,
        "MapPublicIpOnLaunch": bool,
        "State": Literal["pending", "available"],
        "SubnetId": str,
        "VpcId": str,
        "OwnerId": str,
        "AssignIpv6AddressOnCreation": bool,
        "Ipv6CidrBlockAssociationSet": List[
            ClientCreateSubnetResponseSubnetIpv6CidrBlockAssociationSetTypeDef
        ],
        "Tags": List[ClientCreateSubnetResponseSubnetTagsTypeDef],
        "SubnetArn": str,
        "OutpostArn": str,
    },
    total=False,
)

ClientCreateSubnetResponseTypeDef = TypedDict(
    "ClientCreateSubnetResponseTypeDef",
    {"Subnet": ClientCreateSubnetResponseSubnetTypeDef},
    total=False,
)

ClientCreateTagsTagsTypeDef = TypedDict(
    "ClientCreateTagsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef,
        "SourcePortRange": ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef,
        "SourcePortRange": ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTagsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTypeDef",
    {
        "TrafficMirrorFilterId": str,
        "IngressFilterRules": List[
            ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterIngressFilterRulesTypeDef
        ],
        "EgressFilterRules": List[
            ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterEgressFilterRulesTypeDef
        ],
        "NetworkServices": List[str],
        "Description": str,
        "Tags": List[ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTagsTypeDef],
    },
    total=False,
)

ClientCreateTrafficMirrorFilterResponseTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterResponseTypeDef",
    {
        "TrafficMirrorFilter": ClientCreateTrafficMirrorFilterResponseTrafficMirrorFilterTypeDef,
        "ClientToken": str,
    },
    total=False,
)

ClientCreateTrafficMirrorFilterRuleDestinationPortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef,
        "SourcePortRange": ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientCreateTrafficMirrorFilterRuleResponseTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterRuleResponseTypeDef",
    {
        "TrafficMirrorFilterRule": ClientCreateTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef,
        "ClientToken": str,
    },
    total=False,
)

ClientCreateTrafficMirrorFilterRuleSourcePortRangeTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientCreateTrafficMirrorFilterTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTrafficMirrorFilterTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorFilterTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTrafficMirrorFilterTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef = TypedDict(
    "ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef",
    {
        "TrafficMirrorSessionId": str,
        "TrafficMirrorTargetId": str,
        "TrafficMirrorFilterId": str,
        "NetworkInterfaceId": str,
        "OwnerId": str,
        "PacketLength": int,
        "SessionNumber": int,
        "VirtualNetworkId": int,
        "Description": str,
        "Tags": List[ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef],
    },
    total=False,
)

ClientCreateTrafficMirrorSessionResponseTypeDef = TypedDict(
    "ClientCreateTrafficMirrorSessionResponseTypeDef",
    {
        "TrafficMirrorSession": ClientCreateTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef,
        "ClientToken": str,
    },
    total=False,
)

ClientCreateTrafficMirrorSessionTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorSessionTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTrafficMirrorSessionTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorSessionTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTrafficMirrorSessionTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTagsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTypeDef = TypedDict(
    "ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTypeDef",
    {
        "TrafficMirrorTargetId": str,
        "NetworkInterfaceId": str,
        "NetworkLoadBalancerArn": str,
        "Type": Literal["network-interface", "network-load-balancer"],
        "Description": str,
        "OwnerId": str,
        "Tags": List[ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTagsTypeDef],
    },
    total=False,
)

ClientCreateTrafficMirrorTargetResponseTypeDef = TypedDict(
    "ClientCreateTrafficMirrorTargetResponseTypeDef",
    {
        "TrafficMirrorTarget": ClientCreateTrafficMirrorTargetResponseTrafficMirrorTargetTypeDef,
        "ClientToken": str,
    },
    total=False,
)

ClientCreateTrafficMirrorTargetTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorTargetTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTrafficMirrorTargetTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTrafficMirrorTargetTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTrafficMirrorTargetTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef = TypedDict(
    "ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "TransitGatewayId": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "CreationTime": datetime,
        "Tags": List[
            ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateTransitGatewayMulticastDomainResponseTypeDef = TypedDict(
    "ClientCreateTransitGatewayMulticastDomainResponseTypeDef",
    {
        "TransitGatewayMulticastDomain": ClientCreateTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef
    },
    total=False,
)

ClientCreateTransitGatewayMulticastDomainTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayMulticastDomainTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayMulticastDomainTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTransitGatewayMulticastDomainTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTransitGatewayMulticastDomainTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateTransitGatewayOptionsTypeDef = TypedDict(
    "ClientCreateTransitGatewayOptionsTypeDef",
    {
        "AmazonSideAsn": int,
        "AutoAcceptSharedAttachments": Literal["enable", "disable"],
        "DefaultRouteTableAssociation": Literal["enable", "disable"],
        "DefaultRouteTablePropagation": Literal["enable", "disable"],
        "VpnEcmpSupport": Literal["enable", "disable"],
        "DnsSupport": Literal["enable", "disable"],
        "MulticastSupport": Literal["enable", "disable"],
    },
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "RequesterTgwInfo": ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef,
        "AccepterTgwInfo": ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef,
        "Status": ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "CreationTime": datetime,
        "Tags": List[
            ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentResponseTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentResponseTypeDef",
    {
        "TransitGatewayPeeringAttachment": ClientCreateTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef
    },
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayPeeringAttachmentTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTransitGatewayPeeringAttachmentTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTransitGatewayPeeringAttachmentTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateTransitGatewayResponseTransitGatewayOptionsTypeDef = TypedDict(
    "ClientCreateTransitGatewayResponseTransitGatewayOptionsTypeDef",
    {
        "AmazonSideAsn": int,
        "AutoAcceptSharedAttachments": Literal["enable", "disable"],
        "DefaultRouteTableAssociation": Literal["enable", "disable"],
        "AssociationDefaultRouteTableId": str,
        "DefaultRouteTablePropagation": Literal["enable", "disable"],
        "PropagationDefaultRouteTableId": str,
        "VpnEcmpSupport": Literal["enable", "disable"],
        "DnsSupport": Literal["enable", "disable"],
        "MulticastSupport": Literal["enable", "disable"],
    },
    total=False,
)

ClientCreateTransitGatewayResponseTransitGatewayTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayResponseTransitGatewayTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayResponseTransitGatewayTypeDef = TypedDict(
    "ClientCreateTransitGatewayResponseTransitGatewayTypeDef",
    {
        "TransitGatewayId": str,
        "TransitGatewayArn": str,
        "State": Literal["pending", "available", "modifying", "deleting", "deleted"],
        "OwnerId": str,
        "Description": str,
        "CreationTime": datetime,
        "Options": ClientCreateTransitGatewayResponseTransitGatewayOptionsTypeDef,
        "Tags": List[ClientCreateTransitGatewayResponseTransitGatewayTagsTypeDef],
    },
    total=False,
)

ClientCreateTransitGatewayResponseTypeDef = TypedDict(
    "ClientCreateTransitGatewayResponseTypeDef",
    {"TransitGateway": ClientCreateTransitGatewayResponseTransitGatewayTypeDef},
    total=False,
)

ClientCreateTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef",
    {
        "ResourceId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
    },
    total=False,
)

ClientCreateTransitGatewayRouteResponseRouteTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteResponseRouteTypeDef",
    {
        "DestinationCidrBlock": str,
        "TransitGatewayAttachments": List[
            ClientCreateTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef
        ],
        "Type": Literal["static", "propagated"],
        "State": Literal["pending", "active", "blackhole", "deleting", "deleted"],
    },
    total=False,
)

ClientCreateTransitGatewayRouteResponseTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteResponseTypeDef",
    {"Route": ClientCreateTransitGatewayRouteResponseRouteTypeDef},
    total=False,
)

ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef",
    {
        "TransitGatewayRouteTableId": str,
        "TransitGatewayId": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "DefaultAssociationRouteTable": bool,
        "DefaultPropagationRouteTable": bool,
        "CreationTime": datetime,
        "Tags": List[
            ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateTransitGatewayRouteTableResponseTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteTableResponseTypeDef",
    {
        "TransitGatewayRouteTable": ClientCreateTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef
    },
    total=False,
)

ClientCreateTransitGatewayRouteTableTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteTableTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayRouteTableTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTransitGatewayRouteTableTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTransitGatewayRouteTableTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateTransitGatewayTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTransitGatewayTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTransitGatewayTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateTransitGatewayVpcAttachmentOptionsTypeDef = TypedDict(
    "ClientCreateTransitGatewayVpcAttachmentOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef = TypedDict(
    "ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef = TypedDict(
    "ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "TransitGatewayId": str,
        "VpcId": str,
        "VpcOwnerId": str,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "SubnetIds": List[str],
        "CreationTime": datetime,
        "Options": ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef,
        "Tags": List[
            ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateTransitGatewayVpcAttachmentResponseTypeDef = TypedDict(
    "ClientCreateTransitGatewayVpcAttachmentResponseTypeDef",
    {
        "TransitGatewayVpcAttachment": ClientCreateTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef
    },
    total=False,
)

ClientCreateTransitGatewayVpcAttachmentTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateTransitGatewayVpcAttachmentTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateTransitGatewayVpcAttachmentTagSpecificationsTypeDef = TypedDict(
    "ClientCreateTransitGatewayVpcAttachmentTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateTransitGatewayVpcAttachmentTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateVolumeResponseAttachmentsTypeDef = TypedDict(
    "ClientCreateVolumeResponseAttachmentsTypeDef",
    {
        "AttachTime": datetime,
        "Device": str,
        "InstanceId": str,
        "State": Literal["attaching", "attached", "detaching", "detached", "busy"],
        "VolumeId": str,
        "DeleteOnTermination": bool,
    },
    total=False,
)

ClientCreateVolumeResponseTagsTypeDef = TypedDict(
    "ClientCreateVolumeResponseTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateVolumeResponseTypeDef = TypedDict(
    "ClientCreateVolumeResponseTypeDef",
    {
        "Attachments": List[ClientCreateVolumeResponseAttachmentsTypeDef],
        "AvailabilityZone": str,
        "CreateTime": datetime,
        "Encrypted": bool,
        "KmsKeyId": str,
        "OutpostArn": str,
        "Size": int,
        "SnapshotId": str,
        "State": Literal["creating", "available", "in-use", "deleting", "deleted", "error"],
        "VolumeId": str,
        "Iops": int,
        "Tags": List[ClientCreateVolumeResponseTagsTypeDef],
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "FastRestored": bool,
        "MultiAttachEnabled": bool,
    },
    total=False,
)

ClientCreateVolumeTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateVolumeTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateVolumeTagSpecificationsTypeDef = TypedDict(
    "ClientCreateVolumeTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateVolumeTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateVpcEndpointConnectionNotificationResponseConnectionNotificationTypeDef = TypedDict(
    "ClientCreateVpcEndpointConnectionNotificationResponseConnectionNotificationTypeDef",
    {
        "ConnectionNotificationId": str,
        "ServiceId": str,
        "VpcEndpointId": str,
        "ConnectionNotificationType": str,
        "ConnectionNotificationArn": str,
        "ConnectionEvents": List[str],
        "ConnectionNotificationState": Literal["Enabled", "Disabled"],
    },
    total=False,
)

ClientCreateVpcEndpointConnectionNotificationResponseTypeDef = TypedDict(
    "ClientCreateVpcEndpointConnectionNotificationResponseTypeDef",
    {
        "ConnectionNotification": ClientCreateVpcEndpointConnectionNotificationResponseConnectionNotificationTypeDef,
        "ClientToken": str,
    },
    total=False,
)

ClientCreateVpcEndpointResponseVpcEndpointDnsEntriesTypeDef = TypedDict(
    "ClientCreateVpcEndpointResponseVpcEndpointDnsEntriesTypeDef",
    {"DnsName": str, "HostedZoneId": str},
    total=False,
)

ClientCreateVpcEndpointResponseVpcEndpointGroupsTypeDef = TypedDict(
    "ClientCreateVpcEndpointResponseVpcEndpointGroupsTypeDef",
    {"GroupId": str, "GroupName": str},
    total=False,
)

ClientCreateVpcEndpointResponseVpcEndpointLastErrorTypeDef = TypedDict(
    "ClientCreateVpcEndpointResponseVpcEndpointLastErrorTypeDef",
    {"Message": str, "Code": str},
    total=False,
)

ClientCreateVpcEndpointResponseVpcEndpointTagsTypeDef = TypedDict(
    "ClientCreateVpcEndpointResponseVpcEndpointTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateVpcEndpointResponseVpcEndpointTypeDef = TypedDict(
    "ClientCreateVpcEndpointResponseVpcEndpointTypeDef",
    {
        "VpcEndpointId": str,
        "VpcEndpointType": Literal["Interface", "Gateway"],
        "VpcId": str,
        "ServiceName": str,
        "State": Literal[
            "PendingAcceptance",
            "Pending",
            "Available",
            "Deleting",
            "Deleted",
            "Rejected",
            "Failed",
            "Expired",
        ],
        "PolicyDocument": str,
        "RouteTableIds": List[str],
        "SubnetIds": List[str],
        "Groups": List[ClientCreateVpcEndpointResponseVpcEndpointGroupsTypeDef],
        "PrivateDnsEnabled": bool,
        "RequesterManaged": bool,
        "NetworkInterfaceIds": List[str],
        "DnsEntries": List[ClientCreateVpcEndpointResponseVpcEndpointDnsEntriesTypeDef],
        "CreationTimestamp": datetime,
        "Tags": List[ClientCreateVpcEndpointResponseVpcEndpointTagsTypeDef],
        "OwnerId": str,
        "LastError": ClientCreateVpcEndpointResponseVpcEndpointLastErrorTypeDef,
    },
    total=False,
)

ClientCreateVpcEndpointResponseTypeDef = TypedDict(
    "ClientCreateVpcEndpointResponseTypeDef",
    {"VpcEndpoint": ClientCreateVpcEndpointResponseVpcEndpointTypeDef, "ClientToken": str},
    total=False,
)

ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationPrivateDnsNameConfigurationTypeDef = TypedDict(
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationPrivateDnsNameConfigurationTypeDef",
    {
        "State": Literal["pendingVerification", "verified", "failed"],
        "Type": str,
        "Value": str,
        "Name": str,
    },
    total=False,
)

ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationServiceTypeTypeDef = TypedDict(
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationServiceTypeTypeDef",
    {"ServiceType": Literal["Interface", "Gateway"]},
    total=False,
)

ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTagsTypeDef = TypedDict(
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTypeDef = TypedDict(
    "ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTypeDef",
    {
        "ServiceType": List[
            ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationServiceTypeTypeDef
        ],
        "ServiceId": str,
        "ServiceName": str,
        "ServiceState": Literal["Pending", "Available", "Deleting", "Deleted", "Failed"],
        "AvailabilityZones": List[str],
        "AcceptanceRequired": bool,
        "ManagesVpcEndpoints": bool,
        "NetworkLoadBalancerArns": List[str],
        "BaseEndpointDnsNames": List[str],
        "PrivateDnsName": str,
        "PrivateDnsNameConfiguration": ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationPrivateDnsNameConfigurationTypeDef,
        "Tags": List[
            ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTagsTypeDef
        ],
    },
    total=False,
)

ClientCreateVpcEndpointServiceConfigurationResponseTypeDef = TypedDict(
    "ClientCreateVpcEndpointServiceConfigurationResponseTypeDef",
    {
        "ServiceConfiguration": ClientCreateVpcEndpointServiceConfigurationResponseServiceConfigurationTypeDef,
        "ClientToken": str,
    },
    total=False,
)

ClientCreateVpcEndpointServiceConfigurationTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateVpcEndpointServiceConfigurationTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateVpcEndpointServiceConfigurationTagSpecificationsTypeDef = TypedDict(
    "ClientCreateVpcEndpointServiceConfigurationTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateVpcEndpointServiceConfigurationTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateVpcEndpointTagSpecificationsTagsTypeDef = TypedDict(
    "ClientCreateVpcEndpointTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateVpcEndpointTagSpecificationsTypeDef = TypedDict(
    "ClientCreateVpcEndpointTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientCreateVpcEndpointTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef",
    {"CidrBlock": str},
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef",
    {"Ipv6CidrBlock": str},
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef",
    {
        "CidrBlock": str,
        "Ipv6CidrBlockSet": List[
            ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoIpv6CidrBlockSetTypeDef
        ],
        "CidrBlockSet": List[
            ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoCidrBlockSetTypeDef
        ],
        "OwnerId": str,
        "PeeringOptions": ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoPeeringOptionsTypeDef,
        "VpcId": str,
        "Region": str,
    },
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef",
    {"CidrBlock": str},
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef",
    {"Ipv6CidrBlock": str},
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef",
    {
        "CidrBlock": str,
        "Ipv6CidrBlockSet": List[
            ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoIpv6CidrBlockSetTypeDef
        ],
        "CidrBlockSet": List[
            ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoCidrBlockSetTypeDef
        ],
        "OwnerId": str,
        "PeeringOptions": ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoPeeringOptionsTypeDef,
        "VpcId": str,
        "Region": str,
    },
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef",
    {
        "Code": Literal[
            "initiating-request",
            "pending-acceptance",
            "active",
            "deleted",
            "rejected",
            "failed",
            "expired",
            "provisioning",
            "deleting",
        ],
        "Message": str,
    },
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef",
    {
        "AccepterVpcInfo": ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionAccepterVpcInfoTypeDef,
        "ExpirationTime": datetime,
        "RequesterVpcInfo": ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionRequesterVpcInfoTypeDef,
        "Status": ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionStatusTypeDef,
        "Tags": List[ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTagsTypeDef],
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientCreateVpcPeeringConnectionResponseTypeDef = TypedDict(
    "ClientCreateVpcPeeringConnectionResponseTypeDef",
    {"VpcPeeringConnection": ClientCreateVpcPeeringConnectionResponseVpcPeeringConnectionTypeDef},
    total=False,
)

ClientCreateVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef = TypedDict(
    "ClientCreateVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientCreateVpcResponseVpcCidrBlockAssociationSetTypeDef = TypedDict(
    "ClientCreateVpcResponseVpcCidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "CidrBlock": str,
        "CidrBlockState": ClientCreateVpcResponseVpcCidrBlockAssociationSetCidrBlockStateTypeDef,
    },
    total=False,
)

ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef = TypedDict(
    "ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef,
        "NetworkBorderGroup": str,
        "Ipv6Pool": str,
    },
    total=False,
)

ClientCreateVpcResponseVpcTagsTypeDef = TypedDict(
    "ClientCreateVpcResponseVpcTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateVpcResponseVpcTypeDef = TypedDict(
    "ClientCreateVpcResponseVpcTypeDef",
    {
        "CidrBlock": str,
        "DhcpOptionsId": str,
        "State": Literal["pending", "available"],
        "VpcId": str,
        "OwnerId": str,
        "InstanceTenancy": Literal["default", "dedicated", "host"],
        "Ipv6CidrBlockAssociationSet": List[
            ClientCreateVpcResponseVpcIpv6CidrBlockAssociationSetTypeDef
        ],
        "CidrBlockAssociationSet": List[ClientCreateVpcResponseVpcCidrBlockAssociationSetTypeDef],
        "IsDefault": bool,
        "Tags": List[ClientCreateVpcResponseVpcTagsTypeDef],
    },
    total=False,
)

ClientCreateVpcResponseTypeDef = TypedDict(
    "ClientCreateVpcResponseTypeDef", {"Vpc": ClientCreateVpcResponseVpcTypeDef}, total=False
)

ClientCreateVpnConnectionOptionsTunnelOptionsIKEVersionsTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsIKEVersionsTypeDef", {"Value": str}, total=False
)

ClientCreateVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientCreateVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientCreateVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionOptionsTunnelOptionsTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTunnelOptionsTypeDef",
    {
        "TunnelInsideCidr": str,
        "PreSharedKey": str,
        "Phase1LifetimeSeconds": int,
        "Phase2LifetimeSeconds": int,
        "RekeyMarginTimeSeconds": int,
        "RekeyFuzzPercentage": int,
        "ReplayWindowSize": int,
        "DPDTimeoutSeconds": int,
        "Phase1EncryptionAlgorithms": List[
            ClientCreateVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef
        ],
        "Phase2EncryptionAlgorithms": List[
            ClientCreateVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef
        ],
        "Phase1IntegrityAlgorithms": List[
            ClientCreateVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef
        ],
        "Phase2IntegrityAlgorithms": List[
            ClientCreateVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef
        ],
        "Phase1DHGroupNumbers": List[
            ClientCreateVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef
        ],
        "Phase2DHGroupNumbers": List[
            ClientCreateVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef
        ],
        "IKEVersions": List[ClientCreateVpnConnectionOptionsTunnelOptionsIKEVersionsTypeDef],
    },
    total=False,
)

ClientCreateVpnConnectionOptionsTypeDef = TypedDict(
    "ClientCreateVpnConnectionOptionsTypeDef",
    {
        "EnableAcceleration": bool,
        "StaticRoutesOnly": bool,
        "TunnelOptions": List[ClientCreateVpnConnectionOptionsTunnelOptionsTypeDef],
    },
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    {
        "OutsideIpAddress": str,
        "TunnelInsideCidr": str,
        "PreSharedKey": str,
        "Phase1LifetimeSeconds": int,
        "Phase2LifetimeSeconds": int,
        "RekeyMarginTimeSeconds": int,
        "RekeyFuzzPercentage": int,
        "ReplayWindowSize": int,
        "DpdTimeoutSeconds": int,
        "Phase1EncryptionAlgorithms": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef
        ],
        "Phase2EncryptionAlgorithms": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef
        ],
        "Phase1IntegrityAlgorithms": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef
        ],
        "Phase2IntegrityAlgorithms": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef
        ],
        "Phase1DHGroupNumbers": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef
        ],
        "Phase2DHGroupNumbers": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef
        ],
        "IkeVersions": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef
        ],
    },
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionOptionsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionOptionsTypeDef",
    {
        "EnableAcceleration": bool,
        "StaticRoutesOnly": bool,
        "TunnelOptions": List[
            ClientCreateVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef
        ],
    },
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionRoutesTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "Source": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
    },
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionTagsTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef",
    {
        "AcceptedRouteCount": int,
        "LastStatusChange": datetime,
        "OutsideIpAddress": str,
        "Status": Literal["UP", "DOWN"],
        "StatusMessage": str,
        "CertificateArn": str,
    },
    total=False,
)

ClientCreateVpnConnectionResponseVpnConnectionTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseVpnConnectionTypeDef",
    {
        "CustomerGatewayConfiguration": str,
        "CustomerGatewayId": str,
        "Category": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Type": str,
        "VpnConnectionId": str,
        "VpnGatewayId": str,
        "TransitGatewayId": str,
        "Options": ClientCreateVpnConnectionResponseVpnConnectionOptionsTypeDef,
        "Routes": List[ClientCreateVpnConnectionResponseVpnConnectionRoutesTypeDef],
        "Tags": List[ClientCreateVpnConnectionResponseVpnConnectionTagsTypeDef],
        "VgwTelemetry": List[ClientCreateVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef],
    },
    total=False,
)

ClientCreateVpnConnectionResponseTypeDef = TypedDict(
    "ClientCreateVpnConnectionResponseTypeDef",
    {"VpnConnection": ClientCreateVpnConnectionResponseVpnConnectionTypeDef},
    total=False,
)

ClientCreateVpnGatewayResponseVpnGatewayTagsTypeDef = TypedDict(
    "ClientCreateVpnGatewayResponseVpnGatewayTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientCreateVpnGatewayResponseVpnGatewayVpcAttachmentsTypeDef = TypedDict(
    "ClientCreateVpnGatewayResponseVpnGatewayVpcAttachmentsTypeDef",
    {"State": Literal["attaching", "attached", "detaching", "detached"], "VpcId": str},
    total=False,
)

ClientCreateVpnGatewayResponseVpnGatewayTypeDef = TypedDict(
    "ClientCreateVpnGatewayResponseVpnGatewayTypeDef",
    {
        "AvailabilityZone": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Type": str,
        "VpcAttachments": List[ClientCreateVpnGatewayResponseVpnGatewayVpcAttachmentsTypeDef],
        "VpnGatewayId": str,
        "AmazonSideAsn": int,
        "Tags": List[ClientCreateVpnGatewayResponseVpnGatewayTagsTypeDef],
    },
    total=False,
)

ClientCreateVpnGatewayResponseTypeDef = TypedDict(
    "ClientCreateVpnGatewayResponseTypeDef",
    {"VpnGateway": ClientCreateVpnGatewayResponseVpnGatewayTypeDef},
    total=False,
)

ClientDeleteClientVpnEndpointResponseStatusTypeDef = TypedDict(
    "ClientDeleteClientVpnEndpointResponseStatusTypeDef",
    {"Code": Literal["pending-associate", "available", "deleting", "deleted"], "Message": str},
    total=False,
)

ClientDeleteClientVpnEndpointResponseTypeDef = TypedDict(
    "ClientDeleteClientVpnEndpointResponseTypeDef",
    {"Status": ClientDeleteClientVpnEndpointResponseStatusTypeDef},
    total=False,
)

ClientDeleteClientVpnRouteResponseStatusTypeDef = TypedDict(
    "ClientDeleteClientVpnRouteResponseStatusTypeDef",
    {"Code": Literal["creating", "active", "failed", "deleting"], "Message": str},
    total=False,
)

ClientDeleteClientVpnRouteResponseTypeDef = TypedDict(
    "ClientDeleteClientVpnRouteResponseTypeDef",
    {"Status": ClientDeleteClientVpnRouteResponseStatusTypeDef},
    total=False,
)

ClientDeleteEgressOnlyInternetGatewayResponseTypeDef = TypedDict(
    "ClientDeleteEgressOnlyInternetGatewayResponseTypeDef", {"ReturnCode": bool}, total=False
)

ClientDeleteFleetsResponseSuccessfulFleetDeletionsTypeDef = TypedDict(
    "ClientDeleteFleetsResponseSuccessfulFleetDeletionsTypeDef",
    {
        "CurrentFleetState": Literal[
            "submitted",
            "active",
            "deleted",
            "failed",
            "deleted_running",
            "deleted_terminating",
            "modifying",
        ],
        "PreviousFleetState": Literal[
            "submitted",
            "active",
            "deleted",
            "failed",
            "deleted_running",
            "deleted_terminating",
            "modifying",
        ],
        "FleetId": str,
    },
    total=False,
)

ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsErrorTypeDef = TypedDict(
    "ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsErrorTypeDef",
    {
        "Code": Literal[
            "fleetIdDoesNotExist", "fleetIdMalformed", "fleetNotInDeletableState", "unexpectedError"
        ],
        "Message": str,
    },
    total=False,
)

ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsTypeDef = TypedDict(
    "ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsTypeDef",
    {"Error": ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsErrorTypeDef, "FleetId": str},
    total=False,
)

ClientDeleteFleetsResponseTypeDef = TypedDict(
    "ClientDeleteFleetsResponseTypeDef",
    {
        "SuccessfulFleetDeletions": List[ClientDeleteFleetsResponseSuccessfulFleetDeletionsTypeDef],
        "UnsuccessfulFleetDeletions": List[
            ClientDeleteFleetsResponseUnsuccessfulFleetDeletionsTypeDef
        ],
    },
    total=False,
)

ClientDeleteFlowLogsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientDeleteFlowLogsResponseUnsuccessfulErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDeleteFlowLogsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientDeleteFlowLogsResponseUnsuccessfulTypeDef",
    {"Error": ClientDeleteFlowLogsResponseUnsuccessfulErrorTypeDef, "ResourceId": str},
    total=False,
)

ClientDeleteFlowLogsResponseTypeDef = TypedDict(
    "ClientDeleteFlowLogsResponseTypeDef",
    {"Unsuccessful": List[ClientDeleteFlowLogsResponseUnsuccessfulTypeDef]},
    total=False,
)

ClientDeleteFpgaImageResponseTypeDef = TypedDict(
    "ClientDeleteFpgaImageResponseTypeDef", {"Return": bool}, total=False
)

ClientDeleteLaunchTemplateResponseLaunchTemplateTagsTypeDef = TypedDict(
    "ClientDeleteLaunchTemplateResponseLaunchTemplateTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDeleteLaunchTemplateResponseLaunchTemplateTypeDef = TypedDict(
    "ClientDeleteLaunchTemplateResponseLaunchTemplateTypeDef",
    {
        "LaunchTemplateId": str,
        "LaunchTemplateName": str,
        "CreateTime": datetime,
        "CreatedBy": str,
        "DefaultVersionNumber": int,
        "LatestVersionNumber": int,
        "Tags": List[ClientDeleteLaunchTemplateResponseLaunchTemplateTagsTypeDef],
    },
    total=False,
)

ClientDeleteLaunchTemplateResponseTypeDef = TypedDict(
    "ClientDeleteLaunchTemplateResponseTypeDef",
    {"LaunchTemplate": ClientDeleteLaunchTemplateResponseLaunchTemplateTypeDef},
    total=False,
)

ClientDeleteLaunchTemplateVersionsResponseSuccessfullyDeletedLaunchTemplateVersionsTypeDef = TypedDict(
    "ClientDeleteLaunchTemplateVersionsResponseSuccessfullyDeletedLaunchTemplateVersionsTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "VersionNumber": int},
    total=False,
)

ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsResponseErrorTypeDef = TypedDict(
    "ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsResponseErrorTypeDef",
    {
        "Code": Literal[
            "launchTemplateIdDoesNotExist",
            "launchTemplateIdMalformed",
            "launchTemplateNameDoesNotExist",
            "launchTemplateNameMalformed",
            "launchTemplateVersionDoesNotExist",
            "unexpectedError",
        ],
        "Message": str,
    },
    total=False,
)

ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsTypeDef = TypedDict(
    "ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsTypeDef",
    {
        "LaunchTemplateId": str,
        "LaunchTemplateName": str,
        "VersionNumber": int,
        "ResponseError": ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsResponseErrorTypeDef,
    },
    total=False,
)

ClientDeleteLaunchTemplateVersionsResponseTypeDef = TypedDict(
    "ClientDeleteLaunchTemplateVersionsResponseTypeDef",
    {
        "SuccessfullyDeletedLaunchTemplateVersions": List[
            ClientDeleteLaunchTemplateVersionsResponseSuccessfullyDeletedLaunchTemplateVersionsTypeDef
        ],
        "UnsuccessfullyDeletedLaunchTemplateVersions": List[
            ClientDeleteLaunchTemplateVersionsResponseUnsuccessfullyDeletedLaunchTemplateVersionsTypeDef
        ],
    },
    total=False,
)

ClientDeleteLocalGatewayRouteResponseRouteTypeDef = TypedDict(
    "ClientDeleteLocalGatewayRouteResponseRouteTypeDef",
    {
        "DestinationCidrBlock": str,
        "LocalGatewayVirtualInterfaceGroupId": str,
        "Type": Literal["static", "propagated"],
        "State": Literal["pending", "active", "blackhole", "deleting", "deleted"],
        "LocalGatewayRouteTableId": str,
    },
    total=False,
)

ClientDeleteLocalGatewayRouteResponseTypeDef = TypedDict(
    "ClientDeleteLocalGatewayRouteResponseTypeDef",
    {"Route": ClientDeleteLocalGatewayRouteResponseRouteTypeDef},
    total=False,
)

ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef = TypedDict(
    "ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef = TypedDict(
    "ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef",
    {
        "LocalGatewayRouteTableVpcAssociationId": str,
        "LocalGatewayRouteTableId": str,
        "LocalGatewayId": str,
        "VpcId": str,
        "State": str,
        "Tags": List[
            ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTagsTypeDef
        ],
    },
    total=False,
)

ClientDeleteLocalGatewayRouteTableVpcAssociationResponseTypeDef = TypedDict(
    "ClientDeleteLocalGatewayRouteTableVpcAssociationResponseTypeDef",
    {
        "LocalGatewayRouteTableVpcAssociation": ClientDeleteLocalGatewayRouteTableVpcAssociationResponseLocalGatewayRouteTableVpcAssociationTypeDef
    },
    total=False,
)

ClientDeleteNatGatewayResponseTypeDef = TypedDict(
    "ClientDeleteNatGatewayResponseTypeDef", {"NatGatewayId": str}, total=False
)

ClientDeleteNetworkInterfacePermissionResponseTypeDef = TypedDict(
    "ClientDeleteNetworkInterfacePermissionResponseTypeDef", {"Return": bool}, total=False
)

ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsErrorTypeDef = TypedDict(
    "ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsErrorTypeDef",
    {
        "Code": Literal[
            "reserved-instances-id-invalid",
            "reserved-instances-not-in-queued-state",
            "unexpected-error",
        ],
        "Message": str,
    },
    total=False,
)

ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsTypeDef = TypedDict(
    "ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsTypeDef",
    {
        "Error": ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsErrorTypeDef,
        "ReservedInstancesId": str,
    },
    total=False,
)

ClientDeleteQueuedReservedInstancesResponseSuccessfulQueuedPurchaseDeletionsTypeDef = TypedDict(
    "ClientDeleteQueuedReservedInstancesResponseSuccessfulQueuedPurchaseDeletionsTypeDef",
    {"ReservedInstancesId": str},
    total=False,
)

ClientDeleteQueuedReservedInstancesResponseTypeDef = TypedDict(
    "ClientDeleteQueuedReservedInstancesResponseTypeDef",
    {
        "SuccessfulQueuedPurchaseDeletions": List[
            ClientDeleteQueuedReservedInstancesResponseSuccessfulQueuedPurchaseDeletionsTypeDef
        ],
        "FailedQueuedPurchaseDeletions": List[
            ClientDeleteQueuedReservedInstancesResponseFailedQueuedPurchaseDeletionsTypeDef
        ],
    },
    total=False,
)

ClientDeleteTagsTagsTypeDef = TypedDict(
    "ClientDeleteTagsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDeleteTrafficMirrorFilterResponseTypeDef = TypedDict(
    "ClientDeleteTrafficMirrorFilterResponseTypeDef", {"TrafficMirrorFilterId": str}, total=False
)

ClientDeleteTrafficMirrorFilterRuleResponseTypeDef = TypedDict(
    "ClientDeleteTrafficMirrorFilterRuleResponseTypeDef",
    {"TrafficMirrorFilterRuleId": str},
    total=False,
)

ClientDeleteTrafficMirrorSessionResponseTypeDef = TypedDict(
    "ClientDeleteTrafficMirrorSessionResponseTypeDef", {"TrafficMirrorSessionId": str}, total=False
)

ClientDeleteTrafficMirrorTargetResponseTypeDef = TypedDict(
    "ClientDeleteTrafficMirrorTargetResponseTypeDef", {"TrafficMirrorTargetId": str}, total=False
)

ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef = TypedDict(
    "ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "TransitGatewayId": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "CreationTime": datetime,
        "Tags": List[
            ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTagsTypeDef
        ],
    },
    total=False,
)

ClientDeleteTransitGatewayMulticastDomainResponseTypeDef = TypedDict(
    "ClientDeleteTransitGatewayMulticastDomainResponseTypeDef",
    {
        "TransitGatewayMulticastDomain": ClientDeleteTransitGatewayMulticastDomainResponseTransitGatewayMulticastDomainTypeDef
    },
    total=False,
)

ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef = TypedDict(
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef = TypedDict(
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef = TypedDict(
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef = TypedDict(
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "RequesterTgwInfo": ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef,
        "AccepterTgwInfo": ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef,
        "Status": ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "CreationTime": datetime,
        "Tags": List[
            ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientDeleteTransitGatewayPeeringAttachmentResponseTypeDef = TypedDict(
    "ClientDeleteTransitGatewayPeeringAttachmentResponseTypeDef",
    {
        "TransitGatewayPeeringAttachment": ClientDeleteTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef
    },
    total=False,
)

ClientDeleteTransitGatewayResponseTransitGatewayOptionsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayResponseTransitGatewayOptionsTypeDef",
    {
        "AmazonSideAsn": int,
        "AutoAcceptSharedAttachments": Literal["enable", "disable"],
        "DefaultRouteTableAssociation": Literal["enable", "disable"],
        "AssociationDefaultRouteTableId": str,
        "DefaultRouteTablePropagation": Literal["enable", "disable"],
        "PropagationDefaultRouteTableId": str,
        "VpnEcmpSupport": Literal["enable", "disable"],
        "DnsSupport": Literal["enable", "disable"],
        "MulticastSupport": Literal["enable", "disable"],
    },
    total=False,
)

ClientDeleteTransitGatewayResponseTransitGatewayTagsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayResponseTransitGatewayTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDeleteTransitGatewayResponseTransitGatewayTypeDef = TypedDict(
    "ClientDeleteTransitGatewayResponseTransitGatewayTypeDef",
    {
        "TransitGatewayId": str,
        "TransitGatewayArn": str,
        "State": Literal["pending", "available", "modifying", "deleting", "deleted"],
        "OwnerId": str,
        "Description": str,
        "CreationTime": datetime,
        "Options": ClientDeleteTransitGatewayResponseTransitGatewayOptionsTypeDef,
        "Tags": List[ClientDeleteTransitGatewayResponseTransitGatewayTagsTypeDef],
    },
    total=False,
)

ClientDeleteTransitGatewayResponseTypeDef = TypedDict(
    "ClientDeleteTransitGatewayResponseTypeDef",
    {"TransitGateway": ClientDeleteTransitGatewayResponseTransitGatewayTypeDef},
    total=False,
)

ClientDeleteTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef",
    {
        "ResourceId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
    },
    total=False,
)

ClientDeleteTransitGatewayRouteResponseRouteTypeDef = TypedDict(
    "ClientDeleteTransitGatewayRouteResponseRouteTypeDef",
    {
        "DestinationCidrBlock": str,
        "TransitGatewayAttachments": List[
            ClientDeleteTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef
        ],
        "Type": Literal["static", "propagated"],
        "State": Literal["pending", "active", "blackhole", "deleting", "deleted"],
    },
    total=False,
)

ClientDeleteTransitGatewayRouteResponseTypeDef = TypedDict(
    "ClientDeleteTransitGatewayRouteResponseTypeDef",
    {"Route": ClientDeleteTransitGatewayRouteResponseRouteTypeDef},
    total=False,
)

ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef = TypedDict(
    "ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef",
    {
        "TransitGatewayRouteTableId": str,
        "TransitGatewayId": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "DefaultAssociationRouteTable": bool,
        "DefaultPropagationRouteTable": bool,
        "CreationTime": datetime,
        "Tags": List[
            ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTagsTypeDef
        ],
    },
    total=False,
)

ClientDeleteTransitGatewayRouteTableResponseTypeDef = TypedDict(
    "ClientDeleteTransitGatewayRouteTableResponseTypeDef",
    {
        "TransitGatewayRouteTable": ClientDeleteTransitGatewayRouteTableResponseTransitGatewayRouteTableTypeDef
    },
    total=False,
)

ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef = TypedDict(
    "ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef = TypedDict(
    "ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "TransitGatewayId": str,
        "VpcId": str,
        "VpcOwnerId": str,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "SubnetIds": List[str],
        "CreationTime": datetime,
        "Options": ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef,
        "Tags": List[
            ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientDeleteTransitGatewayVpcAttachmentResponseTypeDef = TypedDict(
    "ClientDeleteTransitGatewayVpcAttachmentResponseTypeDef",
    {
        "TransitGatewayVpcAttachment": ClientDeleteTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef
    },
    total=False,
)

ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulTypeDef",
    {
        "Error": ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulErrorTypeDef,
        "ResourceId": str,
    },
    total=False,
)

ClientDeleteVpcEndpointConnectionNotificationsResponseTypeDef = TypedDict(
    "ClientDeleteVpcEndpointConnectionNotificationsResponseTypeDef",
    {
        "Unsuccessful": List[
            ClientDeleteVpcEndpointConnectionNotificationsResponseUnsuccessfulTypeDef
        ]
    },
    total=False,
)

ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulTypeDef",
    {
        "Error": ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulErrorTypeDef,
        "ResourceId": str,
    },
    total=False,
)

ClientDeleteVpcEndpointServiceConfigurationsResponseTypeDef = TypedDict(
    "ClientDeleteVpcEndpointServiceConfigurationsResponseTypeDef",
    {"Unsuccessful": List[ClientDeleteVpcEndpointServiceConfigurationsResponseUnsuccessfulTypeDef]},
    total=False,
)

ClientDeleteVpcEndpointsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientDeleteVpcEndpointsResponseUnsuccessfulErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDeleteVpcEndpointsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientDeleteVpcEndpointsResponseUnsuccessfulTypeDef",
    {"Error": ClientDeleteVpcEndpointsResponseUnsuccessfulErrorTypeDef, "ResourceId": str},
    total=False,
)

ClientDeleteVpcEndpointsResponseTypeDef = TypedDict(
    "ClientDeleteVpcEndpointsResponseTypeDef",
    {"Unsuccessful": List[ClientDeleteVpcEndpointsResponseUnsuccessfulTypeDef]},
    total=False,
)

ClientDeleteVpcPeeringConnectionResponseTypeDef = TypedDict(
    "ClientDeleteVpcPeeringConnectionResponseTypeDef", {"Return": bool}, total=False
)

ClientDeprovisionByoipCidrResponseByoipCidrTypeDef = TypedDict(
    "ClientDeprovisionByoipCidrResponseByoipCidrTypeDef",
    {
        "Cidr": str,
        "Description": str,
        "StatusMessage": str,
        "State": Literal[
            "advertised",
            "deprovisioned",
            "failed-deprovision",
            "failed-provision",
            "pending-deprovision",
            "pending-provision",
            "provisioned",
            "provisioned-not-publicly-advertisable",
        ],
    },
    total=False,
)

ClientDeprovisionByoipCidrResponseTypeDef = TypedDict(
    "ClientDeprovisionByoipCidrResponseTypeDef",
    {"ByoipCidr": ClientDeprovisionByoipCidrResponseByoipCidrTypeDef},
    total=False,
)

ClientDeregisterTransitGatewayMulticastGroupMembersResponseDeregisteredMulticastGroupMembersTypeDef = TypedDict(
    "ClientDeregisterTransitGatewayMulticastGroupMembersResponseDeregisteredMulticastGroupMembersTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "DeregisteredNetworkInterfaceIds": List[str],
        "GroupIpAddress": str,
    },
    total=False,
)

ClientDeregisterTransitGatewayMulticastGroupMembersResponseTypeDef = TypedDict(
    "ClientDeregisterTransitGatewayMulticastGroupMembersResponseTypeDef",
    {
        "DeregisteredMulticastGroupMembers": ClientDeregisterTransitGatewayMulticastGroupMembersResponseDeregisteredMulticastGroupMembersTypeDef
    },
    total=False,
)

ClientDeregisterTransitGatewayMulticastGroupSourcesResponseDeregisteredMulticastGroupSourcesTypeDef = TypedDict(
    "ClientDeregisterTransitGatewayMulticastGroupSourcesResponseDeregisteredMulticastGroupSourcesTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "DeregisteredNetworkInterfaceIds": List[str],
        "GroupIpAddress": str,
    },
    total=False,
)

ClientDeregisterTransitGatewayMulticastGroupSourcesResponseTypeDef = TypedDict(
    "ClientDeregisterTransitGatewayMulticastGroupSourcesResponseTypeDef",
    {
        "DeregisteredMulticastGroupSources": ClientDeregisterTransitGatewayMulticastGroupSourcesResponseDeregisteredMulticastGroupSourcesTypeDef
    },
    total=False,
)

ClientDescribeAccountAttributesResponseAccountAttributesAttributeValuesTypeDef = TypedDict(
    "ClientDescribeAccountAttributesResponseAccountAttributesAttributeValuesTypeDef",
    {"AttributeValue": str},
    total=False,
)

ClientDescribeAccountAttributesResponseAccountAttributesTypeDef = TypedDict(
    "ClientDescribeAccountAttributesResponseAccountAttributesTypeDef",
    {
        "AttributeName": str,
        "AttributeValues": List[
            ClientDescribeAccountAttributesResponseAccountAttributesAttributeValuesTypeDef
        ],
    },
    total=False,
)

ClientDescribeAccountAttributesResponseTypeDef = TypedDict(
    "ClientDescribeAccountAttributesResponseTypeDef",
    {"AccountAttributes": List[ClientDescribeAccountAttributesResponseAccountAttributesTypeDef]},
    total=False,
)

ClientDescribeAddressesFiltersTypeDef = TypedDict(
    "ClientDescribeAddressesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeAddressesResponseAddressesTagsTypeDef = TypedDict(
    "ClientDescribeAddressesResponseAddressesTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeAddressesResponseAddressesTypeDef = TypedDict(
    "ClientDescribeAddressesResponseAddressesTypeDef",
    {
        "InstanceId": str,
        "PublicIp": str,
        "AllocationId": str,
        "AssociationId": str,
        "Domain": Literal["vpc", "standard"],
        "NetworkInterfaceId": str,
        "NetworkInterfaceOwnerId": str,
        "PrivateIpAddress": str,
        "Tags": List[ClientDescribeAddressesResponseAddressesTagsTypeDef],
        "PublicIpv4Pool": str,
        "NetworkBorderGroup": str,
        "CustomerOwnedIp": str,
        "CustomerOwnedIpv4Pool": str,
    },
    total=False,
)

ClientDescribeAddressesResponseTypeDef = TypedDict(
    "ClientDescribeAddressesResponseTypeDef",
    {"Addresses": List[ClientDescribeAddressesResponseAddressesTypeDef]},
    total=False,
)

ClientDescribeAggregateIdFormatResponseStatusesTypeDef = TypedDict(
    "ClientDescribeAggregateIdFormatResponseStatusesTypeDef",
    {"Deadline": datetime, "Resource": str, "UseLongIds": bool},
    total=False,
)

ClientDescribeAggregateIdFormatResponseTypeDef = TypedDict(
    "ClientDescribeAggregateIdFormatResponseTypeDef",
    {
        "UseLongIdsAggregated": bool,
        "Statuses": List[ClientDescribeAggregateIdFormatResponseStatusesTypeDef],
    },
    total=False,
)

ClientDescribeAvailabilityZonesFiltersTypeDef = TypedDict(
    "ClientDescribeAvailabilityZonesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeAvailabilityZonesResponseAvailabilityZonesMessagesTypeDef = TypedDict(
    "ClientDescribeAvailabilityZonesResponseAvailabilityZonesMessagesTypeDef",
    {"Message": str},
    total=False,
)

ClientDescribeAvailabilityZonesResponseAvailabilityZonesTypeDef = TypedDict(
    "ClientDescribeAvailabilityZonesResponseAvailabilityZonesTypeDef",
    {
        "State": Literal["available", "information", "impaired", "unavailable"],
        "OptInStatus": Literal["opt-in-not-required", "opted-in", "not-opted-in"],
        "Messages": List[ClientDescribeAvailabilityZonesResponseAvailabilityZonesMessagesTypeDef],
        "RegionName": str,
        "ZoneName": str,
        "ZoneId": str,
        "GroupName": str,
        "NetworkBorderGroup": str,
    },
    total=False,
)

ClientDescribeAvailabilityZonesResponseTypeDef = TypedDict(
    "ClientDescribeAvailabilityZonesResponseTypeDef",
    {"AvailabilityZones": List[ClientDescribeAvailabilityZonesResponseAvailabilityZonesTypeDef]},
    total=False,
)

ClientDescribeBundleTasksFiltersTypeDef = TypedDict(
    "ClientDescribeBundleTasksFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeBundleTasksResponseBundleTasksBundleTaskErrorTypeDef = TypedDict(
    "ClientDescribeBundleTasksResponseBundleTasksBundleTaskErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDescribeBundleTasksResponseBundleTasksStorageS3TypeDef = TypedDict(
    "ClientDescribeBundleTasksResponseBundleTasksStorageS3TypeDef",
    {
        "AWSAccessKeyId": str,
        "Bucket": str,
        "Prefix": str,
        "UploadPolicy": bytes,
        "UploadPolicySignature": str,
    },
    total=False,
)

ClientDescribeBundleTasksResponseBundleTasksStorageTypeDef = TypedDict(
    "ClientDescribeBundleTasksResponseBundleTasksStorageTypeDef",
    {"S3": ClientDescribeBundleTasksResponseBundleTasksStorageS3TypeDef},
    total=False,
)

ClientDescribeBundleTasksResponseBundleTasksTypeDef = TypedDict(
    "ClientDescribeBundleTasksResponseBundleTasksTypeDef",
    {
        "BundleId": str,
        "BundleTaskError": ClientDescribeBundleTasksResponseBundleTasksBundleTaskErrorTypeDef,
        "InstanceId": str,
        "Progress": str,
        "StartTime": datetime,
        "State": Literal[
            "pending",
            "waiting-for-shutdown",
            "bundling",
            "storing",
            "cancelling",
            "complete",
            "failed",
        ],
        "Storage": ClientDescribeBundleTasksResponseBundleTasksStorageTypeDef,
        "UpdateTime": datetime,
    },
    total=False,
)

ClientDescribeBundleTasksResponseTypeDef = TypedDict(
    "ClientDescribeBundleTasksResponseTypeDef",
    {"BundleTasks": List[ClientDescribeBundleTasksResponseBundleTasksTypeDef]},
    total=False,
)

ClientDescribeByoipCidrsResponseByoipCidrsTypeDef = TypedDict(
    "ClientDescribeByoipCidrsResponseByoipCidrsTypeDef",
    {
        "Cidr": str,
        "Description": str,
        "StatusMessage": str,
        "State": Literal[
            "advertised",
            "deprovisioned",
            "failed-deprovision",
            "failed-provision",
            "pending-deprovision",
            "pending-provision",
            "provisioned",
            "provisioned-not-publicly-advertisable",
        ],
    },
    total=False,
)

ClientDescribeByoipCidrsResponseTypeDef = TypedDict(
    "ClientDescribeByoipCidrsResponseTypeDef",
    {"ByoipCidrs": List[ClientDescribeByoipCidrsResponseByoipCidrsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeCapacityReservationsFiltersTypeDef = TypedDict(
    "ClientDescribeCapacityReservationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeCapacityReservationsResponseCapacityReservationsTagsTypeDef = TypedDict(
    "ClientDescribeCapacityReservationsResponseCapacityReservationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeCapacityReservationsResponseCapacityReservationsTypeDef = TypedDict(
    "ClientDescribeCapacityReservationsResponseCapacityReservationsTypeDef",
    {
        "CapacityReservationId": str,
        "OwnerId": str,
        "CapacityReservationArn": str,
        "AvailabilityZoneId": str,
        "InstanceType": str,
        "InstancePlatform": Literal[
            "Linux/UNIX",
            "Red Hat Enterprise Linux",
            "SUSE Linux",
            "Windows",
            "Windows with SQL Server",
            "Windows with SQL Server Enterprise",
            "Windows with SQL Server Standard",
            "Windows with SQL Server Web",
            "Linux with SQL Server Standard",
            "Linux with SQL Server Web",
            "Linux with SQL Server Enterprise",
        ],
        "AvailabilityZone": str,
        "Tenancy": Literal["default", "dedicated"],
        "TotalInstanceCount": int,
        "AvailableInstanceCount": int,
        "EbsOptimized": bool,
        "EphemeralStorage": bool,
        "State": Literal["active", "expired", "cancelled", "pending", "failed"],
        "EndDate": datetime,
        "EndDateType": Literal["unlimited", "limited"],
        "InstanceMatchCriteria": Literal["open", "targeted"],
        "CreateDate": datetime,
        "Tags": List[ClientDescribeCapacityReservationsResponseCapacityReservationsTagsTypeDef],
    },
    total=False,
)

ClientDescribeCapacityReservationsResponseTypeDef = TypedDict(
    "ClientDescribeCapacityReservationsResponseTypeDef",
    {
        "NextToken": str,
        "CapacityReservations": List[
            ClientDescribeCapacityReservationsResponseCapacityReservationsTypeDef
        ],
    },
    total=False,
)

ClientDescribeClassicLinkInstancesFiltersTypeDef = TypedDict(
    "ClientDescribeClassicLinkInstancesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeClassicLinkInstancesResponseInstancesGroupsTypeDef = TypedDict(
    "ClientDescribeClassicLinkInstancesResponseInstancesGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeClassicLinkInstancesResponseInstancesTagsTypeDef = TypedDict(
    "ClientDescribeClassicLinkInstancesResponseInstancesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeClassicLinkInstancesResponseInstancesTypeDef = TypedDict(
    "ClientDescribeClassicLinkInstancesResponseInstancesTypeDef",
    {
        "Groups": List[ClientDescribeClassicLinkInstancesResponseInstancesGroupsTypeDef],
        "InstanceId": str,
        "Tags": List[ClientDescribeClassicLinkInstancesResponseInstancesTagsTypeDef],
        "VpcId": str,
    },
    total=False,
)

ClientDescribeClassicLinkInstancesResponseTypeDef = TypedDict(
    "ClientDescribeClassicLinkInstancesResponseTypeDef",
    {
        "Instances": List[ClientDescribeClassicLinkInstancesResponseInstancesTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeClientVpnAuthorizationRulesFiltersTypeDef = TypedDict(
    "ClientDescribeClientVpnAuthorizationRulesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesStatusTypeDef = TypedDict(
    "ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesStatusTypeDef",
    {"Code": Literal["authorizing", "active", "failed", "revoking"], "Message": str},
    total=False,
)

ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesTypeDef = TypedDict(
    "ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesTypeDef",
    {
        "ClientVpnEndpointId": str,
        "Description": str,
        "GroupId": str,
        "AccessAll": bool,
        "DestinationCidr": str,
        "Status": ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesStatusTypeDef,
    },
    total=False,
)

ClientDescribeClientVpnAuthorizationRulesResponseTypeDef = TypedDict(
    "ClientDescribeClientVpnAuthorizationRulesResponseTypeDef",
    {
        "AuthorizationRules": List[
            ClientDescribeClientVpnAuthorizationRulesResponseAuthorizationRulesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeClientVpnConnectionsFiltersTypeDef = TypedDict(
    "ClientDescribeClientVpnConnectionsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeClientVpnConnectionsResponseConnectionsStatusTypeDef = TypedDict(
    "ClientDescribeClientVpnConnectionsResponseConnectionsStatusTypeDef",
    {"Code": Literal["active", "failed-to-terminate", "terminating", "terminated"], "Message": str},
    total=False,
)

ClientDescribeClientVpnConnectionsResponseConnectionsTypeDef = TypedDict(
    "ClientDescribeClientVpnConnectionsResponseConnectionsTypeDef",
    {
        "ClientVpnEndpointId": str,
        "Timestamp": str,
        "ConnectionId": str,
        "Username": str,
        "ConnectionEstablishedTime": str,
        "IngressBytes": str,
        "EgressBytes": str,
        "IngressPackets": str,
        "EgressPackets": str,
        "ClientIp": str,
        "CommonName": str,
        "Status": ClientDescribeClientVpnConnectionsResponseConnectionsStatusTypeDef,
        "ConnectionEndTime": str,
    },
    total=False,
)

ClientDescribeClientVpnConnectionsResponseTypeDef = TypedDict(
    "ClientDescribeClientVpnConnectionsResponseTypeDef",
    {
        "Connections": List[ClientDescribeClientVpnConnectionsResponseConnectionsTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeClientVpnEndpointsFiltersTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAssociatedTargetNetworksTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAssociatedTargetNetworksTypeDef",
    {"NetworkId": str, "NetworkType": str},
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsActiveDirectoryTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsActiveDirectoryTypeDef",
    {"DirectoryId": str},
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsMutualAuthenticationTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsMutualAuthenticationTypeDef",
    {"ClientRootCertificateChain": str},
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsTypeDef",
    {
        "Type": Literal["certificate-authentication", "directory-service-authentication"],
        "ActiveDirectory": ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsActiveDirectoryTypeDef,
        "MutualAuthentication": ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsMutualAuthenticationTypeDef,
    },
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsConnectionLogOptionsTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsConnectionLogOptionsTypeDef",
    {"Enabled": bool, "CloudwatchLogGroup": str, "CloudwatchLogStream": str},
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsStatusTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsStatusTypeDef",
    {"Code": Literal["pending-associate", "available", "deleting", "deleted"], "Message": str},
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTagsTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTypeDef",
    {
        "ClientVpnEndpointId": str,
        "Description": str,
        "Status": ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsStatusTypeDef,
        "CreationTime": str,
        "DeletionTime": str,
        "DnsName": str,
        "ClientCidrBlock": str,
        "DnsServers": List[str],
        "SplitTunnel": bool,
        "VpnProtocol": str,
        "TransportProtocol": Literal["tcp", "udp"],
        "VpnPort": int,
        "AssociatedTargetNetworks": List[
            ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAssociatedTargetNetworksTypeDef
        ],
        "ServerCertificateArn": str,
        "AuthenticationOptions": List[
            ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsAuthenticationOptionsTypeDef
        ],
        "ConnectionLogOptions": ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsConnectionLogOptionsTypeDef,
        "Tags": List[ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTagsTypeDef],
    },
    total=False,
)

ClientDescribeClientVpnEndpointsResponseTypeDef = TypedDict(
    "ClientDescribeClientVpnEndpointsResponseTypeDef",
    {
        "ClientVpnEndpoints": List[
            ClientDescribeClientVpnEndpointsResponseClientVpnEndpointsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeClientVpnRoutesFiltersTypeDef = TypedDict(
    "ClientDescribeClientVpnRoutesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeClientVpnRoutesResponseRoutesStatusTypeDef = TypedDict(
    "ClientDescribeClientVpnRoutesResponseRoutesStatusTypeDef",
    {"Code": Literal["creating", "active", "failed", "deleting"], "Message": str},
    total=False,
)

ClientDescribeClientVpnRoutesResponseRoutesTypeDef = TypedDict(
    "ClientDescribeClientVpnRoutesResponseRoutesTypeDef",
    {
        "ClientVpnEndpointId": str,
        "DestinationCidr": str,
        "TargetSubnet": str,
        "Type": str,
        "Origin": str,
        "Status": ClientDescribeClientVpnRoutesResponseRoutesStatusTypeDef,
        "Description": str,
    },
    total=False,
)

ClientDescribeClientVpnRoutesResponseTypeDef = TypedDict(
    "ClientDescribeClientVpnRoutesResponseTypeDef",
    {"Routes": List[ClientDescribeClientVpnRoutesResponseRoutesTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeClientVpnTargetNetworksFiltersTypeDef = TypedDict(
    "ClientDescribeClientVpnTargetNetworksFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksStatusTypeDef = TypedDict(
    "ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksStatusTypeDef",
    {
        "Code": Literal[
            "associating", "associated", "association-failed", "disassociating", "disassociated"
        ],
        "Message": str,
    },
    total=False,
)

ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksTypeDef = TypedDict(
    "ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksTypeDef",
    {
        "AssociationId": str,
        "VpcId": str,
        "TargetNetworkId": str,
        "ClientVpnEndpointId": str,
        "Status": ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksStatusTypeDef,
        "SecurityGroups": List[str],
    },
    total=False,
)

ClientDescribeClientVpnTargetNetworksResponseTypeDef = TypedDict(
    "ClientDescribeClientVpnTargetNetworksResponseTypeDef",
    {
        "ClientVpnTargetNetworks": List[
            ClientDescribeClientVpnTargetNetworksResponseClientVpnTargetNetworksTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeCoipPoolsFiltersTypeDef = TypedDict(
    "ClientDescribeCoipPoolsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeCoipPoolsResponseCoipPoolsTagsTypeDef = TypedDict(
    "ClientDescribeCoipPoolsResponseCoipPoolsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeCoipPoolsResponseCoipPoolsTypeDef = TypedDict(
    "ClientDescribeCoipPoolsResponseCoipPoolsTypeDef",
    {
        "PoolId": str,
        "PoolCidrs": List[str],
        "LocalGatewayRouteTableId": str,
        "Tags": List[ClientDescribeCoipPoolsResponseCoipPoolsTagsTypeDef],
    },
    total=False,
)

ClientDescribeCoipPoolsResponseTypeDef = TypedDict(
    "ClientDescribeCoipPoolsResponseTypeDef",
    {"CoipPools": List[ClientDescribeCoipPoolsResponseCoipPoolsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesImageTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesImageTypeDef",
    {
        "Checksum": str,
        "Format": Literal["VMDK", "RAW", "VHD"],
        "ImportManifestUrl": str,
        "Size": int,
    },
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesVolumeTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesVolumeTypeDef",
    {"Id": str, "Size": int},
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesTypeDef",
    {
        "AvailabilityZone": str,
        "BytesConverted": int,
        "Description": str,
        "Image": ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesImageTypeDef,
        "Status": str,
        "StatusMessage": str,
        "Volume": ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesVolumeTypeDef,
    },
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksImportInstanceTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksImportInstanceTypeDef",
    {
        "Description": str,
        "InstanceId": str,
        "Platform": str,
        "Volumes": List[
            ClientDescribeConversionTasksResponseConversionTasksImportInstanceVolumesTypeDef
        ],
    },
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksImportVolumeImageTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksImportVolumeImageTypeDef",
    {
        "Checksum": str,
        "Format": Literal["VMDK", "RAW", "VHD"],
        "ImportManifestUrl": str,
        "Size": int,
    },
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksImportVolumeVolumeTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksImportVolumeVolumeTypeDef",
    {"Id": str, "Size": int},
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksImportVolumeTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksImportVolumeTypeDef",
    {
        "AvailabilityZone": str,
        "BytesConverted": int,
        "Description": str,
        "Image": ClientDescribeConversionTasksResponseConversionTasksImportVolumeImageTypeDef,
        "Volume": ClientDescribeConversionTasksResponseConversionTasksImportVolumeVolumeTypeDef,
    },
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksTagsTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeConversionTasksResponseConversionTasksTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseConversionTasksTypeDef",
    {
        "ConversionTaskId": str,
        "ExpirationTime": str,
        "ImportInstance": ClientDescribeConversionTasksResponseConversionTasksImportInstanceTypeDef,
        "ImportVolume": ClientDescribeConversionTasksResponseConversionTasksImportVolumeTypeDef,
        "State": Literal["active", "cancelling", "cancelled", "completed"],
        "StatusMessage": str,
        "Tags": List[ClientDescribeConversionTasksResponseConversionTasksTagsTypeDef],
    },
    total=False,
)

ClientDescribeConversionTasksResponseTypeDef = TypedDict(
    "ClientDescribeConversionTasksResponseTypeDef",
    {"ConversionTasks": List[ClientDescribeConversionTasksResponseConversionTasksTypeDef]},
    total=False,
)

ClientDescribeCustomerGatewaysFiltersTypeDef = TypedDict(
    "ClientDescribeCustomerGatewaysFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeCustomerGatewaysResponseCustomerGatewaysTagsTypeDef = TypedDict(
    "ClientDescribeCustomerGatewaysResponseCustomerGatewaysTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeCustomerGatewaysResponseCustomerGatewaysTypeDef = TypedDict(
    "ClientDescribeCustomerGatewaysResponseCustomerGatewaysTypeDef",
    {
        "BgpAsn": str,
        "CustomerGatewayId": str,
        "IpAddress": str,
        "CertificateArn": str,
        "State": str,
        "Type": str,
        "DeviceName": str,
        "Tags": List[ClientDescribeCustomerGatewaysResponseCustomerGatewaysTagsTypeDef],
    },
    total=False,
)

ClientDescribeCustomerGatewaysResponseTypeDef = TypedDict(
    "ClientDescribeCustomerGatewaysResponseTypeDef",
    {"CustomerGateways": List[ClientDescribeCustomerGatewaysResponseCustomerGatewaysTypeDef]},
    total=False,
)

ClientDescribeDhcpOptionsFiltersTypeDef = TypedDict(
    "ClientDescribeDhcpOptionsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef = TypedDict(
    "ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef",
    {"Value": str},
    total=False,
)

ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef = TypedDict(
    "ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef",
    {
        "Key": str,
        "Values": List[ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsValuesTypeDef],
    },
    total=False,
)

ClientDescribeDhcpOptionsResponseDhcpOptionsTagsTypeDef = TypedDict(
    "ClientDescribeDhcpOptionsResponseDhcpOptionsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeDhcpOptionsResponseDhcpOptionsTypeDef = TypedDict(
    "ClientDescribeDhcpOptionsResponseDhcpOptionsTypeDef",
    {
        "DhcpConfigurations": List[
            ClientDescribeDhcpOptionsResponseDhcpOptionsDhcpConfigurationsTypeDef
        ],
        "DhcpOptionsId": str,
        "OwnerId": str,
        "Tags": List[ClientDescribeDhcpOptionsResponseDhcpOptionsTagsTypeDef],
    },
    total=False,
)

ClientDescribeDhcpOptionsResponseTypeDef = TypedDict(
    "ClientDescribeDhcpOptionsResponseTypeDef",
    {"DhcpOptions": List[ClientDescribeDhcpOptionsResponseDhcpOptionsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeEgressOnlyInternetGatewaysFiltersTypeDef = TypedDict(
    "ClientDescribeEgressOnlyInternetGatewaysFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysAttachmentsTypeDef = TypedDict(
    "ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysAttachmentsTypeDef",
    {"State": Literal["attaching", "attached", "detaching", "detached"], "VpcId": str},
    total=False,
)

ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTagsTypeDef = TypedDict(
    "ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTypeDef = TypedDict(
    "ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTypeDef",
    {
        "Attachments": List[
            ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysAttachmentsTypeDef
        ],
        "EgressOnlyInternetGatewayId": str,
        "Tags": List[
            ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeEgressOnlyInternetGatewaysResponseTypeDef = TypedDict(
    "ClientDescribeEgressOnlyInternetGatewaysResponseTypeDef",
    {
        "EgressOnlyInternetGateways": List[
            ClientDescribeEgressOnlyInternetGatewaysResponseEgressOnlyInternetGatewaysTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeElasticGpusFiltersTypeDef = TypedDict(
    "ClientDescribeElasticGpusFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeElasticGpusResponseElasticGpuSetElasticGpuHealthTypeDef = TypedDict(
    "ClientDescribeElasticGpusResponseElasticGpuSetElasticGpuHealthTypeDef",
    {"Status": Literal["OK", "IMPAIRED"]},
    total=False,
)

ClientDescribeElasticGpusResponseElasticGpuSetTagsTypeDef = TypedDict(
    "ClientDescribeElasticGpusResponseElasticGpuSetTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeElasticGpusResponseElasticGpuSetTypeDef = TypedDict(
    "ClientDescribeElasticGpusResponseElasticGpuSetTypeDef",
    {
        "ElasticGpuId": str,
        "AvailabilityZone": str,
        "ElasticGpuType": str,
        "ElasticGpuHealth": ClientDescribeElasticGpusResponseElasticGpuSetElasticGpuHealthTypeDef,
        "ElasticGpuState": str,
        "InstanceId": str,
        "Tags": List[ClientDescribeElasticGpusResponseElasticGpuSetTagsTypeDef],
    },
    total=False,
)

ClientDescribeElasticGpusResponseTypeDef = TypedDict(
    "ClientDescribeElasticGpusResponseTypeDef",
    {
        "ElasticGpuSet": List[ClientDescribeElasticGpusResponseElasticGpuSetTypeDef],
        "MaxResults": int,
        "NextToken": str,
    },
    total=False,
)

ClientDescribeExportImageTasksFiltersTypeDef = TypedDict(
    "ClientDescribeExportImageTasksFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeExportImageTasksResponseExportImageTasksS3ExportLocationTypeDef = TypedDict(
    "ClientDescribeExportImageTasksResponseExportImageTasksS3ExportLocationTypeDef",
    {"S3Bucket": str, "S3Prefix": str},
    total=False,
)

ClientDescribeExportImageTasksResponseExportImageTasksTypeDef = TypedDict(
    "ClientDescribeExportImageTasksResponseExportImageTasksTypeDef",
    {
        "Description": str,
        "ExportImageTaskId": str,
        "ImageId": str,
        "Progress": str,
        "S3ExportLocation": ClientDescribeExportImageTasksResponseExportImageTasksS3ExportLocationTypeDef,
        "Status": str,
        "StatusMessage": str,
    },
    total=False,
)

ClientDescribeExportImageTasksResponseTypeDef = TypedDict(
    "ClientDescribeExportImageTasksResponseTypeDef",
    {
        "ExportImageTasks": List[ClientDescribeExportImageTasksResponseExportImageTasksTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeExportTasksFiltersTypeDef = TypedDict(
    "ClientDescribeExportTasksFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeExportTasksResponseExportTasksExportToS3TaskTypeDef = TypedDict(
    "ClientDescribeExportTasksResponseExportTasksExportToS3TaskTypeDef",
    {
        "ContainerFormat": str,
        "DiskImageFormat": Literal["VMDK", "RAW", "VHD"],
        "S3Bucket": str,
        "S3Key": str,
    },
    total=False,
)

ClientDescribeExportTasksResponseExportTasksInstanceExportDetailsTypeDef = TypedDict(
    "ClientDescribeExportTasksResponseExportTasksInstanceExportDetailsTypeDef",
    {"InstanceId": str, "TargetEnvironment": Literal["citrix", "vmware", "microsoft"]},
    total=False,
)

ClientDescribeExportTasksResponseExportTasksTagsTypeDef = TypedDict(
    "ClientDescribeExportTasksResponseExportTasksTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeExportTasksResponseExportTasksTypeDef = TypedDict(
    "ClientDescribeExportTasksResponseExportTasksTypeDef",
    {
        "Description": str,
        "ExportTaskId": str,
        "ExportToS3Task": ClientDescribeExportTasksResponseExportTasksExportToS3TaskTypeDef,
        "InstanceExportDetails": ClientDescribeExportTasksResponseExportTasksInstanceExportDetailsTypeDef,
        "State": Literal["active", "cancelling", "cancelled", "completed"],
        "StatusMessage": str,
        "Tags": List[ClientDescribeExportTasksResponseExportTasksTagsTypeDef],
    },
    total=False,
)

ClientDescribeExportTasksResponseTypeDef = TypedDict(
    "ClientDescribeExportTasksResponseTypeDef",
    {"ExportTasks": List[ClientDescribeExportTasksResponseExportTasksTypeDef]},
    total=False,
)

ClientDescribeFastSnapshotRestoresFiltersTypeDef = TypedDict(
    "ClientDescribeFastSnapshotRestoresFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeFastSnapshotRestoresResponseFastSnapshotRestoresTypeDef = TypedDict(
    "ClientDescribeFastSnapshotRestoresResponseFastSnapshotRestoresTypeDef",
    {
        "SnapshotId": str,
        "AvailabilityZone": str,
        "State": Literal["enabling", "optimizing", "enabled", "disabling", "disabled"],
        "StateTransitionReason": str,
        "OwnerId": str,
        "OwnerAlias": str,
        "EnablingTime": datetime,
        "OptimizingTime": datetime,
        "EnabledTime": datetime,
        "DisablingTime": datetime,
        "DisabledTime": datetime,
    },
    total=False,
)

ClientDescribeFastSnapshotRestoresResponseTypeDef = TypedDict(
    "ClientDescribeFastSnapshotRestoresResponseTypeDef",
    {
        "FastSnapshotRestores": List[
            ClientDescribeFastSnapshotRestoresResponseFastSnapshotRestoresTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeFleetHistoryResponseHistoryRecordsEventInformationTypeDef = TypedDict(
    "ClientDescribeFleetHistoryResponseHistoryRecordsEventInformationTypeDef",
    {"EventDescription": str, "EventSubType": str, "InstanceId": str},
    total=False,
)

ClientDescribeFleetHistoryResponseHistoryRecordsTypeDef = TypedDict(
    "ClientDescribeFleetHistoryResponseHistoryRecordsTypeDef",
    {
        "EventInformation": ClientDescribeFleetHistoryResponseHistoryRecordsEventInformationTypeDef,
        "EventType": Literal["instance-change", "fleet-change", "service-error"],
        "Timestamp": datetime,
    },
    total=False,
)

ClientDescribeFleetHistoryResponseTypeDef = TypedDict(
    "ClientDescribeFleetHistoryResponseTypeDef",
    {
        "HistoryRecords": List[ClientDescribeFleetHistoryResponseHistoryRecordsTypeDef],
        "LastEvaluatedTime": datetime,
        "NextToken": str,
        "FleetId": str,
        "StartTime": datetime,
    },
    total=False,
)

ClientDescribeFleetInstancesFiltersTypeDef = TypedDict(
    "ClientDescribeFleetInstancesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeFleetInstancesResponseActiveInstancesTypeDef = TypedDict(
    "ClientDescribeFleetInstancesResponseActiveInstancesTypeDef",
    {
        "InstanceId": str,
        "InstanceType": str,
        "SpotInstanceRequestId": str,
        "InstanceHealth": Literal["healthy", "unhealthy"],
    },
    total=False,
)

ClientDescribeFleetInstancesResponseTypeDef = TypedDict(
    "ClientDescribeFleetInstancesResponseTypeDef",
    {
        "ActiveInstances": List[ClientDescribeFleetInstancesResponseActiveInstancesTypeDef],
        "NextToken": str,
        "FleetId": str,
    },
    total=False,
)

ClientDescribeFleetsFiltersTypeDef = TypedDict(
    "ClientDescribeFleetsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    {"GroupName": str},
    total=False,
)

ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "MaxPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
        "Placement": ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesPlacementTypeDef,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesTypeDef",
    {
        "LaunchTemplateSpecification": ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef,
        "Overrides": ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesOverridesTypeDef,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsErrorsTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsErrorsTypeDef",
    {
        "LaunchTemplateAndOverrides": ClientDescribeFleetsResponseFleetsErrorsLaunchTemplateAndOverridesTypeDef,
        "Lifecycle": Literal["spot", "on-demand"],
        "ErrorCode": str,
        "ErrorMessage": str,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef",
    {"GroupName": str},
    total=False,
)

ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "MaxPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
        "Placement": ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesPlacementTypeDef,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesTypeDef",
    {
        "LaunchTemplateSpecification": ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesLaunchTemplateSpecificationTypeDef,
        "Overrides": ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesOverridesTypeDef,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsInstancesTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsInstancesTypeDef",
    {
        "LaunchTemplateAndOverrides": ClientDescribeFleetsResponseFleetsInstancesLaunchTemplateAndOverridesTypeDef,
        "Lifecycle": Literal["spot", "on-demand"],
        "InstanceIds": List[str],
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "Platform": str,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesPlacementTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesPlacementTypeDef",
    {"GroupName": str},
    total=False,
)

ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "MaxPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
        "Placement": ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesPlacementTypeDef,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsTypeDef",
    {
        "LaunchTemplateSpecification": ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef,
        "Overrides": List[ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsOverridesTypeDef],
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsOnDemandOptionsCapacityReservationOptionsTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsOnDemandOptionsCapacityReservationOptionsTypeDef",
    {"UsageStrategy": str},
    total=False,
)

ClientDescribeFleetsResponseFleetsOnDemandOptionsTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsOnDemandOptionsTypeDef",
    {
        "AllocationStrategy": Literal["lowest-price", "prioritized"],
        "CapacityReservationOptions": ClientDescribeFleetsResponseFleetsOnDemandOptionsCapacityReservationOptionsTypeDef,
        "SingleInstanceType": bool,
        "SingleAvailabilityZone": bool,
        "MinTargetCapacity": int,
        "MaxTotalPrice": str,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsSpotOptionsTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsSpotOptionsTypeDef",
    {
        "AllocationStrategy": Literal["lowest-price", "diversified", "capacity-optimized"],
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
        "InstancePoolsToUseCount": int,
        "SingleInstanceType": bool,
        "SingleAvailabilityZone": bool,
        "MinTargetCapacity": int,
        "MaxTotalPrice": str,
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsTagsTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeFleetsResponseFleetsTargetCapacitySpecificationTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsTargetCapacitySpecificationTypeDef",
    {
        "TotalTargetCapacity": int,
        "OnDemandTargetCapacity": int,
        "SpotTargetCapacity": int,
        "DefaultTargetCapacityType": Literal["spot", "on-demand"],
    },
    total=False,
)

ClientDescribeFleetsResponseFleetsTypeDef = TypedDict(
    "ClientDescribeFleetsResponseFleetsTypeDef",
    {
        "ActivityStatus": Literal[
            "error", "pending_fulfillment", "pending_termination", "fulfilled"
        ],
        "CreateTime": datetime,
        "FleetId": str,
        "FleetState": Literal[
            "submitted",
            "active",
            "deleted",
            "failed",
            "deleted_running",
            "deleted_terminating",
            "modifying",
        ],
        "ClientToken": str,
        "ExcessCapacityTerminationPolicy": Literal["no-termination", "termination"],
        "FulfilledCapacity": float,
        "FulfilledOnDemandCapacity": float,
        "LaunchTemplateConfigs": List[
            ClientDescribeFleetsResponseFleetsLaunchTemplateConfigsTypeDef
        ],
        "TargetCapacitySpecification": ClientDescribeFleetsResponseFleetsTargetCapacitySpecificationTypeDef,
        "TerminateInstancesWithExpiration": bool,
        "Type": Literal["request", "maintain", "instant"],
        "ValidFrom": datetime,
        "ValidUntil": datetime,
        "ReplaceUnhealthyInstances": bool,
        "SpotOptions": ClientDescribeFleetsResponseFleetsSpotOptionsTypeDef,
        "OnDemandOptions": ClientDescribeFleetsResponseFleetsOnDemandOptionsTypeDef,
        "Tags": List[ClientDescribeFleetsResponseFleetsTagsTypeDef],
        "Errors": List[ClientDescribeFleetsResponseFleetsErrorsTypeDef],
        "Instances": List[ClientDescribeFleetsResponseFleetsInstancesTypeDef],
    },
    total=False,
)

ClientDescribeFleetsResponseTypeDef = TypedDict(
    "ClientDescribeFleetsResponseTypeDef",
    {"NextToken": str, "Fleets": List[ClientDescribeFleetsResponseFleetsTypeDef]},
    total=False,
)

ClientDescribeFlowLogsFiltersTypeDef = TypedDict(
    "ClientDescribeFlowLogsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeFlowLogsResponseFlowLogsTypeDef = TypedDict(
    "ClientDescribeFlowLogsResponseFlowLogsTypeDef",
    {
        "CreationTime": datetime,
        "DeliverLogsErrorMessage": str,
        "DeliverLogsPermissionArn": str,
        "DeliverLogsStatus": str,
        "FlowLogId": str,
        "FlowLogStatus": str,
        "LogGroupName": str,
        "ResourceId": str,
        "TrafficType": Literal["ACCEPT", "REJECT", "ALL"],
        "LogDestinationType": Literal["cloud-watch-logs", "s3"],
        "LogDestination": str,
        "LogFormat": str,
        "MaxAggregationInterval": int,
    },
    total=False,
)

ClientDescribeFlowLogsResponseTypeDef = TypedDict(
    "ClientDescribeFlowLogsResponseTypeDef",
    {"FlowLogs": List[ClientDescribeFlowLogsResponseFlowLogsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef = TypedDict(
    "ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef",
    {"UserId": str, "Group": str},
    total=False,
)

ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef = TypedDict(
    "ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeTypeDef = TypedDict(
    "ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeTypeDef",
    {
        "FpgaImageId": str,
        "Name": str,
        "Description": str,
        "LoadPermissions": List[
            ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef
        ],
        "ProductCodes": List[
            ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef
        ],
    },
    total=False,
)

ClientDescribeFpgaImageAttributeResponseTypeDef = TypedDict(
    "ClientDescribeFpgaImageAttributeResponseTypeDef",
    {"FpgaImageAttribute": ClientDescribeFpgaImageAttributeResponseFpgaImageAttributeTypeDef},
    total=False,
)

ClientDescribeFpgaImagesFiltersTypeDef = TypedDict(
    "ClientDescribeFpgaImagesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeFpgaImagesResponseFpgaImagesPciIdTypeDef = TypedDict(
    "ClientDescribeFpgaImagesResponseFpgaImagesPciIdTypeDef",
    {"DeviceId": str, "VendorId": str, "SubsystemId": str, "SubsystemVendorId": str},
    total=False,
)

ClientDescribeFpgaImagesResponseFpgaImagesProductCodesTypeDef = TypedDict(
    "ClientDescribeFpgaImagesResponseFpgaImagesProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeFpgaImagesResponseFpgaImagesStateTypeDef = TypedDict(
    "ClientDescribeFpgaImagesResponseFpgaImagesStateTypeDef",
    {"Code": Literal["pending", "failed", "available", "unavailable"], "Message": str},
    total=False,
)

ClientDescribeFpgaImagesResponseFpgaImagesTagsTypeDef = TypedDict(
    "ClientDescribeFpgaImagesResponseFpgaImagesTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeFpgaImagesResponseFpgaImagesTypeDef = TypedDict(
    "ClientDescribeFpgaImagesResponseFpgaImagesTypeDef",
    {
        "FpgaImageId": str,
        "FpgaImageGlobalId": str,
        "Name": str,
        "Description": str,
        "ShellVersion": str,
        "PciId": ClientDescribeFpgaImagesResponseFpgaImagesPciIdTypeDef,
        "State": ClientDescribeFpgaImagesResponseFpgaImagesStateTypeDef,
        "CreateTime": datetime,
        "UpdateTime": datetime,
        "OwnerId": str,
        "OwnerAlias": str,
        "ProductCodes": List[ClientDescribeFpgaImagesResponseFpgaImagesProductCodesTypeDef],
        "Tags": List[ClientDescribeFpgaImagesResponseFpgaImagesTagsTypeDef],
        "Public": bool,
        "DataRetentionSupport": bool,
    },
    total=False,
)

ClientDescribeFpgaImagesResponseTypeDef = TypedDict(
    "ClientDescribeFpgaImagesResponseTypeDef",
    {"FpgaImages": List[ClientDescribeFpgaImagesResponseFpgaImagesTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeHostReservationOfferingsFiltersTypeDef = TypedDict(
    "ClientDescribeHostReservationOfferingsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeHostReservationOfferingsResponseOfferingSetTypeDef = TypedDict(
    "ClientDescribeHostReservationOfferingsResponseOfferingSetTypeDef",
    {
        "CurrencyCode": str,
        "Duration": int,
        "HourlyPrice": str,
        "InstanceFamily": str,
        "OfferingId": str,
        "PaymentOption": Literal["AllUpfront", "PartialUpfront", "NoUpfront"],
        "UpfrontPrice": str,
    },
    total=False,
)

ClientDescribeHostReservationOfferingsResponseTypeDef = TypedDict(
    "ClientDescribeHostReservationOfferingsResponseTypeDef",
    {
        "NextToken": str,
        "OfferingSet": List[ClientDescribeHostReservationOfferingsResponseOfferingSetTypeDef],
    },
    total=False,
)

ClientDescribeHostReservationsFiltersTypeDef = TypedDict(
    "ClientDescribeHostReservationsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeHostReservationsResponseHostReservationSetTagsTypeDef = TypedDict(
    "ClientDescribeHostReservationsResponseHostReservationSetTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeHostReservationsResponseHostReservationSetTypeDef = TypedDict(
    "ClientDescribeHostReservationsResponseHostReservationSetTypeDef",
    {
        "Count": int,
        "CurrencyCode": str,
        "Duration": int,
        "End": datetime,
        "HostIdSet": List[str],
        "HostReservationId": str,
        "HourlyPrice": str,
        "InstanceFamily": str,
        "OfferingId": str,
        "PaymentOption": Literal["AllUpfront", "PartialUpfront", "NoUpfront"],
        "Start": datetime,
        "State": Literal["payment-pending", "payment-failed", "active", "retired"],
        "UpfrontPrice": str,
        "Tags": List[ClientDescribeHostReservationsResponseHostReservationSetTagsTypeDef],
    },
    total=False,
)

ClientDescribeHostReservationsResponseTypeDef = TypedDict(
    "ClientDescribeHostReservationsResponseTypeDef",
    {
        "HostReservationSet": List[ClientDescribeHostReservationsResponseHostReservationSetTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeHostsFiltersTypeDef = TypedDict(
    "ClientDescribeHostsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeHostsResponseHostsAvailableCapacityAvailableInstanceCapacityTypeDef = TypedDict(
    "ClientDescribeHostsResponseHostsAvailableCapacityAvailableInstanceCapacityTypeDef",
    {"AvailableCapacity": int, "InstanceType": str, "TotalCapacity": int},
    total=False,
)

ClientDescribeHostsResponseHostsAvailableCapacityTypeDef = TypedDict(
    "ClientDescribeHostsResponseHostsAvailableCapacityTypeDef",
    {
        "AvailableInstanceCapacity": List[
            ClientDescribeHostsResponseHostsAvailableCapacityAvailableInstanceCapacityTypeDef
        ],
        "AvailableVCpus": int,
    },
    total=False,
)

ClientDescribeHostsResponseHostsHostPropertiesTypeDef = TypedDict(
    "ClientDescribeHostsResponseHostsHostPropertiesTypeDef",
    {"Cores": int, "InstanceType": str, "InstanceFamily": str, "Sockets": int, "TotalVCpus": int},
    total=False,
)

ClientDescribeHostsResponseHostsInstancesTypeDef = TypedDict(
    "ClientDescribeHostsResponseHostsInstancesTypeDef",
    {"InstanceId": str, "InstanceType": str, "OwnerId": str},
    total=False,
)

ClientDescribeHostsResponseHostsTagsTypeDef = TypedDict(
    "ClientDescribeHostsResponseHostsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeHostsResponseHostsTypeDef = TypedDict(
    "ClientDescribeHostsResponseHostsTypeDef",
    {
        "AutoPlacement": Literal["on", "off"],
        "AvailabilityZone": str,
        "AvailableCapacity": ClientDescribeHostsResponseHostsAvailableCapacityTypeDef,
        "ClientToken": str,
        "HostId": str,
        "HostProperties": ClientDescribeHostsResponseHostsHostPropertiesTypeDef,
        "HostReservationId": str,
        "Instances": List[ClientDescribeHostsResponseHostsInstancesTypeDef],
        "State": Literal[
            "available",
            "under-assessment",
            "permanent-failure",
            "released",
            "released-permanent-failure",
            "pending",
        ],
        "AllocationTime": datetime,
        "ReleaseTime": datetime,
        "Tags": List[ClientDescribeHostsResponseHostsTagsTypeDef],
        "HostRecovery": Literal["on", "off"],
        "AllowsMultipleInstanceTypes": Literal["on", "off"],
        "OwnerId": str,
        "AvailabilityZoneId": str,
        "MemberOfServiceLinkedResourceGroup": bool,
    },
    total=False,
)

ClientDescribeHostsResponseTypeDef = TypedDict(
    "ClientDescribeHostsResponseTypeDef",
    {"Hosts": List[ClientDescribeHostsResponseHostsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeIamInstanceProfileAssociationsFiltersTypeDef = TypedDict(
    "ClientDescribeIamInstanceProfileAssociationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsIamInstanceProfileTypeDef = TypedDict(
    "ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsIamInstanceProfileTypeDef",
    {"Arn": str, "Id": str},
    total=False,
)

ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsTypeDef = TypedDict(
    "ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsTypeDef",
    {
        "AssociationId": str,
        "InstanceId": str,
        "IamInstanceProfile": ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsIamInstanceProfileTypeDef,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
        "Timestamp": datetime,
    },
    total=False,
)

ClientDescribeIamInstanceProfileAssociationsResponseTypeDef = TypedDict(
    "ClientDescribeIamInstanceProfileAssociationsResponseTypeDef",
    {
        "IamInstanceProfileAssociations": List[
            ClientDescribeIamInstanceProfileAssociationsResponseIamInstanceProfileAssociationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeIdFormatResponseStatusesTypeDef = TypedDict(
    "ClientDescribeIdFormatResponseStatusesTypeDef",
    {"Deadline": datetime, "Resource": str, "UseLongIds": bool},
    total=False,
)

ClientDescribeIdFormatResponseTypeDef = TypedDict(
    "ClientDescribeIdFormatResponseTypeDef",
    {"Statuses": List[ClientDescribeIdFormatResponseStatusesTypeDef]},
    total=False,
)

ClientDescribeIdentityIdFormatResponseStatusesTypeDef = TypedDict(
    "ClientDescribeIdentityIdFormatResponseStatusesTypeDef",
    {"Deadline": datetime, "Resource": str, "UseLongIds": bool},
    total=False,
)

ClientDescribeIdentityIdFormatResponseTypeDef = TypedDict(
    "ClientDescribeIdentityIdFormatResponseTypeDef",
    {"Statuses": List[ClientDescribeIdentityIdFormatResponseStatusesTypeDef]},
    total=False,
)

ClientDescribeImageAttributeResponseBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientDescribeImageAttributeResponseBlockDeviceMappingsTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientDescribeImageAttributeResponseBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientDescribeImageAttributeResponseDescriptionTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseDescriptionTypeDef", {"Value": str}, total=False
)

ClientDescribeImageAttributeResponseKernelIdTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseKernelIdTypeDef", {"Value": str}, total=False
)

ClientDescribeImageAttributeResponseLaunchPermissionsTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseLaunchPermissionsTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientDescribeImageAttributeResponseProductCodesTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeImageAttributeResponseRamdiskIdTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseRamdiskIdTypeDef", {"Value": str}, total=False
)

ClientDescribeImageAttributeResponseSriovNetSupportTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseSriovNetSupportTypeDef", {"Value": str}, total=False
)

ClientDescribeImageAttributeResponseTypeDef = TypedDict(
    "ClientDescribeImageAttributeResponseTypeDef",
    {
        "BlockDeviceMappings": List[ClientDescribeImageAttributeResponseBlockDeviceMappingsTypeDef],
        "ImageId": str,
        "LaunchPermissions": List[ClientDescribeImageAttributeResponseLaunchPermissionsTypeDef],
        "ProductCodes": List[ClientDescribeImageAttributeResponseProductCodesTypeDef],
        "Description": ClientDescribeImageAttributeResponseDescriptionTypeDef,
        "KernelId": ClientDescribeImageAttributeResponseKernelIdTypeDef,
        "RamdiskId": ClientDescribeImageAttributeResponseRamdiskIdTypeDef,
        "SriovNetSupport": ClientDescribeImageAttributeResponseSriovNetSupportTypeDef,
    },
    total=False,
)

ClientDescribeImagesFiltersTypeDef = TypedDict(
    "ClientDescribeImagesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeImagesResponseImagesBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientDescribeImagesResponseImagesBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientDescribeImagesResponseImagesBlockDeviceMappingsTypeDef = TypedDict(
    "ClientDescribeImagesResponseImagesBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientDescribeImagesResponseImagesBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientDescribeImagesResponseImagesProductCodesTypeDef = TypedDict(
    "ClientDescribeImagesResponseImagesProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeImagesResponseImagesStateReasonTypeDef = TypedDict(
    "ClientDescribeImagesResponseImagesStateReasonTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDescribeImagesResponseImagesTagsTypeDef = TypedDict(
    "ClientDescribeImagesResponseImagesTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeImagesResponseImagesTypeDef = TypedDict(
    "ClientDescribeImagesResponseImagesTypeDef",
    {
        "Architecture": Literal["i386", "x86_64", "arm64"],
        "CreationDate": str,
        "ImageId": str,
        "ImageLocation": str,
        "ImageType": Literal["machine", "kernel", "ramdisk"],
        "Public": bool,
        "KernelId": str,
        "OwnerId": str,
        "Platform": str,
        "PlatformDetails": str,
        "UsageOperation": str,
        "ProductCodes": List[ClientDescribeImagesResponseImagesProductCodesTypeDef],
        "RamdiskId": str,
        "State": Literal[
            "pending", "available", "invalid", "deregistered", "transient", "failed", "error"
        ],
        "BlockDeviceMappings": List[ClientDescribeImagesResponseImagesBlockDeviceMappingsTypeDef],
        "Description": str,
        "EnaSupport": bool,
        "Hypervisor": Literal["ovm", "xen"],
        "ImageOwnerAlias": str,
        "Name": str,
        "RootDeviceName": str,
        "RootDeviceType": Literal["ebs", "instance-store"],
        "SriovNetSupport": str,
        "StateReason": ClientDescribeImagesResponseImagesStateReasonTypeDef,
        "Tags": List[ClientDescribeImagesResponseImagesTagsTypeDef],
        "VirtualizationType": Literal["hvm", "paravirtual"],
    },
    total=False,
)

ClientDescribeImagesResponseTypeDef = TypedDict(
    "ClientDescribeImagesResponseTypeDef",
    {"Images": List[ClientDescribeImagesResponseImagesTypeDef]},
    total=False,
)

ClientDescribeImportImageTasksFiltersTypeDef = TypedDict(
    "ClientDescribeImportImageTasksFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeImportImageTasksResponseImportImageTasksLicenseSpecificationsTypeDef = TypedDict(
    "ClientDescribeImportImageTasksResponseImportImageTasksLicenseSpecificationsTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsUserBucketTypeDef = TypedDict(
    "ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsUserBucketTypeDef",
    {"S3Bucket": str, "S3Key": str},
    total=False,
)

ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsTypeDef = TypedDict(
    "ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsTypeDef",
    {
        "Description": str,
        "DeviceName": str,
        "DiskImageSize": float,
        "Format": str,
        "Progress": str,
        "SnapshotId": str,
        "Status": str,
        "StatusMessage": str,
        "Url": str,
        "UserBucket": ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsUserBucketTypeDef,
    },
    total=False,
)

ClientDescribeImportImageTasksResponseImportImageTasksTagsTypeDef = TypedDict(
    "ClientDescribeImportImageTasksResponseImportImageTasksTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeImportImageTasksResponseImportImageTasksTypeDef = TypedDict(
    "ClientDescribeImportImageTasksResponseImportImageTasksTypeDef",
    {
        "Architecture": str,
        "Description": str,
        "Encrypted": bool,
        "Hypervisor": str,
        "ImageId": str,
        "ImportTaskId": str,
        "KmsKeyId": str,
        "LicenseType": str,
        "Platform": str,
        "Progress": str,
        "SnapshotDetails": List[
            ClientDescribeImportImageTasksResponseImportImageTasksSnapshotDetailsTypeDef
        ],
        "Status": str,
        "StatusMessage": str,
        "Tags": List[ClientDescribeImportImageTasksResponseImportImageTasksTagsTypeDef],
        "LicenseSpecifications": List[
            ClientDescribeImportImageTasksResponseImportImageTasksLicenseSpecificationsTypeDef
        ],
    },
    total=False,
)

ClientDescribeImportImageTasksResponseTypeDef = TypedDict(
    "ClientDescribeImportImageTasksResponseTypeDef",
    {
        "ImportImageTasks": List[ClientDescribeImportImageTasksResponseImportImageTasksTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeImportSnapshotTasksFiltersTypeDef = TypedDict(
    "ClientDescribeImportSnapshotTasksFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailUserBucketTypeDef = TypedDict(
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailUserBucketTypeDef",
    {"S3Bucket": str, "S3Key": str},
    total=False,
)

ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailTypeDef = TypedDict(
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailTypeDef",
    {
        "Description": str,
        "DiskImageSize": float,
        "Encrypted": bool,
        "Format": str,
        "KmsKeyId": str,
        "Progress": str,
        "SnapshotId": str,
        "Status": str,
        "StatusMessage": str,
        "Url": str,
        "UserBucket": ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailUserBucketTypeDef,
    },
    total=False,
)

ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTagsTypeDef = TypedDict(
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTypeDef = TypedDict(
    "ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTypeDef",
    {
        "Description": str,
        "ImportTaskId": str,
        "SnapshotTaskDetail": ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksSnapshotTaskDetailTypeDef,
        "Tags": List[ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTagsTypeDef],
    },
    total=False,
)

ClientDescribeImportSnapshotTasksResponseTypeDef = TypedDict(
    "ClientDescribeImportSnapshotTasksResponseTypeDef",
    {
        "ImportSnapshotTasks": List[
            ClientDescribeImportSnapshotTasksResponseImportSnapshotTasksTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeInstanceAttributeResponseBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseBlockDeviceMappingsEbsTypeDef",
    {
        "AttachTime": datetime,
        "DeleteOnTermination": bool,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
        "VolumeId": str,
    },
    total=False,
)

ClientDescribeInstanceAttributeResponseBlockDeviceMappingsTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "Ebs": ClientDescribeInstanceAttributeResponseBlockDeviceMappingsEbsTypeDef,
    },
    total=False,
)

ClientDescribeInstanceAttributeResponseDisableApiTerminationTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseDisableApiTerminationTypeDef",
    {"Value": bool},
    total=False,
)

ClientDescribeInstanceAttributeResponseEbsOptimizedTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseEbsOptimizedTypeDef", {"Value": bool}, total=False
)

ClientDescribeInstanceAttributeResponseEnaSupportTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseEnaSupportTypeDef", {"Value": bool}, total=False
)

ClientDescribeInstanceAttributeResponseGroupsTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeInstanceAttributeResponseInstanceInitiatedShutdownBehaviorTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseInstanceInitiatedShutdownBehaviorTypeDef",
    {"Value": str},
    total=False,
)

ClientDescribeInstanceAttributeResponseInstanceTypeTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseInstanceTypeTypeDef", {"Value": str}, total=False
)

ClientDescribeInstanceAttributeResponseKernelIdTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseKernelIdTypeDef", {"Value": str}, total=False
)

ClientDescribeInstanceAttributeResponseProductCodesTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeInstanceAttributeResponseRamdiskIdTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseRamdiskIdTypeDef", {"Value": str}, total=False
)

ClientDescribeInstanceAttributeResponseRootDeviceNameTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseRootDeviceNameTypeDef", {"Value": str}, total=False
)

ClientDescribeInstanceAttributeResponseSourceDestCheckTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseSourceDestCheckTypeDef", {"Value": bool}, total=False
)

ClientDescribeInstanceAttributeResponseSriovNetSupportTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseSriovNetSupportTypeDef", {"Value": str}, total=False
)

ClientDescribeInstanceAttributeResponseUserDataTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseUserDataTypeDef", {"Value": str}, total=False
)

ClientDescribeInstanceAttributeResponseTypeDef = TypedDict(
    "ClientDescribeInstanceAttributeResponseTypeDef",
    {
        "Groups": List[ClientDescribeInstanceAttributeResponseGroupsTypeDef],
        "BlockDeviceMappings": List[
            ClientDescribeInstanceAttributeResponseBlockDeviceMappingsTypeDef
        ],
        "DisableApiTermination": ClientDescribeInstanceAttributeResponseDisableApiTerminationTypeDef,
        "EnaSupport": ClientDescribeInstanceAttributeResponseEnaSupportTypeDef,
        "EbsOptimized": ClientDescribeInstanceAttributeResponseEbsOptimizedTypeDef,
        "InstanceId": str,
        "InstanceInitiatedShutdownBehavior": ClientDescribeInstanceAttributeResponseInstanceInitiatedShutdownBehaviorTypeDef,
        "InstanceType": ClientDescribeInstanceAttributeResponseInstanceTypeTypeDef,
        "KernelId": ClientDescribeInstanceAttributeResponseKernelIdTypeDef,
        "ProductCodes": List[ClientDescribeInstanceAttributeResponseProductCodesTypeDef],
        "RamdiskId": ClientDescribeInstanceAttributeResponseRamdiskIdTypeDef,
        "RootDeviceName": ClientDescribeInstanceAttributeResponseRootDeviceNameTypeDef,
        "SourceDestCheck": ClientDescribeInstanceAttributeResponseSourceDestCheckTypeDef,
        "SriovNetSupport": ClientDescribeInstanceAttributeResponseSriovNetSupportTypeDef,
        "UserData": ClientDescribeInstanceAttributeResponseUserDataTypeDef,
    },
    total=False,
)

ClientDescribeInstanceCreditSpecificationsFiltersTypeDef = TypedDict(
    "ClientDescribeInstanceCreditSpecificationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeInstanceCreditSpecificationsResponseInstanceCreditSpecificationsTypeDef = TypedDict(
    "ClientDescribeInstanceCreditSpecificationsResponseInstanceCreditSpecificationsTypeDef",
    {"InstanceId": str, "CpuCredits": str},
    total=False,
)

ClientDescribeInstanceCreditSpecificationsResponseTypeDef = TypedDict(
    "ClientDescribeInstanceCreditSpecificationsResponseTypeDef",
    {
        "InstanceCreditSpecifications": List[
            ClientDescribeInstanceCreditSpecificationsResponseInstanceCreditSpecificationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeInstanceStatusFiltersTypeDef = TypedDict(
    "ClientDescribeInstanceStatusFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeInstanceStatusResponseInstanceStatusesEventsTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseInstanceStatusesEventsTypeDef",
    {
        "InstanceEventId": str,
        "Code": Literal[
            "instance-reboot",
            "system-reboot",
            "system-maintenance",
            "instance-retirement",
            "instance-stop",
        ],
        "Description": str,
        "NotAfter": datetime,
        "NotBefore": datetime,
        "NotBeforeDeadline": datetime,
    },
    total=False,
)

ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStateTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusDetailsTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusDetailsTypeDef",
    {
        "ImpairedSince": datetime,
        "Name": str,
        "Status": Literal["passed", "failed", "insufficient-data", "initializing"],
    },
    total=False,
)

ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusTypeDef",
    {
        "Details": List[
            ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusDetailsTypeDef
        ],
        "Status": Literal["ok", "impaired", "insufficient-data", "not-applicable", "initializing"],
    },
    total=False,
)

ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusDetailsTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusDetailsTypeDef",
    {
        "ImpairedSince": datetime,
        "Name": str,
        "Status": Literal["passed", "failed", "insufficient-data", "initializing"],
    },
    total=False,
)

ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusTypeDef",
    {
        "Details": List[
            ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusDetailsTypeDef
        ],
        "Status": Literal["ok", "impaired", "insufficient-data", "not-applicable", "initializing"],
    },
    total=False,
)

ClientDescribeInstanceStatusResponseInstanceStatusesTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseInstanceStatusesTypeDef",
    {
        "AvailabilityZone": str,
        "OutpostArn": str,
        "Events": List[ClientDescribeInstanceStatusResponseInstanceStatusesEventsTypeDef],
        "InstanceId": str,
        "InstanceState": ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStateTypeDef,
        "InstanceStatus": ClientDescribeInstanceStatusResponseInstanceStatusesInstanceStatusTypeDef,
        "SystemStatus": ClientDescribeInstanceStatusResponseInstanceStatusesSystemStatusTypeDef,
    },
    total=False,
)

ClientDescribeInstanceStatusResponseTypeDef = TypedDict(
    "ClientDescribeInstanceStatusResponseTypeDef",
    {
        "InstanceStatuses": List[ClientDescribeInstanceStatusResponseInstanceStatusesTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeInstanceTypeOfferingsFiltersTypeDef = TypedDict(
    "ClientDescribeInstanceTypeOfferingsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeInstanceTypeOfferingsResponseInstanceTypeOfferingsTypeDef = TypedDict(
    "ClientDescribeInstanceTypeOfferingsResponseInstanceTypeOfferingsTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "LocationType": Literal["region", "availability-zone", "availability-zone-id"],
        "Location": str,
    },
    total=False,
)

ClientDescribeInstanceTypeOfferingsResponseTypeDef = TypedDict(
    "ClientDescribeInstanceTypeOfferingsResponseTypeDef",
    {
        "InstanceTypeOfferings": List[
            ClientDescribeInstanceTypeOfferingsResponseInstanceTypeOfferingsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeInstanceTypesFiltersTypeDef = TypedDict(
    "ClientDescribeInstanceTypesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeInstanceTypesResponseInstanceTypesEbsInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesEbsInfoTypeDef",
    {
        "EbsOptimizedSupport": Literal["unsupported", "supported", "default"],
        "EncryptionSupport": Literal["unsupported", "supported"],
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasMemoryInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasMemoryInfoTypeDef",
    {"SizeInMiB": int},
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasTypeDef",
    {
        "Name": str,
        "Manufacturer": str,
        "Count": int,
        "MemoryInfo": ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasMemoryInfoTypeDef,
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoTypeDef",
    {
        "Fpgas": List[ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoFpgasTypeDef],
        "TotalFpgaMemoryInMiB": int,
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusMemoryInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusMemoryInfoTypeDef",
    {"SizeInMiB": int},
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusTypeDef",
    {
        "Name": str,
        "Manufacturer": str,
        "Count": int,
        "MemoryInfo": ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusMemoryInfoTypeDef,
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoTypeDef",
    {
        "Gpus": List[ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoGpusTypeDef],
        "TotalGpuMemoryInMiB": int,
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoAcceleratorsTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoAcceleratorsTypeDef",
    {"Count": int, "Name": str, "Manufacturer": str},
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoTypeDef",
    {
        "Accelerators": List[
            ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoAcceleratorsTypeDef
        ]
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoDisksTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoDisksTypeDef",
    {"SizeInGB": int, "Count": int, "Type": Literal["hdd", "ssd"]},
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoTypeDef",
    {
        "TotalSizeInGB": int,
        "Disks": List[
            ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoDisksTypeDef
        ],
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesMemoryInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesMemoryInfoTypeDef",
    {"SizeInMiB": int},
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesNetworkInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesNetworkInfoTypeDef",
    {
        "NetworkPerformance": str,
        "MaximumNetworkInterfaces": int,
        "Ipv4AddressesPerInterface": int,
        "Ipv6AddressesPerInterface": int,
        "Ipv6Supported": bool,
        "EnaSupport": Literal["unsupported", "supported", "required"],
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesPlacementGroupInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesPlacementGroupInfoTypeDef",
    {"SupportedStrategies": List[Literal["cluster", "partition", "spread"]]},
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesProcessorInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesProcessorInfoTypeDef",
    {
        "SupportedArchitectures": List[Literal["i386", "x86_64", "arm64"]],
        "SustainedClockSpeedInGhz": float,
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesVCpuInfoTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesVCpuInfoTypeDef",
    {
        "DefaultVCpus": int,
        "DefaultCores": int,
        "DefaultThreadsPerCore": int,
        "ValidCores": List[int],
        "ValidThreadsPerCore": List[int],
    },
    total=False,
)

ClientDescribeInstanceTypesResponseInstanceTypesTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseInstanceTypesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "CurrentGeneration": bool,
        "FreeTierEligible": bool,
        "SupportedUsageClasses": List[Literal["spot", "on-demand"]],
        "SupportedRootDeviceTypes": List[Literal["ebs", "instance-store"]],
        "BareMetal": bool,
        "Hypervisor": Literal["nitro", "xen"],
        "ProcessorInfo": ClientDescribeInstanceTypesResponseInstanceTypesProcessorInfoTypeDef,
        "VCpuInfo": ClientDescribeInstanceTypesResponseInstanceTypesVCpuInfoTypeDef,
        "MemoryInfo": ClientDescribeInstanceTypesResponseInstanceTypesMemoryInfoTypeDef,
        "InstanceStorageSupported": bool,
        "InstanceStorageInfo": ClientDescribeInstanceTypesResponseInstanceTypesInstanceStorageInfoTypeDef,
        "EbsInfo": ClientDescribeInstanceTypesResponseInstanceTypesEbsInfoTypeDef,
        "NetworkInfo": ClientDescribeInstanceTypesResponseInstanceTypesNetworkInfoTypeDef,
        "GpuInfo": ClientDescribeInstanceTypesResponseInstanceTypesGpuInfoTypeDef,
        "FpgaInfo": ClientDescribeInstanceTypesResponseInstanceTypesFpgaInfoTypeDef,
        "PlacementGroupInfo": ClientDescribeInstanceTypesResponseInstanceTypesPlacementGroupInfoTypeDef,
        "InferenceAcceleratorInfo": ClientDescribeInstanceTypesResponseInstanceTypesInferenceAcceleratorInfoTypeDef,
        "HibernationSupported": bool,
        "BurstablePerformanceSupported": bool,
        "DedicatedHostsSupported": bool,
        "AutoRecoverySupported": bool,
    },
    total=False,
)

ClientDescribeInstanceTypesResponseTypeDef = TypedDict(
    "ClientDescribeInstanceTypesResponseTypeDef",
    {
        "InstanceTypes": List[ClientDescribeInstanceTypesResponseInstanceTypesTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeInstancesFiltersTypeDef = TypedDict(
    "ClientDescribeInstancesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeInstancesResponseReservationsGroupsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsEbsTypeDef",
    {
        "AttachTime": datetime,
        "DeleteOnTermination": bool,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
        "VolumeId": str,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "Ebs": ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsEbsTypeDef,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesCpuOptionsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesCpuOptionsTypeDef",
    {"CoreCount": int, "ThreadsPerCore": int},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesElasticGpuAssociationsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesElasticGpuAssociationsTypeDef",
    {
        "ElasticGpuId": str,
        "ElasticGpuAssociationId": str,
        "ElasticGpuAssociationState": str,
        "ElasticGpuAssociationTime": str,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesElasticInferenceAcceleratorAssociationsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesElasticInferenceAcceleratorAssociationsTypeDef",
    {
        "ElasticInferenceAcceleratorArn": str,
        "ElasticInferenceAcceleratorAssociationId": str,
        "ElasticInferenceAcceleratorAssociationState": str,
        "ElasticInferenceAcceleratorAssociationTime": datetime,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesHibernationOptionsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesHibernationOptionsTypeDef",
    {"Configured": bool},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesIamInstanceProfileTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesIamInstanceProfileTypeDef",
    {"Arn": str, "Id": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesLicensesTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesLicensesTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesMetadataOptionsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesMetadataOptionsTypeDef",
    {
        "State": Literal["pending", "applied"],
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesMonitoringTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesMonitoringTypeDef",
    {"State": Literal["disabled", "disabling", "enabled", "pending"]},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAssociationTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAssociationTypeDef",
    {"IpOwnerId": str, "PublicDnsName": str, "PublicIp": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAttachmentTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAttachmentTypeDef",
    {
        "AttachTime": datetime,
        "AttachmentId": str,
        "DeleteOnTermination": bool,
        "DeviceIndex": int,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesGroupsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef",
    {"IpOwnerId": str, "PublicDnsName": str, "PublicIp": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesTypeDef",
    {
        "Association": ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef,
        "Primary": bool,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesTypeDef",
    {
        "Association": ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAssociationTypeDef,
        "Attachment": ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesAttachmentTypeDef,
        "Description": str,
        "Groups": List[
            ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesGroupsTypeDef
        ],
        "Ipv6Addresses": List[
            ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesIpv6AddressesTypeDef
        ],
        "MacAddress": str,
        "NetworkInterfaceId": str,
        "OwnerId": str,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SourceDestCheck": bool,
        "Status": Literal["available", "associated", "attaching", "in-use", "detaching"],
        "SubnetId": str,
        "VpcId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesPlacementTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "PartitionNumber": int,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesProductCodesTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesSecurityGroupsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesSecurityGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesStateReasonTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesStateReasonTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesStateTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesTagsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeInstancesResponseReservationsInstancesTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsInstancesTypeDef",
    {
        "AmiLaunchIndex": int,
        "ImageId": str,
        "InstanceId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KernelId": str,
        "KeyName": str,
        "LaunchTime": datetime,
        "Monitoring": ClientDescribeInstancesResponseReservationsInstancesMonitoringTypeDef,
        "Placement": ClientDescribeInstancesResponseReservationsInstancesPlacementTypeDef,
        "Platform": str,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
        "ProductCodes": List[
            ClientDescribeInstancesResponseReservationsInstancesProductCodesTypeDef
        ],
        "PublicDnsName": str,
        "PublicIpAddress": str,
        "RamdiskId": str,
        "State": ClientDescribeInstancesResponseReservationsInstancesStateTypeDef,
        "StateTransitionReason": str,
        "SubnetId": str,
        "VpcId": str,
        "Architecture": Literal["i386", "x86_64", "arm64"],
        "BlockDeviceMappings": List[
            ClientDescribeInstancesResponseReservationsInstancesBlockDeviceMappingsTypeDef
        ],
        "ClientToken": str,
        "EbsOptimized": bool,
        "EnaSupport": bool,
        "Hypervisor": Literal["ovm", "xen"],
        "IamInstanceProfile": ClientDescribeInstancesResponseReservationsInstancesIamInstanceProfileTypeDef,
        "InstanceLifecycle": Literal["spot", "scheduled"],
        "ElasticGpuAssociations": List[
            ClientDescribeInstancesResponseReservationsInstancesElasticGpuAssociationsTypeDef
        ],
        "ElasticInferenceAcceleratorAssociations": List[
            ClientDescribeInstancesResponseReservationsInstancesElasticInferenceAcceleratorAssociationsTypeDef
        ],
        "NetworkInterfaces": List[
            ClientDescribeInstancesResponseReservationsInstancesNetworkInterfacesTypeDef
        ],
        "OutpostArn": str,
        "RootDeviceName": str,
        "RootDeviceType": Literal["ebs", "instance-store"],
        "SecurityGroups": List[
            ClientDescribeInstancesResponseReservationsInstancesSecurityGroupsTypeDef
        ],
        "SourceDestCheck": bool,
        "SpotInstanceRequestId": str,
        "SriovNetSupport": str,
        "StateReason": ClientDescribeInstancesResponseReservationsInstancesStateReasonTypeDef,
        "Tags": List[ClientDescribeInstancesResponseReservationsInstancesTagsTypeDef],
        "VirtualizationType": Literal["hvm", "paravirtual"],
        "CpuOptions": ClientDescribeInstancesResponseReservationsInstancesCpuOptionsTypeDef,
        "CapacityReservationId": str,
        "CapacityReservationSpecification": ClientDescribeInstancesResponseReservationsInstancesCapacityReservationSpecificationTypeDef,
        "HibernationOptions": ClientDescribeInstancesResponseReservationsInstancesHibernationOptionsTypeDef,
        "Licenses": List[ClientDescribeInstancesResponseReservationsInstancesLicensesTypeDef],
        "MetadataOptions": ClientDescribeInstancesResponseReservationsInstancesMetadataOptionsTypeDef,
    },
    total=False,
)

ClientDescribeInstancesResponseReservationsTypeDef = TypedDict(
    "ClientDescribeInstancesResponseReservationsTypeDef",
    {
        "Groups": List[ClientDescribeInstancesResponseReservationsGroupsTypeDef],
        "Instances": List[ClientDescribeInstancesResponseReservationsInstancesTypeDef],
        "OwnerId": str,
        "RequesterId": str,
        "ReservationId": str,
    },
    total=False,
)

ClientDescribeInstancesResponseTypeDef = TypedDict(
    "ClientDescribeInstancesResponseTypeDef",
    {"Reservations": List[ClientDescribeInstancesResponseReservationsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeInternetGatewaysFiltersTypeDef = TypedDict(
    "ClientDescribeInternetGatewaysFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeInternetGatewaysResponseInternetGatewaysAttachmentsTypeDef = TypedDict(
    "ClientDescribeInternetGatewaysResponseInternetGatewaysAttachmentsTypeDef",
    {"State": Literal["attaching", "attached", "detaching", "detached"], "VpcId": str},
    total=False,
)

ClientDescribeInternetGatewaysResponseInternetGatewaysTagsTypeDef = TypedDict(
    "ClientDescribeInternetGatewaysResponseInternetGatewaysTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeInternetGatewaysResponseInternetGatewaysTypeDef = TypedDict(
    "ClientDescribeInternetGatewaysResponseInternetGatewaysTypeDef",
    {
        "Attachments": List[
            ClientDescribeInternetGatewaysResponseInternetGatewaysAttachmentsTypeDef
        ],
        "InternetGatewayId": str,
        "OwnerId": str,
        "Tags": List[ClientDescribeInternetGatewaysResponseInternetGatewaysTagsTypeDef],
    },
    total=False,
)

ClientDescribeInternetGatewaysResponseTypeDef = TypedDict(
    "ClientDescribeInternetGatewaysResponseTypeDef",
    {
        "InternetGateways": List[ClientDescribeInternetGatewaysResponseInternetGatewaysTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeIpv6PoolsFiltersTypeDef = TypedDict(
    "ClientDescribeIpv6PoolsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeIpv6PoolsResponseIpv6PoolsPoolCidrBlocksTypeDef = TypedDict(
    "ClientDescribeIpv6PoolsResponseIpv6PoolsPoolCidrBlocksTypeDef", {"Cidr": str}, total=False
)

ClientDescribeIpv6PoolsResponseIpv6PoolsTagsTypeDef = TypedDict(
    "ClientDescribeIpv6PoolsResponseIpv6PoolsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeIpv6PoolsResponseIpv6PoolsTypeDef = TypedDict(
    "ClientDescribeIpv6PoolsResponseIpv6PoolsTypeDef",
    {
        "PoolId": str,
        "Description": str,
        "PoolCidrBlocks": List[ClientDescribeIpv6PoolsResponseIpv6PoolsPoolCidrBlocksTypeDef],
        "Tags": List[ClientDescribeIpv6PoolsResponseIpv6PoolsTagsTypeDef],
    },
    total=False,
)

ClientDescribeIpv6PoolsResponseTypeDef = TypedDict(
    "ClientDescribeIpv6PoolsResponseTypeDef",
    {"Ipv6Pools": List[ClientDescribeIpv6PoolsResponseIpv6PoolsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeKeyPairsFiltersTypeDef = TypedDict(
    "ClientDescribeKeyPairsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeKeyPairsResponseKeyPairsTagsTypeDef = TypedDict(
    "ClientDescribeKeyPairsResponseKeyPairsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeKeyPairsResponseKeyPairsTypeDef = TypedDict(
    "ClientDescribeKeyPairsResponseKeyPairsTypeDef",
    {
        "KeyPairId": str,
        "KeyFingerprint": str,
        "KeyName": str,
        "Tags": List[ClientDescribeKeyPairsResponseKeyPairsTagsTypeDef],
    },
    total=False,
)

ClientDescribeKeyPairsResponseTypeDef = TypedDict(
    "ClientDescribeKeyPairsResponseTypeDef",
    {"KeyPairs": List[ClientDescribeKeyPairsResponseKeyPairsTypeDef]},
    total=False,
)

ClientDescribeLaunchTemplateVersionsFiltersTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    {
        "Encrypted": bool,
        "DeleteOnTermination": bool,
        "Iops": int,
        "KmsKeyId": str,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCpuOptionsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCpuOptionsTypeDef",
    {"CoreCount": int, "ThreadsPerCore": int},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCreditSpecificationTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCreditSpecificationTypeDef",
    {"CpuCredits": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticGpuSpecificationsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    {"Type": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticInferenceAcceleratorsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    {"Type": str, "Count": int},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataHibernationOptionsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataHibernationOptionsTypeDef",
    {"Configured": bool},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataIamInstanceProfileTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    {
        "MaxPrice": str,
        "SpotInstanceType": Literal["one-time", "persistent"],
        "BlockDurationMinutes": int,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsTypeDef",
    {
        "MarketType": str,
        "SpotOptions": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef,
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataLicenseSpecificationsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataLicenseSpecificationsTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMetadataOptionsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMetadataOptionsTypeDef",
    {
        "State": Literal["pending", "applied"],
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMonitoringTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "InterfaceType": str,
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataPlacementTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
        "PartitionNumber": int,
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTagsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTypeDef",
    {
        "KernelId": str,
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataIamInstanceProfileTypeDef,
        "BlockDeviceMappings": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataBlockDeviceMappingsTypeDef
        ],
        "NetworkInterfaces": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataNetworkInterfacesTypeDef
        ],
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KeyName": str,
        "Monitoring": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMonitoringTypeDef,
        "Placement": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataPlacementTypeDef,
        "RamDiskId": str,
        "DisableApiTermination": bool,
        "InstanceInitiatedShutdownBehavior": Literal["stop", "terminate"],
        "UserData": str,
        "TagSpecifications": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTagSpecificationsTypeDef
        ],
        "ElasticGpuSpecifications": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticGpuSpecificationsTypeDef
        ],
        "ElasticInferenceAccelerators": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataElasticInferenceAcceleratorsTypeDef
        ],
        "SecurityGroupIds": List[str],
        "SecurityGroups": List[str],
        "InstanceMarketOptions": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataInstanceMarketOptionsTypeDef,
        "CreditSpecification": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCreditSpecificationTypeDef,
        "CpuOptions": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCpuOptionsTypeDef,
        "CapacityReservationSpecification": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataCapacityReservationSpecificationTypeDef,
        "LicenseSpecifications": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataLicenseSpecificationsTypeDef
        ],
        "HibernationOptions": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataHibernationOptionsTypeDef,
        "MetadataOptions": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataMetadataOptionsTypeDef,
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsTypeDef",
    {
        "LaunchTemplateId": str,
        "LaunchTemplateName": str,
        "VersionNumber": int,
        "VersionDescription": str,
        "CreateTime": datetime,
        "CreatedBy": str,
        "DefaultVersion": bool,
        "LaunchTemplateData": ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsLaunchTemplateDataTypeDef,
    },
    total=False,
)

ClientDescribeLaunchTemplateVersionsResponseTypeDef = TypedDict(
    "ClientDescribeLaunchTemplateVersionsResponseTypeDef",
    {
        "LaunchTemplateVersions": List[
            ClientDescribeLaunchTemplateVersionsResponseLaunchTemplateVersionsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeLaunchTemplatesFiltersTypeDef = TypedDict(
    "ClientDescribeLaunchTemplatesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeLaunchTemplatesResponseLaunchTemplatesTagsTypeDef = TypedDict(
    "ClientDescribeLaunchTemplatesResponseLaunchTemplatesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLaunchTemplatesResponseLaunchTemplatesTypeDef = TypedDict(
    "ClientDescribeLaunchTemplatesResponseLaunchTemplatesTypeDef",
    {
        "LaunchTemplateId": str,
        "LaunchTemplateName": str,
        "CreateTime": datetime,
        "CreatedBy": str,
        "DefaultVersionNumber": int,
        "LatestVersionNumber": int,
        "Tags": List[ClientDescribeLaunchTemplatesResponseLaunchTemplatesTagsTypeDef],
    },
    total=False,
)

ClientDescribeLaunchTemplatesResponseTypeDef = TypedDict(
    "ClientDescribeLaunchTemplatesResponseTypeDef",
    {
        "LaunchTemplates": List[ClientDescribeLaunchTemplatesResponseLaunchTemplatesTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsFiltersTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTagsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTypeDef",
    {
        "LocalGatewayRouteTableVirtualInterfaceGroupAssociationId": str,
        "LocalGatewayVirtualInterfaceGroupId": str,
        "LocalGatewayId": str,
        "LocalGatewayRouteTableId": str,
        "State": str,
        "Tags": List[
            ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseTypeDef",
    {
        "LocalGatewayRouteTableVirtualInterfaceGroupAssociations": List[
            ClientDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseLocalGatewayRouteTableVirtualInterfaceGroupAssociationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeLocalGatewayRouteTableVpcAssociationsFiltersTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTagsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTypeDef",
    {
        "LocalGatewayRouteTableVpcAssociationId": str,
        "LocalGatewayRouteTableId": str,
        "LocalGatewayId": str,
        "VpcId": str,
        "State": str,
        "Tags": List[
            ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseTypeDef",
    {
        "LocalGatewayRouteTableVpcAssociations": List[
            ClientDescribeLocalGatewayRouteTableVpcAssociationsResponseLocalGatewayRouteTableVpcAssociationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeLocalGatewayRouteTablesFiltersTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTablesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTagsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTypeDef",
    {
        "LocalGatewayRouteTableId": str,
        "LocalGatewayId": str,
        "OutpostArn": str,
        "State": str,
        "Tags": List[
            ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeLocalGatewayRouteTablesResponseTypeDef = TypedDict(
    "ClientDescribeLocalGatewayRouteTablesResponseTypeDef",
    {
        "LocalGatewayRouteTables": List[
            ClientDescribeLocalGatewayRouteTablesResponseLocalGatewayRouteTablesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfaceGroupsFiltersTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTagsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTypeDef",
    {
        "LocalGatewayVirtualInterfaceGroupId": str,
        "LocalGatewayVirtualInterfaceIds": List[str],
        "LocalGatewayId": str,
        "Tags": List[
            ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseTypeDef",
    {
        "LocalGatewayVirtualInterfaceGroups": List[
            ClientDescribeLocalGatewayVirtualInterfaceGroupsResponseLocalGatewayVirtualInterfaceGroupsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfacesFiltersTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfacesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTagsTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTypeDef",
    {
        "LocalGatewayVirtualInterfaceId": str,
        "LocalGatewayId": str,
        "Vlan": int,
        "LocalAddress": str,
        "PeerAddress": str,
        "LocalBgpAsn": int,
        "PeerBgpAsn": int,
        "Tags": List[
            ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeLocalGatewayVirtualInterfacesResponseTypeDef = TypedDict(
    "ClientDescribeLocalGatewayVirtualInterfacesResponseTypeDef",
    {
        "LocalGatewayVirtualInterfaces": List[
            ClientDescribeLocalGatewayVirtualInterfacesResponseLocalGatewayVirtualInterfacesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeLocalGatewaysFiltersTypeDef = TypedDict(
    "ClientDescribeLocalGatewaysFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeLocalGatewaysResponseLocalGatewaysTagsTypeDef = TypedDict(
    "ClientDescribeLocalGatewaysResponseLocalGatewaysTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeLocalGatewaysResponseLocalGatewaysTypeDef = TypedDict(
    "ClientDescribeLocalGatewaysResponseLocalGatewaysTypeDef",
    {
        "LocalGatewayId": str,
        "OutpostArn": str,
        "OwnerId": str,
        "State": str,
        "Tags": List[ClientDescribeLocalGatewaysResponseLocalGatewaysTagsTypeDef],
    },
    total=False,
)

ClientDescribeLocalGatewaysResponseTypeDef = TypedDict(
    "ClientDescribeLocalGatewaysResponseTypeDef",
    {
        "LocalGateways": List[ClientDescribeLocalGatewaysResponseLocalGatewaysTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeMovingAddressesFiltersTypeDef = TypedDict(
    "ClientDescribeMovingAddressesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeMovingAddressesResponseMovingAddressStatusesTypeDef = TypedDict(
    "ClientDescribeMovingAddressesResponseMovingAddressStatusesTypeDef",
    {"MoveStatus": Literal["movingToVpc", "restoringToClassic"], "PublicIp": str},
    total=False,
)

ClientDescribeMovingAddressesResponseTypeDef = TypedDict(
    "ClientDescribeMovingAddressesResponseTypeDef",
    {
        "MovingAddressStatuses": List[
            ClientDescribeMovingAddressesResponseMovingAddressStatusesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeNatGatewaysFiltersTypeDef = TypedDict(
    "ClientDescribeNatGatewaysFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeNatGatewaysResponseNatGatewaysNatGatewayAddressesTypeDef = TypedDict(
    "ClientDescribeNatGatewaysResponseNatGatewaysNatGatewayAddressesTypeDef",
    {"AllocationId": str, "NetworkInterfaceId": str, "PrivateIp": str, "PublicIp": str},
    total=False,
)

ClientDescribeNatGatewaysResponseNatGatewaysProvisionedBandwidthTypeDef = TypedDict(
    "ClientDescribeNatGatewaysResponseNatGatewaysProvisionedBandwidthTypeDef",
    {
        "ProvisionTime": datetime,
        "Provisioned": str,
        "RequestTime": datetime,
        "Requested": str,
        "Status": str,
    },
    total=False,
)

ClientDescribeNatGatewaysResponseNatGatewaysTagsTypeDef = TypedDict(
    "ClientDescribeNatGatewaysResponseNatGatewaysTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeNatGatewaysResponseNatGatewaysTypeDef = TypedDict(
    "ClientDescribeNatGatewaysResponseNatGatewaysTypeDef",
    {
        "CreateTime": datetime,
        "DeleteTime": datetime,
        "FailureCode": str,
        "FailureMessage": str,
        "NatGatewayAddresses": List[
            ClientDescribeNatGatewaysResponseNatGatewaysNatGatewayAddressesTypeDef
        ],
        "NatGatewayId": str,
        "ProvisionedBandwidth": ClientDescribeNatGatewaysResponseNatGatewaysProvisionedBandwidthTypeDef,
        "State": Literal["pending", "failed", "available", "deleting", "deleted"],
        "SubnetId": str,
        "VpcId": str,
        "Tags": List[ClientDescribeNatGatewaysResponseNatGatewaysTagsTypeDef],
    },
    total=False,
)

ClientDescribeNatGatewaysResponseTypeDef = TypedDict(
    "ClientDescribeNatGatewaysResponseTypeDef",
    {"NatGateways": List[ClientDescribeNatGatewaysResponseNatGatewaysTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeNetworkAclsFiltersTypeDef = TypedDict(
    "ClientDescribeNetworkAclsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeNetworkAclsResponseNetworkAclsAssociationsTypeDef = TypedDict(
    "ClientDescribeNetworkAclsResponseNetworkAclsAssociationsTypeDef",
    {"NetworkAclAssociationId": str, "NetworkAclId": str, "SubnetId": str},
    total=False,
)

ClientDescribeNetworkAclsResponseNetworkAclsEntriesIcmpTypeCodeTypeDef = TypedDict(
    "ClientDescribeNetworkAclsResponseNetworkAclsEntriesIcmpTypeCodeTypeDef",
    {"Code": int, "Type": int},
    total=False,
)

ClientDescribeNetworkAclsResponseNetworkAclsEntriesPortRangeTypeDef = TypedDict(
    "ClientDescribeNetworkAclsResponseNetworkAclsEntriesPortRangeTypeDef",
    {"From": int, "To": int},
    total=False,
)

ClientDescribeNetworkAclsResponseNetworkAclsEntriesTypeDef = TypedDict(
    "ClientDescribeNetworkAclsResponseNetworkAclsEntriesTypeDef",
    {
        "CidrBlock": str,
        "Egress": bool,
        "IcmpTypeCode": ClientDescribeNetworkAclsResponseNetworkAclsEntriesIcmpTypeCodeTypeDef,
        "Ipv6CidrBlock": str,
        "PortRange": ClientDescribeNetworkAclsResponseNetworkAclsEntriesPortRangeTypeDef,
        "Protocol": str,
        "RuleAction": Literal["allow", "deny"],
        "RuleNumber": int,
    },
    total=False,
)

ClientDescribeNetworkAclsResponseNetworkAclsTagsTypeDef = TypedDict(
    "ClientDescribeNetworkAclsResponseNetworkAclsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeNetworkAclsResponseNetworkAclsTypeDef = TypedDict(
    "ClientDescribeNetworkAclsResponseNetworkAclsTypeDef",
    {
        "Associations": List[ClientDescribeNetworkAclsResponseNetworkAclsAssociationsTypeDef],
        "Entries": List[ClientDescribeNetworkAclsResponseNetworkAclsEntriesTypeDef],
        "IsDefault": bool,
        "NetworkAclId": str,
        "Tags": List[ClientDescribeNetworkAclsResponseNetworkAclsTagsTypeDef],
        "VpcId": str,
        "OwnerId": str,
    },
    total=False,
)

ClientDescribeNetworkAclsResponseTypeDef = TypedDict(
    "ClientDescribeNetworkAclsResponseTypeDef",
    {"NetworkAcls": List[ClientDescribeNetworkAclsResponseNetworkAclsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeNetworkInterfaceAttributeResponseAttachmentTypeDef = TypedDict(
    "ClientDescribeNetworkInterfaceAttributeResponseAttachmentTypeDef",
    {
        "AttachTime": datetime,
        "AttachmentId": str,
        "DeleteOnTermination": bool,
        "DeviceIndex": int,
        "InstanceId": str,
        "InstanceOwnerId": str,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
    },
    total=False,
)

ClientDescribeNetworkInterfaceAttributeResponseDescriptionTypeDef = TypedDict(
    "ClientDescribeNetworkInterfaceAttributeResponseDescriptionTypeDef", {"Value": str}, total=False
)

ClientDescribeNetworkInterfaceAttributeResponseGroupsTypeDef = TypedDict(
    "ClientDescribeNetworkInterfaceAttributeResponseGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeNetworkInterfaceAttributeResponseSourceDestCheckTypeDef = TypedDict(
    "ClientDescribeNetworkInterfaceAttributeResponseSourceDestCheckTypeDef",
    {"Value": bool},
    total=False,
)

ClientDescribeNetworkInterfaceAttributeResponseTypeDef = TypedDict(
    "ClientDescribeNetworkInterfaceAttributeResponseTypeDef",
    {
        "Attachment": ClientDescribeNetworkInterfaceAttributeResponseAttachmentTypeDef,
        "Description": ClientDescribeNetworkInterfaceAttributeResponseDescriptionTypeDef,
        "Groups": List[ClientDescribeNetworkInterfaceAttributeResponseGroupsTypeDef],
        "NetworkInterfaceId": str,
        "SourceDestCheck": ClientDescribeNetworkInterfaceAttributeResponseSourceDestCheckTypeDef,
    },
    total=False,
)

ClientDescribeNetworkInterfacePermissionsFiltersTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacePermissionsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsPermissionStateTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsPermissionStateTypeDef",
    {"State": Literal["pending", "granted", "revoking", "revoked"], "StatusMessage": str},
    total=False,
)

ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsTypeDef",
    {
        "NetworkInterfacePermissionId": str,
        "NetworkInterfaceId": str,
        "AwsAccountId": str,
        "AwsService": str,
        "Permission": Literal["INSTANCE-ATTACH", "EIP-ASSOCIATE"],
        "PermissionState": ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsPermissionStateTypeDef,
    },
    total=False,
)

ClientDescribeNetworkInterfacePermissionsResponseTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacePermissionsResponseTypeDef",
    {
        "NetworkInterfacePermissions": List[
            ClientDescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeNetworkInterfacesFiltersTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesAssociationTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesAssociationTypeDef",
    {
        "AllocationId": str,
        "AssociationId": str,
        "IpOwnerId": str,
        "PublicDnsName": str,
        "PublicIp": str,
    },
    total=False,
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesAttachmentTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesAttachmentTypeDef",
    {
        "AttachTime": datetime,
        "AttachmentId": str,
        "DeleteOnTermination": bool,
        "DeviceIndex": int,
        "InstanceId": str,
        "InstanceOwnerId": str,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
    },
    total=False,
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesGroupsTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesAssociationTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesAssociationTypeDef",
    {
        "AllocationId": str,
        "AssociationId": str,
        "IpOwnerId": str,
        "PublicDnsName": str,
        "PublicIp": str,
    },
    total=False,
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesTypeDef",
    {
        "Association": ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesAssociationTypeDef,
        "Primary": bool,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
    },
    total=False,
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesTagSetTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesTagSetTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeNetworkInterfacesResponseNetworkInterfacesTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseNetworkInterfacesTypeDef",
    {
        "Association": ClientDescribeNetworkInterfacesResponseNetworkInterfacesAssociationTypeDef,
        "Attachment": ClientDescribeNetworkInterfacesResponseNetworkInterfacesAttachmentTypeDef,
        "AvailabilityZone": str,
        "Description": str,
        "Groups": List[ClientDescribeNetworkInterfacesResponseNetworkInterfacesGroupsTypeDef],
        "InterfaceType": Literal["interface", "natGateway", "efa"],
        "Ipv6Addresses": List[
            ClientDescribeNetworkInterfacesResponseNetworkInterfacesIpv6AddressesTypeDef
        ],
        "MacAddress": str,
        "NetworkInterfaceId": str,
        "OutpostArn": str,
        "OwnerId": str,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientDescribeNetworkInterfacesResponseNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "RequesterId": str,
        "RequesterManaged": bool,
        "SourceDestCheck": bool,
        "Status": Literal["available", "associated", "attaching", "in-use", "detaching"],
        "SubnetId": str,
        "TagSet": List[ClientDescribeNetworkInterfacesResponseNetworkInterfacesTagSetTypeDef],
        "VpcId": str,
    },
    total=False,
)

ClientDescribeNetworkInterfacesResponseTypeDef = TypedDict(
    "ClientDescribeNetworkInterfacesResponseTypeDef",
    {
        "NetworkInterfaces": List[ClientDescribeNetworkInterfacesResponseNetworkInterfacesTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribePlacementGroupsFiltersTypeDef = TypedDict(
    "ClientDescribePlacementGroupsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribePlacementGroupsResponsePlacementGroupsTagsTypeDef = TypedDict(
    "ClientDescribePlacementGroupsResponsePlacementGroupsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribePlacementGroupsResponsePlacementGroupsTypeDef = TypedDict(
    "ClientDescribePlacementGroupsResponsePlacementGroupsTypeDef",
    {
        "GroupName": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Strategy": Literal["cluster", "spread", "partition"],
        "PartitionCount": int,
        "GroupId": str,
        "Tags": List[ClientDescribePlacementGroupsResponsePlacementGroupsTagsTypeDef],
    },
    total=False,
)

ClientDescribePlacementGroupsResponseTypeDef = TypedDict(
    "ClientDescribePlacementGroupsResponseTypeDef",
    {"PlacementGroups": List[ClientDescribePlacementGroupsResponsePlacementGroupsTypeDef]},
    total=False,
)

ClientDescribePrefixListsFiltersTypeDef = TypedDict(
    "ClientDescribePrefixListsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribePrefixListsResponsePrefixListsTypeDef = TypedDict(
    "ClientDescribePrefixListsResponsePrefixListsTypeDef",
    {"Cidrs": List[str], "PrefixListId": str, "PrefixListName": str},
    total=False,
)

ClientDescribePrefixListsResponseTypeDef = TypedDict(
    "ClientDescribePrefixListsResponseTypeDef",
    {"NextToken": str, "PrefixLists": List[ClientDescribePrefixListsResponsePrefixListsTypeDef]},
    total=False,
)

ClientDescribePrincipalIdFormatResponsePrincipalsStatusesTypeDef = TypedDict(
    "ClientDescribePrincipalIdFormatResponsePrincipalsStatusesTypeDef",
    {"Deadline": datetime, "Resource": str, "UseLongIds": bool},
    total=False,
)

ClientDescribePrincipalIdFormatResponsePrincipalsTypeDef = TypedDict(
    "ClientDescribePrincipalIdFormatResponsePrincipalsTypeDef",
    {
        "Arn": str,
        "Statuses": List[ClientDescribePrincipalIdFormatResponsePrincipalsStatusesTypeDef],
    },
    total=False,
)

ClientDescribePrincipalIdFormatResponseTypeDef = TypedDict(
    "ClientDescribePrincipalIdFormatResponseTypeDef",
    {
        "Principals": List[ClientDescribePrincipalIdFormatResponsePrincipalsTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribePublicIpv4PoolsFiltersTypeDef = TypedDict(
    "ClientDescribePublicIpv4PoolsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsPoolAddressRangesTypeDef = TypedDict(
    "ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsPoolAddressRangesTypeDef",
    {"FirstAddress": str, "LastAddress": str, "AddressCount": int, "AvailableAddressCount": int},
    total=False,
)

ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTagsTypeDef = TypedDict(
    "ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTypeDef = TypedDict(
    "ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTypeDef",
    {
        "PoolId": str,
        "Description": str,
        "PoolAddressRanges": List[
            ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsPoolAddressRangesTypeDef
        ],
        "TotalAddressCount": int,
        "TotalAvailableAddressCount": int,
        "Tags": List[ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTagsTypeDef],
    },
    total=False,
)

ClientDescribePublicIpv4PoolsResponseTypeDef = TypedDict(
    "ClientDescribePublicIpv4PoolsResponseTypeDef",
    {
        "PublicIpv4Pools": List[ClientDescribePublicIpv4PoolsResponsePublicIpv4PoolsTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeRegionsFiltersTypeDef = TypedDict(
    "ClientDescribeRegionsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeRegionsResponseRegionsTypeDef = TypedDict(
    "ClientDescribeRegionsResponseRegionsTypeDef",
    {"Endpoint": str, "RegionName": str, "OptInStatus": str},
    total=False,
)

ClientDescribeRegionsResponseTypeDef = TypedDict(
    "ClientDescribeRegionsResponseTypeDef",
    {"Regions": List[ClientDescribeRegionsResponseRegionsTypeDef]},
    total=False,
)

ClientDescribeReservedInstancesFiltersTypeDef = TypedDict(
    "ClientDescribeReservedInstancesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeReservedInstancesListingsFiltersTypeDef = TypedDict(
    "ClientDescribeReservedInstancesListingsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsInstanceCountsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsInstanceCountsTypeDef",
    {"InstanceCount": int, "State": Literal["available", "sold", "cancelled", "pending"]},
    total=False,
)

ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsPriceSchedulesTypeDef = TypedDict(
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsPriceSchedulesTypeDef",
    {"Active": bool, "CurrencyCode": str, "Price": float, "Term": int},
    total=False,
)

ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTagsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTypeDef",
    {
        "ClientToken": str,
        "CreateDate": datetime,
        "InstanceCounts": List[
            ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsInstanceCountsTypeDef
        ],
        "PriceSchedules": List[
            ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsPriceSchedulesTypeDef
        ],
        "ReservedInstancesId": str,
        "ReservedInstancesListingId": str,
        "Status": Literal["active", "pending", "cancelled", "closed"],
        "StatusMessage": str,
        "Tags": List[
            ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTagsTypeDef
        ],
        "UpdateDate": datetime,
    },
    total=False,
)

ClientDescribeReservedInstancesListingsResponseTypeDef = TypedDict(
    "ClientDescribeReservedInstancesListingsResponseTypeDef",
    {
        "ReservedInstancesListings": List[
            ClientDescribeReservedInstancesListingsResponseReservedInstancesListingsTypeDef
        ]
    },
    total=False,
)

ClientDescribeReservedInstancesModificationsFiltersTypeDef = TypedDict(
    "ClientDescribeReservedInstancesModificationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTargetConfigurationTypeDef = TypedDict(
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTargetConfigurationTypeDef",
    {
        "AvailabilityZone": str,
        "InstanceCount": int,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "Platform": str,
        "Scope": Literal["Availability Zone", "Region"],
    },
    total=False,
)

ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTypeDef",
    {
        "ReservedInstancesId": str,
        "TargetConfiguration": ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTargetConfigurationTypeDef,
    },
    total=False,
)

ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsReservedInstancesIdsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsReservedInstancesIdsTypeDef",
    {"ReservedInstancesId": str},
    total=False,
)

ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsTypeDef",
    {
        "ClientToken": str,
        "CreateDate": datetime,
        "EffectiveDate": datetime,
        "ModificationResults": List[
            ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsModificationResultsTypeDef
        ],
        "ReservedInstancesIds": List[
            ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsReservedInstancesIdsTypeDef
        ],
        "ReservedInstancesModificationId": str,
        "Status": str,
        "StatusMessage": str,
        "UpdateDate": datetime,
    },
    total=False,
)

ClientDescribeReservedInstancesModificationsResponseTypeDef = TypedDict(
    "ClientDescribeReservedInstancesModificationsResponseTypeDef",
    {
        "NextToken": str,
        "ReservedInstancesModifications": List[
            ClientDescribeReservedInstancesModificationsResponseReservedInstancesModificationsTypeDef
        ],
    },
    total=False,
)

ClientDescribeReservedInstancesOfferingsFiltersTypeDef = TypedDict(
    "ClientDescribeReservedInstancesOfferingsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsPricingDetailsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsPricingDetailsTypeDef",
    {"Count": int, "Price": float},
    total=False,
)

ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsRecurringChargesTypeDef = TypedDict(
    "ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsRecurringChargesTypeDef",
    {"Amount": float, "Frequency": str},
    total=False,
)

ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsTypeDef",
    {
        "AvailabilityZone": str,
        "Duration": int,
        "FixedPrice": Any,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "ProductDescription": Literal[
            "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
        ],
        "ReservedInstancesOfferingId": str,
        "UsagePrice": Any,
        "CurrencyCode": str,
        "InstanceTenancy": Literal["default", "dedicated", "host"],
        "Marketplace": bool,
        "OfferingClass": Literal["standard", "convertible"],
        "OfferingType": Literal[
            "Heavy Utilization",
            "Medium Utilization",
            "Light Utilization",
            "No Upfront",
            "Partial Upfront",
            "All Upfront",
        ],
        "PricingDetails": List[
            ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsPricingDetailsTypeDef
        ],
        "RecurringCharges": List[
            ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsRecurringChargesTypeDef
        ],
        "Scope": Literal["Availability Zone", "Region"],
    },
    total=False,
)

ClientDescribeReservedInstancesOfferingsResponseTypeDef = TypedDict(
    "ClientDescribeReservedInstancesOfferingsResponseTypeDef",
    {
        "ReservedInstancesOfferings": List[
            ClientDescribeReservedInstancesOfferingsResponseReservedInstancesOfferingsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeReservedInstancesResponseReservedInstancesRecurringChargesTypeDef = TypedDict(
    "ClientDescribeReservedInstancesResponseReservedInstancesRecurringChargesTypeDef",
    {"Amount": float, "Frequency": str},
    total=False,
)

ClientDescribeReservedInstancesResponseReservedInstancesTagsTypeDef = TypedDict(
    "ClientDescribeReservedInstancesResponseReservedInstancesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeReservedInstancesResponseReservedInstancesTypeDef = TypedDict(
    "ClientDescribeReservedInstancesResponseReservedInstancesTypeDef",
    {
        "AvailabilityZone": str,
        "Duration": int,
        "End": datetime,
        "FixedPrice": Any,
        "InstanceCount": int,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "ProductDescription": Literal[
            "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
        ],
        "ReservedInstancesId": str,
        "Start": datetime,
        "State": Literal[
            "payment-pending", "active", "payment-failed", "retired", "queued", "queued-deleted"
        ],
        "UsagePrice": Any,
        "CurrencyCode": str,
        "InstanceTenancy": Literal["default", "dedicated", "host"],
        "OfferingClass": Literal["standard", "convertible"],
        "OfferingType": Literal[
            "Heavy Utilization",
            "Medium Utilization",
            "Light Utilization",
            "No Upfront",
            "Partial Upfront",
            "All Upfront",
        ],
        "RecurringCharges": List[
            ClientDescribeReservedInstancesResponseReservedInstancesRecurringChargesTypeDef
        ],
        "Scope": Literal["Availability Zone", "Region"],
        "Tags": List[ClientDescribeReservedInstancesResponseReservedInstancesTagsTypeDef],
    },
    total=False,
)

ClientDescribeReservedInstancesResponseTypeDef = TypedDict(
    "ClientDescribeReservedInstancesResponseTypeDef",
    {"ReservedInstances": List[ClientDescribeReservedInstancesResponseReservedInstancesTypeDef]},
    total=False,
)

ClientDescribeRouteTablesFiltersTypeDef = TypedDict(
    "ClientDescribeRouteTablesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeRouteTablesResponseRouteTablesAssociationsAssociationStateTypeDef = TypedDict(
    "ClientDescribeRouteTablesResponseRouteTablesAssociationsAssociationStateTypeDef",
    {
        "State": Literal["associating", "associated", "disassociating", "disassociated", "failed"],
        "StatusMessage": str,
    },
    total=False,
)

ClientDescribeRouteTablesResponseRouteTablesAssociationsTypeDef = TypedDict(
    "ClientDescribeRouteTablesResponseRouteTablesAssociationsTypeDef",
    {
        "Main": bool,
        "RouteTableAssociationId": str,
        "RouteTableId": str,
        "SubnetId": str,
        "GatewayId": str,
        "AssociationState": ClientDescribeRouteTablesResponseRouteTablesAssociationsAssociationStateTypeDef,
    },
    total=False,
)

ClientDescribeRouteTablesResponseRouteTablesPropagatingVgwsTypeDef = TypedDict(
    "ClientDescribeRouteTablesResponseRouteTablesPropagatingVgwsTypeDef",
    {"GatewayId": str},
    total=False,
)

ClientDescribeRouteTablesResponseRouteTablesRoutesTypeDef = TypedDict(
    "ClientDescribeRouteTablesResponseRouteTablesRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "DestinationIpv6CidrBlock": str,
        "DestinationPrefixListId": str,
        "EgressOnlyInternetGatewayId": str,
        "GatewayId": str,
        "InstanceId": str,
        "InstanceOwnerId": str,
        "NatGatewayId": str,
        "TransitGatewayId": str,
        "LocalGatewayId": str,
        "NetworkInterfaceId": str,
        "Origin": Literal["CreateRouteTable", "CreateRoute", "EnableVgwRoutePropagation"],
        "State": Literal["active", "blackhole"],
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientDescribeRouteTablesResponseRouteTablesTagsTypeDef = TypedDict(
    "ClientDescribeRouteTablesResponseRouteTablesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeRouteTablesResponseRouteTablesTypeDef = TypedDict(
    "ClientDescribeRouteTablesResponseRouteTablesTypeDef",
    {
        "Associations": List[ClientDescribeRouteTablesResponseRouteTablesAssociationsTypeDef],
        "PropagatingVgws": List[ClientDescribeRouteTablesResponseRouteTablesPropagatingVgwsTypeDef],
        "RouteTableId": str,
        "Routes": List[ClientDescribeRouteTablesResponseRouteTablesRoutesTypeDef],
        "Tags": List[ClientDescribeRouteTablesResponseRouteTablesTagsTypeDef],
        "VpcId": str,
        "OwnerId": str,
    },
    total=False,
)

ClientDescribeRouteTablesResponseTypeDef = TypedDict(
    "ClientDescribeRouteTablesResponseTypeDef",
    {"RouteTables": List[ClientDescribeRouteTablesResponseRouteTablesTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeScheduledInstanceAvailabilityFiltersTypeDef = TypedDict(
    "ClientDescribeScheduledInstanceAvailabilityFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

_RequiredClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef = TypedDict(
    "_RequiredClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef",
    {"EarliestTime": datetime},
)
_OptionalClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef = TypedDict(
    "_OptionalClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef",
    {"LatestTime": datetime},
    total=False,
)


class ClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef(
    _RequiredClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef,
    _OptionalClientDescribeScheduledInstanceAvailabilityFirstSlotStartTimeRangeTypeDef,
):
    pass


ClientDescribeScheduledInstanceAvailabilityRecurrenceTypeDef = TypedDict(
    "ClientDescribeScheduledInstanceAvailabilityRecurrenceTypeDef",
    {
        "Frequency": str,
        "Interval": int,
        "OccurrenceDays": List[int],
        "OccurrenceRelativeToEnd": bool,
        "OccurrenceUnit": str,
    },
    total=False,
)

ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetRecurrenceTypeDef = TypedDict(
    "ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetRecurrenceTypeDef",
    {
        "Frequency": str,
        "Interval": int,
        "OccurrenceDaySet": List[int],
        "OccurrenceRelativeToEnd": bool,
        "OccurrenceUnit": str,
    },
    total=False,
)

ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetTypeDef = TypedDict(
    "ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetTypeDef",
    {
        "AvailabilityZone": str,
        "AvailableInstanceCount": int,
        "FirstSlotStartTime": datetime,
        "HourlyPrice": str,
        "InstanceType": str,
        "MaxTermDurationInDays": int,
        "MinTermDurationInDays": int,
        "NetworkPlatform": str,
        "Platform": str,
        "PurchaseToken": str,
        "Recurrence": ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetRecurrenceTypeDef,
        "SlotDurationInHours": int,
        "TotalScheduledInstanceHours": int,
    },
    total=False,
)

ClientDescribeScheduledInstanceAvailabilityResponseTypeDef = TypedDict(
    "ClientDescribeScheduledInstanceAvailabilityResponseTypeDef",
    {
        "NextToken": str,
        "ScheduledInstanceAvailabilitySet": List[
            ClientDescribeScheduledInstanceAvailabilityResponseScheduledInstanceAvailabilitySetTypeDef
        ],
    },
    total=False,
)

ClientDescribeScheduledInstancesFiltersTypeDef = TypedDict(
    "ClientDescribeScheduledInstancesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef = TypedDict(
    "ClientDescribeScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef",
    {
        "Frequency": str,
        "Interval": int,
        "OccurrenceDaySet": List[int],
        "OccurrenceRelativeToEnd": bool,
        "OccurrenceUnit": str,
    },
    total=False,
)

ClientDescribeScheduledInstancesResponseScheduledInstanceSetTypeDef = TypedDict(
    "ClientDescribeScheduledInstancesResponseScheduledInstanceSetTypeDef",
    {
        "AvailabilityZone": str,
        "CreateDate": datetime,
        "HourlyPrice": str,
        "InstanceCount": int,
        "InstanceType": str,
        "NetworkPlatform": str,
        "NextSlotStartTime": datetime,
        "Platform": str,
        "PreviousSlotEndTime": datetime,
        "Recurrence": ClientDescribeScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef,
        "ScheduledInstanceId": str,
        "SlotDurationInHours": int,
        "TermEndDate": datetime,
        "TermStartDate": datetime,
        "TotalScheduledInstanceHours": int,
    },
    total=False,
)

ClientDescribeScheduledInstancesResponseTypeDef = TypedDict(
    "ClientDescribeScheduledInstancesResponseTypeDef",
    {
        "NextToken": str,
        "ScheduledInstanceSet": List[
            ClientDescribeScheduledInstancesResponseScheduledInstanceSetTypeDef
        ],
    },
    total=False,
)

ClientDescribeScheduledInstancesSlotStartTimeRangeTypeDef = TypedDict(
    "ClientDescribeScheduledInstancesSlotStartTimeRangeTypeDef",
    {"EarliestTime": datetime, "LatestTime": datetime},
    total=False,
)

ClientDescribeSecurityGroupReferencesResponseSecurityGroupReferenceSetTypeDef = TypedDict(
    "ClientDescribeSecurityGroupReferencesResponseSecurityGroupReferenceSetTypeDef",
    {"GroupId": str, "ReferencingVpcId": str, "VpcPeeringConnectionId": str},
    total=False,
)

ClientDescribeSecurityGroupReferencesResponseTypeDef = TypedDict(
    "ClientDescribeSecurityGroupReferencesResponseTypeDef",
    {
        "SecurityGroupReferenceSet": List[
            ClientDescribeSecurityGroupReferencesResponseSecurityGroupReferenceSetTypeDef
        ]
    },
    total=False,
)

ClientDescribeSecurityGroupsFiltersTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpRangesTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpRangesTypeDef",
    {"CidrIp": str, "Description": str},
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpv6RangesTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpv6RangesTypeDef",
    {"CidrIpv6": str, "Description": str},
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressPrefixListIdsTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressPrefixListIdsTypeDef",
    {"Description": str, "PrefixListId": str},
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressUserIdGroupPairsTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpRangesTypeDef
        ],
        "Ipv6Ranges": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressIpv6RangesTypeDef
        ],
        "PrefixListIds": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressPrefixListIdsTypeDef
        ],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpRangesTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpRangesTypeDef",
    {"CidrIp": str, "Description": str},
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpv6RangesTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpv6RangesTypeDef",
    {"CidrIpv6": str, "Description": str},
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsPrefixListIdsTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsPrefixListIdsTypeDef",
    {"Description": str, "PrefixListId": str},
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsUserIdGroupPairsTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpRangesTypeDef
        ],
        "Ipv6Ranges": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsIpv6RangesTypeDef
        ],
        "PrefixListIds": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsPrefixListIdsTypeDef
        ],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsTagsTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeSecurityGroupsResponseSecurityGroupsTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseSecurityGroupsTypeDef",
    {
        "Description": str,
        "GroupName": str,
        "IpPermissions": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsTypeDef
        ],
        "OwnerId": str,
        "GroupId": str,
        "IpPermissionsEgress": List[
            ClientDescribeSecurityGroupsResponseSecurityGroupsIpPermissionsEgressTypeDef
        ],
        "Tags": List[ClientDescribeSecurityGroupsResponseSecurityGroupsTagsTypeDef],
        "VpcId": str,
    },
    total=False,
)

ClientDescribeSecurityGroupsResponseTypeDef = TypedDict(
    "ClientDescribeSecurityGroupsResponseTypeDef",
    {
        "SecurityGroups": List[ClientDescribeSecurityGroupsResponseSecurityGroupsTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeSnapshotAttributeResponseCreateVolumePermissionsTypeDef = TypedDict(
    "ClientDescribeSnapshotAttributeResponseCreateVolumePermissionsTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientDescribeSnapshotAttributeResponseProductCodesTypeDef = TypedDict(
    "ClientDescribeSnapshotAttributeResponseProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeSnapshotAttributeResponseTypeDef = TypedDict(
    "ClientDescribeSnapshotAttributeResponseTypeDef",
    {
        "CreateVolumePermissions": List[
            ClientDescribeSnapshotAttributeResponseCreateVolumePermissionsTypeDef
        ],
        "ProductCodes": List[ClientDescribeSnapshotAttributeResponseProductCodesTypeDef],
        "SnapshotId": str,
    },
    total=False,
)

ClientDescribeSnapshotsFiltersTypeDef = TypedDict(
    "ClientDescribeSnapshotsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeSnapshotsResponseSnapshotsTagsTypeDef = TypedDict(
    "ClientDescribeSnapshotsResponseSnapshotsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeSnapshotsResponseSnapshotsTypeDef = TypedDict(
    "ClientDescribeSnapshotsResponseSnapshotsTypeDef",
    {
        "DataEncryptionKeyId": str,
        "Description": str,
        "Encrypted": bool,
        "KmsKeyId": str,
        "OwnerId": str,
        "Progress": str,
        "SnapshotId": str,
        "StartTime": datetime,
        "State": Literal["pending", "completed", "error"],
        "StateMessage": str,
        "VolumeId": str,
        "VolumeSize": int,
        "OwnerAlias": str,
        "Tags": List[ClientDescribeSnapshotsResponseSnapshotsTagsTypeDef],
    },
    total=False,
)

ClientDescribeSnapshotsResponseTypeDef = TypedDict(
    "ClientDescribeSnapshotsResponseTypeDef",
    {"Snapshots": List[ClientDescribeSnapshotsResponseSnapshotsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef = TypedDict(
    "ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef = TypedDict(
    "ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef",
    {
        "Bucket": str,
        "Fault": ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionFaultTypeDef,
        "OwnerId": str,
        "Prefix": str,
        "State": Literal["Active", "Inactive"],
    },
    total=False,
)

ClientDescribeSpotDatafeedSubscriptionResponseTypeDef = TypedDict(
    "ClientDescribeSpotDatafeedSubscriptionResponseTypeDef",
    {
        "SpotDatafeedSubscription": ClientDescribeSpotDatafeedSubscriptionResponseSpotDatafeedSubscriptionTypeDef
    },
    total=False,
)

ClientDescribeSpotFleetInstancesResponseActiveInstancesTypeDef = TypedDict(
    "ClientDescribeSpotFleetInstancesResponseActiveInstancesTypeDef",
    {
        "InstanceId": str,
        "InstanceType": str,
        "SpotInstanceRequestId": str,
        "InstanceHealth": Literal["healthy", "unhealthy"],
    },
    total=False,
)

ClientDescribeSpotFleetInstancesResponseTypeDef = TypedDict(
    "ClientDescribeSpotFleetInstancesResponseTypeDef",
    {
        "ActiveInstances": List[ClientDescribeSpotFleetInstancesResponseActiveInstancesTypeDef],
        "NextToken": str,
        "SpotFleetRequestId": str,
    },
    total=False,
)

ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsEventInformationTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsEventInformationTypeDef",
    {"EventDescription": str, "EventSubType": str, "InstanceId": str},
    total=False,
)

ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsTypeDef",
    {
        "EventInformation": ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsEventInformationTypeDef,
        "EventType": Literal["instanceChange", "fleetRequestChange", "error", "information"],
        "Timestamp": datetime,
    },
    total=False,
)

ClientDescribeSpotFleetRequestHistoryResponseTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestHistoryResponseTypeDef",
    {
        "HistoryRecords": List[ClientDescribeSpotFleetRequestHistoryResponseHistoryRecordsTypeDef],
        "LastEvaluatedTime": datetime,
        "NextToken": str,
        "SpotFleetRequestId": str,
        "StartTime": datetime,
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef",
    {"AvailabilityZone": str, "GroupName": str, "Tenancy": Literal["default", "dedicated", "host"]},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTypeDef",
    {
        "SecurityGroups": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef
        ],
        "AddressingType": str,
        "BlockDeviceMappings": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef
        ],
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef,
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KernelId": str,
        "KeyName": str,
        "Monitoring": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef,
        "NetworkInterfaces": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef
        ],
        "Placement": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef,
        "RamdiskId": str,
        "SpotPrice": str,
        "SubnetId": str,
        "UserData": str,
        "WeightedCapacity": float,
        "TagSpecifications": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef
        ],
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "SpotPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsTypeDef",
    {
        "LaunchTemplateSpecification": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef,
        "Overrides": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef
        ],
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef",
    {"Name": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef",
    {
        "ClassicLoadBalancers": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef
        ]
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef",
    {"Arn": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef",
    {
        "TargetGroups": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef
        ]
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTypeDef",
    {
        "ClassicLoadBalancersConfig": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef,
        "TargetGroupsConfig": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef,
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTagsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTypeDef",
    {
        "AllocationStrategy": Literal["lowestPrice", "diversified", "capacityOptimized"],
        "OnDemandAllocationStrategy": Literal["lowestPrice", "prioritized"],
        "ClientToken": str,
        "ExcessCapacityTerminationPolicy": Literal["noTermination", "default"],
        "FulfilledCapacity": float,
        "OnDemandFulfilledCapacity": float,
        "IamFleetRole": str,
        "LaunchSpecifications": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchSpecificationsTypeDef
        ],
        "LaunchTemplateConfigs": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLaunchTemplateConfigsTypeDef
        ],
        "SpotPrice": str,
        "TargetCapacity": int,
        "OnDemandTargetCapacity": int,
        "OnDemandMaxTotalPrice": str,
        "SpotMaxTotalPrice": str,
        "TerminateInstancesWithExpiration": bool,
        "Type": Literal["request", "maintain", "instant"],
        "ValidFrom": datetime,
        "ValidUntil": datetime,
        "ReplaceUnhealthyInstances": bool,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
        "LoadBalancersConfig": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigLoadBalancersConfigTypeDef,
        "InstancePoolsToUseCount": int,
        "TagSpecifications": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTagSpecificationsTypeDef
        ],
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTagsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTypeDef",
    {
        "ActivityStatus": Literal[
            "error", "pending_fulfillment", "pending_termination", "fulfilled"
        ],
        "CreateTime": datetime,
        "SpotFleetRequestConfig": ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsSpotFleetRequestConfigTypeDef,
        "SpotFleetRequestId": str,
        "SpotFleetRequestState": Literal[
            "submitted",
            "active",
            "cancelled",
            "failed",
            "cancelled_running",
            "cancelled_terminating",
            "modifying",
        ],
        "Tags": List[ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTagsTypeDef],
    },
    total=False,
)

ClientDescribeSpotFleetRequestsResponseTypeDef = TypedDict(
    "ClientDescribeSpotFleetRequestsResponseTypeDef",
    {
        "NextToken": str,
        "SpotFleetRequestConfigs": List[
            ClientDescribeSpotFleetRequestsResponseSpotFleetRequestConfigsTypeDef
        ],
    },
    total=False,
)

ClientDescribeSpotInstanceRequestsFiltersTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsFaultTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsFaultTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef",
    {"AvailabilityZone": str, "GroupName": str, "Tenancy": Literal["default", "dedicated", "host"]},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationTypeDef",
    {
        "UserData": str,
        "SecurityGroups": List[
            ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef
        ],
        "AddressingType": str,
        "BlockDeviceMappings": List[
            ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef
        ],
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef,
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KernelId": str,
        "KeyName": str,
        "NetworkInterfaces": List[
            ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef
        ],
        "Placement": ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef,
        "RamdiskId": str,
        "SubnetId": str,
        "Monitoring": ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef,
    },
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsStatusTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsStatusTypeDef",
    {"Code": str, "Message": str, "UpdateTime": datetime},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTagsTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTypeDef",
    {
        "ActualBlockHourlyPrice": str,
        "AvailabilityZoneGroup": str,
        "BlockDurationMinutes": int,
        "CreateTime": datetime,
        "Fault": ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsFaultTypeDef,
        "InstanceId": str,
        "LaunchGroup": str,
        "LaunchSpecification": ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsLaunchSpecificationTypeDef,
        "LaunchedAvailabilityZone": str,
        "ProductDescription": Literal[
            "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
        ],
        "SpotInstanceRequestId": str,
        "SpotPrice": str,
        "State": Literal["open", "active", "closed", "cancelled", "failed"],
        "Status": ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsStatusTypeDef,
        "Tags": List[ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTagsTypeDef],
        "Type": Literal["one-time", "persistent"],
        "ValidFrom": datetime,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientDescribeSpotInstanceRequestsResponseTypeDef = TypedDict(
    "ClientDescribeSpotInstanceRequestsResponseTypeDef",
    {
        "SpotInstanceRequests": List[
            ClientDescribeSpotInstanceRequestsResponseSpotInstanceRequestsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeSpotPriceHistoryFiltersTypeDef = TypedDict(
    "ClientDescribeSpotPriceHistoryFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeSpotPriceHistoryResponseSpotPriceHistoryTypeDef = TypedDict(
    "ClientDescribeSpotPriceHistoryResponseSpotPriceHistoryTypeDef",
    {
        "AvailabilityZone": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "ProductDescription": Literal[
            "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
        ],
        "SpotPrice": str,
        "Timestamp": datetime,
    },
    total=False,
)

ClientDescribeSpotPriceHistoryResponseTypeDef = TypedDict(
    "ClientDescribeSpotPriceHistoryResponseTypeDef",
    {
        "NextToken": str,
        "SpotPriceHistory": List[ClientDescribeSpotPriceHistoryResponseSpotPriceHistoryTypeDef],
    },
    total=False,
)

ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressUserIdGroupPairsTypeDef = TypedDict(
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressTypeDef = TypedDict(
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[str],
        "PrefixListIds": List[str],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsUserIdGroupPairsTypeDef = TypedDict(
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsTypeDef = TypedDict(
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[str],
        "PrefixListIds": List[str],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetTypeDef = TypedDict(
    "ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "StaleIpPermissions": List[
            ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsTypeDef
        ],
        "StaleIpPermissionsEgress": List[
            ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetStaleIpPermissionsEgressTypeDef
        ],
        "VpcId": str,
    },
    total=False,
)

ClientDescribeStaleSecurityGroupsResponseTypeDef = TypedDict(
    "ClientDescribeStaleSecurityGroupsResponseTypeDef",
    {
        "NextToken": str,
        "StaleSecurityGroupSet": List[
            ClientDescribeStaleSecurityGroupsResponseStaleSecurityGroupSetTypeDef
        ],
    },
    total=False,
)

ClientDescribeSubnetsFiltersTypeDef = TypedDict(
    "ClientDescribeSubnetsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetTypeDef = TypedDict(
    "ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef,
    },
    total=False,
)

ClientDescribeSubnetsResponseSubnetsTagsTypeDef = TypedDict(
    "ClientDescribeSubnetsResponseSubnetsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeSubnetsResponseSubnetsTypeDef = TypedDict(
    "ClientDescribeSubnetsResponseSubnetsTypeDef",
    {
        "AvailabilityZone": str,
        "AvailabilityZoneId": str,
        "AvailableIpAddressCount": int,
        "CidrBlock": str,
        "DefaultForAz": bool,
        "MapPublicIpOnLaunch": bool,
        "State": Literal["pending", "available"],
        "SubnetId": str,
        "VpcId": str,
        "OwnerId": str,
        "AssignIpv6AddressOnCreation": bool,
        "Ipv6CidrBlockAssociationSet": List[
            ClientDescribeSubnetsResponseSubnetsIpv6CidrBlockAssociationSetTypeDef
        ],
        "Tags": List[ClientDescribeSubnetsResponseSubnetsTagsTypeDef],
        "SubnetArn": str,
        "OutpostArn": str,
    },
    total=False,
)

ClientDescribeSubnetsResponseTypeDef = TypedDict(
    "ClientDescribeSubnetsResponseTypeDef",
    {"Subnets": List[ClientDescribeSubnetsResponseSubnetsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeTagsFiltersTypeDef = TypedDict(
    "ClientDescribeTagsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeTagsResponseTagsTypeDef = TypedDict(
    "ClientDescribeTagsResponseTagsTypeDef",
    {
        "Key": str,
        "ResourceId": str,
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Value": str,
    },
    total=False,
)

ClientDescribeTagsResponseTypeDef = TypedDict(
    "ClientDescribeTagsResponseTypeDef",
    {"NextToken": str, "Tags": List[ClientDescribeTagsResponseTagsTypeDef]},
    total=False,
)

ClientDescribeTrafficMirrorFiltersFiltersTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesDestinationPortRangeTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesSourcePortRangeTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesDestinationPortRangeTypeDef,
        "SourcePortRange": ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesDestinationPortRangeTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesSourcePortRangeTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesDestinationPortRangeTypeDef,
        "SourcePortRange": ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTagsTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTypeDef",
    {
        "TrafficMirrorFilterId": str,
        "IngressFilterRules": List[
            ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersIngressFilterRulesTypeDef
        ],
        "EgressFilterRules": List[
            ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersEgressFilterRulesTypeDef
        ],
        "NetworkServices": List[str],
        "Description": str,
        "Tags": List[ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTagsTypeDef],
    },
    total=False,
)

ClientDescribeTrafficMirrorFiltersResponseTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorFiltersResponseTypeDef",
    {
        "TrafficMirrorFilters": List[
            ClientDescribeTrafficMirrorFiltersResponseTrafficMirrorFiltersTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTrafficMirrorSessionsFiltersTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorSessionsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTagsTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTypeDef",
    {
        "TrafficMirrorSessionId": str,
        "TrafficMirrorTargetId": str,
        "TrafficMirrorFilterId": str,
        "NetworkInterfaceId": str,
        "OwnerId": str,
        "PacketLength": int,
        "SessionNumber": int,
        "VirtualNetworkId": int,
        "Description": str,
        "Tags": List[ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTagsTypeDef],
    },
    total=False,
)

ClientDescribeTrafficMirrorSessionsResponseTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorSessionsResponseTypeDef",
    {
        "TrafficMirrorSessions": List[
            ClientDescribeTrafficMirrorSessionsResponseTrafficMirrorSessionsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTrafficMirrorTargetsFiltersTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorTargetsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTagsTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTypeDef",
    {
        "TrafficMirrorTargetId": str,
        "NetworkInterfaceId": str,
        "NetworkLoadBalancerArn": str,
        "Type": Literal["network-interface", "network-load-balancer"],
        "Description": str,
        "OwnerId": str,
        "Tags": List[ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTagsTypeDef],
    },
    total=False,
)

ClientDescribeTrafficMirrorTargetsResponseTypeDef = TypedDict(
    "ClientDescribeTrafficMirrorTargetsResponseTypeDef",
    {
        "TrafficMirrorTargets": List[
            ClientDescribeTrafficMirrorTargetsResponseTrafficMirrorTargetsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTransitGatewayAttachmentsFiltersTypeDef = TypedDict(
    "ClientDescribeTransitGatewayAttachmentsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsAssociationTypeDef = TypedDict(
    "ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsAssociationTypeDef",
    {
        "TransitGatewayRouteTableId": str,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
    },
    total=False,
)

ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTagsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "TransitGatewayId": str,
        "TransitGatewayOwnerId": str,
        "ResourceOwnerId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "ResourceId": str,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "Association": ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsAssociationTypeDef,
        "CreationTime": datetime,
        "Tags": List[
            ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeTransitGatewayAttachmentsResponseTypeDef = TypedDict(
    "ClientDescribeTransitGatewayAttachmentsResponseTypeDef",
    {
        "TransitGatewayAttachments": List[
            ClientDescribeTransitGatewayAttachmentsResponseTransitGatewayAttachmentsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTransitGatewayMulticastDomainsFiltersTypeDef = TypedDict(
    "ClientDescribeTransitGatewayMulticastDomainsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTagsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "TransitGatewayId": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "CreationTime": datetime,
        "Tags": List[
            ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeTransitGatewayMulticastDomainsResponseTypeDef = TypedDict(
    "ClientDescribeTransitGatewayMulticastDomainsResponseTypeDef",
    {
        "TransitGatewayMulticastDomains": List[
            ClientDescribeTransitGatewayMulticastDomainsResponseTransitGatewayMulticastDomainsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTransitGatewayPeeringAttachmentsFiltersTypeDef = TypedDict(
    "ClientDescribeTransitGatewayPeeringAttachmentsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsAccepterTgwInfoTypeDef = TypedDict(
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsAccepterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsRequesterTgwInfoTypeDef = TypedDict(
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsRequesterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsStatusTypeDef = TypedDict(
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsStatusTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTagsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "RequesterTgwInfo": ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsRequesterTgwInfoTypeDef,
        "AccepterTgwInfo": ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsAccepterTgwInfoTypeDef,
        "Status": ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsStatusTypeDef,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "CreationTime": datetime,
        "Tags": List[
            ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeTransitGatewayPeeringAttachmentsResponseTypeDef = TypedDict(
    "ClientDescribeTransitGatewayPeeringAttachmentsResponseTypeDef",
    {
        "TransitGatewayPeeringAttachments": List[
            ClientDescribeTransitGatewayPeeringAttachmentsResponseTransitGatewayPeeringAttachmentsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTransitGatewayRouteTablesFiltersTypeDef = TypedDict(
    "ClientDescribeTransitGatewayRouteTablesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTagsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTypeDef = TypedDict(
    "ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTypeDef",
    {
        "TransitGatewayRouteTableId": str,
        "TransitGatewayId": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "DefaultAssociationRouteTable": bool,
        "DefaultPropagationRouteTable": bool,
        "CreationTime": datetime,
        "Tags": List[
            ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeTransitGatewayRouteTablesResponseTypeDef = TypedDict(
    "ClientDescribeTransitGatewayRouteTablesResponseTypeDef",
    {
        "TransitGatewayRouteTables": List[
            ClientDescribeTransitGatewayRouteTablesResponseTransitGatewayRouteTablesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTransitGatewayVpcAttachmentsFiltersTypeDef = TypedDict(
    "ClientDescribeTransitGatewayVpcAttachmentsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsOptionsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTagsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTypeDef = TypedDict(
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "TransitGatewayId": str,
        "VpcId": str,
        "VpcOwnerId": str,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "SubnetIds": List[str],
        "CreationTime": datetime,
        "Options": ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsOptionsTypeDef,
        "Tags": List[
            ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeTransitGatewayVpcAttachmentsResponseTypeDef = TypedDict(
    "ClientDescribeTransitGatewayVpcAttachmentsResponseTypeDef",
    {
        "TransitGatewayVpcAttachments": List[
            ClientDescribeTransitGatewayVpcAttachmentsResponseTransitGatewayVpcAttachmentsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeTransitGatewaysFiltersTypeDef = TypedDict(
    "ClientDescribeTransitGatewaysFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeTransitGatewaysResponseTransitGatewaysOptionsTypeDef = TypedDict(
    "ClientDescribeTransitGatewaysResponseTransitGatewaysOptionsTypeDef",
    {
        "AmazonSideAsn": int,
        "AutoAcceptSharedAttachments": Literal["enable", "disable"],
        "DefaultRouteTableAssociation": Literal["enable", "disable"],
        "AssociationDefaultRouteTableId": str,
        "DefaultRouteTablePropagation": Literal["enable", "disable"],
        "PropagationDefaultRouteTableId": str,
        "VpnEcmpSupport": Literal["enable", "disable"],
        "DnsSupport": Literal["enable", "disable"],
        "MulticastSupport": Literal["enable", "disable"],
    },
    total=False,
)

ClientDescribeTransitGatewaysResponseTransitGatewaysTagsTypeDef = TypedDict(
    "ClientDescribeTransitGatewaysResponseTransitGatewaysTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeTransitGatewaysResponseTransitGatewaysTypeDef = TypedDict(
    "ClientDescribeTransitGatewaysResponseTransitGatewaysTypeDef",
    {
        "TransitGatewayId": str,
        "TransitGatewayArn": str,
        "State": Literal["pending", "available", "modifying", "deleting", "deleted"],
        "OwnerId": str,
        "Description": str,
        "CreationTime": datetime,
        "Options": ClientDescribeTransitGatewaysResponseTransitGatewaysOptionsTypeDef,
        "Tags": List[ClientDescribeTransitGatewaysResponseTransitGatewaysTagsTypeDef],
    },
    total=False,
)

ClientDescribeTransitGatewaysResponseTypeDef = TypedDict(
    "ClientDescribeTransitGatewaysResponseTypeDef",
    {
        "TransitGateways": List[ClientDescribeTransitGatewaysResponseTransitGatewaysTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVolumeAttributeResponseAutoEnableIOTypeDef = TypedDict(
    "ClientDescribeVolumeAttributeResponseAutoEnableIOTypeDef", {"Value": bool}, total=False
)

ClientDescribeVolumeAttributeResponseProductCodesTypeDef = TypedDict(
    "ClientDescribeVolumeAttributeResponseProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientDescribeVolumeAttributeResponseTypeDef = TypedDict(
    "ClientDescribeVolumeAttributeResponseTypeDef",
    {
        "AutoEnableIO": ClientDescribeVolumeAttributeResponseAutoEnableIOTypeDef,
        "ProductCodes": List[ClientDescribeVolumeAttributeResponseProductCodesTypeDef],
        "VolumeId": str,
    },
    total=False,
)

ClientDescribeVolumeStatusFiltersTypeDef = TypedDict(
    "ClientDescribeVolumeStatusFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeVolumeStatusResponseVolumeStatusesActionsTypeDef = TypedDict(
    "ClientDescribeVolumeStatusResponseVolumeStatusesActionsTypeDef",
    {"Code": str, "Description": str, "EventId": str, "EventType": str},
    total=False,
)

ClientDescribeVolumeStatusResponseVolumeStatusesAttachmentStatusesTypeDef = TypedDict(
    "ClientDescribeVolumeStatusResponseVolumeStatusesAttachmentStatusesTypeDef",
    {"IoPerformance": str, "InstanceId": str},
    total=False,
)

ClientDescribeVolumeStatusResponseVolumeStatusesEventsTypeDef = TypedDict(
    "ClientDescribeVolumeStatusResponseVolumeStatusesEventsTypeDef",
    {
        "Description": str,
        "EventId": str,
        "EventType": str,
        "NotAfter": datetime,
        "NotBefore": datetime,
        "InstanceId": str,
    },
    total=False,
)

ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusDetailsTypeDef = TypedDict(
    "ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusDetailsTypeDef",
    {"Name": Literal["io-enabled", "io-performance"], "Status": str},
    total=False,
)

ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusTypeDef = TypedDict(
    "ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusTypeDef",
    {
        "Details": List[ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusDetailsTypeDef],
        "Status": Literal["ok", "impaired", "insufficient-data"],
    },
    total=False,
)

ClientDescribeVolumeStatusResponseVolumeStatusesTypeDef = TypedDict(
    "ClientDescribeVolumeStatusResponseVolumeStatusesTypeDef",
    {
        "Actions": List[ClientDescribeVolumeStatusResponseVolumeStatusesActionsTypeDef],
        "AvailabilityZone": str,
        "OutpostArn": str,
        "Events": List[ClientDescribeVolumeStatusResponseVolumeStatusesEventsTypeDef],
        "VolumeId": str,
        "VolumeStatus": ClientDescribeVolumeStatusResponseVolumeStatusesVolumeStatusTypeDef,
        "AttachmentStatuses": List[
            ClientDescribeVolumeStatusResponseVolumeStatusesAttachmentStatusesTypeDef
        ],
    },
    total=False,
)

ClientDescribeVolumeStatusResponseTypeDef = TypedDict(
    "ClientDescribeVolumeStatusResponseTypeDef",
    {
        "NextToken": str,
        "VolumeStatuses": List[ClientDescribeVolumeStatusResponseVolumeStatusesTypeDef],
    },
    total=False,
)

ClientDescribeVolumesFiltersTypeDef = TypedDict(
    "ClientDescribeVolumesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeVolumesModificationsFiltersTypeDef = TypedDict(
    "ClientDescribeVolumesModificationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeVolumesModificationsResponseVolumesModificationsTypeDef = TypedDict(
    "ClientDescribeVolumesModificationsResponseVolumesModificationsTypeDef",
    {
        "VolumeId": str,
        "ModificationState": Literal["modifying", "optimizing", "completed", "failed"],
        "StatusMessage": str,
        "TargetSize": int,
        "TargetIops": int,
        "TargetVolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "OriginalSize": int,
        "OriginalIops": int,
        "OriginalVolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "Progress": int,
        "StartTime": datetime,
        "EndTime": datetime,
    },
    total=False,
)

ClientDescribeVolumesModificationsResponseTypeDef = TypedDict(
    "ClientDescribeVolumesModificationsResponseTypeDef",
    {
        "VolumesModifications": List[
            ClientDescribeVolumesModificationsResponseVolumesModificationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVolumesResponseVolumesAttachmentsTypeDef = TypedDict(
    "ClientDescribeVolumesResponseVolumesAttachmentsTypeDef",
    {
        "AttachTime": datetime,
        "Device": str,
        "InstanceId": str,
        "State": Literal["attaching", "attached", "detaching", "detached", "busy"],
        "VolumeId": str,
        "DeleteOnTermination": bool,
    },
    total=False,
)

ClientDescribeVolumesResponseVolumesTagsTypeDef = TypedDict(
    "ClientDescribeVolumesResponseVolumesTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeVolumesResponseVolumesTypeDef = TypedDict(
    "ClientDescribeVolumesResponseVolumesTypeDef",
    {
        "Attachments": List[ClientDescribeVolumesResponseVolumesAttachmentsTypeDef],
        "AvailabilityZone": str,
        "CreateTime": datetime,
        "Encrypted": bool,
        "KmsKeyId": str,
        "OutpostArn": str,
        "Size": int,
        "SnapshotId": str,
        "State": Literal["creating", "available", "in-use", "deleting", "deleted", "error"],
        "VolumeId": str,
        "Iops": int,
        "Tags": List[ClientDescribeVolumesResponseVolumesTagsTypeDef],
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "FastRestored": bool,
        "MultiAttachEnabled": bool,
    },
    total=False,
)

ClientDescribeVolumesResponseTypeDef = TypedDict(
    "ClientDescribeVolumesResponseTypeDef",
    {"Volumes": List[ClientDescribeVolumesResponseVolumesTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeVpcAttributeResponseEnableDnsHostnamesTypeDef = TypedDict(
    "ClientDescribeVpcAttributeResponseEnableDnsHostnamesTypeDef", {"Value": bool}, total=False
)

ClientDescribeVpcAttributeResponseEnableDnsSupportTypeDef = TypedDict(
    "ClientDescribeVpcAttributeResponseEnableDnsSupportTypeDef", {"Value": bool}, total=False
)

ClientDescribeVpcAttributeResponseTypeDef = TypedDict(
    "ClientDescribeVpcAttributeResponseTypeDef",
    {
        "VpcId": str,
        "EnableDnsHostnames": ClientDescribeVpcAttributeResponseEnableDnsHostnamesTypeDef,
        "EnableDnsSupport": ClientDescribeVpcAttributeResponseEnableDnsSupportTypeDef,
    },
    total=False,
)

ClientDescribeVpcClassicLinkDnsSupportResponseVpcsTypeDef = TypedDict(
    "ClientDescribeVpcClassicLinkDnsSupportResponseVpcsTypeDef",
    {"ClassicLinkDnsSupported": bool, "VpcId": str},
    total=False,
)

ClientDescribeVpcClassicLinkDnsSupportResponseTypeDef = TypedDict(
    "ClientDescribeVpcClassicLinkDnsSupportResponseTypeDef",
    {"NextToken": str, "Vpcs": List[ClientDescribeVpcClassicLinkDnsSupportResponseVpcsTypeDef]},
    total=False,
)

ClientDescribeVpcClassicLinkFiltersTypeDef = TypedDict(
    "ClientDescribeVpcClassicLinkFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeVpcClassicLinkResponseVpcsTagsTypeDef = TypedDict(
    "ClientDescribeVpcClassicLinkResponseVpcsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeVpcClassicLinkResponseVpcsTypeDef = TypedDict(
    "ClientDescribeVpcClassicLinkResponseVpcsTypeDef",
    {
        "ClassicLinkEnabled": bool,
        "Tags": List[ClientDescribeVpcClassicLinkResponseVpcsTagsTypeDef],
        "VpcId": str,
    },
    total=False,
)

ClientDescribeVpcClassicLinkResponseTypeDef = TypedDict(
    "ClientDescribeVpcClassicLinkResponseTypeDef",
    {"Vpcs": List[ClientDescribeVpcClassicLinkResponseVpcsTypeDef]},
    total=False,
)

ClientDescribeVpcEndpointConnectionNotificationsFiltersTypeDef = TypedDict(
    "ClientDescribeVpcEndpointConnectionNotificationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeVpcEndpointConnectionNotificationsResponseConnectionNotificationSetTypeDef = TypedDict(
    "ClientDescribeVpcEndpointConnectionNotificationsResponseConnectionNotificationSetTypeDef",
    {
        "ConnectionNotificationId": str,
        "ServiceId": str,
        "VpcEndpointId": str,
        "ConnectionNotificationType": str,
        "ConnectionNotificationArn": str,
        "ConnectionEvents": List[str],
        "ConnectionNotificationState": Literal["Enabled", "Disabled"],
    },
    total=False,
)

ClientDescribeVpcEndpointConnectionNotificationsResponseTypeDef = TypedDict(
    "ClientDescribeVpcEndpointConnectionNotificationsResponseTypeDef",
    {
        "ConnectionNotificationSet": List[
            ClientDescribeVpcEndpointConnectionNotificationsResponseConnectionNotificationSetTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVpcEndpointConnectionsFiltersTypeDef = TypedDict(
    "ClientDescribeVpcEndpointConnectionsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsDnsEntriesTypeDef = TypedDict(
    "ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsDnsEntriesTypeDef",
    {"DnsName": str, "HostedZoneId": str},
    total=False,
)

ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsTypeDef",
    {
        "ServiceId": str,
        "VpcEndpointId": str,
        "VpcEndpointOwner": str,
        "VpcEndpointState": Literal[
            "PendingAcceptance",
            "Pending",
            "Available",
            "Deleting",
            "Deleted",
            "Rejected",
            "Failed",
            "Expired",
        ],
        "CreationTimestamp": datetime,
        "DnsEntries": List[
            ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsDnsEntriesTypeDef
        ],
        "NetworkLoadBalancerArns": List[str],
    },
    total=False,
)

ClientDescribeVpcEndpointConnectionsResponseTypeDef = TypedDict(
    "ClientDescribeVpcEndpointConnectionsResponseTypeDef",
    {
        "VpcEndpointConnections": List[
            ClientDescribeVpcEndpointConnectionsResponseVpcEndpointConnectionsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVpcEndpointServiceConfigurationsFiltersTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServiceConfigurationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsPrivateDnsNameConfigurationTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsPrivateDnsNameConfigurationTypeDef",
    {
        "State": Literal["pendingVerification", "verified", "failed"],
        "Type": str,
        "Value": str,
        "Name": str,
    },
    total=False,
)

ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsServiceTypeTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsServiceTypeTypeDef",
    {"ServiceType": Literal["Interface", "Gateway"]},
    total=False,
)

ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTagsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTypeDef",
    {
        "ServiceType": List[
            ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsServiceTypeTypeDef
        ],
        "ServiceId": str,
        "ServiceName": str,
        "ServiceState": Literal["Pending", "Available", "Deleting", "Deleted", "Failed"],
        "AvailabilityZones": List[str],
        "AcceptanceRequired": bool,
        "ManagesVpcEndpoints": bool,
        "NetworkLoadBalancerArns": List[str],
        "BaseEndpointDnsNames": List[str],
        "PrivateDnsName": str,
        "PrivateDnsNameConfiguration": ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsPrivateDnsNameConfigurationTypeDef,
        "Tags": List[
            ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTagsTypeDef
        ],
    },
    total=False,
)

ClientDescribeVpcEndpointServiceConfigurationsResponseTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServiceConfigurationsResponseTypeDef",
    {
        "ServiceConfigurations": List[
            ClientDescribeVpcEndpointServiceConfigurationsResponseServiceConfigurationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVpcEndpointServicePermissionsFiltersTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicePermissionsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeVpcEndpointServicePermissionsResponseAllowedPrincipalsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicePermissionsResponseAllowedPrincipalsTypeDef",
    {
        "PrincipalType": Literal["All", "Service", "OrganizationUnit", "Account", "User", "Role"],
        "Principal": str,
    },
    total=False,
)

ClientDescribeVpcEndpointServicePermissionsResponseTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicePermissionsResponseTypeDef",
    {
        "AllowedPrincipals": List[
            ClientDescribeVpcEndpointServicePermissionsResponseAllowedPrincipalsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVpcEndpointServicesFiltersTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeVpcEndpointServicesResponseServiceDetailsServiceTypeTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicesResponseServiceDetailsServiceTypeTypeDef",
    {"ServiceType": Literal["Interface", "Gateway"]},
    total=False,
)

ClientDescribeVpcEndpointServicesResponseServiceDetailsTagsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicesResponseServiceDetailsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeVpcEndpointServicesResponseServiceDetailsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicesResponseServiceDetailsTypeDef",
    {
        "ServiceName": str,
        "ServiceId": str,
        "ServiceType": List[
            ClientDescribeVpcEndpointServicesResponseServiceDetailsServiceTypeTypeDef
        ],
        "AvailabilityZones": List[str],
        "Owner": str,
        "BaseEndpointDnsNames": List[str],
        "PrivateDnsName": str,
        "VpcEndpointPolicySupported": bool,
        "AcceptanceRequired": bool,
        "ManagesVpcEndpoints": bool,
        "Tags": List[ClientDescribeVpcEndpointServicesResponseServiceDetailsTagsTypeDef],
        "PrivateDnsNameVerificationState": Literal["pendingVerification", "verified", "failed"],
    },
    total=False,
)

ClientDescribeVpcEndpointServicesResponseTypeDef = TypedDict(
    "ClientDescribeVpcEndpointServicesResponseTypeDef",
    {
        "ServiceNames": List[str],
        "ServiceDetails": List[ClientDescribeVpcEndpointServicesResponseServiceDetailsTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVpcEndpointsFiltersTypeDef = TypedDict(
    "ClientDescribeVpcEndpointsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeVpcEndpointsResponseVpcEndpointsDnsEntriesTypeDef = TypedDict(
    "ClientDescribeVpcEndpointsResponseVpcEndpointsDnsEntriesTypeDef",
    {"DnsName": str, "HostedZoneId": str},
    total=False,
)

ClientDescribeVpcEndpointsResponseVpcEndpointsGroupsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointsResponseVpcEndpointsGroupsTypeDef",
    {"GroupId": str, "GroupName": str},
    total=False,
)

ClientDescribeVpcEndpointsResponseVpcEndpointsLastErrorTypeDef = TypedDict(
    "ClientDescribeVpcEndpointsResponseVpcEndpointsLastErrorTypeDef",
    {"Message": str, "Code": str},
    total=False,
)

ClientDescribeVpcEndpointsResponseVpcEndpointsTagsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointsResponseVpcEndpointsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeVpcEndpointsResponseVpcEndpointsTypeDef = TypedDict(
    "ClientDescribeVpcEndpointsResponseVpcEndpointsTypeDef",
    {
        "VpcEndpointId": str,
        "VpcEndpointType": Literal["Interface", "Gateway"],
        "VpcId": str,
        "ServiceName": str,
        "State": Literal[
            "PendingAcceptance",
            "Pending",
            "Available",
            "Deleting",
            "Deleted",
            "Rejected",
            "Failed",
            "Expired",
        ],
        "PolicyDocument": str,
        "RouteTableIds": List[str],
        "SubnetIds": List[str],
        "Groups": List[ClientDescribeVpcEndpointsResponseVpcEndpointsGroupsTypeDef],
        "PrivateDnsEnabled": bool,
        "RequesterManaged": bool,
        "NetworkInterfaceIds": List[str],
        "DnsEntries": List[ClientDescribeVpcEndpointsResponseVpcEndpointsDnsEntriesTypeDef],
        "CreationTimestamp": datetime,
        "Tags": List[ClientDescribeVpcEndpointsResponseVpcEndpointsTagsTypeDef],
        "OwnerId": str,
        "LastError": ClientDescribeVpcEndpointsResponseVpcEndpointsLastErrorTypeDef,
    },
    total=False,
)

ClientDescribeVpcEndpointsResponseTypeDef = TypedDict(
    "ClientDescribeVpcEndpointsResponseTypeDef",
    {"VpcEndpoints": List[ClientDescribeVpcEndpointsResponseVpcEndpointsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeVpcPeeringConnectionsFiltersTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoCidrBlockSetTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoCidrBlockSetTypeDef",
    {"CidrBlock": str},
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoIpv6CidrBlockSetTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoIpv6CidrBlockSetTypeDef",
    {"Ipv6CidrBlock": str},
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoPeeringOptionsTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoPeeringOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoTypeDef",
    {
        "CidrBlock": str,
        "Ipv6CidrBlockSet": List[
            ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoIpv6CidrBlockSetTypeDef
        ],
        "CidrBlockSet": List[
            ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoCidrBlockSetTypeDef
        ],
        "OwnerId": str,
        "PeeringOptions": ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoPeeringOptionsTypeDef,
        "VpcId": str,
        "Region": str,
    },
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoCidrBlockSetTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoCidrBlockSetTypeDef",
    {"CidrBlock": str},
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoIpv6CidrBlockSetTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoIpv6CidrBlockSetTypeDef",
    {"Ipv6CidrBlock": str},
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoPeeringOptionsTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoPeeringOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoTypeDef",
    {
        "CidrBlock": str,
        "Ipv6CidrBlockSet": List[
            ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoIpv6CidrBlockSetTypeDef
        ],
        "CidrBlockSet": List[
            ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoCidrBlockSetTypeDef
        ],
        "OwnerId": str,
        "PeeringOptions": ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoPeeringOptionsTypeDef,
        "VpcId": str,
        "Region": str,
    },
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsStatusTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsStatusTypeDef",
    {
        "Code": Literal[
            "initiating-request",
            "pending-acceptance",
            "active",
            "deleted",
            "rejected",
            "failed",
            "expired",
            "provisioning",
            "deleting",
        ],
        "Message": str,
    },
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTagsTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTypeDef",
    {
        "AccepterVpcInfo": ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsAccepterVpcInfoTypeDef,
        "ExpirationTime": datetime,
        "RequesterVpcInfo": ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsRequesterVpcInfoTypeDef,
        "Status": ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsStatusTypeDef,
        "Tags": List[ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTagsTypeDef],
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientDescribeVpcPeeringConnectionsResponseTypeDef = TypedDict(
    "ClientDescribeVpcPeeringConnectionsResponseTypeDef",
    {
        "VpcPeeringConnections": List[
            ClientDescribeVpcPeeringConnectionsResponseVpcPeeringConnectionsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientDescribeVpcsFiltersTypeDef = TypedDict(
    "ClientDescribeVpcsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetCidrBlockStateTypeDef = TypedDict(
    "ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetCidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetTypeDef = TypedDict(
    "ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "CidrBlock": str,
        "CidrBlockState": ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetCidrBlockStateTypeDef,
    },
    total=False,
)

ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetTypeDef = TypedDict(
    "ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetIpv6CidrBlockStateTypeDef,
        "NetworkBorderGroup": str,
        "Ipv6Pool": str,
    },
    total=False,
)

ClientDescribeVpcsResponseVpcsTagsTypeDef = TypedDict(
    "ClientDescribeVpcsResponseVpcsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientDescribeVpcsResponseVpcsTypeDef = TypedDict(
    "ClientDescribeVpcsResponseVpcsTypeDef",
    {
        "CidrBlock": str,
        "DhcpOptionsId": str,
        "State": Literal["pending", "available"],
        "VpcId": str,
        "OwnerId": str,
        "InstanceTenancy": Literal["default", "dedicated", "host"],
        "Ipv6CidrBlockAssociationSet": List[
            ClientDescribeVpcsResponseVpcsIpv6CidrBlockAssociationSetTypeDef
        ],
        "CidrBlockAssociationSet": List[
            ClientDescribeVpcsResponseVpcsCidrBlockAssociationSetTypeDef
        ],
        "IsDefault": bool,
        "Tags": List[ClientDescribeVpcsResponseVpcsTagsTypeDef],
    },
    total=False,
)

ClientDescribeVpcsResponseTypeDef = TypedDict(
    "ClientDescribeVpcsResponseTypeDef",
    {"Vpcs": List[ClientDescribeVpcsResponseVpcsTypeDef], "NextToken": str},
    total=False,
)

ClientDescribeVpnConnectionsFiltersTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsIkeVersionsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsIkeVersionsTypeDef",
    {"Value": str},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsTypeDef",
    {
        "OutsideIpAddress": str,
        "TunnelInsideCidr": str,
        "PreSharedKey": str,
        "Phase1LifetimeSeconds": int,
        "Phase2LifetimeSeconds": int,
        "RekeyMarginTimeSeconds": int,
        "RekeyFuzzPercentage": int,
        "ReplayWindowSize": int,
        "DpdTimeoutSeconds": int,
        "Phase1EncryptionAlgorithms": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef
        ],
        "Phase2EncryptionAlgorithms": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef
        ],
        "Phase1IntegrityAlgorithms": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef
        ],
        "Phase2IntegrityAlgorithms": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef
        ],
        "Phase1DHGroupNumbers": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef
        ],
        "Phase2DHGroupNumbers": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef
        ],
        "IkeVersions": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsIkeVersionsTypeDef
        ],
    },
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTypeDef",
    {
        "EnableAcceleration": bool,
        "StaticRoutesOnly": bool,
        "TunnelOptions": List[
            ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTunnelOptionsTypeDef
        ],
    },
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsRoutesTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "Source": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
    },
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsTagsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsVgwTelemetryTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsVgwTelemetryTypeDef",
    {
        "AcceptedRouteCount": int,
        "LastStatusChange": datetime,
        "OutsideIpAddress": str,
        "Status": Literal["UP", "DOWN"],
        "StatusMessage": str,
        "CertificateArn": str,
    },
    total=False,
)

ClientDescribeVpnConnectionsResponseVpnConnectionsTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseVpnConnectionsTypeDef",
    {
        "CustomerGatewayConfiguration": str,
        "CustomerGatewayId": str,
        "Category": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Type": str,
        "VpnConnectionId": str,
        "VpnGatewayId": str,
        "TransitGatewayId": str,
        "Options": ClientDescribeVpnConnectionsResponseVpnConnectionsOptionsTypeDef,
        "Routes": List[ClientDescribeVpnConnectionsResponseVpnConnectionsRoutesTypeDef],
        "Tags": List[ClientDescribeVpnConnectionsResponseVpnConnectionsTagsTypeDef],
        "VgwTelemetry": List[ClientDescribeVpnConnectionsResponseVpnConnectionsVgwTelemetryTypeDef],
    },
    total=False,
)

ClientDescribeVpnConnectionsResponseTypeDef = TypedDict(
    "ClientDescribeVpnConnectionsResponseTypeDef",
    {"VpnConnections": List[ClientDescribeVpnConnectionsResponseVpnConnectionsTypeDef]},
    total=False,
)

ClientDescribeVpnGatewaysFiltersTypeDef = TypedDict(
    "ClientDescribeVpnGatewaysFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientDescribeVpnGatewaysResponseVpnGatewaysTagsTypeDef = TypedDict(
    "ClientDescribeVpnGatewaysResponseVpnGatewaysTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientDescribeVpnGatewaysResponseVpnGatewaysVpcAttachmentsTypeDef = TypedDict(
    "ClientDescribeVpnGatewaysResponseVpnGatewaysVpcAttachmentsTypeDef",
    {"State": Literal["attaching", "attached", "detaching", "detached"], "VpcId": str},
    total=False,
)

ClientDescribeVpnGatewaysResponseVpnGatewaysTypeDef = TypedDict(
    "ClientDescribeVpnGatewaysResponseVpnGatewaysTypeDef",
    {
        "AvailabilityZone": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Type": str,
        "VpcAttachments": List[ClientDescribeVpnGatewaysResponseVpnGatewaysVpcAttachmentsTypeDef],
        "VpnGatewayId": str,
        "AmazonSideAsn": int,
        "Tags": List[ClientDescribeVpnGatewaysResponseVpnGatewaysTagsTypeDef],
    },
    total=False,
)

ClientDescribeVpnGatewaysResponseTypeDef = TypedDict(
    "ClientDescribeVpnGatewaysResponseTypeDef",
    {"VpnGateways": List[ClientDescribeVpnGatewaysResponseVpnGatewaysTypeDef]},
    total=False,
)

ClientDetachClassicLinkVpcResponseTypeDef = TypedDict(
    "ClientDetachClassicLinkVpcResponseTypeDef", {"Return": bool}, total=False
)

ClientDetachVolumeResponseTypeDef = TypedDict(
    "ClientDetachVolumeResponseTypeDef",
    {
        "AttachTime": datetime,
        "Device": str,
        "InstanceId": str,
        "State": Literal["attaching", "attached", "detaching", "detached", "busy"],
        "VolumeId": str,
        "DeleteOnTermination": bool,
    },
    total=False,
)

ClientDisableEbsEncryptionByDefaultResponseTypeDef = TypedDict(
    "ClientDisableEbsEncryptionByDefaultResponseTypeDef",
    {"EbsEncryptionByDefault": bool},
    total=False,
)

ClientDisableFastSnapshotRestoresResponseSuccessfulTypeDef = TypedDict(
    "ClientDisableFastSnapshotRestoresResponseSuccessfulTypeDef",
    {
        "SnapshotId": str,
        "AvailabilityZone": str,
        "State": Literal["enabling", "optimizing", "enabled", "disabling", "disabled"],
        "StateTransitionReason": str,
        "OwnerId": str,
        "OwnerAlias": str,
        "EnablingTime": datetime,
        "OptimizingTime": datetime,
        "EnabledTime": datetime,
        "DisablingTime": datetime,
        "DisabledTime": datetime,
    },
    total=False,
)

ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef = TypedDict(
    "ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef = TypedDict(
    "ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef",
    {
        "AvailabilityZone": str,
        "Error": ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef,
    },
    total=False,
)

ClientDisableFastSnapshotRestoresResponseUnsuccessfulTypeDef = TypedDict(
    "ClientDisableFastSnapshotRestoresResponseUnsuccessfulTypeDef",
    {
        "SnapshotId": str,
        "FastSnapshotRestoreStateErrors": List[
            ClientDisableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef
        ],
    },
    total=False,
)

ClientDisableFastSnapshotRestoresResponseTypeDef = TypedDict(
    "ClientDisableFastSnapshotRestoresResponseTypeDef",
    {
        "Successful": List[ClientDisableFastSnapshotRestoresResponseSuccessfulTypeDef],
        "Unsuccessful": List[ClientDisableFastSnapshotRestoresResponseUnsuccessfulTypeDef],
    },
    total=False,
)

ClientDisableTransitGatewayRouteTablePropagationResponsePropagationTypeDef = TypedDict(
    "ClientDisableTransitGatewayRouteTablePropagationResponsePropagationTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "TransitGatewayRouteTableId": str,
        "State": Literal["enabling", "enabled", "disabling", "disabled"],
    },
    total=False,
)

ClientDisableTransitGatewayRouteTablePropagationResponseTypeDef = TypedDict(
    "ClientDisableTransitGatewayRouteTablePropagationResponseTypeDef",
    {"Propagation": ClientDisableTransitGatewayRouteTablePropagationResponsePropagationTypeDef},
    total=False,
)

ClientDisableVpcClassicLinkDnsSupportResponseTypeDef = TypedDict(
    "ClientDisableVpcClassicLinkDnsSupportResponseTypeDef", {"Return": bool}, total=False
)

ClientDisableVpcClassicLinkResponseTypeDef = TypedDict(
    "ClientDisableVpcClassicLinkResponseTypeDef", {"Return": bool}, total=False
)

ClientDisassociateClientVpnTargetNetworkResponseStatusTypeDef = TypedDict(
    "ClientDisassociateClientVpnTargetNetworkResponseStatusTypeDef",
    {
        "Code": Literal[
            "associating", "associated", "association-failed", "disassociating", "disassociated"
        ],
        "Message": str,
    },
    total=False,
)

ClientDisassociateClientVpnTargetNetworkResponseTypeDef = TypedDict(
    "ClientDisassociateClientVpnTargetNetworkResponseTypeDef",
    {"AssociationId": str, "Status": ClientDisassociateClientVpnTargetNetworkResponseStatusTypeDef},
    total=False,
)

ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef = TypedDict(
    "ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    {"Arn": str, "Id": str},
    total=False,
)

ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef = TypedDict(
    "ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef",
    {
        "AssociationId": str,
        "InstanceId": str,
        "IamInstanceProfile": ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
        "Timestamp": datetime,
    },
    total=False,
)

ClientDisassociateIamInstanceProfileResponseTypeDef = TypedDict(
    "ClientDisassociateIamInstanceProfileResponseTypeDef",
    {
        "IamInstanceProfileAssociation": ClientDisassociateIamInstanceProfileResponseIamInstanceProfileAssociationTypeDef
    },
    total=False,
)

ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef = TypedDict(
    "ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef,
    },
    total=False,
)

ClientDisassociateSubnetCidrBlockResponseTypeDef = TypedDict(
    "ClientDisassociateSubnetCidrBlockResponseTypeDef",
    {
        "Ipv6CidrBlockAssociation": ClientDisassociateSubnetCidrBlockResponseIpv6CidrBlockAssociationTypeDef,
        "SubnetId": str,
    },
    total=False,
)

ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef = TypedDict(
    "ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef",
    {
        "SubnetId": str,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
    },
    total=False,
)

ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsTypeDef = TypedDict(
    "ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "Subnets": List[
            ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsSubnetsTypeDef
        ],
    },
    total=False,
)

ClientDisassociateTransitGatewayMulticastDomainResponseTypeDef = TypedDict(
    "ClientDisassociateTransitGatewayMulticastDomainResponseTypeDef",
    {"Associations": ClientDisassociateTransitGatewayMulticastDomainResponseAssociationsTypeDef},
    total=False,
)

ClientDisassociateTransitGatewayRouteTableResponseAssociationTypeDef = TypedDict(
    "ClientDisassociateTransitGatewayRouteTableResponseAssociationTypeDef",
    {
        "TransitGatewayRouteTableId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
    },
    total=False,
)

ClientDisassociateTransitGatewayRouteTableResponseTypeDef = TypedDict(
    "ClientDisassociateTransitGatewayRouteTableResponseTypeDef",
    {"Association": ClientDisassociateTransitGatewayRouteTableResponseAssociationTypeDef},
    total=False,
)

ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef = TypedDict(
    "ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationTypeDef = TypedDict(
    "ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationTypeDef",
    {
        "AssociationId": str,
        "CidrBlock": str,
        "CidrBlockState": ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationCidrBlockStateTypeDef,
    },
    total=False,
)

ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef = TypedDict(
    "ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef",
    {
        "State": Literal[
            "associating", "associated", "disassociating", "disassociated", "failing", "failed"
        ],
        "StatusMessage": str,
    },
    total=False,
)

ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef = TypedDict(
    "ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef",
    {
        "AssociationId": str,
        "Ipv6CidrBlock": str,
        "Ipv6CidrBlockState": ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationIpv6CidrBlockStateTypeDef,
        "NetworkBorderGroup": str,
        "Ipv6Pool": str,
    },
    total=False,
)

ClientDisassociateVpcCidrBlockResponseTypeDef = TypedDict(
    "ClientDisassociateVpcCidrBlockResponseTypeDef",
    {
        "Ipv6CidrBlockAssociation": ClientDisassociateVpcCidrBlockResponseIpv6CidrBlockAssociationTypeDef,
        "CidrBlockAssociation": ClientDisassociateVpcCidrBlockResponseCidrBlockAssociationTypeDef,
        "VpcId": str,
    },
    total=False,
)

ClientEnableEbsEncryptionByDefaultResponseTypeDef = TypedDict(
    "ClientEnableEbsEncryptionByDefaultResponseTypeDef",
    {"EbsEncryptionByDefault": bool},
    total=False,
)

ClientEnableFastSnapshotRestoresResponseSuccessfulTypeDef = TypedDict(
    "ClientEnableFastSnapshotRestoresResponseSuccessfulTypeDef",
    {
        "SnapshotId": str,
        "AvailabilityZone": str,
        "State": Literal["enabling", "optimizing", "enabled", "disabling", "disabled"],
        "StateTransitionReason": str,
        "OwnerId": str,
        "OwnerAlias": str,
        "EnablingTime": datetime,
        "OptimizingTime": datetime,
        "EnabledTime": datetime,
        "DisablingTime": datetime,
        "DisabledTime": datetime,
    },
    total=False,
)

ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef = TypedDict(
    "ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef = TypedDict(
    "ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef",
    {
        "AvailabilityZone": str,
        "Error": ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsErrorTypeDef,
    },
    total=False,
)

ClientEnableFastSnapshotRestoresResponseUnsuccessfulTypeDef = TypedDict(
    "ClientEnableFastSnapshotRestoresResponseUnsuccessfulTypeDef",
    {
        "SnapshotId": str,
        "FastSnapshotRestoreStateErrors": List[
            ClientEnableFastSnapshotRestoresResponseUnsuccessfulFastSnapshotRestoreStateErrorsTypeDef
        ],
    },
    total=False,
)

ClientEnableFastSnapshotRestoresResponseTypeDef = TypedDict(
    "ClientEnableFastSnapshotRestoresResponseTypeDef",
    {
        "Successful": List[ClientEnableFastSnapshotRestoresResponseSuccessfulTypeDef],
        "Unsuccessful": List[ClientEnableFastSnapshotRestoresResponseUnsuccessfulTypeDef],
    },
    total=False,
)

ClientEnableTransitGatewayRouteTablePropagationResponsePropagationTypeDef = TypedDict(
    "ClientEnableTransitGatewayRouteTablePropagationResponsePropagationTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "TransitGatewayRouteTableId": str,
        "State": Literal["enabling", "enabled", "disabling", "disabled"],
    },
    total=False,
)

ClientEnableTransitGatewayRouteTablePropagationResponseTypeDef = TypedDict(
    "ClientEnableTransitGatewayRouteTablePropagationResponseTypeDef",
    {"Propagation": ClientEnableTransitGatewayRouteTablePropagationResponsePropagationTypeDef},
    total=False,
)

ClientEnableVpcClassicLinkDnsSupportResponseTypeDef = TypedDict(
    "ClientEnableVpcClassicLinkDnsSupportResponseTypeDef", {"Return": bool}, total=False
)

ClientEnableVpcClassicLinkResponseTypeDef = TypedDict(
    "ClientEnableVpcClassicLinkResponseTypeDef", {"Return": bool}, total=False
)

ClientExportClientVpnClientCertificateRevocationListResponseStatusTypeDef = TypedDict(
    "ClientExportClientVpnClientCertificateRevocationListResponseStatusTypeDef",
    {"Code": Literal["pending", "active"], "Message": str},
    total=False,
)

ClientExportClientVpnClientCertificateRevocationListResponseTypeDef = TypedDict(
    "ClientExportClientVpnClientCertificateRevocationListResponseTypeDef",
    {
        "CertificateRevocationList": str,
        "Status": ClientExportClientVpnClientCertificateRevocationListResponseStatusTypeDef,
    },
    total=False,
)

ClientExportClientVpnClientConfigurationResponseTypeDef = TypedDict(
    "ClientExportClientVpnClientConfigurationResponseTypeDef",
    {"ClientConfiguration": str},
    total=False,
)

ClientExportImageResponseS3ExportLocationTypeDef = TypedDict(
    "ClientExportImageResponseS3ExportLocationTypeDef",
    {"S3Bucket": str, "S3Prefix": str},
    total=False,
)

ClientExportImageResponseTypeDef = TypedDict(
    "ClientExportImageResponseTypeDef",
    {
        "Description": str,
        "DiskImageFormat": Literal["VMDK", "RAW", "VHD"],
        "ExportImageTaskId": str,
        "ImageId": str,
        "RoleName": str,
        "Progress": str,
        "S3ExportLocation": ClientExportImageResponseS3ExportLocationTypeDef,
        "Status": str,
        "StatusMessage": str,
    },
    total=False,
)

_RequiredClientExportImageS3ExportLocationTypeDef = TypedDict(
    "_RequiredClientExportImageS3ExportLocationTypeDef", {"S3Bucket": str}
)
_OptionalClientExportImageS3ExportLocationTypeDef = TypedDict(
    "_OptionalClientExportImageS3ExportLocationTypeDef", {"S3Prefix": str}, total=False
)


class ClientExportImageS3ExportLocationTypeDef(
    _RequiredClientExportImageS3ExportLocationTypeDef,
    _OptionalClientExportImageS3ExportLocationTypeDef,
):
    pass


ClientExportTransitGatewayRoutesFiltersTypeDef = TypedDict(
    "ClientExportTransitGatewayRoutesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientExportTransitGatewayRoutesResponseTypeDef = TypedDict(
    "ClientExportTransitGatewayRoutesResponseTypeDef", {"S3Location": str}, total=False
)

ClientGetAssociatedIpv6PoolCidrsResponseIpv6CidrAssociationsTypeDef = TypedDict(
    "ClientGetAssociatedIpv6PoolCidrsResponseIpv6CidrAssociationsTypeDef",
    {"Ipv6Cidr": str, "AssociatedResource": str},
    total=False,
)

ClientGetAssociatedIpv6PoolCidrsResponseTypeDef = TypedDict(
    "ClientGetAssociatedIpv6PoolCidrsResponseTypeDef",
    {
        "Ipv6CidrAssociations": List[
            ClientGetAssociatedIpv6PoolCidrsResponseIpv6CidrAssociationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientGetCapacityReservationUsageResponseInstanceUsagesTypeDef = TypedDict(
    "ClientGetCapacityReservationUsageResponseInstanceUsagesTypeDef",
    {"AccountId": str, "UsedInstanceCount": int},
    total=False,
)

ClientGetCapacityReservationUsageResponseTypeDef = TypedDict(
    "ClientGetCapacityReservationUsageResponseTypeDef",
    {
        "NextToken": str,
        "CapacityReservationId": str,
        "InstanceType": str,
        "TotalInstanceCount": int,
        "AvailableInstanceCount": int,
        "State": Literal["active", "expired", "cancelled", "pending", "failed"],
        "InstanceUsages": List[ClientGetCapacityReservationUsageResponseInstanceUsagesTypeDef],
    },
    total=False,
)

ClientGetCoipPoolUsageFiltersTypeDef = TypedDict(
    "ClientGetCoipPoolUsageFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientGetCoipPoolUsageResponseCoipAddressUsagesTypeDef = TypedDict(
    "ClientGetCoipPoolUsageResponseCoipAddressUsagesTypeDef",
    {"AllocationId": str, "AwsAccountId": str, "AwsService": str, "CoIp": str},
    total=False,
)

ClientGetCoipPoolUsageResponseTypeDef = TypedDict(
    "ClientGetCoipPoolUsageResponseTypeDef",
    {
        "CoipPoolId": str,
        "CoipAddressUsages": List[ClientGetCoipPoolUsageResponseCoipAddressUsagesTypeDef],
        "LocalGatewayRouteTableId": str,
    },
    total=False,
)

ClientGetConsoleOutputResponseTypeDef = TypedDict(
    "ClientGetConsoleOutputResponseTypeDef",
    {"InstanceId": str, "Output": str, "Timestamp": datetime},
    total=False,
)

ClientGetConsoleScreenshotResponseTypeDef = TypedDict(
    "ClientGetConsoleScreenshotResponseTypeDef", {"ImageData": str, "InstanceId": str}, total=False
)

ClientGetDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef = TypedDict(
    "ClientGetDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef",
    {"InstanceFamily": Literal["t2", "t3", "t3a"], "CpuCredits": str},
    total=False,
)

ClientGetDefaultCreditSpecificationResponseTypeDef = TypedDict(
    "ClientGetDefaultCreditSpecificationResponseTypeDef",
    {
        "InstanceFamilyCreditSpecification": ClientGetDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef
    },
    total=False,
)

ClientGetEbsDefaultKmsKeyIdResponseTypeDef = TypedDict(
    "ClientGetEbsDefaultKmsKeyIdResponseTypeDef", {"KmsKeyId": str}, total=False
)

ClientGetEbsEncryptionByDefaultResponseTypeDef = TypedDict(
    "ClientGetEbsEncryptionByDefaultResponseTypeDef", {"EbsEncryptionByDefault": bool}, total=False
)

ClientGetHostReservationPurchasePreviewResponsePurchaseTypeDef = TypedDict(
    "ClientGetHostReservationPurchasePreviewResponsePurchaseTypeDef",
    {
        "CurrencyCode": str,
        "Duration": int,
        "HostIdSet": List[str],
        "HostReservationId": str,
        "HourlyPrice": str,
        "InstanceFamily": str,
        "PaymentOption": Literal["AllUpfront", "PartialUpfront", "NoUpfront"],
        "UpfrontPrice": str,
    },
    total=False,
)

ClientGetHostReservationPurchasePreviewResponseTypeDef = TypedDict(
    "ClientGetHostReservationPurchasePreviewResponseTypeDef",
    {
        "CurrencyCode": str,
        "Purchase": List[ClientGetHostReservationPurchasePreviewResponsePurchaseTypeDef],
        "TotalHourlyPrice": str,
        "TotalUpfrontPrice": str,
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsEbsTypeDef",
    {
        "Encrypted": bool,
        "DeleteOnTermination": bool,
        "Iops": int,
        "KmsKeyId": str,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataCpuOptionsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCpuOptionsTypeDef",
    {"CoreCount": int, "ThreadsPerCore": int},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataCreditSpecificationTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataCreditSpecificationTypeDef",
    {"CpuCredits": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticGpuSpecificationsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticGpuSpecificationsTypeDef",
    {"Type": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticInferenceAcceleratorsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticInferenceAcceleratorsTypeDef",
    {"Type": str, "Count": int},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataHibernationOptionsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataHibernationOptionsTypeDef",
    {"Configured": bool},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataIamInstanceProfileTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef",
    {
        "MaxPrice": str,
        "SpotInstanceType": Literal["one-time", "persistent"],
        "BlockDurationMinutes": int,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsTypeDef",
    {
        "MarketType": str,
        "SpotOptions": ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsSpotOptionsTypeDef,
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataLicenseSpecificationsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataLicenseSpecificationsTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataMetadataOptionsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataMetadataOptionsTypeDef",
    {
        "State": Literal["pending", "applied"],
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataMonitoringTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "InterfaceType": str,
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataPlacementTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
        "PartitionNumber": int,
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTagsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTagsTypeDef
        ],
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseLaunchTemplateDataTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseLaunchTemplateDataTypeDef",
    {
        "KernelId": str,
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientGetLaunchTemplateDataResponseLaunchTemplateDataIamInstanceProfileTypeDef,
        "BlockDeviceMappings": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataBlockDeviceMappingsTypeDef
        ],
        "NetworkInterfaces": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataNetworkInterfacesTypeDef
        ],
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KeyName": str,
        "Monitoring": ClientGetLaunchTemplateDataResponseLaunchTemplateDataMonitoringTypeDef,
        "Placement": ClientGetLaunchTemplateDataResponseLaunchTemplateDataPlacementTypeDef,
        "RamDiskId": str,
        "DisableApiTermination": bool,
        "InstanceInitiatedShutdownBehavior": Literal["stop", "terminate"],
        "UserData": str,
        "TagSpecifications": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataTagSpecificationsTypeDef
        ],
        "ElasticGpuSpecifications": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticGpuSpecificationsTypeDef
        ],
        "ElasticInferenceAccelerators": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataElasticInferenceAcceleratorsTypeDef
        ],
        "SecurityGroupIds": List[str],
        "SecurityGroups": List[str],
        "InstanceMarketOptions": ClientGetLaunchTemplateDataResponseLaunchTemplateDataInstanceMarketOptionsTypeDef,
        "CreditSpecification": ClientGetLaunchTemplateDataResponseLaunchTemplateDataCreditSpecificationTypeDef,
        "CpuOptions": ClientGetLaunchTemplateDataResponseLaunchTemplateDataCpuOptionsTypeDef,
        "CapacityReservationSpecification": ClientGetLaunchTemplateDataResponseLaunchTemplateDataCapacityReservationSpecificationTypeDef,
        "LicenseSpecifications": List[
            ClientGetLaunchTemplateDataResponseLaunchTemplateDataLicenseSpecificationsTypeDef
        ],
        "HibernationOptions": ClientGetLaunchTemplateDataResponseLaunchTemplateDataHibernationOptionsTypeDef,
        "MetadataOptions": ClientGetLaunchTemplateDataResponseLaunchTemplateDataMetadataOptionsTypeDef,
    },
    total=False,
)

ClientGetLaunchTemplateDataResponseTypeDef = TypedDict(
    "ClientGetLaunchTemplateDataResponseTypeDef",
    {"LaunchTemplateData": ClientGetLaunchTemplateDataResponseLaunchTemplateDataTypeDef},
    total=False,
)

ClientGetPasswordDataResponseTypeDef = TypedDict(
    "ClientGetPasswordDataResponseTypeDef",
    {"InstanceId": str, "PasswordData": str, "Timestamp": datetime},
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueRollupTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueRollupTypeDef",
    {"HourlyPrice": str, "RemainingTotalValue": str, "RemainingUpfrontValue": str},
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetReservationValueTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetReservationValueTypeDef",
    {"HourlyPrice": str, "RemainingTotalValue": str, "RemainingUpfrontValue": str},
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetTypeDef",
    {
        "ReservationValue": ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetReservationValueTypeDef,
        "ReservedInstanceId": str,
    },
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueRollupTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueRollupTypeDef",
    {"HourlyPrice": str, "RemainingTotalValue": str, "RemainingUpfrontValue": str},
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetReservationValueTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetReservationValueTypeDef",
    {"HourlyPrice": str, "RemainingTotalValue": str, "RemainingUpfrontValue": str},
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTargetConfigurationTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTargetConfigurationTypeDef",
    {"InstanceCount": int, "OfferingId": str},
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTypeDef",
    {
        "ReservationValue": ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetReservationValueTypeDef,
        "TargetConfiguration": ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTargetConfigurationTypeDef,
    },
    total=False,
)

ClientGetReservedInstancesExchangeQuoteResponseTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteResponseTypeDef",
    {
        "CurrencyCode": str,
        "IsValidExchange": bool,
        "OutputReservedInstancesWillExpireAt": datetime,
        "PaymentDue": str,
        "ReservedInstanceValueRollup": ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueRollupTypeDef,
        "ReservedInstanceValueSet": List[
            ClientGetReservedInstancesExchangeQuoteResponseReservedInstanceValueSetTypeDef
        ],
        "TargetConfigurationValueRollup": ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueRollupTypeDef,
        "TargetConfigurationValueSet": List[
            ClientGetReservedInstancesExchangeQuoteResponseTargetConfigurationValueSetTypeDef
        ],
        "ValidationFailureReason": str,
    },
    total=False,
)

ClientGetReservedInstancesExchangeQuoteTargetConfigurationsTypeDef = TypedDict(
    "ClientGetReservedInstancesExchangeQuoteTargetConfigurationsTypeDef",
    {"InstanceCount": int, "OfferingId": str},
    total=False,
)

ClientGetTransitGatewayAttachmentPropagationsFiltersTypeDef = TypedDict(
    "ClientGetTransitGatewayAttachmentPropagationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientGetTransitGatewayAttachmentPropagationsResponseTransitGatewayAttachmentPropagationsTypeDef = TypedDict(
    "ClientGetTransitGatewayAttachmentPropagationsResponseTransitGatewayAttachmentPropagationsTypeDef",
    {
        "TransitGatewayRouteTableId": str,
        "State": Literal["enabling", "enabled", "disabling", "disabled"],
    },
    total=False,
)

ClientGetTransitGatewayAttachmentPropagationsResponseTypeDef = TypedDict(
    "ClientGetTransitGatewayAttachmentPropagationsResponseTypeDef",
    {
        "TransitGatewayAttachmentPropagations": List[
            ClientGetTransitGatewayAttachmentPropagationsResponseTransitGatewayAttachmentPropagationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientGetTransitGatewayMulticastDomainAssociationsFiltersTypeDef = TypedDict(
    "ClientGetTransitGatewayMulticastDomainAssociationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsSubnetTypeDef = TypedDict(
    "ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsSubnetTypeDef",
    {
        "SubnetId": str,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
    },
    total=False,
)

ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsTypeDef = TypedDict(
    "ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "Subnet": ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsSubnetTypeDef,
    },
    total=False,
)

ClientGetTransitGatewayMulticastDomainAssociationsResponseTypeDef = TypedDict(
    "ClientGetTransitGatewayMulticastDomainAssociationsResponseTypeDef",
    {
        "MulticastDomainAssociations": List[
            ClientGetTransitGatewayMulticastDomainAssociationsResponseMulticastDomainAssociationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientGetTransitGatewayRouteTableAssociationsFiltersTypeDef = TypedDict(
    "ClientGetTransitGatewayRouteTableAssociationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientGetTransitGatewayRouteTableAssociationsResponseAssociationsTypeDef = TypedDict(
    "ClientGetTransitGatewayRouteTableAssociationsResponseAssociationsTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
    },
    total=False,
)

ClientGetTransitGatewayRouteTableAssociationsResponseTypeDef = TypedDict(
    "ClientGetTransitGatewayRouteTableAssociationsResponseTypeDef",
    {
        "Associations": List[
            ClientGetTransitGatewayRouteTableAssociationsResponseAssociationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientGetTransitGatewayRouteTablePropagationsFiltersTypeDef = TypedDict(
    "ClientGetTransitGatewayRouteTablePropagationsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientGetTransitGatewayRouteTablePropagationsResponseTransitGatewayRouteTablePropagationsTypeDef = TypedDict(
    "ClientGetTransitGatewayRouteTablePropagationsResponseTransitGatewayRouteTablePropagationsTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "State": Literal["enabling", "enabled", "disabling", "disabled"],
    },
    total=False,
)

ClientGetTransitGatewayRouteTablePropagationsResponseTypeDef = TypedDict(
    "ClientGetTransitGatewayRouteTablePropagationsResponseTypeDef",
    {
        "TransitGatewayRouteTablePropagations": List[
            ClientGetTransitGatewayRouteTablePropagationsResponseTransitGatewayRouteTablePropagationsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientImportClientVpnClientCertificateRevocationListResponseTypeDef = TypedDict(
    "ClientImportClientVpnClientCertificateRevocationListResponseTypeDef",
    {"Return": bool},
    total=False,
)

ClientImportImageClientDataTypeDef = TypedDict(
    "ClientImportImageClientDataTypeDef",
    {"Comment": str, "UploadEnd": datetime, "UploadSize": float, "UploadStart": datetime},
    total=False,
)

ClientImportImageDiskContainersUserBucketTypeDef = TypedDict(
    "ClientImportImageDiskContainersUserBucketTypeDef", {"S3Bucket": str, "S3Key": str}, total=False
)

ClientImportImageDiskContainersTypeDef = TypedDict(
    "ClientImportImageDiskContainersTypeDef",
    {
        "Description": str,
        "DeviceName": str,
        "Format": str,
        "SnapshotId": str,
        "Url": str,
        "UserBucket": ClientImportImageDiskContainersUserBucketTypeDef,
    },
    total=False,
)

ClientImportImageLicenseSpecificationsTypeDef = TypedDict(
    "ClientImportImageLicenseSpecificationsTypeDef", {"LicenseConfigurationArn": str}, total=False
)

ClientImportImageResponseLicenseSpecificationsTypeDef = TypedDict(
    "ClientImportImageResponseLicenseSpecificationsTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientImportImageResponseSnapshotDetailsUserBucketTypeDef = TypedDict(
    "ClientImportImageResponseSnapshotDetailsUserBucketTypeDef",
    {"S3Bucket": str, "S3Key": str},
    total=False,
)

ClientImportImageResponseSnapshotDetailsTypeDef = TypedDict(
    "ClientImportImageResponseSnapshotDetailsTypeDef",
    {
        "Description": str,
        "DeviceName": str,
        "DiskImageSize": float,
        "Format": str,
        "Progress": str,
        "SnapshotId": str,
        "Status": str,
        "StatusMessage": str,
        "Url": str,
        "UserBucket": ClientImportImageResponseSnapshotDetailsUserBucketTypeDef,
    },
    total=False,
)

ClientImportImageResponseTypeDef = TypedDict(
    "ClientImportImageResponseTypeDef",
    {
        "Architecture": str,
        "Description": str,
        "Encrypted": bool,
        "Hypervisor": str,
        "ImageId": str,
        "ImportTaskId": str,
        "KmsKeyId": str,
        "LicenseType": str,
        "Platform": str,
        "Progress": str,
        "SnapshotDetails": List[ClientImportImageResponseSnapshotDetailsTypeDef],
        "Status": str,
        "StatusMessage": str,
        "LicenseSpecifications": List[ClientImportImageResponseLicenseSpecificationsTypeDef],
    },
    total=False,
)

ClientImportInstanceDiskImagesImageTypeDef = TypedDict(
    "ClientImportInstanceDiskImagesImageTypeDef",
    {"Bytes": int, "Format": Literal["VMDK", "RAW", "VHD"], "ImportManifestUrl": str},
    total=False,
)

ClientImportInstanceDiskImagesVolumeTypeDef = TypedDict(
    "ClientImportInstanceDiskImagesVolumeTypeDef", {"Size": int}, total=False
)

ClientImportInstanceDiskImagesTypeDef = TypedDict(
    "ClientImportInstanceDiskImagesTypeDef",
    {
        "Description": str,
        "Image": ClientImportInstanceDiskImagesImageTypeDef,
        "Volume": ClientImportInstanceDiskImagesVolumeTypeDef,
    },
    total=False,
)

ClientImportInstanceLaunchSpecificationPlacementTypeDef = TypedDict(
    "ClientImportInstanceLaunchSpecificationPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "PartitionNumber": int,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
    },
    total=False,
)

ClientImportInstanceLaunchSpecificationUserDataTypeDef = TypedDict(
    "ClientImportInstanceLaunchSpecificationUserDataTypeDef", {"Data": str}, total=False
)

ClientImportInstanceLaunchSpecificationTypeDef = TypedDict(
    "ClientImportInstanceLaunchSpecificationTypeDef",
    {
        "AdditionalInfo": str,
        "Architecture": Literal["i386", "x86_64", "arm64"],
        "GroupIds": List[str],
        "GroupNames": List[str],
        "InstanceInitiatedShutdownBehavior": Literal["stop", "terminate"],
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "Monitoring": bool,
        "Placement": ClientImportInstanceLaunchSpecificationPlacementTypeDef,
        "PrivateIpAddress": str,
        "SubnetId": str,
        "UserData": ClientImportInstanceLaunchSpecificationUserDataTypeDef,
    },
    total=False,
)

ClientImportInstanceResponseConversionTaskImportInstanceVolumesImageTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskImportInstanceVolumesImageTypeDef",
    {
        "Checksum": str,
        "Format": Literal["VMDK", "RAW", "VHD"],
        "ImportManifestUrl": str,
        "Size": int,
    },
    total=False,
)

ClientImportInstanceResponseConversionTaskImportInstanceVolumesVolumeTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskImportInstanceVolumesVolumeTypeDef",
    {"Id": str, "Size": int},
    total=False,
)

ClientImportInstanceResponseConversionTaskImportInstanceVolumesTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskImportInstanceVolumesTypeDef",
    {
        "AvailabilityZone": str,
        "BytesConverted": int,
        "Description": str,
        "Image": ClientImportInstanceResponseConversionTaskImportInstanceVolumesImageTypeDef,
        "Status": str,
        "StatusMessage": str,
        "Volume": ClientImportInstanceResponseConversionTaskImportInstanceVolumesVolumeTypeDef,
    },
    total=False,
)

ClientImportInstanceResponseConversionTaskImportInstanceTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskImportInstanceTypeDef",
    {
        "Description": str,
        "InstanceId": str,
        "Platform": str,
        "Volumes": List[ClientImportInstanceResponseConversionTaskImportInstanceVolumesTypeDef],
    },
    total=False,
)

ClientImportInstanceResponseConversionTaskImportVolumeImageTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskImportVolumeImageTypeDef",
    {
        "Checksum": str,
        "Format": Literal["VMDK", "RAW", "VHD"],
        "ImportManifestUrl": str,
        "Size": int,
    },
    total=False,
)

ClientImportInstanceResponseConversionTaskImportVolumeVolumeTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskImportVolumeVolumeTypeDef",
    {"Id": str, "Size": int},
    total=False,
)

ClientImportInstanceResponseConversionTaskImportVolumeTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskImportVolumeTypeDef",
    {
        "AvailabilityZone": str,
        "BytesConverted": int,
        "Description": str,
        "Image": ClientImportInstanceResponseConversionTaskImportVolumeImageTypeDef,
        "Volume": ClientImportInstanceResponseConversionTaskImportVolumeVolumeTypeDef,
    },
    total=False,
)

ClientImportInstanceResponseConversionTaskTagsTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientImportInstanceResponseConversionTaskTypeDef = TypedDict(
    "ClientImportInstanceResponseConversionTaskTypeDef",
    {
        "ConversionTaskId": str,
        "ExpirationTime": str,
        "ImportInstance": ClientImportInstanceResponseConversionTaskImportInstanceTypeDef,
        "ImportVolume": ClientImportInstanceResponseConversionTaskImportVolumeTypeDef,
        "State": Literal["active", "cancelling", "cancelled", "completed"],
        "StatusMessage": str,
        "Tags": List[ClientImportInstanceResponseConversionTaskTagsTypeDef],
    },
    total=False,
)

ClientImportInstanceResponseTypeDef = TypedDict(
    "ClientImportInstanceResponseTypeDef",
    {"ConversionTask": ClientImportInstanceResponseConversionTaskTypeDef},
    total=False,
)

ClientImportKeyPairResponseTypeDef = TypedDict(
    "ClientImportKeyPairResponseTypeDef", {"KeyFingerprint": str, "KeyName": str}, total=False
)

ClientImportSnapshotClientDataTypeDef = TypedDict(
    "ClientImportSnapshotClientDataTypeDef",
    {"Comment": str, "UploadEnd": datetime, "UploadSize": float, "UploadStart": datetime},
    total=False,
)

ClientImportSnapshotDiskContainerUserBucketTypeDef = TypedDict(
    "ClientImportSnapshotDiskContainerUserBucketTypeDef",
    {"S3Bucket": str, "S3Key": str},
    total=False,
)

ClientImportSnapshotDiskContainerTypeDef = TypedDict(
    "ClientImportSnapshotDiskContainerTypeDef",
    {
        "Description": str,
        "Format": str,
        "Url": str,
        "UserBucket": ClientImportSnapshotDiskContainerUserBucketTypeDef,
    },
    total=False,
)

ClientImportSnapshotResponseSnapshotTaskDetailUserBucketTypeDef = TypedDict(
    "ClientImportSnapshotResponseSnapshotTaskDetailUserBucketTypeDef",
    {"S3Bucket": str, "S3Key": str},
    total=False,
)

ClientImportSnapshotResponseSnapshotTaskDetailTypeDef = TypedDict(
    "ClientImportSnapshotResponseSnapshotTaskDetailTypeDef",
    {
        "Description": str,
        "DiskImageSize": float,
        "Encrypted": bool,
        "Format": str,
        "KmsKeyId": str,
        "Progress": str,
        "SnapshotId": str,
        "Status": str,
        "StatusMessage": str,
        "Url": str,
        "UserBucket": ClientImportSnapshotResponseSnapshotTaskDetailUserBucketTypeDef,
    },
    total=False,
)

ClientImportSnapshotResponseTypeDef = TypedDict(
    "ClientImportSnapshotResponseTypeDef",
    {
        "Description": str,
        "ImportTaskId": str,
        "SnapshotTaskDetail": ClientImportSnapshotResponseSnapshotTaskDetailTypeDef,
    },
    total=False,
)

_RequiredClientImportVolumeImageTypeDef = TypedDict(
    "_RequiredClientImportVolumeImageTypeDef", {"Bytes": int}
)
_OptionalClientImportVolumeImageTypeDef = TypedDict(
    "_OptionalClientImportVolumeImageTypeDef",
    {"Format": Literal["VMDK", "RAW", "VHD"], "ImportManifestUrl": str},
    total=False,
)


class ClientImportVolumeImageTypeDef(
    _RequiredClientImportVolumeImageTypeDef, _OptionalClientImportVolumeImageTypeDef
):
    pass


ClientImportVolumeResponseConversionTaskImportInstanceVolumesImageTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskImportInstanceVolumesImageTypeDef",
    {
        "Checksum": str,
        "Format": Literal["VMDK", "RAW", "VHD"],
        "ImportManifestUrl": str,
        "Size": int,
    },
    total=False,
)

ClientImportVolumeResponseConversionTaskImportInstanceVolumesVolumeTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskImportInstanceVolumesVolumeTypeDef",
    {"Id": str, "Size": int},
    total=False,
)

ClientImportVolumeResponseConversionTaskImportInstanceVolumesTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskImportInstanceVolumesTypeDef",
    {
        "AvailabilityZone": str,
        "BytesConverted": int,
        "Description": str,
        "Image": ClientImportVolumeResponseConversionTaskImportInstanceVolumesImageTypeDef,
        "Status": str,
        "StatusMessage": str,
        "Volume": ClientImportVolumeResponseConversionTaskImportInstanceVolumesVolumeTypeDef,
    },
    total=False,
)

ClientImportVolumeResponseConversionTaskImportInstanceTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskImportInstanceTypeDef",
    {
        "Description": str,
        "InstanceId": str,
        "Platform": str,
        "Volumes": List[ClientImportVolumeResponseConversionTaskImportInstanceVolumesTypeDef],
    },
    total=False,
)

ClientImportVolumeResponseConversionTaskImportVolumeImageTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskImportVolumeImageTypeDef",
    {
        "Checksum": str,
        "Format": Literal["VMDK", "RAW", "VHD"],
        "ImportManifestUrl": str,
        "Size": int,
    },
    total=False,
)

ClientImportVolumeResponseConversionTaskImportVolumeVolumeTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskImportVolumeVolumeTypeDef",
    {"Id": str, "Size": int},
    total=False,
)

ClientImportVolumeResponseConversionTaskImportVolumeTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskImportVolumeTypeDef",
    {
        "AvailabilityZone": str,
        "BytesConverted": int,
        "Description": str,
        "Image": ClientImportVolumeResponseConversionTaskImportVolumeImageTypeDef,
        "Volume": ClientImportVolumeResponseConversionTaskImportVolumeVolumeTypeDef,
    },
    total=False,
)

ClientImportVolumeResponseConversionTaskTagsTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientImportVolumeResponseConversionTaskTypeDef = TypedDict(
    "ClientImportVolumeResponseConversionTaskTypeDef",
    {
        "ConversionTaskId": str,
        "ExpirationTime": str,
        "ImportInstance": ClientImportVolumeResponseConversionTaskImportInstanceTypeDef,
        "ImportVolume": ClientImportVolumeResponseConversionTaskImportVolumeTypeDef,
        "State": Literal["active", "cancelling", "cancelled", "completed"],
        "StatusMessage": str,
        "Tags": List[ClientImportVolumeResponseConversionTaskTagsTypeDef],
    },
    total=False,
)

ClientImportVolumeResponseTypeDef = TypedDict(
    "ClientImportVolumeResponseTypeDef",
    {"ConversionTask": ClientImportVolumeResponseConversionTaskTypeDef},
    total=False,
)

ClientImportVolumeVolumeTypeDef = TypedDict("ClientImportVolumeVolumeTypeDef", {"Size": int})

ClientModifyCapacityReservationResponseTypeDef = TypedDict(
    "ClientModifyCapacityReservationResponseTypeDef", {"Return": bool}, total=False
)

ClientModifyClientVpnEndpointConnectionLogOptionsTypeDef = TypedDict(
    "ClientModifyClientVpnEndpointConnectionLogOptionsTypeDef",
    {"Enabled": bool, "CloudwatchLogGroup": str, "CloudwatchLogStream": str},
    total=False,
)

ClientModifyClientVpnEndpointDnsServersTypeDef = TypedDict(
    "ClientModifyClientVpnEndpointDnsServersTypeDef",
    {"CustomDnsServers": List[str], "Enabled": bool},
    total=False,
)

ClientModifyClientVpnEndpointResponseTypeDef = TypedDict(
    "ClientModifyClientVpnEndpointResponseTypeDef", {"Return": bool}, total=False
)

ClientModifyDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef = TypedDict(
    "ClientModifyDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef",
    {"InstanceFamily": Literal["t2", "t3", "t3a"], "CpuCredits": str},
    total=False,
)

ClientModifyDefaultCreditSpecificationResponseTypeDef = TypedDict(
    "ClientModifyDefaultCreditSpecificationResponseTypeDef",
    {
        "InstanceFamilyCreditSpecification": ClientModifyDefaultCreditSpecificationResponseInstanceFamilyCreditSpecificationTypeDef
    },
    total=False,
)

ClientModifyEbsDefaultKmsKeyIdResponseTypeDef = TypedDict(
    "ClientModifyEbsDefaultKmsKeyIdResponseTypeDef", {"KmsKeyId": str}, total=False
)

ClientModifyFleetResponseTypeDef = TypedDict(
    "ClientModifyFleetResponseTypeDef", {"Return": bool}, total=False
)

_RequiredClientModifyFleetTargetCapacitySpecificationTypeDef = TypedDict(
    "_RequiredClientModifyFleetTargetCapacitySpecificationTypeDef", {"TotalTargetCapacity": int}
)
_OptionalClientModifyFleetTargetCapacitySpecificationTypeDef = TypedDict(
    "_OptionalClientModifyFleetTargetCapacitySpecificationTypeDef",
    {
        "OnDemandTargetCapacity": int,
        "SpotTargetCapacity": int,
        "DefaultTargetCapacityType": Literal["spot", "on-demand"],
    },
    total=False,
)


class ClientModifyFleetTargetCapacitySpecificationTypeDef(
    _RequiredClientModifyFleetTargetCapacitySpecificationTypeDef,
    _OptionalClientModifyFleetTargetCapacitySpecificationTypeDef,
):
    pass


ClientModifyFpgaImageAttributeLoadPermissionAddTypeDef = TypedDict(
    "ClientModifyFpgaImageAttributeLoadPermissionAddTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientModifyFpgaImageAttributeLoadPermissionRemoveTypeDef = TypedDict(
    "ClientModifyFpgaImageAttributeLoadPermissionRemoveTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientModifyFpgaImageAttributeLoadPermissionTypeDef = TypedDict(
    "ClientModifyFpgaImageAttributeLoadPermissionTypeDef",
    {
        "Add": List[ClientModifyFpgaImageAttributeLoadPermissionAddTypeDef],
        "Remove": List[ClientModifyFpgaImageAttributeLoadPermissionRemoveTypeDef],
    },
    total=False,
)

ClientModifyFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef = TypedDict(
    "ClientModifyFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef",
    {"UserId": str, "Group": str},
    total=False,
)

ClientModifyFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef = TypedDict(
    "ClientModifyFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientModifyFpgaImageAttributeResponseFpgaImageAttributeTypeDef = TypedDict(
    "ClientModifyFpgaImageAttributeResponseFpgaImageAttributeTypeDef",
    {
        "FpgaImageId": str,
        "Name": str,
        "Description": str,
        "LoadPermissions": List[
            ClientModifyFpgaImageAttributeResponseFpgaImageAttributeLoadPermissionsTypeDef
        ],
        "ProductCodes": List[
            ClientModifyFpgaImageAttributeResponseFpgaImageAttributeProductCodesTypeDef
        ],
    },
    total=False,
)

ClientModifyFpgaImageAttributeResponseTypeDef = TypedDict(
    "ClientModifyFpgaImageAttributeResponseTypeDef",
    {"FpgaImageAttribute": ClientModifyFpgaImageAttributeResponseFpgaImageAttributeTypeDef},
    total=False,
)

ClientModifyHostsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientModifyHostsResponseUnsuccessfulErrorTypeDef", {"Code": str, "Message": str}, total=False
)

ClientModifyHostsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientModifyHostsResponseUnsuccessfulTypeDef",
    {"Error": ClientModifyHostsResponseUnsuccessfulErrorTypeDef, "ResourceId": str},
    total=False,
)

ClientModifyHostsResponseTypeDef = TypedDict(
    "ClientModifyHostsResponseTypeDef",
    {"Successful": List[str], "Unsuccessful": List[ClientModifyHostsResponseUnsuccessfulTypeDef]},
    total=False,
)

ClientModifyImageAttributeDescriptionTypeDef = TypedDict(
    "ClientModifyImageAttributeDescriptionTypeDef", {"Value": str}, total=False
)

ClientModifyImageAttributeLaunchPermissionAddTypeDef = TypedDict(
    "ClientModifyImageAttributeLaunchPermissionAddTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientModifyImageAttributeLaunchPermissionRemoveTypeDef = TypedDict(
    "ClientModifyImageAttributeLaunchPermissionRemoveTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientModifyImageAttributeLaunchPermissionTypeDef = TypedDict(
    "ClientModifyImageAttributeLaunchPermissionTypeDef",
    {
        "Add": List[ClientModifyImageAttributeLaunchPermissionAddTypeDef],
        "Remove": List[ClientModifyImageAttributeLaunchPermissionRemoveTypeDef],
    },
    total=False,
)

ClientModifyInstanceAttributeBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientModifyInstanceAttributeBlockDeviceMappingsEbsTypeDef",
    {"DeleteOnTermination": bool, "VolumeId": str},
    total=False,
)

ClientModifyInstanceAttributeBlockDeviceMappingsTypeDef = TypedDict(
    "ClientModifyInstanceAttributeBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "Ebs": ClientModifyInstanceAttributeBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
        "VirtualName": str,
    },
    total=False,
)

ClientModifyInstanceAttributeDisableApiTerminationTypeDef = TypedDict(
    "ClientModifyInstanceAttributeDisableApiTerminationTypeDef", {"Value": bool}, total=False
)

ClientModifyInstanceAttributeEbsOptimizedTypeDef = TypedDict(
    "ClientModifyInstanceAttributeEbsOptimizedTypeDef", {"Value": bool}, total=False
)

ClientModifyInstanceAttributeEnaSupportTypeDef = TypedDict(
    "ClientModifyInstanceAttributeEnaSupportTypeDef", {"Value": bool}, total=False
)

ClientModifyInstanceAttributeInstanceInitiatedShutdownBehaviorTypeDef = TypedDict(
    "ClientModifyInstanceAttributeInstanceInitiatedShutdownBehaviorTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyInstanceAttributeInstanceTypeTypeDef = TypedDict(
    "ClientModifyInstanceAttributeInstanceTypeTypeDef", {"Value": str}, total=False
)

ClientModifyInstanceAttributeKernelTypeDef = TypedDict(
    "ClientModifyInstanceAttributeKernelTypeDef", {"Value": str}, total=False
)

ClientModifyInstanceAttributeRamdiskTypeDef = TypedDict(
    "ClientModifyInstanceAttributeRamdiskTypeDef", {"Value": str}, total=False
)

ClientModifyInstanceAttributeSourceDestCheckTypeDef = TypedDict(
    "ClientModifyInstanceAttributeSourceDestCheckTypeDef", {"Value": bool}, total=False
)

ClientModifyInstanceAttributeSriovNetSupportTypeDef = TypedDict(
    "ClientModifyInstanceAttributeSriovNetSupportTypeDef", {"Value": str}, total=False
)

ClientModifyInstanceAttributeUserDataTypeDef = TypedDict(
    "ClientModifyInstanceAttributeUserDataTypeDef", {"Value": bytes}, total=False
)

ClientModifyInstanceCapacityReservationAttributesCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientModifyInstanceCapacityReservationAttributesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientModifyInstanceCapacityReservationAttributesCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientModifyInstanceCapacityReservationAttributesCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientModifyInstanceCapacityReservationAttributesCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientModifyInstanceCapacityReservationAttributesResponseTypeDef = TypedDict(
    "ClientModifyInstanceCapacityReservationAttributesResponseTypeDef",
    {"Return": bool},
    total=False,
)

ClientModifyInstanceCreditSpecificationInstanceCreditSpecificationsTypeDef = TypedDict(
    "ClientModifyInstanceCreditSpecificationInstanceCreditSpecificationsTypeDef",
    {"InstanceId": str, "CpuCredits": str},
    total=False,
)

ClientModifyInstanceCreditSpecificationResponseSuccessfulInstanceCreditSpecificationsTypeDef = TypedDict(
    "ClientModifyInstanceCreditSpecificationResponseSuccessfulInstanceCreditSpecificationsTypeDef",
    {"InstanceId": str},
    total=False,
)

ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsErrorTypeDef = TypedDict(
    "ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsErrorTypeDef",
    {
        "Code": Literal[
            "InvalidInstanceID.Malformed",
            "InvalidInstanceID.NotFound",
            "IncorrectInstanceState",
            "InstanceCreditSpecification.NotSupported",
        ],
        "Message": str,
    },
    total=False,
)

ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsTypeDef = TypedDict(
    "ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsTypeDef",
    {
        "InstanceId": str,
        "Error": ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsErrorTypeDef,
    },
    total=False,
)

ClientModifyInstanceCreditSpecificationResponseTypeDef = TypedDict(
    "ClientModifyInstanceCreditSpecificationResponseTypeDef",
    {
        "SuccessfulInstanceCreditSpecifications": List[
            ClientModifyInstanceCreditSpecificationResponseSuccessfulInstanceCreditSpecificationsTypeDef
        ],
        "UnsuccessfulInstanceCreditSpecifications": List[
            ClientModifyInstanceCreditSpecificationResponseUnsuccessfulInstanceCreditSpecificationsTypeDef
        ],
    },
    total=False,
)

ClientModifyInstanceEventStartTimeResponseEventTypeDef = TypedDict(
    "ClientModifyInstanceEventStartTimeResponseEventTypeDef",
    {
        "InstanceEventId": str,
        "Code": Literal[
            "instance-reboot",
            "system-reboot",
            "system-maintenance",
            "instance-retirement",
            "instance-stop",
        ],
        "Description": str,
        "NotAfter": datetime,
        "NotBefore": datetime,
        "NotBeforeDeadline": datetime,
    },
    total=False,
)

ClientModifyInstanceEventStartTimeResponseTypeDef = TypedDict(
    "ClientModifyInstanceEventStartTimeResponseTypeDef",
    {"Event": ClientModifyInstanceEventStartTimeResponseEventTypeDef},
    total=False,
)

ClientModifyInstanceMetadataOptionsResponseInstanceMetadataOptionsTypeDef = TypedDict(
    "ClientModifyInstanceMetadataOptionsResponseInstanceMetadataOptionsTypeDef",
    {
        "State": Literal["pending", "applied"],
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientModifyInstanceMetadataOptionsResponseTypeDef = TypedDict(
    "ClientModifyInstanceMetadataOptionsResponseTypeDef",
    {
        "InstanceId": str,
        "InstanceMetadataOptions": ClientModifyInstanceMetadataOptionsResponseInstanceMetadataOptionsTypeDef,
    },
    total=False,
)

ClientModifyInstancePlacementResponseTypeDef = TypedDict(
    "ClientModifyInstancePlacementResponseTypeDef", {"Return": bool}, total=False
)

ClientModifyLaunchTemplateResponseLaunchTemplateTagsTypeDef = TypedDict(
    "ClientModifyLaunchTemplateResponseLaunchTemplateTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientModifyLaunchTemplateResponseLaunchTemplateTypeDef = TypedDict(
    "ClientModifyLaunchTemplateResponseLaunchTemplateTypeDef",
    {
        "LaunchTemplateId": str,
        "LaunchTemplateName": str,
        "CreateTime": datetime,
        "CreatedBy": str,
        "DefaultVersionNumber": int,
        "LatestVersionNumber": int,
        "Tags": List[ClientModifyLaunchTemplateResponseLaunchTemplateTagsTypeDef],
    },
    total=False,
)

ClientModifyLaunchTemplateResponseTypeDef = TypedDict(
    "ClientModifyLaunchTemplateResponseTypeDef",
    {"LaunchTemplate": ClientModifyLaunchTemplateResponseLaunchTemplateTypeDef},
    total=False,
)

ClientModifyNetworkInterfaceAttributeAttachmentTypeDef = TypedDict(
    "ClientModifyNetworkInterfaceAttributeAttachmentTypeDef",
    {"AttachmentId": str, "DeleteOnTermination": bool},
    total=False,
)

ClientModifyNetworkInterfaceAttributeDescriptionTypeDef = TypedDict(
    "ClientModifyNetworkInterfaceAttributeDescriptionTypeDef", {"Value": str}, total=False
)

ClientModifyNetworkInterfaceAttributeSourceDestCheckTypeDef = TypedDict(
    "ClientModifyNetworkInterfaceAttributeSourceDestCheckTypeDef", {"Value": bool}, total=False
)

ClientModifyReservedInstancesResponseTypeDef = TypedDict(
    "ClientModifyReservedInstancesResponseTypeDef",
    {"ReservedInstancesModificationId": str},
    total=False,
)

ClientModifyReservedInstancesTargetConfigurationsTypeDef = TypedDict(
    "ClientModifyReservedInstancesTargetConfigurationsTypeDef",
    {
        "AvailabilityZone": str,
        "InstanceCount": int,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "Platform": str,
        "Scope": Literal["Availability Zone", "Region"],
    },
    total=False,
)

ClientModifySnapshotAttributeCreateVolumePermissionAddTypeDef = TypedDict(
    "ClientModifySnapshotAttributeCreateVolumePermissionAddTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientModifySnapshotAttributeCreateVolumePermissionRemoveTypeDef = TypedDict(
    "ClientModifySnapshotAttributeCreateVolumePermissionRemoveTypeDef",
    {"Group": str, "UserId": str},
    total=False,
)

ClientModifySnapshotAttributeCreateVolumePermissionTypeDef = TypedDict(
    "ClientModifySnapshotAttributeCreateVolumePermissionTypeDef",
    {
        "Add": List[ClientModifySnapshotAttributeCreateVolumePermissionAddTypeDef],
        "Remove": List[ClientModifySnapshotAttributeCreateVolumePermissionRemoveTypeDef],
    },
    total=False,
)

ClientModifySpotFleetRequestResponseTypeDef = TypedDict(
    "ClientModifySpotFleetRequestResponseTypeDef", {"Return": bool}, total=False
)

ClientModifySubnetAttributeAssignIpv6AddressOnCreationTypeDef = TypedDict(
    "ClientModifySubnetAttributeAssignIpv6AddressOnCreationTypeDef", {"Value": bool}, total=False
)

ClientModifySubnetAttributeMapPublicIpOnLaunchTypeDef = TypedDict(
    "ClientModifySubnetAttributeMapPublicIpOnLaunchTypeDef", {"Value": bool}, total=False
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesDestinationPortRangeTypeDef,
        "SourcePortRange": ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesDestinationPortRangeTypeDef,
        "SourcePortRange": ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTagsTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTypeDef",
    {
        "TrafficMirrorFilterId": str,
        "IngressFilterRules": List[
            ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterIngressFilterRulesTypeDef
        ],
        "EgressFilterRules": List[
            ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterEgressFilterRulesTypeDef
        ],
        "NetworkServices": List[str],
        "Description": str,
        "Tags": List[
            ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTagsTypeDef
        ],
    },
    total=False,
)

ClientModifyTrafficMirrorFilterNetworkServicesResponseTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterNetworkServicesResponseTypeDef",
    {
        "TrafficMirrorFilter": ClientModifyTrafficMirrorFilterNetworkServicesResponseTrafficMirrorFilterTypeDef
    },
    total=False,
)

ClientModifyTrafficMirrorFilterRuleDestinationPortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef",
    {
        "TrafficMirrorFilterRuleId": str,
        "TrafficMirrorFilterId": str,
        "TrafficDirection": Literal["ingress", "egress"],
        "RuleNumber": int,
        "RuleAction": Literal["accept", "reject"],
        "Protocol": int,
        "DestinationPortRange": ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleDestinationPortRangeTypeDef,
        "SourcePortRange": ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleSourcePortRangeTypeDef,
        "DestinationCidrBlock": str,
        "SourceCidrBlock": str,
        "Description": str,
    },
    total=False,
)

ClientModifyTrafficMirrorFilterRuleResponseTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterRuleResponseTypeDef",
    {
        "TrafficMirrorFilterRule": ClientModifyTrafficMirrorFilterRuleResponseTrafficMirrorFilterRuleTypeDef
    },
    total=False,
)

ClientModifyTrafficMirrorFilterRuleSourcePortRangeTypeDef = TypedDict(
    "ClientModifyTrafficMirrorFilterRuleSourcePortRangeTypeDef",
    {"FromPort": int, "ToPort": int},
    total=False,
)

ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef = TypedDict(
    "ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef = TypedDict(
    "ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef",
    {
        "TrafficMirrorSessionId": str,
        "TrafficMirrorTargetId": str,
        "TrafficMirrorFilterId": str,
        "NetworkInterfaceId": str,
        "OwnerId": str,
        "PacketLength": int,
        "SessionNumber": int,
        "VirtualNetworkId": int,
        "Description": str,
        "Tags": List[ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTagsTypeDef],
    },
    total=False,
)

ClientModifyTrafficMirrorSessionResponseTypeDef = TypedDict(
    "ClientModifyTrafficMirrorSessionResponseTypeDef",
    {"TrafficMirrorSession": ClientModifyTrafficMirrorSessionResponseTrafficMirrorSessionTypeDef},
    total=False,
)

ClientModifyTransitGatewayVpcAttachmentOptionsTypeDef = TypedDict(
    "ClientModifyTransitGatewayVpcAttachmentOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef = TypedDict(
    "ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef = TypedDict(
    "ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef = TypedDict(
    "ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "TransitGatewayId": str,
        "VpcId": str,
        "VpcOwnerId": str,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "SubnetIds": List[str],
        "CreationTime": datetime,
        "Options": ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef,
        "Tags": List[
            ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientModifyTransitGatewayVpcAttachmentResponseTypeDef = TypedDict(
    "ClientModifyTransitGatewayVpcAttachmentResponseTypeDef",
    {
        "TransitGatewayVpcAttachment": ClientModifyTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef
    },
    total=False,
)

ClientModifyVolumeAttributeAutoEnableIOTypeDef = TypedDict(
    "ClientModifyVolumeAttributeAutoEnableIOTypeDef", {"Value": bool}, total=False
)

ClientModifyVolumeResponseVolumeModificationTypeDef = TypedDict(
    "ClientModifyVolumeResponseVolumeModificationTypeDef",
    {
        "VolumeId": str,
        "ModificationState": Literal["modifying", "optimizing", "completed", "failed"],
        "StatusMessage": str,
        "TargetSize": int,
        "TargetIops": int,
        "TargetVolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "OriginalSize": int,
        "OriginalIops": int,
        "OriginalVolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "Progress": int,
        "StartTime": datetime,
        "EndTime": datetime,
    },
    total=False,
)

ClientModifyVolumeResponseTypeDef = TypedDict(
    "ClientModifyVolumeResponseTypeDef",
    {"VolumeModification": ClientModifyVolumeResponseVolumeModificationTypeDef},
    total=False,
)

ClientModifyVpcAttributeEnableDnsHostnamesTypeDef = TypedDict(
    "ClientModifyVpcAttributeEnableDnsHostnamesTypeDef", {"Value": bool}, total=False
)

ClientModifyVpcAttributeEnableDnsSupportTypeDef = TypedDict(
    "ClientModifyVpcAttributeEnableDnsSupportTypeDef", {"Value": bool}, total=False
)

ClientModifyVpcEndpointConnectionNotificationResponseTypeDef = TypedDict(
    "ClientModifyVpcEndpointConnectionNotificationResponseTypeDef",
    {"ReturnValue": bool},
    total=False,
)

ClientModifyVpcEndpointResponseTypeDef = TypedDict(
    "ClientModifyVpcEndpointResponseTypeDef", {"Return": bool}, total=False
)

ClientModifyVpcEndpointServiceConfigurationResponseTypeDef = TypedDict(
    "ClientModifyVpcEndpointServiceConfigurationResponseTypeDef", {"Return": bool}, total=False
)

ClientModifyVpcEndpointServicePermissionsResponseTypeDef = TypedDict(
    "ClientModifyVpcEndpointServicePermissionsResponseTypeDef", {"ReturnValue": bool}, total=False
)

ClientModifyVpcPeeringConnectionOptionsAccepterPeeringConnectionOptionsTypeDef = TypedDict(
    "ClientModifyVpcPeeringConnectionOptionsAccepterPeeringConnectionOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientModifyVpcPeeringConnectionOptionsRequesterPeeringConnectionOptionsTypeDef = TypedDict(
    "ClientModifyVpcPeeringConnectionOptionsRequesterPeeringConnectionOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientModifyVpcPeeringConnectionOptionsResponseAccepterPeeringConnectionOptionsTypeDef = TypedDict(
    "ClientModifyVpcPeeringConnectionOptionsResponseAccepterPeeringConnectionOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientModifyVpcPeeringConnectionOptionsResponseRequesterPeeringConnectionOptionsTypeDef = TypedDict(
    "ClientModifyVpcPeeringConnectionOptionsResponseRequesterPeeringConnectionOptionsTypeDef",
    {
        "AllowDnsResolutionFromRemoteVpc": bool,
        "AllowEgressFromLocalClassicLinkToRemoteVpc": bool,
        "AllowEgressFromLocalVpcToRemoteClassicLink": bool,
    },
    total=False,
)

ClientModifyVpcPeeringConnectionOptionsResponseTypeDef = TypedDict(
    "ClientModifyVpcPeeringConnectionOptionsResponseTypeDef",
    {
        "AccepterPeeringConnectionOptions": ClientModifyVpcPeeringConnectionOptionsResponseAccepterPeeringConnectionOptionsTypeDef,
        "RequesterPeeringConnectionOptions": ClientModifyVpcPeeringConnectionOptionsResponseRequesterPeeringConnectionOptionsTypeDef,
    },
    total=False,
)

ClientModifyVpcTenancyResponseTypeDef = TypedDict(
    "ClientModifyVpcTenancyResponseTypeDef", {"ReturnValue": bool}, total=False
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    {
        "OutsideIpAddress": str,
        "TunnelInsideCidr": str,
        "PreSharedKey": str,
        "Phase1LifetimeSeconds": int,
        "Phase2LifetimeSeconds": int,
        "RekeyMarginTimeSeconds": int,
        "RekeyFuzzPercentage": int,
        "ReplayWindowSize": int,
        "DpdTimeoutSeconds": int,
        "Phase1EncryptionAlgorithms": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef
        ],
        "Phase2EncryptionAlgorithms": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef
        ],
        "Phase1IntegrityAlgorithms": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef
        ],
        "Phase2IntegrityAlgorithms": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef
        ],
        "Phase1DHGroupNumbers": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef
        ],
        "Phase2DHGroupNumbers": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef
        ],
        "IkeVersions": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef
        ],
    },
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionOptionsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionOptionsTypeDef",
    {
        "EnableAcceleration": bool,
        "StaticRoutesOnly": bool,
        "TunnelOptions": List[
            ClientModifyVpnConnectionResponseVpnConnectionOptionsTunnelOptionsTypeDef
        ],
    },
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionRoutesTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "Source": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
    },
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionTagsTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef",
    {
        "AcceptedRouteCount": int,
        "LastStatusChange": datetime,
        "OutsideIpAddress": str,
        "Status": Literal["UP", "DOWN"],
        "StatusMessage": str,
        "CertificateArn": str,
    },
    total=False,
)

ClientModifyVpnConnectionResponseVpnConnectionTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseVpnConnectionTypeDef",
    {
        "CustomerGatewayConfiguration": str,
        "CustomerGatewayId": str,
        "Category": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Type": str,
        "VpnConnectionId": str,
        "VpnGatewayId": str,
        "TransitGatewayId": str,
        "Options": ClientModifyVpnConnectionResponseVpnConnectionOptionsTypeDef,
        "Routes": List[ClientModifyVpnConnectionResponseVpnConnectionRoutesTypeDef],
        "Tags": List[ClientModifyVpnConnectionResponseVpnConnectionTagsTypeDef],
        "VgwTelemetry": List[ClientModifyVpnConnectionResponseVpnConnectionVgwTelemetryTypeDef],
    },
    total=False,
)

ClientModifyVpnConnectionResponseTypeDef = TypedDict(
    "ClientModifyVpnConnectionResponseTypeDef",
    {"VpnConnection": ClientModifyVpnConnectionResponseVpnConnectionTypeDef},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    {
        "OutsideIpAddress": str,
        "TunnelInsideCidr": str,
        "PreSharedKey": str,
        "Phase1LifetimeSeconds": int,
        "Phase2LifetimeSeconds": int,
        "RekeyMarginTimeSeconds": int,
        "RekeyFuzzPercentage": int,
        "ReplayWindowSize": int,
        "DpdTimeoutSeconds": int,
        "Phase1EncryptionAlgorithms": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef
        ],
        "Phase2EncryptionAlgorithms": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef
        ],
        "Phase1IntegrityAlgorithms": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef
        ],
        "Phase2IntegrityAlgorithms": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef
        ],
        "Phase1DHGroupNumbers": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef
        ],
        "Phase2DHGroupNumbers": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef
        ],
        "IkeVersions": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef
        ],
    },
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTypeDef",
    {
        "EnableAcceleration": bool,
        "StaticRoutesOnly": bool,
        "TunnelOptions": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTunnelOptionsTypeDef
        ],
    },
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionRoutesTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "Source": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
    },
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionTagsTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionVgwTelemetryTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionVgwTelemetryTypeDef",
    {
        "AcceptedRouteCount": int,
        "LastStatusChange": datetime,
        "OutsideIpAddress": str,
        "Status": Literal["UP", "DOWN"],
        "StatusMessage": str,
        "CertificateArn": str,
    },
    total=False,
)

ClientModifyVpnTunnelCertificateResponseVpnConnectionTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseVpnConnectionTypeDef",
    {
        "CustomerGatewayConfiguration": str,
        "CustomerGatewayId": str,
        "Category": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Type": str,
        "VpnConnectionId": str,
        "VpnGatewayId": str,
        "TransitGatewayId": str,
        "Options": ClientModifyVpnTunnelCertificateResponseVpnConnectionOptionsTypeDef,
        "Routes": List[ClientModifyVpnTunnelCertificateResponseVpnConnectionRoutesTypeDef],
        "Tags": List[ClientModifyVpnTunnelCertificateResponseVpnConnectionTagsTypeDef],
        "VgwTelemetry": List[
            ClientModifyVpnTunnelCertificateResponseVpnConnectionVgwTelemetryTypeDef
        ],
    },
    total=False,
)

ClientModifyVpnTunnelCertificateResponseTypeDef = TypedDict(
    "ClientModifyVpnTunnelCertificateResponseTypeDef",
    {"VpnConnection": ClientModifyVpnTunnelCertificateResponseVpnConnectionTypeDef},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsTypeDef",
    {
        "OutsideIpAddress": str,
        "TunnelInsideCidr": str,
        "PreSharedKey": str,
        "Phase1LifetimeSeconds": int,
        "Phase2LifetimeSeconds": int,
        "RekeyMarginTimeSeconds": int,
        "RekeyFuzzPercentage": int,
        "ReplayWindowSize": int,
        "DpdTimeoutSeconds": int,
        "Phase1EncryptionAlgorithms": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef
        ],
        "Phase2EncryptionAlgorithms": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef
        ],
        "Phase1IntegrityAlgorithms": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef
        ],
        "Phase2IntegrityAlgorithms": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef
        ],
        "Phase1DHGroupNumbers": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef
        ],
        "Phase2DHGroupNumbers": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef
        ],
        "IkeVersions": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsIkeVersionsTypeDef
        ],
    },
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTypeDef",
    {
        "EnableAcceleration": bool,
        "StaticRoutesOnly": bool,
        "TunnelOptions": List[
            ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTunnelOptionsTypeDef
        ],
    },
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionRoutesTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "Source": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
    },
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionTagsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionVgwTelemetryTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionVgwTelemetryTypeDef",
    {
        "AcceptedRouteCount": int,
        "LastStatusChange": datetime,
        "OutsideIpAddress": str,
        "Status": Literal["UP", "DOWN"],
        "StatusMessage": str,
        "CertificateArn": str,
    },
    total=False,
)

ClientModifyVpnTunnelOptionsResponseVpnConnectionTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseVpnConnectionTypeDef",
    {
        "CustomerGatewayConfiguration": str,
        "CustomerGatewayId": str,
        "Category": str,
        "State": Literal["pending", "available", "deleting", "deleted"],
        "Type": str,
        "VpnConnectionId": str,
        "VpnGatewayId": str,
        "TransitGatewayId": str,
        "Options": ClientModifyVpnTunnelOptionsResponseVpnConnectionOptionsTypeDef,
        "Routes": List[ClientModifyVpnTunnelOptionsResponseVpnConnectionRoutesTypeDef],
        "Tags": List[ClientModifyVpnTunnelOptionsResponseVpnConnectionTagsTypeDef],
        "VgwTelemetry": List[ClientModifyVpnTunnelOptionsResponseVpnConnectionVgwTelemetryTypeDef],
    },
    total=False,
)

ClientModifyVpnTunnelOptionsResponseTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsResponseTypeDef",
    {"VpnConnection": ClientModifyVpnTunnelOptionsResponseVpnConnectionTypeDef},
    total=False,
)

ClientModifyVpnTunnelOptionsTunnelOptionsIKEVersionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsIKEVersionsTypeDef", {"Value": str}, total=False
)

ClientModifyVpnTunnelOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnTunnelOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef",
    {"Value": int},
    total=False,
)

ClientModifyVpnTunnelOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef",
    {"Value": str},
    total=False,
)

ClientModifyVpnTunnelOptionsTunnelOptionsTypeDef = TypedDict(
    "ClientModifyVpnTunnelOptionsTunnelOptionsTypeDef",
    {
        "TunnelInsideCidr": str,
        "PreSharedKey": str,
        "Phase1LifetimeSeconds": int,
        "Phase2LifetimeSeconds": int,
        "RekeyMarginTimeSeconds": int,
        "RekeyFuzzPercentage": int,
        "ReplayWindowSize": int,
        "DPDTimeoutSeconds": int,
        "Phase1EncryptionAlgorithms": List[
            ClientModifyVpnTunnelOptionsTunnelOptionsPhase1EncryptionAlgorithmsTypeDef
        ],
        "Phase2EncryptionAlgorithms": List[
            ClientModifyVpnTunnelOptionsTunnelOptionsPhase2EncryptionAlgorithmsTypeDef
        ],
        "Phase1IntegrityAlgorithms": List[
            ClientModifyVpnTunnelOptionsTunnelOptionsPhase1IntegrityAlgorithmsTypeDef
        ],
        "Phase2IntegrityAlgorithms": List[
            ClientModifyVpnTunnelOptionsTunnelOptionsPhase2IntegrityAlgorithmsTypeDef
        ],
        "Phase1DHGroupNumbers": List[
            ClientModifyVpnTunnelOptionsTunnelOptionsPhase1DHGroupNumbersTypeDef
        ],
        "Phase2DHGroupNumbers": List[
            ClientModifyVpnTunnelOptionsTunnelOptionsPhase2DHGroupNumbersTypeDef
        ],
        "IKEVersions": List[ClientModifyVpnTunnelOptionsTunnelOptionsIKEVersionsTypeDef],
    },
    total=False,
)

ClientMonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef = TypedDict(
    "ClientMonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef",
    {"State": Literal["disabled", "disabling", "enabled", "pending"]},
    total=False,
)

ClientMonitorInstancesResponseInstanceMonitoringsTypeDef = TypedDict(
    "ClientMonitorInstancesResponseInstanceMonitoringsTypeDef",
    {
        "InstanceId": str,
        "Monitoring": ClientMonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef,
    },
    total=False,
)

ClientMonitorInstancesResponseTypeDef = TypedDict(
    "ClientMonitorInstancesResponseTypeDef",
    {"InstanceMonitorings": List[ClientMonitorInstancesResponseInstanceMonitoringsTypeDef]},
    total=False,
)

ClientMoveAddressToVpcResponseTypeDef = TypedDict(
    "ClientMoveAddressToVpcResponseTypeDef",
    {"AllocationId": str, "Status": Literal["MoveInProgress", "InVpc", "InClassic"]},
    total=False,
)

_RequiredClientProvisionByoipCidrCidrAuthorizationContextTypeDef = TypedDict(
    "_RequiredClientProvisionByoipCidrCidrAuthorizationContextTypeDef", {"Message": str}
)
_OptionalClientProvisionByoipCidrCidrAuthorizationContextTypeDef = TypedDict(
    "_OptionalClientProvisionByoipCidrCidrAuthorizationContextTypeDef",
    {"Signature": str},
    total=False,
)


class ClientProvisionByoipCidrCidrAuthorizationContextTypeDef(
    _RequiredClientProvisionByoipCidrCidrAuthorizationContextTypeDef,
    _OptionalClientProvisionByoipCidrCidrAuthorizationContextTypeDef,
):
    pass


ClientProvisionByoipCidrResponseByoipCidrTypeDef = TypedDict(
    "ClientProvisionByoipCidrResponseByoipCidrTypeDef",
    {
        "Cidr": str,
        "Description": str,
        "StatusMessage": str,
        "State": Literal[
            "advertised",
            "deprovisioned",
            "failed-deprovision",
            "failed-provision",
            "pending-deprovision",
            "pending-provision",
            "provisioned",
            "provisioned-not-publicly-advertisable",
        ],
    },
    total=False,
)

ClientProvisionByoipCidrResponseTypeDef = TypedDict(
    "ClientProvisionByoipCidrResponseTypeDef",
    {"ByoipCidr": ClientProvisionByoipCidrResponseByoipCidrTypeDef},
    total=False,
)

ClientPurchaseHostReservationResponsePurchaseTypeDef = TypedDict(
    "ClientPurchaseHostReservationResponsePurchaseTypeDef",
    {
        "CurrencyCode": str,
        "Duration": int,
        "HostIdSet": List[str],
        "HostReservationId": str,
        "HourlyPrice": str,
        "InstanceFamily": str,
        "PaymentOption": Literal["AllUpfront", "PartialUpfront", "NoUpfront"],
        "UpfrontPrice": str,
    },
    total=False,
)

ClientPurchaseHostReservationResponseTypeDef = TypedDict(
    "ClientPurchaseHostReservationResponseTypeDef",
    {
        "ClientToken": str,
        "CurrencyCode": str,
        "Purchase": List[ClientPurchaseHostReservationResponsePurchaseTypeDef],
        "TotalHourlyPrice": str,
        "TotalUpfrontPrice": str,
    },
    total=False,
)

ClientPurchaseReservedInstancesOfferingLimitPriceTypeDef = TypedDict(
    "ClientPurchaseReservedInstancesOfferingLimitPriceTypeDef",
    {"Amount": float, "CurrencyCode": str},
    total=False,
)

ClientPurchaseReservedInstancesOfferingResponseTypeDef = TypedDict(
    "ClientPurchaseReservedInstancesOfferingResponseTypeDef",
    {"ReservedInstancesId": str},
    total=False,
)

_RequiredClientPurchaseScheduledInstancesPurchaseRequestsTypeDef = TypedDict(
    "_RequiredClientPurchaseScheduledInstancesPurchaseRequestsTypeDef", {"InstanceCount": int}
)
_OptionalClientPurchaseScheduledInstancesPurchaseRequestsTypeDef = TypedDict(
    "_OptionalClientPurchaseScheduledInstancesPurchaseRequestsTypeDef",
    {"PurchaseToken": str},
    total=False,
)


class ClientPurchaseScheduledInstancesPurchaseRequestsTypeDef(
    _RequiredClientPurchaseScheduledInstancesPurchaseRequestsTypeDef,
    _OptionalClientPurchaseScheduledInstancesPurchaseRequestsTypeDef,
):
    pass


ClientPurchaseScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef = TypedDict(
    "ClientPurchaseScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef",
    {
        "Frequency": str,
        "Interval": int,
        "OccurrenceDaySet": List[int],
        "OccurrenceRelativeToEnd": bool,
        "OccurrenceUnit": str,
    },
    total=False,
)

ClientPurchaseScheduledInstancesResponseScheduledInstanceSetTypeDef = TypedDict(
    "ClientPurchaseScheduledInstancesResponseScheduledInstanceSetTypeDef",
    {
        "AvailabilityZone": str,
        "CreateDate": datetime,
        "HourlyPrice": str,
        "InstanceCount": int,
        "InstanceType": str,
        "NetworkPlatform": str,
        "NextSlotStartTime": datetime,
        "Platform": str,
        "PreviousSlotEndTime": datetime,
        "Recurrence": ClientPurchaseScheduledInstancesResponseScheduledInstanceSetRecurrenceTypeDef,
        "ScheduledInstanceId": str,
        "SlotDurationInHours": int,
        "TermEndDate": datetime,
        "TermStartDate": datetime,
        "TotalScheduledInstanceHours": int,
    },
    total=False,
)

ClientPurchaseScheduledInstancesResponseTypeDef = TypedDict(
    "ClientPurchaseScheduledInstancesResponseTypeDef",
    {
        "ScheduledInstanceSet": List[
            ClientPurchaseScheduledInstancesResponseScheduledInstanceSetTypeDef
        ]
    },
    total=False,
)

ClientRegisterImageBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientRegisterImageBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientRegisterImageBlockDeviceMappingsTypeDef = TypedDict(
    "ClientRegisterImageBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientRegisterImageBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientRegisterImageResponseTypeDef = TypedDict(
    "ClientRegisterImageResponseTypeDef", {"ImageId": str}, total=False
)

ClientRegisterTransitGatewayMulticastGroupMembersResponseRegisteredMulticastGroupMembersTypeDef = TypedDict(
    "ClientRegisterTransitGatewayMulticastGroupMembersResponseRegisteredMulticastGroupMembersTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "RegisteredNetworkInterfaceIds": List[str],
        "GroupIpAddress": str,
    },
    total=False,
)

ClientRegisterTransitGatewayMulticastGroupMembersResponseTypeDef = TypedDict(
    "ClientRegisterTransitGatewayMulticastGroupMembersResponseTypeDef",
    {
        "RegisteredMulticastGroupMembers": ClientRegisterTransitGatewayMulticastGroupMembersResponseRegisteredMulticastGroupMembersTypeDef
    },
    total=False,
)

ClientRegisterTransitGatewayMulticastGroupSourcesResponseRegisteredMulticastGroupSourcesTypeDef = TypedDict(
    "ClientRegisterTransitGatewayMulticastGroupSourcesResponseRegisteredMulticastGroupSourcesTypeDef",
    {
        "TransitGatewayMulticastDomainId": str,
        "RegisteredNetworkInterfaceIds": List[str],
        "GroupIpAddress": str,
    },
    total=False,
)

ClientRegisterTransitGatewayMulticastGroupSourcesResponseTypeDef = TypedDict(
    "ClientRegisterTransitGatewayMulticastGroupSourcesResponseTypeDef",
    {
        "RegisteredMulticastGroupSources": ClientRegisterTransitGatewayMulticastGroupSourcesResponseRegisteredMulticastGroupSourcesTypeDef
    },
    total=False,
)

ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef = TypedDict(
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef = TypedDict(
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef",
    {"TransitGatewayId": str, "OwnerId": str, "Region": str},
    total=False,
)

ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef = TypedDict(
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef = TypedDict(
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef = TypedDict(
    "ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "RequesterTgwInfo": ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentRequesterTgwInfoTypeDef,
        "AccepterTgwInfo": ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentAccepterTgwInfoTypeDef,
        "Status": ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentStatusTypeDef,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "CreationTime": datetime,
        "Tags": List[
            ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientRejectTransitGatewayPeeringAttachmentResponseTypeDef = TypedDict(
    "ClientRejectTransitGatewayPeeringAttachmentResponseTypeDef",
    {
        "TransitGatewayPeeringAttachment": ClientRejectTransitGatewayPeeringAttachmentResponseTransitGatewayPeeringAttachmentTypeDef
    },
    total=False,
)

ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef = TypedDict(
    "ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef",
    {"DnsSupport": Literal["enable", "disable"], "Ipv6Support": Literal["enable", "disable"]},
    total=False,
)

ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef = TypedDict(
    "ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef = TypedDict(
    "ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef",
    {
        "TransitGatewayAttachmentId": str,
        "TransitGatewayId": str,
        "VpcId": str,
        "VpcOwnerId": str,
        "State": Literal[
            "initiating",
            "pendingAcceptance",
            "rollingBack",
            "pending",
            "available",
            "modifying",
            "deleting",
            "deleted",
            "failed",
            "rejected",
            "rejecting",
            "failing",
        ],
        "SubnetIds": List[str],
        "CreationTime": datetime,
        "Options": ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentOptionsTypeDef,
        "Tags": List[
            ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTagsTypeDef
        ],
    },
    total=False,
)

ClientRejectTransitGatewayVpcAttachmentResponseTypeDef = TypedDict(
    "ClientRejectTransitGatewayVpcAttachmentResponseTypeDef",
    {
        "TransitGatewayVpcAttachment": ClientRejectTransitGatewayVpcAttachmentResponseTransitGatewayVpcAttachmentTypeDef
    },
    total=False,
)

ClientRejectVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientRejectVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientRejectVpcEndpointConnectionsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientRejectVpcEndpointConnectionsResponseUnsuccessfulTypeDef",
    {
        "Error": ClientRejectVpcEndpointConnectionsResponseUnsuccessfulErrorTypeDef,
        "ResourceId": str,
    },
    total=False,
)

ClientRejectVpcEndpointConnectionsResponseTypeDef = TypedDict(
    "ClientRejectVpcEndpointConnectionsResponseTypeDef",
    {"Unsuccessful": List[ClientRejectVpcEndpointConnectionsResponseUnsuccessfulTypeDef]},
    total=False,
)

ClientRejectVpcPeeringConnectionResponseTypeDef = TypedDict(
    "ClientRejectVpcPeeringConnectionResponseTypeDef", {"Return": bool}, total=False
)

ClientReleaseHostsResponseUnsuccessfulErrorTypeDef = TypedDict(
    "ClientReleaseHostsResponseUnsuccessfulErrorTypeDef", {"Code": str, "Message": str}, total=False
)

ClientReleaseHostsResponseUnsuccessfulTypeDef = TypedDict(
    "ClientReleaseHostsResponseUnsuccessfulTypeDef",
    {"Error": ClientReleaseHostsResponseUnsuccessfulErrorTypeDef, "ResourceId": str},
    total=False,
)

ClientReleaseHostsResponseTypeDef = TypedDict(
    "ClientReleaseHostsResponseTypeDef",
    {"Successful": List[str], "Unsuccessful": List[ClientReleaseHostsResponseUnsuccessfulTypeDef]},
    total=False,
)

ClientReplaceIamInstanceProfileAssociationIamInstanceProfileTypeDef = TypedDict(
    "ClientReplaceIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef = TypedDict(
    "ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef",
    {"Arn": str, "Id": str},
    total=False,
)

ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationTypeDef = TypedDict(
    "ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationTypeDef",
    {
        "AssociationId": str,
        "InstanceId": str,
        "IamInstanceProfile": ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationIamInstanceProfileTypeDef,
        "State": Literal["associating", "associated", "disassociating", "disassociated"],
        "Timestamp": datetime,
    },
    total=False,
)

ClientReplaceIamInstanceProfileAssociationResponseTypeDef = TypedDict(
    "ClientReplaceIamInstanceProfileAssociationResponseTypeDef",
    {
        "IamInstanceProfileAssociation": ClientReplaceIamInstanceProfileAssociationResponseIamInstanceProfileAssociationTypeDef
    },
    total=False,
)

ClientReplaceNetworkAclAssociationResponseTypeDef = TypedDict(
    "ClientReplaceNetworkAclAssociationResponseTypeDef", {"NewAssociationId": str}, total=False
)

ClientReplaceNetworkAclEntryIcmpTypeCodeTypeDef = TypedDict(
    "ClientReplaceNetworkAclEntryIcmpTypeCodeTypeDef", {"Code": int, "Type": int}, total=False
)

ClientReplaceNetworkAclEntryPortRangeTypeDef = TypedDict(
    "ClientReplaceNetworkAclEntryPortRangeTypeDef", {"From": int, "To": int}, total=False
)

ClientReplaceRouteTableAssociationResponseAssociationStateTypeDef = TypedDict(
    "ClientReplaceRouteTableAssociationResponseAssociationStateTypeDef",
    {
        "State": Literal["associating", "associated", "disassociating", "disassociated", "failed"],
        "StatusMessage": str,
    },
    total=False,
)

ClientReplaceRouteTableAssociationResponseTypeDef = TypedDict(
    "ClientReplaceRouteTableAssociationResponseTypeDef",
    {
        "NewAssociationId": str,
        "AssociationState": ClientReplaceRouteTableAssociationResponseAssociationStateTypeDef,
    },
    total=False,
)

ClientReplaceTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef = TypedDict(
    "ClientReplaceTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef",
    {
        "ResourceId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
    },
    total=False,
)

ClientReplaceTransitGatewayRouteResponseRouteTypeDef = TypedDict(
    "ClientReplaceTransitGatewayRouteResponseRouteTypeDef",
    {
        "DestinationCidrBlock": str,
        "TransitGatewayAttachments": List[
            ClientReplaceTransitGatewayRouteResponseRouteTransitGatewayAttachmentsTypeDef
        ],
        "Type": Literal["static", "propagated"],
        "State": Literal["pending", "active", "blackhole", "deleting", "deleted"],
    },
    total=False,
)

ClientReplaceTransitGatewayRouteResponseTypeDef = TypedDict(
    "ClientReplaceTransitGatewayRouteResponseTypeDef",
    {"Route": ClientReplaceTransitGatewayRouteResponseRouteTypeDef},
    total=False,
)

ClientRequestSpotFleetResponseTypeDef = TypedDict(
    "ClientRequestSpotFleetResponseTypeDef", {"SpotFleetRequestId": str}, total=False
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef",
    {"AvailabilityZone": str, "GroupName": str, "Tenancy": Literal["default", "dedicated", "host"]},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTagsTypeDef
        ],
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTypeDef",
    {
        "SecurityGroups": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsSecurityGroupsTypeDef
        ],
        "AddressingType": str,
        "BlockDeviceMappings": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsBlockDeviceMappingsTypeDef
        ],
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsIamInstanceProfileTypeDef,
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KernelId": str,
        "KeyName": str,
        "Monitoring": ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsMonitoringTypeDef,
        "NetworkInterfaces": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsNetworkInterfacesTypeDef
        ],
        "Placement": ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsPlacementTypeDef,
        "RamdiskId": str,
        "SpotPrice": str,
        "SubnetId": str,
        "UserData": str,
        "WeightedCapacity": float,
        "TagSpecifications": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTagSpecificationsTypeDef
        ],
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef",
    {
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "SpotPrice": str,
        "SubnetId": str,
        "AvailabilityZone": str,
        "WeightedCapacity": float,
        "Priority": float,
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsTypeDef",
    {
        "LaunchTemplateSpecification": ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsLaunchTemplateSpecificationTypeDef,
        "Overrides": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsOverridesTypeDef
        ],
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef",
    {"Name": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef",
    {
        "ClassicLoadBalancers": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigClassicLoadBalancersTypeDef
        ]
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef",
    {"Arn": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef",
    {
        "TargetGroups": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTargetGroupsTypeDef
        ]
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTypeDef",
    {
        "ClassicLoadBalancersConfig": ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigClassicLoadBalancersConfigTypeDef,
        "TargetGroupsConfig": ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTargetGroupsConfigTypeDef,
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTagsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientRequestSpotFleetSpotFleetRequestConfigTypeDef = TypedDict(
    "ClientRequestSpotFleetSpotFleetRequestConfigTypeDef",
    {
        "AllocationStrategy": Literal["lowestPrice", "diversified", "capacityOptimized"],
        "OnDemandAllocationStrategy": Literal["lowestPrice", "prioritized"],
        "ClientToken": str,
        "ExcessCapacityTerminationPolicy": Literal["noTermination", "default"],
        "FulfilledCapacity": float,
        "OnDemandFulfilledCapacity": float,
        "IamFleetRole": str,
        "LaunchSpecifications": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchSpecificationsTypeDef
        ],
        "LaunchTemplateConfigs": List[
            ClientRequestSpotFleetSpotFleetRequestConfigLaunchTemplateConfigsTypeDef
        ],
        "SpotPrice": str,
        "TargetCapacity": int,
        "OnDemandTargetCapacity": int,
        "OnDemandMaxTotalPrice": str,
        "SpotMaxTotalPrice": str,
        "TerminateInstancesWithExpiration": bool,
        "Type": Literal["request", "maintain", "instant"],
        "ValidFrom": datetime,
        "ValidUntil": datetime,
        "ReplaceUnhealthyInstances": bool,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
        "LoadBalancersConfig": ClientRequestSpotFleetSpotFleetRequestConfigLoadBalancersConfigTypeDef,
        "InstancePoolsToUseCount": int,
        "TagSpecifications": List[
            ClientRequestSpotFleetSpotFleetRequestConfigTagSpecificationsTypeDef
        ],
    },
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationIamInstanceProfileTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationMonitoringTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationMonitoringTypeDef", {"Enabled": bool}, total=False
)

ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationPlacementTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationPlacementTypeDef",
    {"AvailabilityZone": str, "GroupName": str, "Tenancy": Literal["default", "dedicated", "host"]},
    total=False,
)

ClientRequestSpotInstancesLaunchSpecificationTypeDef = TypedDict(
    "ClientRequestSpotInstancesLaunchSpecificationTypeDef",
    {
        "SecurityGroupIds": List[str],
        "SecurityGroups": List[str],
        "AddressingType": str,
        "BlockDeviceMappings": List[
            ClientRequestSpotInstancesLaunchSpecificationBlockDeviceMappingsTypeDef
        ],
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientRequestSpotInstancesLaunchSpecificationIamInstanceProfileTypeDef,
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KernelId": str,
        "KeyName": str,
        "Monitoring": ClientRequestSpotInstancesLaunchSpecificationMonitoringTypeDef,
        "NetworkInterfaces": List[
            ClientRequestSpotInstancesLaunchSpecificationNetworkInterfacesTypeDef
        ],
        "Placement": ClientRequestSpotInstancesLaunchSpecificationPlacementTypeDef,
        "RamdiskId": str,
        "SubnetId": str,
        "UserData": str,
    },
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsFaultTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsFaultTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef",
    {"AvailabilityZone": str, "GroupName": str, "Tenancy": Literal["default", "dedicated", "host"]},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationTypeDef",
    {
        "UserData": str,
        "SecurityGroups": List[
            ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationSecurityGroupsTypeDef
        ],
        "AddressingType": str,
        "BlockDeviceMappings": List[
            ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationBlockDeviceMappingsTypeDef
        ],
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationIamInstanceProfileTypeDef,
        "ImageId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KernelId": str,
        "KeyName": str,
        "NetworkInterfaces": List[
            ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationNetworkInterfacesTypeDef
        ],
        "Placement": ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationPlacementTypeDef,
        "RamdiskId": str,
        "SubnetId": str,
        "Monitoring": ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationMonitoringTypeDef,
    },
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsStatusTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsStatusTypeDef",
    {"Code": str, "Message": str, "UpdateTime": datetime},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsTagsTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)

ClientRequestSpotInstancesResponseSpotInstanceRequestsTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseSpotInstanceRequestsTypeDef",
    {
        "ActualBlockHourlyPrice": str,
        "AvailabilityZoneGroup": str,
        "BlockDurationMinutes": int,
        "CreateTime": datetime,
        "Fault": ClientRequestSpotInstancesResponseSpotInstanceRequestsFaultTypeDef,
        "InstanceId": str,
        "LaunchGroup": str,
        "LaunchSpecification": ClientRequestSpotInstancesResponseSpotInstanceRequestsLaunchSpecificationTypeDef,
        "LaunchedAvailabilityZone": str,
        "ProductDescription": Literal[
            "Linux/UNIX", "Linux/UNIX (Amazon VPC)", "Windows", "Windows (Amazon VPC)"
        ],
        "SpotInstanceRequestId": str,
        "SpotPrice": str,
        "State": Literal["open", "active", "closed", "cancelled", "failed"],
        "Status": ClientRequestSpotInstancesResponseSpotInstanceRequestsStatusTypeDef,
        "Tags": List[ClientRequestSpotInstancesResponseSpotInstanceRequestsTagsTypeDef],
        "Type": Literal["one-time", "persistent"],
        "ValidFrom": datetime,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientRequestSpotInstancesResponseTypeDef = TypedDict(
    "ClientRequestSpotInstancesResponseTypeDef",
    {"SpotInstanceRequests": List[ClientRequestSpotInstancesResponseSpotInstanceRequestsTypeDef]},
    total=False,
)

ClientResetEbsDefaultKmsKeyIdResponseTypeDef = TypedDict(
    "ClientResetEbsDefaultKmsKeyIdResponseTypeDef", {"KmsKeyId": str}, total=False
)

ClientResetFpgaImageAttributeResponseTypeDef = TypedDict(
    "ClientResetFpgaImageAttributeResponseTypeDef", {"Return": bool}, total=False
)

ClientRestoreAddressToClassicResponseTypeDef = TypedDict(
    "ClientRestoreAddressToClassicResponseTypeDef",
    {"PublicIp": str, "Status": Literal["MoveInProgress", "InVpc", "InClassic"]},
    total=False,
)

ClientRevokeClientVpnIngressResponseStatusTypeDef = TypedDict(
    "ClientRevokeClientVpnIngressResponseStatusTypeDef",
    {"Code": Literal["authorizing", "active", "failed", "revoking"], "Message": str},
    total=False,
)

ClientRevokeClientVpnIngressResponseTypeDef = TypedDict(
    "ClientRevokeClientVpnIngressResponseTypeDef",
    {"Status": ClientRevokeClientVpnIngressResponseStatusTypeDef},
    total=False,
)

ClientRevokeSecurityGroupEgressIpPermissionsIpRangesTypeDef = TypedDict(
    "ClientRevokeSecurityGroupEgressIpPermissionsIpRangesTypeDef",
    {"CidrIp": str, "Description": str},
    total=False,
)

ClientRevokeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef = TypedDict(
    "ClientRevokeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef",
    {"CidrIpv6": str, "Description": str},
    total=False,
)

ClientRevokeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef = TypedDict(
    "ClientRevokeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef",
    {"Description": str, "PrefixListId": str},
    total=False,
)

ClientRevokeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef = TypedDict(
    "ClientRevokeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientRevokeSecurityGroupEgressIpPermissionsTypeDef = TypedDict(
    "ClientRevokeSecurityGroupEgressIpPermissionsTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[ClientRevokeSecurityGroupEgressIpPermissionsIpRangesTypeDef],
        "Ipv6Ranges": List[ClientRevokeSecurityGroupEgressIpPermissionsIpv6RangesTypeDef],
        "PrefixListIds": List[ClientRevokeSecurityGroupEgressIpPermissionsPrefixListIdsTypeDef],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientRevokeSecurityGroupEgressIpPermissionsUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientRevokeSecurityGroupIngressIpPermissionsIpRangesTypeDef = TypedDict(
    "ClientRevokeSecurityGroupIngressIpPermissionsIpRangesTypeDef",
    {"CidrIp": str, "Description": str},
    total=False,
)

ClientRevokeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef = TypedDict(
    "ClientRevokeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef",
    {"CidrIpv6": str, "Description": str},
    total=False,
)

ClientRevokeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef = TypedDict(
    "ClientRevokeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef",
    {"Description": str, "PrefixListId": str},
    total=False,
)

ClientRevokeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef = TypedDict(
    "ClientRevokeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnectionId": str,
    },
    total=False,
)

ClientRevokeSecurityGroupIngressIpPermissionsTypeDef = TypedDict(
    "ClientRevokeSecurityGroupIngressIpPermissionsTypeDef",
    {
        "FromPort": int,
        "IpProtocol": str,
        "IpRanges": List[ClientRevokeSecurityGroupIngressIpPermissionsIpRangesTypeDef],
        "Ipv6Ranges": List[ClientRevokeSecurityGroupIngressIpPermissionsIpv6RangesTypeDef],
        "PrefixListIds": List[ClientRevokeSecurityGroupIngressIpPermissionsPrefixListIdsTypeDef],
        "ToPort": int,
        "UserIdGroupPairs": List[
            ClientRevokeSecurityGroupIngressIpPermissionsUserIdGroupPairsTypeDef
        ],
    },
    total=False,
)

ClientRunInstancesBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientRunInstancesBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": Literal["standard", "io1", "gp2", "sc1", "st1"],
        "KmsKeyId": str,
        "Encrypted": bool,
    },
    total=False,
)

ClientRunInstancesBlockDeviceMappingsTypeDef = TypedDict(
    "ClientRunInstancesBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "VirtualName": str,
        "Ebs": ClientRunInstancesBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
    },
    total=False,
)

ClientRunInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientRunInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientRunInstancesCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientRunInstancesCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientRunInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientRunInstancesCpuOptionsTypeDef = TypedDict(
    "ClientRunInstancesCpuOptionsTypeDef", {"CoreCount": int, "ThreadsPerCore": int}, total=False
)

ClientRunInstancesCreditSpecificationTypeDef = TypedDict(
    "ClientRunInstancesCreditSpecificationTypeDef", {"CpuCredits": str}
)

ClientRunInstancesElasticGpuSpecificationTypeDef = TypedDict(
    "ClientRunInstancesElasticGpuSpecificationTypeDef", {"Type": str}
)

_RequiredClientRunInstancesElasticInferenceAcceleratorsTypeDef = TypedDict(
    "_RequiredClientRunInstancesElasticInferenceAcceleratorsTypeDef", {"Type": str}
)
_OptionalClientRunInstancesElasticInferenceAcceleratorsTypeDef = TypedDict(
    "_OptionalClientRunInstancesElasticInferenceAcceleratorsTypeDef", {"Count": int}, total=False
)


class ClientRunInstancesElasticInferenceAcceleratorsTypeDef(
    _RequiredClientRunInstancesElasticInferenceAcceleratorsTypeDef,
    _OptionalClientRunInstancesElasticInferenceAcceleratorsTypeDef,
):
    pass


ClientRunInstancesHibernationOptionsTypeDef = TypedDict(
    "ClientRunInstancesHibernationOptionsTypeDef", {"Configured": bool}, total=False
)

ClientRunInstancesIamInstanceProfileTypeDef = TypedDict(
    "ClientRunInstancesIamInstanceProfileTypeDef", {"Arn": str, "Name": str}, total=False
)

ClientRunInstancesInstanceMarketOptionsSpotOptionsTypeDef = TypedDict(
    "ClientRunInstancesInstanceMarketOptionsSpotOptionsTypeDef",
    {
        "MaxPrice": str,
        "SpotInstanceType": Literal["one-time", "persistent"],
        "BlockDurationMinutes": int,
        "ValidUntil": datetime,
        "InstanceInterruptionBehavior": Literal["hibernate", "stop", "terminate"],
    },
    total=False,
)

ClientRunInstancesInstanceMarketOptionsTypeDef = TypedDict(
    "ClientRunInstancesInstanceMarketOptionsTypeDef",
    {"MarketType": str, "SpotOptions": ClientRunInstancesInstanceMarketOptionsSpotOptionsTypeDef},
    total=False,
)

ClientRunInstancesIpv6AddressesTypeDef = TypedDict(
    "ClientRunInstancesIpv6AddressesTypeDef", {"Ipv6Address": str}, total=False
)

ClientRunInstancesLaunchTemplateTypeDef = TypedDict(
    "ClientRunInstancesLaunchTemplateTypeDef",
    {"LaunchTemplateId": str, "LaunchTemplateName": str, "Version": str},
    total=False,
)

ClientRunInstancesLicenseSpecificationsTypeDef = TypedDict(
    "ClientRunInstancesLicenseSpecificationsTypeDef", {"LicenseConfigurationArn": str}, total=False
)

ClientRunInstancesMetadataOptionsTypeDef = TypedDict(
    "ClientRunInstancesMetadataOptionsTypeDef",
    {
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientRunInstancesMonitoringTypeDef = TypedDict(
    "ClientRunInstancesMonitoringTypeDef", {"Enabled": bool}
)

ClientRunInstancesNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientRunInstancesNetworkInterfacesIpv6AddressesTypeDef", {"Ipv6Address": str}, total=False
)

ClientRunInstancesNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientRunInstancesNetworkInterfacesPrivateIpAddressesTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientRunInstancesNetworkInterfacesTypeDef = TypedDict(
    "ClientRunInstancesNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[ClientRunInstancesNetworkInterfacesIpv6AddressesTypeDef],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[ClientRunInstancesNetworkInterfacesPrivateIpAddressesTypeDef],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientRunInstancesPlacementTypeDef = TypedDict(
    "ClientRunInstancesPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "PartitionNumber": int,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
    },
    total=False,
)

ClientRunInstancesResponseGroupsTypeDef = TypedDict(
    "ClientRunInstancesResponseGroupsTypeDef", {"GroupName": str, "GroupId": str}, total=False
)

ClientRunInstancesResponseInstancesBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesBlockDeviceMappingsEbsTypeDef",
    {
        "AttachTime": datetime,
        "DeleteOnTermination": bool,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
        "VolumeId": str,
    },
    total=False,
)

ClientRunInstancesResponseInstancesBlockDeviceMappingsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesBlockDeviceMappingsTypeDef",
    {"DeviceName": str, "Ebs": ClientRunInstancesResponseInstancesBlockDeviceMappingsEbsTypeDef},
    total=False,
)

ClientRunInstancesResponseInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef",
    {"CapacityReservationId": str},
    total=False,
)

ClientRunInstancesResponseInstancesCapacityReservationSpecificationTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesCapacityReservationSpecificationTypeDef",
    {
        "CapacityReservationPreference": Literal["open", "none"],
        "CapacityReservationTarget": ClientRunInstancesResponseInstancesCapacityReservationSpecificationCapacityReservationTargetTypeDef,
    },
    total=False,
)

ClientRunInstancesResponseInstancesCpuOptionsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesCpuOptionsTypeDef",
    {"CoreCount": int, "ThreadsPerCore": int},
    total=False,
)

ClientRunInstancesResponseInstancesElasticGpuAssociationsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesElasticGpuAssociationsTypeDef",
    {
        "ElasticGpuId": str,
        "ElasticGpuAssociationId": str,
        "ElasticGpuAssociationState": str,
        "ElasticGpuAssociationTime": str,
    },
    total=False,
)

ClientRunInstancesResponseInstancesElasticInferenceAcceleratorAssociationsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesElasticInferenceAcceleratorAssociationsTypeDef",
    {
        "ElasticInferenceAcceleratorArn": str,
        "ElasticInferenceAcceleratorAssociationId": str,
        "ElasticInferenceAcceleratorAssociationState": str,
        "ElasticInferenceAcceleratorAssociationTime": datetime,
    },
    total=False,
)

ClientRunInstancesResponseInstancesHibernationOptionsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesHibernationOptionsTypeDef",
    {"Configured": bool},
    total=False,
)

ClientRunInstancesResponseInstancesIamInstanceProfileTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesIamInstanceProfileTypeDef",
    {"Arn": str, "Id": str},
    total=False,
)

ClientRunInstancesResponseInstancesLicensesTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesLicensesTypeDef",
    {"LicenseConfigurationArn": str},
    total=False,
)

ClientRunInstancesResponseInstancesMetadataOptionsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesMetadataOptionsTypeDef",
    {
        "State": Literal["pending", "applied"],
        "HttpTokens": Literal["optional", "required"],
        "HttpPutResponseHopLimit": int,
        "HttpEndpoint": Literal["disabled", "enabled"],
    },
    total=False,
)

ClientRunInstancesResponseInstancesMonitoringTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesMonitoringTypeDef",
    {"State": Literal["disabled", "disabling", "enabled", "pending"]},
    total=False,
)

ClientRunInstancesResponseInstancesNetworkInterfacesAssociationTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesNetworkInterfacesAssociationTypeDef",
    {"IpOwnerId": str, "PublicDnsName": str, "PublicIp": str},
    total=False,
)

ClientRunInstancesResponseInstancesNetworkInterfacesAttachmentTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesNetworkInterfacesAttachmentTypeDef",
    {
        "AttachTime": datetime,
        "AttachmentId": str,
        "DeleteOnTermination": bool,
        "DeviceIndex": int,
        "Status": Literal["attaching", "attached", "detaching", "detached"],
    },
    total=False,
)

ClientRunInstancesResponseInstancesNetworkInterfacesGroupsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesNetworkInterfacesGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientRunInstancesResponseInstancesNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef",
    {"IpOwnerId": str, "PublicDnsName": str, "PublicIp": str},
    total=False,
)

ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesTypeDef",
    {
        "Association": ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesAssociationTypeDef,
        "Primary": bool,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
    },
    total=False,
)

ClientRunInstancesResponseInstancesNetworkInterfacesTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesNetworkInterfacesTypeDef",
    {
        "Association": ClientRunInstancesResponseInstancesNetworkInterfacesAssociationTypeDef,
        "Attachment": ClientRunInstancesResponseInstancesNetworkInterfacesAttachmentTypeDef,
        "Description": str,
        "Groups": List[ClientRunInstancesResponseInstancesNetworkInterfacesGroupsTypeDef],
        "Ipv6Addresses": List[
            ClientRunInstancesResponseInstancesNetworkInterfacesIpv6AddressesTypeDef
        ],
        "MacAddress": str,
        "NetworkInterfaceId": str,
        "OwnerId": str,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
        "PrivateIpAddresses": List[
            ClientRunInstancesResponseInstancesNetworkInterfacesPrivateIpAddressesTypeDef
        ],
        "SourceDestCheck": bool,
        "Status": Literal["available", "associated", "attaching", "in-use", "detaching"],
        "SubnetId": str,
        "VpcId": str,
        "InterfaceType": str,
    },
    total=False,
)

ClientRunInstancesResponseInstancesPlacementTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesPlacementTypeDef",
    {
        "AvailabilityZone": str,
        "Affinity": str,
        "GroupName": str,
        "PartitionNumber": int,
        "HostId": str,
        "Tenancy": Literal["default", "dedicated", "host"],
        "SpreadDomain": str,
        "HostResourceGroupArn": str,
    },
    total=False,
)

ClientRunInstancesResponseInstancesProductCodesTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesProductCodesTypeDef",
    {"ProductCodeId": str, "ProductCodeType": Literal["devpay", "marketplace"]},
    total=False,
)

ClientRunInstancesResponseInstancesSecurityGroupsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesSecurityGroupsTypeDef",
    {"GroupName": str, "GroupId": str},
    total=False,
)

ClientRunInstancesResponseInstancesStateReasonTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesStateReasonTypeDef",
    {"Code": str, "Message": str},
    total=False,
)

ClientRunInstancesResponseInstancesStateTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientRunInstancesResponseInstancesTagsTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientRunInstancesResponseInstancesTypeDef = TypedDict(
    "ClientRunInstancesResponseInstancesTypeDef",
    {
        "AmiLaunchIndex": int,
        "ImageId": str,
        "InstanceId": str,
        "InstanceType": Literal[
            "t1.micro",
            "t2.nano",
            "t2.micro",
            "t2.small",
            "t2.medium",
            "t2.large",
            "t2.xlarge",
            "t2.2xlarge",
            "t3.nano",
            "t3.micro",
            "t3.small",
            "t3.medium",
            "t3.large",
            "t3.xlarge",
            "t3.2xlarge",
            "t3a.nano",
            "t3a.micro",
            "t3a.small",
            "t3a.medium",
            "t3a.large",
            "t3a.xlarge",
            "t3a.2xlarge",
            "m1.small",
            "m1.medium",
            "m1.large",
            "m1.xlarge",
            "m3.medium",
            "m3.large",
            "m3.xlarge",
            "m3.2xlarge",
            "m4.large",
            "m4.xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m2.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "cr1.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.16xlarge",
            "r5.large",
            "r5.xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.metal",
            "r5a.large",
            "r5a.xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5d.large",
            "r5d.xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.metal",
            "r5ad.large",
            "r5ad.xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.xlarge",
            "x1e.2xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.16xlarge",
            "x1e.32xlarge",
            "i2.xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i3.large",
            "i3.xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.16xlarge",
            "i3.metal",
            "i3en.large",
            "i3en.xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.metal",
            "hi1.4xlarge",
            "hs1.8xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.large",
            "c3.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c5.large",
            "c5.xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.metal",
            "c5d.large",
            "c5d.xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.metal",
            "c5n.large",
            "c5n.xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.18xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3.16xlarge",
            "g3s.xlarge",
            "g4dn.xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "cg1.4xlarge",
            "p2.xlarge",
            "p2.8xlarge",
            "p2.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3.16xlarge",
            "p3dn.24xlarge",
            "d2.xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "f1.16xlarge",
            "m5.large",
            "m5.xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.metal",
            "m5a.large",
            "m5a.xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5d.large",
            "m5d.xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.metal",
            "m5ad.large",
            "m5ad.xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "h1.16xlarge",
            "z1d.large",
            "z1d.xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.12xlarge",
            "z1d.metal",
            "u-6tb1.metal",
            "u-9tb1.metal",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "a1.medium",
            "a1.large",
            "a1.xlarge",
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.metal",
            "m5dn.large",
            "m5dn.xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5n.large",
            "m5n.xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "r5dn.large",
            "r5dn.xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5n.large",
            "r5n.xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "inf1.xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.24xlarge",
        ],
        "KernelId": str,
        "KeyName": str,
        "LaunchTime": datetime,
        "Monitoring": ClientRunInstancesResponseInstancesMonitoringTypeDef,
        "Placement": ClientRunInstancesResponseInstancesPlacementTypeDef,
        "Platform": str,
        "PrivateDnsName": str,
        "PrivateIpAddress": str,
        "ProductCodes": List[ClientRunInstancesResponseInstancesProductCodesTypeDef],
        "PublicDnsName": str,
        "PublicIpAddress": str,
        "RamdiskId": str,
        "State": ClientRunInstancesResponseInstancesStateTypeDef,
        "StateTransitionReason": str,
        "SubnetId": str,
        "VpcId": str,
        "Architecture": Literal["i386", "x86_64", "arm64"],
        "BlockDeviceMappings": List[ClientRunInstancesResponseInstancesBlockDeviceMappingsTypeDef],
        "ClientToken": str,
        "EbsOptimized": bool,
        "EnaSupport": bool,
        "Hypervisor": Literal["ovm", "xen"],
        "IamInstanceProfile": ClientRunInstancesResponseInstancesIamInstanceProfileTypeDef,
        "InstanceLifecycle": Literal["spot", "scheduled"],
        "ElasticGpuAssociations": List[
            ClientRunInstancesResponseInstancesElasticGpuAssociationsTypeDef
        ],
        "ElasticInferenceAcceleratorAssociations": List[
            ClientRunInstancesResponseInstancesElasticInferenceAcceleratorAssociationsTypeDef
        ],
        "NetworkInterfaces": List[ClientRunInstancesResponseInstancesNetworkInterfacesTypeDef],
        "OutpostArn": str,
        "RootDeviceName": str,
        "RootDeviceType": Literal["ebs", "instance-store"],
        "SecurityGroups": List[ClientRunInstancesResponseInstancesSecurityGroupsTypeDef],
        "SourceDestCheck": bool,
        "SpotInstanceRequestId": str,
        "SriovNetSupport": str,
        "StateReason": ClientRunInstancesResponseInstancesStateReasonTypeDef,
        "Tags": List[ClientRunInstancesResponseInstancesTagsTypeDef],
        "VirtualizationType": Literal["hvm", "paravirtual"],
        "CpuOptions": ClientRunInstancesResponseInstancesCpuOptionsTypeDef,
        "CapacityReservationId": str,
        "CapacityReservationSpecification": ClientRunInstancesResponseInstancesCapacityReservationSpecificationTypeDef,
        "HibernationOptions": ClientRunInstancesResponseInstancesHibernationOptionsTypeDef,
        "Licenses": List[ClientRunInstancesResponseInstancesLicensesTypeDef],
        "MetadataOptions": ClientRunInstancesResponseInstancesMetadataOptionsTypeDef,
    },
    total=False,
)

ClientRunInstancesResponseTypeDef = TypedDict(
    "ClientRunInstancesResponseTypeDef",
    {
        "Groups": List[ClientRunInstancesResponseGroupsTypeDef],
        "Instances": List[ClientRunInstancesResponseInstancesTypeDef],
        "OwnerId": str,
        "RequesterId": str,
        "ReservationId": str,
    },
    total=False,
)

ClientRunInstancesTagSpecificationsTagsTypeDef = TypedDict(
    "ClientRunInstancesTagSpecificationsTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientRunInstancesTagSpecificationsTypeDef = TypedDict(
    "ClientRunInstancesTagSpecificationsTypeDef",
    {
        "ResourceType": Literal[
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "elastic-ip",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "instance",
            "internet-gateway",
            "key-pair",
            "launch-template",
            "natgateway",
            "network-acl",
            "network-interface",
            "placement-group",
            "reserved-instances",
            "route-table",
            "security-group",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ],
        "Tags": List[ClientRunInstancesTagSpecificationsTagsTypeDef],
    },
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef",
    {
        "DeleteOnTermination": bool,
        "Encrypted": bool,
        "Iops": int,
        "SnapshotId": str,
        "VolumeSize": int,
        "VolumeType": str,
    },
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsTypeDef",
    {
        "DeviceName": str,
        "Ebs": ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsEbsTypeDef,
        "NoDevice": str,
        "VirtualName": str,
    },
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationIamInstanceProfileTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationIamInstanceProfileTypeDef",
    {"Arn": str, "Name": str},
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationMonitoringTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationMonitoringTypeDef",
    {"Enabled": bool},
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef",
    {"Ipv6Address": str},
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressConfigsTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressConfigsTypeDef",
    {"Primary": bool, "PrivateIpAddress": str},
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesTypeDef",
    {
        "AssociatePublicIpAddress": bool,
        "DeleteOnTermination": bool,
        "Description": str,
        "DeviceIndex": int,
        "Groups": List[str],
        "Ipv6AddressCount": int,
        "Ipv6Addresses": List[
            ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesIpv6AddressesTypeDef
        ],
        "NetworkInterfaceId": str,
        "PrivateIpAddress": str,
        "PrivateIpAddressConfigs": List[
            ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesPrivateIpAddressConfigsTypeDef
        ],
        "SecondaryPrivateIpAddressCount": int,
        "SubnetId": str,
    },
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationPlacementTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationPlacementTypeDef",
    {"AvailabilityZone": str, "GroupName": str},
    total=False,
)

ClientRunScheduledInstancesLaunchSpecificationTypeDef = TypedDict(
    "ClientRunScheduledInstancesLaunchSpecificationTypeDef",
    {
        "BlockDeviceMappings": List[
            ClientRunScheduledInstancesLaunchSpecificationBlockDeviceMappingsTypeDef
        ],
        "EbsOptimized": bool,
        "IamInstanceProfile": ClientRunScheduledInstancesLaunchSpecificationIamInstanceProfileTypeDef,
        "ImageId": str,
        "InstanceType": str,
        "KernelId": str,
        "KeyName": str,
        "Monitoring": ClientRunScheduledInstancesLaunchSpecificationMonitoringTypeDef,
        "NetworkInterfaces": List[
            ClientRunScheduledInstancesLaunchSpecificationNetworkInterfacesTypeDef
        ],
        "Placement": ClientRunScheduledInstancesLaunchSpecificationPlacementTypeDef,
        "RamdiskId": str,
        "SecurityGroupIds": List[str],
        "SubnetId": str,
        "UserData": str,
    },
    total=False,
)

ClientRunScheduledInstancesResponseTypeDef = TypedDict(
    "ClientRunScheduledInstancesResponseTypeDef", {"InstanceIdSet": List[str]}, total=False
)

ClientSearchLocalGatewayRoutesFiltersTypeDef = TypedDict(
    "ClientSearchLocalGatewayRoutesFiltersTypeDef", {"Name": str, "Values": List[str]}, total=False
)

ClientSearchLocalGatewayRoutesResponseRoutesTypeDef = TypedDict(
    "ClientSearchLocalGatewayRoutesResponseRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "LocalGatewayVirtualInterfaceGroupId": str,
        "Type": Literal["static", "propagated"],
        "State": Literal["pending", "active", "blackhole", "deleting", "deleted"],
        "LocalGatewayRouteTableId": str,
    },
    total=False,
)

ClientSearchLocalGatewayRoutesResponseTypeDef = TypedDict(
    "ClientSearchLocalGatewayRoutesResponseTypeDef",
    {"Routes": List[ClientSearchLocalGatewayRoutesResponseRoutesTypeDef], "NextToken": str},
    total=False,
)

ClientSearchTransitGatewayMulticastGroupsFiltersTypeDef = TypedDict(
    "ClientSearchTransitGatewayMulticastGroupsFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientSearchTransitGatewayMulticastGroupsResponseMulticastGroupsTypeDef = TypedDict(
    "ClientSearchTransitGatewayMulticastGroupsResponseMulticastGroupsTypeDef",
    {
        "GroupIpAddress": str,
        "TransitGatewayAttachmentId": str,
        "SubnetId": str,
        "ResourceId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
        "NetworkInterfaceId": str,
        "GroupMember": bool,
        "GroupSource": bool,
        "MemberType": Literal["static", "igmp"],
        "SourceType": Literal["static", "igmp"],
    },
    total=False,
)

ClientSearchTransitGatewayMulticastGroupsResponseTypeDef = TypedDict(
    "ClientSearchTransitGatewayMulticastGroupsResponseTypeDef",
    {
        "MulticastGroups": List[
            ClientSearchTransitGatewayMulticastGroupsResponseMulticastGroupsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)

ClientSearchTransitGatewayRoutesFiltersTypeDef = TypedDict(
    "ClientSearchTransitGatewayRoutesFiltersTypeDef",
    {"Name": str, "Values": List[str]},
    total=False,
)

ClientSearchTransitGatewayRoutesResponseRoutesTransitGatewayAttachmentsTypeDef = TypedDict(
    "ClientSearchTransitGatewayRoutesResponseRoutesTransitGatewayAttachmentsTypeDef",
    {
        "ResourceId": str,
        "TransitGatewayAttachmentId": str,
        "ResourceType": Literal["vpc", "vpn", "direct-connect-gateway", "tgw-peering"],
    },
    total=False,
)

ClientSearchTransitGatewayRoutesResponseRoutesTypeDef = TypedDict(
    "ClientSearchTransitGatewayRoutesResponseRoutesTypeDef",
    {
        "DestinationCidrBlock": str,
        "TransitGatewayAttachments": List[
            ClientSearchTransitGatewayRoutesResponseRoutesTransitGatewayAttachmentsTypeDef
        ],
        "Type": Literal["static", "propagated"],
        "State": Literal["pending", "active", "blackhole", "deleting", "deleted"],
    },
    total=False,
)

ClientSearchTransitGatewayRoutesResponseTypeDef = TypedDict(
    "ClientSearchTransitGatewayRoutesResponseTypeDef",
    {
        "Routes": List[ClientSearchTransitGatewayRoutesResponseRoutesTypeDef],
        "AdditionalRoutesAvailable": bool,
    },
    total=False,
)

ClientStartInstancesResponseStartingInstancesCurrentStateTypeDef = TypedDict(
    "ClientStartInstancesResponseStartingInstancesCurrentStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientStartInstancesResponseStartingInstancesPreviousStateTypeDef = TypedDict(
    "ClientStartInstancesResponseStartingInstancesPreviousStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientStartInstancesResponseStartingInstancesTypeDef = TypedDict(
    "ClientStartInstancesResponseStartingInstancesTypeDef",
    {
        "CurrentState": ClientStartInstancesResponseStartingInstancesCurrentStateTypeDef,
        "InstanceId": str,
        "PreviousState": ClientStartInstancesResponseStartingInstancesPreviousStateTypeDef,
    },
    total=False,
)

ClientStartInstancesResponseTypeDef = TypedDict(
    "ClientStartInstancesResponseTypeDef",
    {"StartingInstances": List[ClientStartInstancesResponseStartingInstancesTypeDef]},
    total=False,
)

ClientStartVpcEndpointServicePrivateDnsVerificationResponseTypeDef = TypedDict(
    "ClientStartVpcEndpointServicePrivateDnsVerificationResponseTypeDef",
    {"ReturnValue": bool},
    total=False,
)

ClientStopInstancesResponseStoppingInstancesCurrentStateTypeDef = TypedDict(
    "ClientStopInstancesResponseStoppingInstancesCurrentStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientStopInstancesResponseStoppingInstancesPreviousStateTypeDef = TypedDict(
    "ClientStopInstancesResponseStoppingInstancesPreviousStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientStopInstancesResponseStoppingInstancesTypeDef = TypedDict(
    "ClientStopInstancesResponseStoppingInstancesTypeDef",
    {
        "CurrentState": ClientStopInstancesResponseStoppingInstancesCurrentStateTypeDef,
        "InstanceId": str,
        "PreviousState": ClientStopInstancesResponseStoppingInstancesPreviousStateTypeDef,
    },
    total=False,
)

ClientStopInstancesResponseTypeDef = TypedDict(
    "ClientStopInstancesResponseTypeDef",
    {"StoppingInstances": List[ClientStopInstancesResponseStoppingInstancesTypeDef]},
    total=False,
)

ClientTerminateClientVpnConnectionsResponseConnectionStatusesCurrentStatusTypeDef = TypedDict(
    "ClientTerminateClientVpnConnectionsResponseConnectionStatusesCurrentStatusTypeDef",
    {"Code": Literal["active", "failed-to-terminate", "terminating", "terminated"], "Message": str},
    total=False,
)

ClientTerminateClientVpnConnectionsResponseConnectionStatusesPreviousStatusTypeDef = TypedDict(
    "ClientTerminateClientVpnConnectionsResponseConnectionStatusesPreviousStatusTypeDef",
    {"Code": Literal["active", "failed-to-terminate", "terminating", "terminated"], "Message": str},
    total=False,
)

ClientTerminateClientVpnConnectionsResponseConnectionStatusesTypeDef = TypedDict(
    "ClientTerminateClientVpnConnectionsResponseConnectionStatusesTypeDef",
    {
        "ConnectionId": str,
        "PreviousStatus": ClientTerminateClientVpnConnectionsResponseConnectionStatusesPreviousStatusTypeDef,
        "CurrentStatus": ClientTerminateClientVpnConnectionsResponseConnectionStatusesCurrentStatusTypeDef,
    },
    total=False,
)

ClientTerminateClientVpnConnectionsResponseTypeDef = TypedDict(
    "ClientTerminateClientVpnConnectionsResponseTypeDef",
    {
        "ClientVpnEndpointId": str,
        "Username": str,
        "ConnectionStatuses": List[
            ClientTerminateClientVpnConnectionsResponseConnectionStatusesTypeDef
        ],
    },
    total=False,
)

ClientTerminateInstancesResponseTerminatingInstancesCurrentStateTypeDef = TypedDict(
    "ClientTerminateInstancesResponseTerminatingInstancesCurrentStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientTerminateInstancesResponseTerminatingInstancesPreviousStateTypeDef = TypedDict(
    "ClientTerminateInstancesResponseTerminatingInstancesPreviousStateTypeDef",
    {
        "Code": int,
        "Name": Literal["pending", "running", "shutting-down", "terminated", "stopping", "stopped"],
    },
    total=False,
)

ClientTerminateInstancesResponseTerminatingInstancesTypeDef = TypedDict(
    "ClientTerminateInstancesResponseTerminatingInstancesTypeDef",
    {
        "CurrentState": ClientTerminateInstancesResponseTerminatingInstancesCurrentStateTypeDef,
        "InstanceId": str,
        "PreviousState": ClientTerminateInstancesResponseTerminatingInstancesPreviousStateTypeDef,
    },
    total=False,
)

ClientTerminateInstancesResponseTypeDef = TypedDict(
    "ClientTerminateInstancesResponseTypeDef",
    {"TerminatingInstances": List[ClientTerminateInstancesResponseTerminatingInstancesTypeDef]},
    total=False,
)

ClientUnassignIpv6AddressesResponseTypeDef = TypedDict(
    "ClientUnassignIpv6AddressesResponseTypeDef",
    {"NetworkInterfaceId": str, "UnassignedIpv6Addresses": List[str]},
    total=False,
)

ClientUnmonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef = TypedDict(
    "ClientUnmonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef",
    {"State": Literal["disabled", "disabling", "enabled", "pending"]},
    total=False,
)

ClientUnmonitorInstancesResponseInstanceMonitoringsTypeDef = TypedDict(
    "ClientUnmonitorInstancesResponseInstanceMonitoringsTypeDef",
    {
        "InstanceId": str,
        "Monitoring": ClientUnmonitorInstancesResponseInstanceMonitoringsMonitoringTypeDef,
    },
    total=False,
)

ClientUnmonitorInstancesResponseTypeDef = TypedDict(
    "ClientUnmonitorInstancesResponseTypeDef",
    {"InstanceMonitorings": List[ClientUnmonitorInstancesResponseInstanceMonitoringsTypeDef]},
    total=False,
)

ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsIpRangesTypeDef = TypedDict(
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsIpRangesTypeDef",
    {"CidrIp": str, "Description": str},
    total=False,
)

ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsIpv6RangesTypeDef = TypedDict(
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsIpv6RangesTypeDef",
    {"CidrIpv6": str, "Description": str},
    total=False,
)

ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsPrefixListIdsTypeDef = TypedDict(
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsPrefixListIdsTypeDef",
    {"Description": str, "PrefixListId": str},
    total=False,
)

ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsUserIdGroupPairsTypeDef = TypedDict(
    "ClientUpdateSecurityGroupRuleDescriptionsEgressIpPermissionsUserIdGroupPairsTypeDef",
    {
        "Description": str,
        "GroupId": str,
        "GroupName": str,
        "PeeringStatus": str,
        "UserId": str,
        "VpcId": str,
        "VpcPeeringConnection