# coding:utf-8
# Code generated by protoc-gen-byteplus-sdk
# source: VodService
# DO NOT EDIT!
from __future__ import print_function
from byteplus_sdk.Policy import *
from google.protobuf.json_format import *
from byteplus_sdk.vod.VodServiceConfig import VodServiceConfig
from retry import retry
from zlib import crc32
import os
import sys
import time
import datetime
import byteplus_sdk.vod
from byteplus_sdk.util.Util import Util
from byteplus_sdk.vod.models.request.request_vod_pb2 import *
from byteplus_sdk.vod.models.response.response_vod_pb2 import *

MinChunkSize = 1024 * 1024 * 20
LargeFileSize = 1024 * 1024 * 1024


#
# Generated from protobuf service <code>VodService</code>
#
class VodService(VodServiceConfig):

    def get_private_drm_play_auth_token(self, request, expire):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            if expire > 0:
                params['X-Expires'] = str(expire)
            data = self.get_sign_url('GetPrivateDrmPlayAuth', params)
            return data
        except Exception as Argument:
            raise Argument

    def create_hls_drm_auth_token(self, auth_algorithm, expire_seconds):
        try:
            if expire_seconds == 0:
                raise Exception("invalid expire")
            deadline = int(time.mktime(datetime.datetime.now().timetuple())) + expire_seconds
            deadTime = datetime.datetime.utcfromtimestamp(deadline).strftime("%Y%m%dT%H%M%SZ")
            if sys.version_info[0] == 3:
                kDate = Util.hmac_sha256(bytes(self.service_info.credentials.sk, encoding='utf-8'), deadTime)
            else:
                kDate = Util.hmac_sha256(bytes(self.service_info.credentials.sk.encode('utf-8')), deadTime)
            kRegion = Util.hmac_sha256(kDate, self.service_info.credentials.region)
            kService = Util.hmac_sha256(kRegion, 'vod')
            kCredentials = Util.hmac_sha256(kService, 'request')
            key = Util.to_hex(kCredentials)
            signDataString = '&'.join([auth_algorithm, '2.0', str(deadline)])
            if auth_algorithm == 'HMAC-SHA1':
                if sys.version_info[0] == 3:
                    signBytes = Util.hmac_sha1(bytes(key, encoding='utf-8'), signDataString)
                else:
                    signBytes = Util.hmac_sha1(bytes(key.encode('utf-8')), signDataString)
            else:
                raise Exception('invalid authAlgorithm')
            sign = base64.b64encode(signBytes).decode('utf-8')
            token = ':'.join([auth_algorithm, '2.0', str(deadline), self.service_info.credentials.ak, sign])
            params = dict()
            params['DrmAuthToken'] = token
            params['X-Expires'] = str(expire_seconds)
            getAuth = self.get_sign_url("GetHlsDecryptionKey", params)
            return getAuth
        except Exception as e:
            raise e

    def get_sha1_hls_drm_auth_token(self, expire_seconds):
        try:
            return self.create_hls_drm_auth_token('HMAC-SHA1', expire_seconds)
        except Exception as Argument:
            raise Argument

    def get_play_auth_token(self, request, expire):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            if expire > 0:
                params['X-Expires'] = str(expire)
            token = self.get_sign_url('GetPlayInfo', params)
            ret = {'TokenVersion': 'V2', 'GetPlayInfoToken': token}
            data = json.dumps(ret)
        except Exception as Argument:
            raise Argument
        else:
            if sys.version_info[0] == 3:
                return base64.b64encode(data.encode('utf-8')).decode('utf-8')
            else:
                return base64.b64encode(data.decode('utf-8'))

    def get_third_party_drm_auth_token(self, request, expire):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            if expire > 0:
                params['X-Expires'] = str(expire)
            token = self.get_sign_url('GetDrmLicense', params)
            ret = {'TokenVersion': 'V2', 'GetThirdPartyDrmAuthToken': token}
            data = json.dumps(ret)
        except Exception as Argument:
            raise Argument
        else:
            if sys.version_info[0] == 3:
                return base64.b64encode(data.encode('utf-8')).decode('utf-8')
            else:
                return base64.b64encode(data.decode('utf-8'))

    def get_fairplay_cert_url(self, cert_id, expire):
        try:
            params = dict()
            params['CertId'] = cert_id
            if expire > 0:
                params['X-Expires'] = str(expire)
            raw_query = self.get_sign_url('GetFairPlayCert', params)
        except Exception as Argument:
            raise Argument
        else:
            return self.service_info.scheme + "://" + self.service_info.host + self.api_info["GetFairPlayCert"].path + '?' + raw_query

    def get_subtitle_auth_token(self, request, expire):
        try:
            if request.Vid == "":
                raise Exception("Vid is None")
            params = {"Vid": request.Vid}
            params["Status"] = "Published"
            if expire > 0:
                params['X-Expires'] = str(expire)
            token = self.get_sign_url('GetSubtitleInfoList', params)
            ret = {'GetSubtitleAuthToken': token}
            data = json.dumps(ret)
        except Exception as Argument:
            raise Argument
        else:
            if sys.version_info[0] == 3:
                return base64.b64encode(data.encode('utf-8')).decode('utf-8')
            else:
                return base64.b64encode(data.decode('utf-8'))

    def upload_media(self, request):
        oid, session_key, avg_speed = self.upload_tob(request.SpaceName, request.FilePath, "", request.FileName,
                                                      request.FileExtension, request.StorageClass)
        req = VodCommitUploadInfoRequest()
        req.SpaceName = request.SpaceName
        req.SessionKey = session_key
        req.Functions = request.Functions
        req.CallbackArgs = request.CallbackArgs
        resp = self.commit_upload_info(req)
        if resp.ResponseMetadata.Error.Code != '':
            print(resp.ResponseMetadata.RequestId)
            raise Exception(resp.ResponseMetadata.Error)
        return resp

    def upload_tob(self, space_name, file_path, file_type, file_name, file_extension, storage_class):
        if not os.path.isfile(file_path):
            raise Exception("no such file on file path")
        apply_req = VodApplyUploadInfoRequest()
        apply_req.SpaceName = space_name
        apply_req.FileType = file_type
        apply_req.FileName = file_name
        apply_req.FileExtension = file_extension
        apply_req.StorageClass = storage_class
        resp = self.apply_upload_info(apply_req)
        if resp.ResponseMetadata.Error.Code != '':
            print(resp.ResponseMetadata.RequestId)
            raise Exception(resp.ResponseMetadata.Error)
        upload_address = resp.Result.Data.UploadAddress
        oid = upload_address.StoreInfos[0].StoreUri
        session_key = upload_address.SessionKey
        auth = upload_address.StoreInfos[0].Auth
        host = upload_address.UploadHosts[0]
        start = time.time()
        file_size = os.path.getsize(file_path)
        if file_size < MinChunkSize:
            self.direct_upload(host, oid, auth, file_path, storage_class)
        else:
            self.chunk_upload(file_path, host, oid, auth, file_size, True, storage_class)
        cost = (time.time() - start) * 1000
        file_size = os.path.getsize(file_path)
        avg_speed = float(file_size) / float(cost)
        return oid, session_key, avg_speed

    @retry(tries=3, delay=1, backoff=2)
    def direct_upload(self, host, oid, auth, file_path, storage_class):
        with open(file_path, 'rb') as f:
            data = f.read()
            check_sum = crc32(data) & 0xFFFFFFFF
        check_sum = "%08x" % check_sum
        url = 'https://{}/{}'.format(host, oid)
        headers = {'Content-CRC32': check_sum, 'Authorization': auth}

        if storage_class == byteplus_sdk.vod.models.business.vod_upload_pb2.Archive:
            headers['X-Upload-Storage-Class'] = 'archive'

        upload_status, resp = self.put(url, file_path, headers)
        if not upload_status:
            raise Exception("direct upload error")
        resp = json.loads(resp)
        if resp.get('success') is None or resp['success'] != 0:
            raise Exception("direct upload error")

    def chunk_upload(self, file_path, host, oid, auth, size, is_large_file, storage_class):
        upload_id = self.init_upload_part(host, oid, auth, is_large_file, storage_class)
        n = size // MinChunkSize
        last_num = n - 1
        parts = []
        meta = {}
        with open(file_path, 'rb') as f:
            for i in range(0, last_num):
                data = f.read(MinChunkSize)
                part_number = i
                if is_large_file:
                    part_number = i + 1
                part, payload = self.upload_part(host, oid, auth, upload_id, part_number, data, is_large_file,
                                                                 storage_class)
                if part_number == 1:
                    meta = payload['meta']
                parts.append(part)
            data = f.read()
            if is_large_file:
                last_num = last_num + 1
            part, payload = self.upload_part(host, oid, auth, upload_id, last_num, data, is_large_file, storage_class)
            if last_num == 1:
                meta = payload["meta"]
            parts.append(part)
        return self.upload_merge_part(host, oid, auth, upload_id, parts, is_large_file, storage_class, meta)

    @retry(tries=3, delay=1, backoff=2)
    def init_upload_part(self, host, oid, auth, is_large_file, storage_class):
        url = 'https://{}/{}?uploads'.format(host, oid)
        headers = {'Authorization': auth}
        if is_large_file:
            headers['X-Storage-Mode'] = 'gateway'

        if storage_class == byteplus_sdk.vod.models.business.vod_upload_pb2.Archive:
            headers['X-Upload-Storage-Class'] = 'archive'


        upload_status, resp = self.put_data(url, None, headers)
        resp = json.loads(resp)
        if not upload_status:
            raise Exception("init upload error")
        if resp.get('success') is None or resp['success'] != 0:
            raise Exception("init upload error")
        return resp['payload']['uploadID']

    @retry(tries=3, delay=1, backoff=2)
    def upload_part(self, host, oid, auth, upload_id, part_number, data, is_large_file, storage_class):
        url = 'https://{}/{}?partNumber={}&uploadID={}'.format(host, oid,
                                                              part_number, upload_id)
        check_sum = crc32(data) & 0xFFFFFFFF
        check_sum = "%08x" % check_sum
        headers = {'Content-CRC32': check_sum, 'Authorization': auth}
        if is_large_file:
            headers['X-Storage-Mode'] = 'gateway'

        if storage_class == byteplus_sdk.vod.models.business.vod_upload_pb2.Archive:
            headers['X-Upload-Storage-Class'] = 'archive'

        upload_status, resp = self.put_data(url, data, headers)
        if not upload_status:
            raise Exception(url + json.dumps(resp))
        resp = json.loads(resp)
        if resp.get('success') is None or resp['success'] != 0:
            raise Exception("upload part error")
        return check_sum, resp['payload']

    @staticmethod
    def generate_merge_body(check_sum_list):
        if len(check_sum_list) == 0:
            raise Exception('crc32 list empty')
        s = []
        for i in range(len(check_sum_list)):
            s.append('{}:{}'.format(i, check_sum_list[i]))
        comma = ','
        return comma.join(s)

    @retry(tries=3, delay=1, backoff=2)
    def upload_merge_part(self, host, oid, auth, upload_id, check_sum_list, is_large_file, storage_class, meta):
        object_content_type = ''
        if (meta is not None) and (meta.get("ObjectContentType") is not None):
            object_content_type = meta['ObjectContentType']
        url = 'https://{}/{}?uploadID={}&ObjectContentType={}'.format(host, oid, upload_id, object_content_type)
        data = self.generate_merge_body(check_sum_list)
        headers = {'Authorization': auth}
        if is_large_file:
            headers['X-Storage-Mode'] = 'gateway'

        if storage_class == byteplus_sdk.vod.models.business.vod_upload_pb2.Archive:
            headers['X-Upload-Storage-Class'] = 'archive'

        upload_status, resp = self.put_data(url, data, headers)
        resp = json.loads(resp)
        if not upload_status:
            raise Exception("init upload error")
        if resp.get('success') is None or resp['success'] != 0:
            raise Exception("init upload error")

    def get_upload_sts2_with_expired_time(self, expired_time):
        actions = ["vod:ApplyUploadInfo", "vod:CommitUploadInfo"]
        resources = []
        statement = Statement.new_allow_statement(actions, resources)
        inline_policy = Policy([statement])
        return self.sign_sts2(inline_policy, expired_time)

    def get_upload_sts2(self):
        return self.get_upload_sts2_with_expired_time(60 * 60)

    def upload_material(self, request):
        oid, session_key, avg_speed = self.upload_tob(request.SpaceName, request.FilePath, request.FileType,
                                                      request.FileName, request.FileExtension, 0)

        req = VodCommitUploadInfoRequest()
        req.SpaceName = request.SpaceName
        req.SessionKey = session_key
        req.Functions = request.Functions
        req.CallbackArgs = request.CallbackArgs

        resp = self.commit_upload_info(req)
        if resp.ResponseMetadata.Error.Code != '':
            print(resp.ResponseMetadata.RequestId)
            raise Exception(resp.ResponseMetadata.Error)
        return resp

    #
    # SubmitDirectEditTaskAsync.
    #
    # @param request VodSubmitDirectEditTaskAsyncRequest
    # @return VodSubmitDirectEditTaskAsyncResponse
    # @raise Exception
    def submit_direct_edit_task_async(self, request):

        try:
            params = MessageToDict(request, False, True)
            params['EditParam'] = json.loads(request.EditParam)
            res = self.json("SubmitDirectEditTaskAsync", {}, json.dumps(params))
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodSubmitDirectEditTaskAsyncResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return res

    #
    # GetDirectEditResult.
    #
    # @param request VodGetDirectEditResultRequest
    # @return VodGetDirectEditResultResponse
    # @raise Exception
    def get_direct_edit_result(self, request):
        try:
            jsonData = MessageToJson(request, False, True)
            res = self.json("GetDirectEditResult", {}, jsonData)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetDirectEditResultResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:

            return res

    #
    # GetDirectEditProgress.
    #
    # @param request VodGetDirectEditProgressRequest
    # @return VodGetDirectEditProgressResponse
    # @raise Exception
    def get_direct_edit_progress(self, request):

        try:
            params = MessageToDict(request, False, True)
            if sys.version_info[0] == 3:
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetDirectEditProgress", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetDirectEditProgressResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return res

    #
    # GetVodMediaPlayData.
    #
    # @param request GetVodMediaPlayDataRequest
    # @return GetVodMediaPlayDataResponse
    # @raise Exception
    def get_vod_media_play_data(self, request):
        try:
            jsonData = MessageToJson(request, False, True)
            params = json.loads(jsonData)
            res = self.json("GetVodMediaPlayData",{},params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), GetVodMediaPlayDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, GetVodMediaPlayDataResponse(), True)

    #
    # GetPlayInfo.
    #
    # @param request VodGetPlayInfoRequest
    # @return VodGetPlayInfoResponse
    # @raise Exception
    def get_play_info(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetPlayInfo", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetPlayInfoResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetPlayInfoResponse(), True)

    #
    # GetPrivateDrmPlayAuth.
    #
    # @param request VodGetPrivateDrmPlayAuthRequest
    # @return VodGetPrivateDrmPlayAuthResponse
    # @raise Exception
    def get_private_drm_play_auth(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetPrivateDrmPlayAuth", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetPrivateDrmPlayAuthResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetPrivateDrmPlayAuthResponse(), True)

    #
    # CreateHlsDecryptionKey.
    #
    # @param request VodCreateHlsDecryptionKeyRequest
    # @return VodCreateHlsDecryptionKeyResponse
    # @raise Exception
    def create_hls_decryption_key(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CreateHlsDecryptionKey", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCreateHlsDecryptionKeyResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCreateHlsDecryptionKeyResponse(), True)

    #
    # GetPlayInfoWithLiveTimeShiftScene.
    #
    # @param request VodGetPlayInfoWithLiveTimeShiftSceneRequest
    # @return VodGetPlayInfoWithLiveTimeShiftSceneResponse
    # @raise Exception
    def get_play_info_with_live_time_shift_scene(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetPlayInfoWithLiveTimeShiftScene", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetPlayInfoWithLiveTimeShiftSceneResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetPlayInfoWithLiveTimeShiftSceneResponse(), True)

    #
    # UploadMediaByUrl.
    #
    # @param request VodUrlUploadRequest
    # @return VodUrlUploadResponse
    # @raise Exception
    def upload_media_by_url(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.post("UploadMediaByUrl",{},params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUrlUploadResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUrlUploadResponse(), True)


    #
    # QueryUploadTaskInfo.
    #
    # @param request VodQueryUploadTaskInfoRequest
    # @return VodQueryUploadTaskInfoResponse
    # @raise Exception
    def query_upload_task_info(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("QueryUploadTaskInfo", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodQueryUploadTaskInfoResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodQueryUploadTaskInfoResponse(), True)

    #
    # ApplyUploadInfo.
    #
    # @param request VodApplyUploadInfoRequest
    # @return VodApplyUploadInfoResponse
    # @raise Exception
    def apply_upload_info(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ApplyUploadInfo", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodApplyUploadInfoResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodApplyUploadInfoResponse(), True)

    #
    # CommitUploadInfo.
    #
    # @param request VodCommitUploadInfoRequest
    # @return VodCommitUploadInfoResponse
    # @raise Exception
    def commit_upload_info(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CommitUploadInfo", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCommitUploadInfoResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCommitUploadInfoResponse(), True)

    #
    # ListFileMetaInfosByFileNames.
    #
    # @param request VodListFileMetaInfosByFileNamesRequest
    # @return VodListFileMetaInfosByFileNamesResponse
    # @raise Exception
    def list_file_meta_infos_by_file_names(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.post("ListFileMetaInfosByFileNames",{},params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListFileMetaInfosByFileNamesResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListFileMetaInfosByFileNamesResponse(), True)


    #
    # UpdateMediaInfo.
    #
    # @param request VodUpdateMediaInfoRequest
    # @return VodUpdateMediaInfoResponse
    # @raise Exception
    def update_media_info(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateMediaInfo", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateMediaInfoResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateMediaInfoResponse(), True)

    #
    # UpdateMediaPublishStatus.
    #
    # @param request VodUpdateMediaPublishStatusRequest
    # @return VodUpdateMediaPublishStatusResponse
    # @raise Exception
    def update_media_publish_status(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateMediaPublishStatus", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateMediaPublishStatusResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateMediaPublishStatusResponse(), True)

    #
    # UpdateMediaStorageClass.
    #
    # @param request VodUpdateMediaStorageClassRequest
    # @return VodUpdateMediaStorageClassResponse
    # @raise Exception
    def update_media_storage_class(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateMediaStorageClass", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateMediaStorageClassResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateMediaStorageClassResponse(), True)

    #
    # GetMediaInfos.
    #
    # @param request VodGetMediaInfosRequest
    # @return VodGetMediaInfosResponse
    # @raise Exception
    def get_media_infos(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetMediaInfos", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetMediaInfosResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetMediaInfosResponse(), True)

    #
    # GetRecommendedPoster.
    #
    # @param request VodGetRecommendedPosterRequest
    # @return VodGetRecommendedPosterResponse
    # @raise Exception
    def get_recommended_poster(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetRecommendedPoster", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetRecommendedPosterResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetRecommendedPosterResponse(), True)

    #
    # DeleteMedia.
    #
    # @param request VodDeleteMediaRequest
    # @return VodDeleteMediaResponse
    # @raise Exception
    def delete_media(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DeleteMedia", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDeleteMediaResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDeleteMediaResponse(), True)

    #
    # DeleteTranscodes.
    #
    # @param request VodDeleteTranscodesRequest
    # @return VodDeleteTranscodesResponse
    # @raise Exception
    def delete_transcodes(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DeleteTranscodes", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDeleteTranscodesResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDeleteTranscodesResponse(), True)

    #
    # GetFileInfos.
    #
    # @param request VodGetFileInfosRequest
    # @return VodGetFileInfosResponse
    # @raise Exception
    def get_file_infos(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetFileInfos", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetFileInfosResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetFileInfosResponse(), True)

    #
    # DeleteMediaTosFile.
    #
    # @param request VodDeleteMediaTosFileRequest
    # @return VodDeleteMediaTosFileResponse
    # @raise Exception
    def delete_media_tos_file(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.post("DeleteMediaTosFile",{},params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDeleteMediaTosFileResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDeleteMediaTosFileResponse(), True)


    #
    # GetMediaList.
    #
    # @param request VodGetMediaListRequest
    # @return VodGetMediaListResponse
    # @raise Exception
    def get_media_list(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetMediaList", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetMediaListResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetMediaListResponse(), True)

    #
    # GetSubtitleInfoList.
    #
    # @param request VodGetSubtitleInfoListRequest
    # @return VodGetSubtitleInfoListResponse
    # @raise Exception
    def get_subtitle_info_list(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetSubtitleInfoList", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetSubtitleInfoListResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetSubtitleInfoListResponse(), True)

    #
    # UpdateSubtitleStatus.
    #
    # @param request VodUpdateSubtitleStatusRequest
    # @return VodUpdateSubtitleStatusResponse
    # @raise Exception
    def update_subtitle_status(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateSubtitleStatus", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateSubtitleStatusResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateSubtitleStatusResponse(), True)

    #
    # UpdateSubtitleInfo.
    #
    # @param request VodUpdateSubtitleInfoRequest
    # @return VodUpdateSubtitleInfoResponse
    # @raise Exception
    def update_subtitle_info(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateSubtitleInfo", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateSubtitleInfoResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateSubtitleInfoResponse(), True)

    #
    # CreatePlaylist.
    #
    # @param request VodCreatePlaylistRequest
    # @return VodCreatePlaylistResponse
    # @raise Exception
    def create_playlist(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CreatePlaylist", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCreatePlaylistResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCreatePlaylistResponse(), True)

    #
    # GetPlaylists.
    #
    # @param request VodGetPlaylistsRequest
    # @return VodGetPlaylistsResponse
    # @raise Exception
    def get_playlists(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetPlaylists", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetPlaylistsResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetPlaylistsResponse(), True)

    #
    # UpdatePlaylist.
    #
    # @param request VodUpdatePlaylistRequest
    # @return VodUpdatePlaylistResponse
    # @raise Exception
    def update_playlist(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdatePlaylist", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdatePlaylistResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdatePlaylistResponse(), True)

    #
    # DeletePlaylist.
    #
    # @param request VodDeletePlaylistRequest
    # @return VodDeletePlaylistResponse
    # @raise Exception
    def delete_playlist(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DeletePlaylist", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDeletePlaylistResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDeletePlaylistResponse(), True)

    #
    # CreateVideoClassification.
    #
    # @param request VodCreateVideoClassificationRequest
    # @return VodCreateVideoClassificationResponse
    # @raise Exception
    def create_video_classification(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CreateVideoClassification", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCreateVideoClassificationResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCreateVideoClassificationResponse(), True)

    #
    # UpdateVideoClassification.
    #
    # @param request VodUpdateVideoClassificationRequest
    # @return VodUpdateVideoClassificationResponse
    # @raise Exception
    def update_video_classification(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateVideoClassification", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateVideoClassificationResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateVideoClassificationResponse(), True)

    #
    # DeleteVideoClassification.
    #
    # @param request VodDeleteVideoClassificationRequest
    # @return VodDeleteVideoClassificationResponse
    # @raise Exception
    def delete_video_classification(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DeleteVideoClassification", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDeleteVideoClassificationResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDeleteVideoClassificationResponse(), True)

    #
    # ListVideoClassifications.
    #
    # @param request VodListVideoClassificationsRequest
    # @return VodListVideoClassificationsResponse
    # @raise Exception
    def list_video_classifications(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListVideoClassifications", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListVideoClassificationsResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListVideoClassificationsResponse(), True)

    #
    # ListSnapshots.
    #
    # @param request VodListSnapshotsRequest
    # @return VodListSnapshotsResponse
    # @raise Exception
    def list_snapshots(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListSnapshots", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListSnapshotsResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListSnapshotsResponse(), True)

    #
    # StartWorkflow.
    #
    # @param request VodStartWorkflowRequest
    # @return VodStartWorkflowResponse
    # @raise Exception
    def start_workflow(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("StartWorkflow", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodStartWorkflowResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodStartWorkflowResponse(), True)

    #
    # RetrieveTranscodeResult.
    #
    # @param request VodRetrieveTranscodeResultRequest
    # @return VodRetrieveTranscodeResultResponse
    # @raise Exception
    def retrieve_transcode_result(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("RetrieveTranscodeResult", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodRetrieveTranscodeResultResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodRetrieveTranscodeResultResponse(), True)

    #
    # GetWorkflowExecution.
    #
    # @param request VodGetWorkflowExecutionStatusRequest
    # @return VodGetWorkflowExecutionStatusResponse
    # @raise Exception
    def get_workflow_execution(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetWorkflowExecution", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetWorkflowExecutionStatusResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetWorkflowExecutionStatusResponse(), True)

    #
    # CreateSpace.
    #
    # @param request VodCreateSpaceRequest
    # @return VodCreateSpaceResponse
    # @raise Exception
    def create_space(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CreateSpace", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCreateSpaceResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCreateSpaceResponse(), True)

    #
    # ListSpace.
    #
    # @param request VodListSpaceRequest
    # @return VodListSpaceResponse
    # @raise Exception
    def list_space(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListSpace", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListSpaceResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListSpaceResponse(), True)

    #
    # GetSpaceDetail.
    #
    # @param request VodGetSpaceDetailRequest
    # @return VodGetSpaceDetailResponse
    # @raise Exception
    def get_space_detail(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("GetSpaceDetail", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetSpaceDetailResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetSpaceDetailResponse(), True)

    #
    # UpdateSpaceUploadConfig.
    #
    # @param request VodUpdateSpaceUploadConfigRequest
    # @return VodUpdateSpaceUploadConfigResponse
    # @raise Exception
    def update_space_upload_config(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateSpaceUploadConfig", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateSpaceUploadConfigResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateSpaceUploadConfigResponse(), True)

    #
    # DescribeVodSpaceStorageData.
    #
    # @param request VodDescribeVodSpaceStorageDataRequest
    # @return VodDescribeVodSpaceStorageDataResponse
    # @raise Exception
    def describe_vod_space_storage_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodSpaceStorageData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDescribeVodSpaceStorageDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDescribeVodSpaceStorageDataResponse(), True)

    #
    # StartDomain.
    #
    # @param request VodStartDomainRequest
    # @return VodStartDomainResponse
    # @raise Exception
    def start_domain(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("StartDomain", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodStartDomainResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodStartDomainResponse(), True)

    #
    # StopDomain.
    #
    # @param request VodStopDomainRequest
    # @return VodStopDomainResponse
    # @raise Exception
    def stop_domain(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("StopDomain", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodStopDomainResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodStopDomainResponse(), True)

    #
    # AddDomainToScheduler.
    #
    # @param request VodAddDomainToSchedulerRequest
    # @return VodAddDomainToSchedulerResponse
    # @raise Exception
    def add_domain_to_scheduler(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("AddDomainToScheduler", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodAddDomainToSchedulerResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodAddDomainToSchedulerResponse(), True)

    #
    # RemoveDomainFromScheduler.
    #
    # @param request VodRemoveDomainFromSchedulerRequest
    # @return VodRemoveDomainFromSchedulerResponse
    # @raise Exception
    def remove_domain_from_scheduler(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("RemoveDomainFromScheduler", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodRemoveDomainFromSchedulerResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodRemoveDomainFromSchedulerResponse(), True)

    #
    # UpdateDomainPlayRule.
    #
    # @param request VodUpdateDomainPlayRuleRequestRequest
    # @return VodUpdateDomainPlayRuleResponse
    # @raise Exception
    def update_domain_play_rule(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateDomainPlayRule", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateDomainPlayRuleResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateDomainPlayRuleResponse(), True)

    #
    # ListDomain.
    #
    # @param request VodListDomainRequest
    # @return VodListDomainResponse
    # @raise Exception
    def list_domain(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListDomain", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListDomainResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListDomainResponse(), True)

    #
    # CreateCdnRefreshTask.
    #
    # @param request VodCreateCdnRefreshTaskRequest
    # @return VodCreateCdnRefreshTaskResponse
    # @raise Exception
    def create_cdn_refresh_task(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CreateCdnRefreshTask", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCreateCdnRefreshTaskResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCreateCdnRefreshTaskResponse(), True)

    #
    # CreateCdnPreloadTask.
    #
    # @param request VodCreateCdnPreloadTaskRequest
    # @return VodCreateCdnPreloadTaskResponse
    # @raise Exception
    def create_cdn_preload_task(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CreateCdnPreloadTask", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCreateCdnPreloadTaskResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCreateCdnPreloadTaskResponse(), True)

    #
    # ListCdnTasks.
    #
    # @param request VodListCdnTasksRequest
    # @return VodListCdnTasksResponse
    # @raise Exception
    def list_cdn_tasks(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnTasks", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListCdnTasksResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListCdnTasksResponse(), True)

    #
    # ListCdnAccessLog.
    #
    # @param request VodListCdnAccessLogRequest
    # @return VodListCdnAccessLogResponse
    # @raise Exception
    def list_cdn_access_log(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnAccessLog", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListCdnAccessLogResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListCdnAccessLogResponse(), True)

    #
    # ListCdnTopAccessUrl.
    #
    # @param request VodListCdnTopAccessUrlRequest
    # @return VodListCdnTopAccessUrlResponse
    # @raise Exception
    def list_cdn_top_access_url(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnTopAccessUrl", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListCdnTopAccessUrlResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListCdnTopAccessUrlResponse(), True)

    #
    # DescribeVodDomainBandwidthData.
    #
    # @param request VodDescribeVodDomainBandwidthDataRequest
    # @return VodDescribeVodDomainBandwidthDataResponse
    # @raise Exception
    def describe_vod_domain_bandwidth_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodDomainBandwidthData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDescribeVodDomainBandwidthDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDescribeVodDomainBandwidthDataResponse(), True)

    #
    # ListCdnUsageData.
    #
    # @param request VodListCdnUsageDataRequest
    # @return VodCdnStatisticsCommonResponse
    # @raise Exception
    def list_cdn_usage_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnUsageData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCdnStatisticsCommonResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCdnStatisticsCommonResponse(), True)

    #
    # ListCdnUsageDataDetail.
    #
    # @param request VodListCdnUsageDataDetailRequest
    # @return VodListCdnUsageDataDetailResponse
    # @raise Exception
    def list_cdn_usage_data_detail(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnUsageDataDetail", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListCdnUsageDataDetailResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListCdnUsageDataDetailResponse(), True)

    #
    # ListCdnStatusData.
    #
    # @param request VodListCdnStatusDataRequest
    # @return VodCdnStatisticsCommonResponse
    # @raise Exception
    def list_cdn_status_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnStatusData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCdnStatisticsCommonResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCdnStatisticsCommonResponse(), True)

    #
    # ListCdnStatusDataDetail.
    #
    # @param request VodListCdnStatusDataDetailRequest
    # @return VodListCdnStatusDataDetailResponse
    # @raise Exception
    def list_cdn_status_data_detail(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnStatusDataDetail", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodListCdnStatusDataDetailResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodListCdnStatusDataDetailResponse(), True)

    #
    # DescribeIpInfo.
    #
    # @param request VodDescribeIPInfoRequest
    # @return VodDescribeIPInfoResponse
    # @raise Exception
    def describe_ip_info(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeIpInfo", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDescribeIPInfoResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDescribeIPInfoResponse(), True)

    #
    # DescribeVodDomainTrafficData.
    #
    # @param request VodDescribeVodDomainTrafficDataRequest
    # @return VodDescribeVodDomainTrafficDataResponse
    # @raise Exception
    def describe_vod_domain_traffic_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodDomainTrafficData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodDescribeVodDomainTrafficDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodDescribeVodDomainTrafficDataResponse(), True)

    #
    # ListCdnPvData.
    #
    # @param request VodListCdnPvDataRequest
    # @return VodCdnStatisticsCommonResponse
    # @raise Exception
    def list_cdn_pv_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("ListCdnPvData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCdnStatisticsCommonResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCdnStatisticsCommonResponse(), True)

    #
    # SubmitBlockTasks.
    #
    # @param request VodSubmitBlockTasksRequest
    # @return VodSubmitBlockTasksResponse
    # @raise Exception
    def submit_block_tasks(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.post("SubmitBlockTasks",{},params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodSubmitBlockTasksResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodSubmitBlockTasksResponse(), True)


    #
    # GetContentBlockTasks.
    #
    # @param request VodGetContentBlockTasksRequest
    # @return VodGetContentBlockTasksResponse
    # @raise Exception
    def get_content_block_tasks(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.post("GetContentBlockTasks",{},params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodGetContentBlockTasksResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodGetContentBlockTasksResponse(), True)


    #
    # CreateDomain.
    #
    # @param request VodCreateDomainV2Request
    # @return VodCreateDomainV2Response
    # @raise Exception
    def create_domain(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("CreateDomain", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodCreateDomainV2Response(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodCreateDomainV2Response(), True)

    #
    # UpdateDomainExpire.
    #
    # @param request VodUpdateDomainExpireV2Request
    # @return VodUpdateDomainExpireV2Response
    # @raise Exception
    def update_domain_expire(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("UpdateDomainExpire", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodUpdateDomainExpireV2Response(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodUpdateDomainExpireV2Response(), True)

    #
    # AddOrUpdateCertificate.
    #
    # @param request AddOrUpdateCertificateV2Request
    # @return AddOrUpdateCertificateV2Response
    # @raise Exception
    def add_or_update_certificate(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.post("AddOrUpdateCertificate",{},params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), AddOrUpdateCertificateV2Response(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, AddOrUpdateCertificateV2Response(), True)


    #
    # AddCallbackSubscription.
    #
    # @param request VodAddCallbackSubscriptionRequest
    # @return VodAddCallbackSubscriptionResponse
    # @raise Exception
    def add_callback_subscription(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("AddCallbackSubscription", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodAddCallbackSubscriptionResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodAddCallbackSubscriptionResponse(), True)

    #
    # SetCallbackEvent.
    #
    # @param request VodSetCallbackEventRequest
    # @return VodSetCallbackEventResponse
    # @raise Exception
    def set_callback_event(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("SetCallbackEvent", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), VodSetCallbackEventResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, VodSetCallbackEventResponse(), True)

    #
    # DescribeVodSpaceTranscodeData.
    #
    # @param request DescribeVodSpaceTranscodeDataRequest
    # @return DescribeVodSpaceTranscodeDataResponse
    # @raise Exception
    def describe_vod_space_transcode_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodSpaceTranscodeData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), DescribeVodSpaceTranscodeDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, DescribeVodSpaceTranscodeDataResponse(), True)

    #
    # DescribeVodSpaceSubtitleStatisData.
    #
    # @param request DescribeVodSpaceSubtitleStatisDataRequest
    # @return DescribeVodSpaceSubtitleStatisDataResponse
    # @raise Exception
    def describe_vod_space_subtitle_statis_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodSpaceSubtitleStatisData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), DescribeVodSpaceSubtitleStatisDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, DescribeVodSpaceSubtitleStatisDataResponse(), True)

    #
    # DescribeVodSnapshotData.
    #
    # @param request DescribeVodSnapshotDataRequest
    # @return DescribeVodSnapshotDataResponse
    # @raise Exception
    def describe_vod_snapshot_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodSnapshotData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), DescribeVodSnapshotDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, DescribeVodSnapshotDataResponse(), True)

    #
    # DescribeVodEnhanceImageData.
    #
    # @param request DescribeVodEnhanceImageDataRequest
    # @return DescribeVodEnhanceImageDataResponse
    # @raise Exception
    def describe_vod_enhance_image_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodEnhanceImageData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), DescribeVodEnhanceImageDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, DescribeVodEnhanceImageDataResponse(), True)

    #
    # DescribeVodPlayedStatisData.
    #
    # @param request DescribeVodPlayedStatisDataRequest
    # @return DescribeVodPlayedStatisDataResponse
    # @raise Exception
    def describe_vod_played_statis_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodPlayedStatisData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), DescribeVodPlayedStatisDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, DescribeVodPlayedStatisDataResponse(), True)

    #
    # DescribeVodMostPlayedStatisData.
    #
    # @param request DescribeVodMostPlayedStatisDataRequest
    # @return DescribeVodMostPlayedStatisDataResponse
    # @raise Exception
    def describe_vod_most_played_statis_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodMostPlayedStatisData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), DescribeVodMostPlayedStatisDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, DescribeVodMostPlayedStatisDataResponse(), True)

    #
    # DescribeVodRealtimeMediaData.
    #
    # @param request DescribeVodRealtimeMediaDataRequest
    # @return DescribeVodRealtimeMediaDataResponse
    # @raise Exception
    def describe_vod_realtime_media_data(self, request):
        try:
            if sys.version_info[0] == 3:
                jsonData = MessageToJson(request, False, True)
                params = json.loads(jsonData)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            else:
                params = MessageToDict(request, False, True)
                for k, v in params.items():
                    if isinstance(v, (int, float, bool, str, unicode)) is True:
                        continue
                    else:
                        params[k] = json.dumps(v)
            res = self.get("DescribeVodRealtimeMediaData", params)
        except Exception as Argument:
            try:
                resp = Parse(Argument.__str__(), DescribeVodRealtimeMediaDataResponse(), True)
            except Exception:
                raise Argument
            else:
                raise Exception(resp.ResponseMetadata.Error.Code)
        else:
            return Parse(res, DescribeVodRealtimeMediaDataResponse(), True)

