# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AutopilotConfigArgs', 'AutopilotConfig']

@pulumi.input_type
class AutopilotConfigArgs:
    def __init__(__self__, *,
                 cleanup_dead_servers: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_upgrade_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_contact_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_trailing_logs: Optional[pulumi.Input[_builtins.int]] = None,
                 redundancy_zone_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 server_stabilization_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_version_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AutopilotConfig resource.
        :param pulumi.Input[_builtins.bool] cleanup_dead_servers: Whether to remove failing servers when a
               replacement comes online. Defaults to true.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's
               default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] disable_upgrade_migration: Whether to disable [upgrade migrations](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones).
               Defaults to false.
        :param pulumi.Input[_builtins.str] last_contact_threshold: The time after which a server is
               considered as unhealthy and will be removed. Defaults to `"200ms"`.
        :param pulumi.Input[_builtins.int] max_trailing_logs: The maximum number of Raft log entries a
               server can trail the leader. Defaults to 250.
        :param pulumi.Input[_builtins.str] redundancy_zone_tag: The [redundancy zone](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones)
               tag to use. Consul will try to keep one voting server by zone to take advantage
               of isolated failure domains. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] server_stabilization_time: The period to wait for a server to be
               healthy and stable before being promoted to a full, voting member. Defaults to
               `"10s"`.
        :param pulumi.Input[_builtins.str] upgrade_version_tag: The tag to override the version information
               used during a migration. Defaults to an empty string.
        """
        if cleanup_dead_servers is not None:
            pulumi.set(__self__, "cleanup_dead_servers", cleanup_dead_servers)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if disable_upgrade_migration is not None:
            pulumi.set(__self__, "disable_upgrade_migration", disable_upgrade_migration)
        if last_contact_threshold is not None:
            pulumi.set(__self__, "last_contact_threshold", last_contact_threshold)
        if max_trailing_logs is not None:
            pulumi.set(__self__, "max_trailing_logs", max_trailing_logs)
        if redundancy_zone_tag is not None:
            pulumi.set(__self__, "redundancy_zone_tag", redundancy_zone_tag)
        if server_stabilization_time is not None:
            pulumi.set(__self__, "server_stabilization_time", server_stabilization_time)
        if upgrade_version_tag is not None:
            pulumi.set(__self__, "upgrade_version_tag", upgrade_version_tag)

    @_builtins.property
    @pulumi.getter(name="cleanupDeadServers")
    def cleanup_dead_servers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to remove failing servers when a
        replacement comes online. Defaults to true.
        """
        return pulumi.get(self, "cleanup_dead_servers")

    @cleanup_dead_servers.setter
    def cleanup_dead_servers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cleanup_dead_servers", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's
        default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter(name="disableUpgradeMigration")
    def disable_upgrade_migration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable [upgrade migrations](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones).
        Defaults to false.
        """
        return pulumi.get(self, "disable_upgrade_migration")

    @disable_upgrade_migration.setter
    def disable_upgrade_migration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_upgrade_migration", value)

    @_builtins.property
    @pulumi.getter(name="lastContactThreshold")
    def last_contact_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time after which a server is
        considered as unhealthy and will be removed. Defaults to `"200ms"`.
        """
        return pulumi.get(self, "last_contact_threshold")

    @last_contact_threshold.setter
    def last_contact_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_contact_threshold", value)

    @_builtins.property
    @pulumi.getter(name="maxTrailingLogs")
    def max_trailing_logs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of Raft log entries a
        server can trail the leader. Defaults to 250.
        """
        return pulumi.get(self, "max_trailing_logs")

    @max_trailing_logs.setter
    def max_trailing_logs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_trailing_logs", value)

    @_builtins.property
    @pulumi.getter(name="redundancyZoneTag")
    def redundancy_zone_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [redundancy zone](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones)
        tag to use. Consul will try to keep one voting server by zone to take advantage
        of isolated failure domains. Defaults to an empty string.
        """
        return pulumi.get(self, "redundancy_zone_tag")

    @redundancy_zone_tag.setter
    def redundancy_zone_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundancy_zone_tag", value)

    @_builtins.property
    @pulumi.getter(name="serverStabilizationTime")
    def server_stabilization_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period to wait for a server to be
        healthy and stable before being promoted to a full, voting member. Defaults to
        `"10s"`.
        """
        return pulumi.get(self, "server_stabilization_time")

    @server_stabilization_time.setter
    def server_stabilization_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_stabilization_time", value)

    @_builtins.property
    @pulumi.getter(name="upgradeVersionTag")
    def upgrade_version_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to override the version information
        used during a migration. Defaults to an empty string.
        """
        return pulumi.get(self, "upgrade_version_tag")

    @upgrade_version_tag.setter
    def upgrade_version_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_version_tag", value)


@pulumi.input_type
class _AutopilotConfigState:
    def __init__(__self__, *,
                 cleanup_dead_servers: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_upgrade_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_contact_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_trailing_logs: Optional[pulumi.Input[_builtins.int]] = None,
                 redundancy_zone_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 server_stabilization_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_version_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutopilotConfig resources.
        :param pulumi.Input[_builtins.bool] cleanup_dead_servers: Whether to remove failing servers when a
               replacement comes online. Defaults to true.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's
               default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] disable_upgrade_migration: Whether to disable [upgrade migrations](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones).
               Defaults to false.
        :param pulumi.Input[_builtins.str] last_contact_threshold: The time after which a server is
               considered as unhealthy and will be removed. Defaults to `"200ms"`.
        :param pulumi.Input[_builtins.int] max_trailing_logs: The maximum number of Raft log entries a
               server can trail the leader. Defaults to 250.
        :param pulumi.Input[_builtins.str] redundancy_zone_tag: The [redundancy zone](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones)
               tag to use. Consul will try to keep one voting server by zone to take advantage
               of isolated failure domains. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] server_stabilization_time: The period to wait for a server to be
               healthy and stable before being promoted to a full, voting member. Defaults to
               `"10s"`.
        :param pulumi.Input[_builtins.str] upgrade_version_tag: The tag to override the version information
               used during a migration. Defaults to an empty string.
        """
        if cleanup_dead_servers is not None:
            pulumi.set(__self__, "cleanup_dead_servers", cleanup_dead_servers)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if disable_upgrade_migration is not None:
            pulumi.set(__self__, "disable_upgrade_migration", disable_upgrade_migration)
        if last_contact_threshold is not None:
            pulumi.set(__self__, "last_contact_threshold", last_contact_threshold)
        if max_trailing_logs is not None:
            pulumi.set(__self__, "max_trailing_logs", max_trailing_logs)
        if redundancy_zone_tag is not None:
            pulumi.set(__self__, "redundancy_zone_tag", redundancy_zone_tag)
        if server_stabilization_time is not None:
            pulumi.set(__self__, "server_stabilization_time", server_stabilization_time)
        if upgrade_version_tag is not None:
            pulumi.set(__self__, "upgrade_version_tag", upgrade_version_tag)

    @_builtins.property
    @pulumi.getter(name="cleanupDeadServers")
    def cleanup_dead_servers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to remove failing servers when a
        replacement comes online. Defaults to true.
        """
        return pulumi.get(self, "cleanup_dead_servers")

    @cleanup_dead_servers.setter
    def cleanup_dead_servers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cleanup_dead_servers", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's
        default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter(name="disableUpgradeMigration")
    def disable_upgrade_migration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable [upgrade migrations](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones).
        Defaults to false.
        """
        return pulumi.get(self, "disable_upgrade_migration")

    @disable_upgrade_migration.setter
    def disable_upgrade_migration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_upgrade_migration", value)

    @_builtins.property
    @pulumi.getter(name="lastContactThreshold")
    def last_contact_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time after which a server is
        considered as unhealthy and will be removed. Defaults to `"200ms"`.
        """
        return pulumi.get(self, "last_contact_threshold")

    @last_contact_threshold.setter
    def last_contact_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_contact_threshold", value)

    @_builtins.property
    @pulumi.getter(name="maxTrailingLogs")
    def max_trailing_logs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of Raft log entries a
        server can trail the leader. Defaults to 250.
        """
        return pulumi.get(self, "max_trailing_logs")

    @max_trailing_logs.setter
    def max_trailing_logs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_trailing_logs", value)

    @_builtins.property
    @pulumi.getter(name="redundancyZoneTag")
    def redundancy_zone_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [redundancy zone](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones)
        tag to use. Consul will try to keep one voting server by zone to take advantage
        of isolated failure domains. Defaults to an empty string.
        """
        return pulumi.get(self, "redundancy_zone_tag")

    @redundancy_zone_tag.setter
    def redundancy_zone_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundancy_zone_tag", value)

    @_builtins.property
    @pulumi.getter(name="serverStabilizationTime")
    def server_stabilization_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period to wait for a server to be
        healthy and stable before being promoted to a full, voting member. Defaults to
        `"10s"`.
        """
        return pulumi.get(self, "server_stabilization_time")

    @server_stabilization_time.setter
    def server_stabilization_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_stabilization_time", value)

    @_builtins.property
    @pulumi.getter(name="upgradeVersionTag")
    def upgrade_version_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to override the version information
        used during a migration. Defaults to an empty string.
        """
        return pulumi.get(self, "upgrade_version_tag")

    @upgrade_version_tag.setter
    def upgrade_version_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_version_tag", value)


@pulumi.type_token("consul:index/autopilotConfig:AutopilotConfig")
class AutopilotConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_dead_servers: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_upgrade_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_contact_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_trailing_logs: Optional[pulumi.Input[_builtins.int]] = None,
                 redundancy_zone_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 server_stabilization_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_version_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides access to the [Autopilot Configuration](https://www.consul.io/docs/guides/autopilot.html)
        of Consul to automatically manage Consul servers.

        It includes to automatically cleanup dead servers, monitor the status of the Raft
        cluster and stable server introduction.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        config = consul.AutopilotConfig("config",
            cleanup_dead_servers=False,
            last_contact_threshold="1s",
            max_trailing_logs=500)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cleanup_dead_servers: Whether to remove failing servers when a
               replacement comes online. Defaults to true.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's
               default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] disable_upgrade_migration: Whether to disable [upgrade migrations](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones).
               Defaults to false.
        :param pulumi.Input[_builtins.str] last_contact_threshold: The time after which a server is
               considered as unhealthy and will be removed. Defaults to `"200ms"`.
        :param pulumi.Input[_builtins.int] max_trailing_logs: The maximum number of Raft log entries a
               server can trail the leader. Defaults to 250.
        :param pulumi.Input[_builtins.str] redundancy_zone_tag: The [redundancy zone](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones)
               tag to use. Consul will try to keep one voting server by zone to take advantage
               of isolated failure domains. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] server_stabilization_time: The period to wait for a server to be
               healthy and stable before being promoted to a full, voting member. Defaults to
               `"10s"`.
        :param pulumi.Input[_builtins.str] upgrade_version_tag: The tag to override the version information
               used during a migration. Defaults to an empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AutopilotConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides access to the [Autopilot Configuration](https://www.consul.io/docs/guides/autopilot.html)
        of Consul to automatically manage Consul servers.

        It includes to automatically cleanup dead servers, monitor the status of the Raft
        cluster and stable server introduction.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        config = consul.AutopilotConfig("config",
            cleanup_dead_servers=False,
            last_contact_threshold="1s",
            max_trailing_logs=500)
        ```

        :param str resource_name: The name of the resource.
        :param AutopilotConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutopilotConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_dead_servers: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_upgrade_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_contact_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 max_trailing_logs: Optional[pulumi.Input[_builtins.int]] = None,
                 redundancy_zone_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 server_stabilization_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_version_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutopilotConfigArgs.__new__(AutopilotConfigArgs)

            __props__.__dict__["cleanup_dead_servers"] = cleanup_dead_servers
            __props__.__dict__["datacenter"] = datacenter
            __props__.__dict__["disable_upgrade_migration"] = disable_upgrade_migration
            __props__.__dict__["last_contact_threshold"] = last_contact_threshold
            __props__.__dict__["max_trailing_logs"] = max_trailing_logs
            __props__.__dict__["redundancy_zone_tag"] = redundancy_zone_tag
            __props__.__dict__["server_stabilization_time"] = server_stabilization_time
            __props__.__dict__["upgrade_version_tag"] = upgrade_version_tag
        super(AutopilotConfig, __self__).__init__(
            'consul:index/autopilotConfig:AutopilotConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cleanup_dead_servers: Optional[pulumi.Input[_builtins.bool]] = None,
            datacenter: Optional[pulumi.Input[_builtins.str]] = None,
            disable_upgrade_migration: Optional[pulumi.Input[_builtins.bool]] = None,
            last_contact_threshold: Optional[pulumi.Input[_builtins.str]] = None,
            max_trailing_logs: Optional[pulumi.Input[_builtins.int]] = None,
            redundancy_zone_tag: Optional[pulumi.Input[_builtins.str]] = None,
            server_stabilization_time: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_version_tag: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutopilotConfig':
        """
        Get an existing AutopilotConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cleanup_dead_servers: Whether to remove failing servers when a
               replacement comes online. Defaults to true.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's
               default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] disable_upgrade_migration: Whether to disable [upgrade migrations](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones).
               Defaults to false.
        :param pulumi.Input[_builtins.str] last_contact_threshold: The time after which a server is
               considered as unhealthy and will be removed. Defaults to `"200ms"`.
        :param pulumi.Input[_builtins.int] max_trailing_logs: The maximum number of Raft log entries a
               server can trail the leader. Defaults to 250.
        :param pulumi.Input[_builtins.str] redundancy_zone_tag: The [redundancy zone](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones)
               tag to use. Consul will try to keep one voting server by zone to take advantage
               of isolated failure domains. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] server_stabilization_time: The period to wait for a server to be
               healthy and stable before being promoted to a full, voting member. Defaults to
               `"10s"`.
        :param pulumi.Input[_builtins.str] upgrade_version_tag: The tag to override the version information
               used during a migration. Defaults to an empty string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutopilotConfigState.__new__(_AutopilotConfigState)

        __props__.__dict__["cleanup_dead_servers"] = cleanup_dead_servers
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["disable_upgrade_migration"] = disable_upgrade_migration
        __props__.__dict__["last_contact_threshold"] = last_contact_threshold
        __props__.__dict__["max_trailing_logs"] = max_trailing_logs
        __props__.__dict__["redundancy_zone_tag"] = redundancy_zone_tag
        __props__.__dict__["server_stabilization_time"] = server_stabilization_time
        __props__.__dict__["upgrade_version_tag"] = upgrade_version_tag
        return AutopilotConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cleanupDeadServers")
    def cleanup_dead_servers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to remove failing servers when a
        replacement comes online. Defaults to true.
        """
        return pulumi.get(self, "cleanup_dead_servers")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's
        default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter(name="disableUpgradeMigration")
    def disable_upgrade_migration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to disable [upgrade migrations](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones).
        Defaults to false.
        """
        return pulumi.get(self, "disable_upgrade_migration")

    @_builtins.property
    @pulumi.getter(name="lastContactThreshold")
    def last_contact_threshold(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time after which a server is
        considered as unhealthy and will be removed. Defaults to `"200ms"`.
        """
        return pulumi.get(self, "last_contact_threshold")

    @_builtins.property
    @pulumi.getter(name="maxTrailingLogs")
    def max_trailing_logs(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of Raft log entries a
        server can trail the leader. Defaults to 250.
        """
        return pulumi.get(self, "max_trailing_logs")

    @_builtins.property
    @pulumi.getter(name="redundancyZoneTag")
    def redundancy_zone_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [redundancy zone](https://www.consul.io/docs/guides/autopilot.html#redundancy-zones)
        tag to use. Consul will try to keep one voting server by zone to take advantage
        of isolated failure domains. Defaults to an empty string.
        """
        return pulumi.get(self, "redundancy_zone_tag")

    @_builtins.property
    @pulumi.getter(name="serverStabilizationTime")
    def server_stabilization_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The period to wait for a server to be
        healthy and stable before being promoted to a full, voting member. Defaults to
        `"10s"`.
        """
        return pulumi.get(self, "server_stabilization_time")

    @_builtins.property
    @pulumi.getter(name="upgradeVersionTag")
    def upgrade_version_tag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The tag to override the version information
        used during a migration. Defaults to an empty string.
        """
        return pulumi.get(self, "upgrade_version_tag")

