# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogEntryArgs', 'CatalogEntry']

@pulumi.input_type
class CatalogEntryArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 node: pulumi.Input[_builtins.str],
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CatalogEntry resource.
        :param pulumi.Input[_builtins.str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[_builtins.str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[_builtins.str] token: ACL token.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "node", node)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if token is not None:
            warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
            pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        The address of the node being added to,
        or referenced in the catalog.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def node(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the node being added to, or
        referenced in the catalog.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]:
        """
        A service to optionally associated with
        the node. Supported values are documented below.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ACL token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class _CatalogEntryState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CatalogEntry resources.
        :param pulumi.Input[_builtins.str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[_builtins.str] token: ACL token.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if token is not None:
            warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
            pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the node being added to,
        or referenced in the catalog.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter
    def node(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the node being added to, or
        referenced in the catalog.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]:
        """
        A service to optionally associated with
        the node. Supported values are documented below.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ACL token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("consul:index/catalogEntry:CatalogEntry")
class CatalogEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogEntryServiceArgs', 'CatalogEntryServiceArgsDict']]]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        !> The `CatalogEntry` resource has been deprecated in version 2.0.0 of the provider
        and will be removed in a future release. Please read the [upgrade guide](https://www.terraform.io/docs/providers/consul/guides/upgrading.html#deprecation-of-consul_catalog_entry)
        for more information.

        Registers a node or service with the [Consul Catalog](https://www.consul.io/docs/agent/http/catalog.html#catalog_register).
        Currently, defining health checks is not supported.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CatalogEntryServiceArgs', 'CatalogEntryServiceArgsDict']]]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[_builtins.str] token: ACL token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> The `CatalogEntry` resource has been deprecated in version 2.0.0 of the provider
        and will be removed in a future release. Please read the [upgrade guide](https://www.terraform.io/docs/providers/consul/guides/upgrading.html#deprecation-of-consul_catalog_entry)
        for more information.

        Registers a node or service with the [Consul Catalog](https://www.consul.io/docs/agent/http/catalog.html#catalog_register).
        Currently, defining health checks is not supported.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param CatalogEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogEntryServiceArgs', 'CatalogEntryServiceArgsDict']]]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogEntryArgs.__new__(CatalogEntryArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["datacenter"] = datacenter
            if node is None and not opts.urn:
                raise TypeError("Missing required property 'node'")
            __props__.__dict__["node"] = node
            __props__.__dict__["services"] = services
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CatalogEntry, __self__).__init__(
            'consul:index/catalogEntry:CatalogEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            datacenter: Optional[pulumi.Input[_builtins.str]] = None,
            node: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogEntryServiceArgs', 'CatalogEntryServiceArgsDict']]]]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None) -> 'CatalogEntry':
        """
        Get an existing CatalogEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CatalogEntryServiceArgs', 'CatalogEntryServiceArgsDict']]]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[_builtins.str] token: ACL token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogEntryState.__new__(_CatalogEntryState)

        __props__.__dict__["address"] = address
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["node"] = node
        __props__.__dict__["services"] = services
        __props__.__dict__["token"] = token
        return CatalogEntry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The address of the node being added to,
        or referenced in the catalog.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[_builtins.str]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter
    def node(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the node being added to, or
        referenced in the catalog.
        """
        return pulumi.get(self, "node")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence['outputs.CatalogEntryService']]]:
        """
        A service to optionally associated with
        the node. Supported values are documented below.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ACL token.
        """
        return pulumi.get(self, "token")

