# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAclTokenSecretIdResult',
    'AwaitableGetAclTokenSecretIdResult',
    'get_acl_token_secret_id',
    'get_acl_token_secret_id_output',
]

@pulumi.output_type
class GetAclTokenSecretIdResult:
    """
    A collection of values returned by getAclTokenSecretId.
    """
    def __init__(__self__, accessor_id=None, encrypted_secret_id=None, id=None, namespace=None, partition=None, pgp_key=None, secret_id=None):
        if accessor_id and not isinstance(accessor_id, str):
            raise TypeError("Expected argument 'accessor_id' to be a str")
        pulumi.set(__self__, "accessor_id", accessor_id)
        if encrypted_secret_id and not isinstance(encrypted_secret_id, str):
            raise TypeError("Expected argument 'encrypted_secret_id' to be a str")
        pulumi.set(__self__, "encrypted_secret_id", encrypted_secret_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)
        if pgp_key and not isinstance(pgp_key, str):
            raise TypeError("Expected argument 'pgp_key' to be a str")
        pulumi.set(__self__, "pgp_key", pgp_key)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter(name="accessorId")
    def accessor_id(self) -> _builtins.str:
        return pulumi.get(self, "accessor_id")

    @_builtins.property
    @pulumi.getter(name="encryptedSecretId")
    def encrypted_secret_id(self) -> _builtins.str:
        return pulumi.get(self, "encrypted_secret_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="pgpKey")
    def pgp_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "pgp_key")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        The secret ID of the ACL token if `pgp_key` has not been set.
        """
        return pulumi.get(self, "secret_id")


class AwaitableGetAclTokenSecretIdResult(GetAclTokenSecretIdResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAclTokenSecretIdResult(
            accessor_id=self.accessor_id,
            encrypted_secret_id=self.encrypted_secret_id,
            id=self.id,
            namespace=self.namespace,
            partition=self.partition,
            pgp_key=self.pgp_key,
            secret_id=self.secret_id)


def get_acl_token_secret_id(accessor_id: Optional[_builtins.str] = None,
                            namespace: Optional[_builtins.str] = None,
                            partition: Optional[_builtins.str] = None,
                            pgp_key: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAclTokenSecretIdResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    test = consul.AclPolicy("test",
        name="test",
        rules="node \\"\\" { policy = \\"read\\" }",
        datacenters=["dc1"])
    test_acl_token = consul.AclToken("test",
        description="test",
        policies=[test.name],
        local=True)
    read = consul.get_acl_token_secret_id_output(accessor_id=test_acl_token.id,
        pgp_key="keybase:my_username")
    pulumi.export("consulAclTokenSecretId", read.encrypted_secret_id)
    ```


    :param _builtins.str accessor_id: The accessor ID of the ACL token.
    :param _builtins.str namespace: The namespace to lookup the token.
    :param _builtins.str partition: The partition to lookup the token.
    """
    __args__ = dict()
    __args__['accessorId'] = accessor_id
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    __args__['pgpKey'] = pgp_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getAclTokenSecretId:getAclTokenSecretId', __args__, opts=opts, typ=GetAclTokenSecretIdResult).value

    return AwaitableGetAclTokenSecretIdResult(
        accessor_id=pulumi.get(__ret__, 'accessor_id'),
        encrypted_secret_id=pulumi.get(__ret__, 'encrypted_secret_id'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        partition=pulumi.get(__ret__, 'partition'),
        pgp_key=pulumi.get(__ret__, 'pgp_key'),
        secret_id=pulumi.get(__ret__, 'secret_id'))
def get_acl_token_secret_id_output(accessor_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   partition: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   pgp_key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAclTokenSecretIdResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    test = consul.AclPolicy("test",
        name="test",
        rules="node \\"\\" { policy = \\"read\\" }",
        datacenters=["dc1"])
    test_acl_token = consul.AclToken("test",
        description="test",
        policies=[test.name],
        local=True)
    read = consul.get_acl_token_secret_id_output(accessor_id=test_acl_token.id,
        pgp_key="keybase:my_username")
    pulumi.export("consulAclTokenSecretId", read.encrypted_secret_id)
    ```


    :param _builtins.str accessor_id: The accessor ID of the ACL token.
    :param _builtins.str namespace: The namespace to lookup the token.
    :param _builtins.str partition: The partition to lookup the token.
    """
    __args__ = dict()
    __args__['accessorId'] = accessor_id
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    __args__['pgpKey'] = pgp_key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('consul:index/getAclTokenSecretId:getAclTokenSecretId', __args__, opts=opts, typ=GetAclTokenSecretIdResult)
    return __ret__.apply(lambda __response__: GetAclTokenSecretIdResult(
        accessor_id=pulumi.get(__response__, 'accessor_id'),
        encrypted_secret_id=pulumi.get(__response__, 'encrypted_secret_id'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        partition=pulumi.get(__response__, 'partition'),
        pgp_key=pulumi.get(__response__, 'pgp_key'),
        secret_id=pulumi.get(__response__, 'secret_id')))
