# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCatalogServiceResult',
    'AwaitableGetCatalogServiceResult',
    'get_catalog_service',
    'get_catalog_service_output',
]

warnings.warn("""getCatalogService has been deprecated in favor of getService""", DeprecationWarning)

@pulumi.output_type
class GetCatalogServiceResult:
    """
    A collection of values returned by getCatalogService.
    """
    def __init__(__self__, datacenter=None, filter=None, id=None, name=None, query_options=None, services=None, tag=None):
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if query_options and not isinstance(query_options, list):
            raise TypeError("Expected argument 'query_options' to be a list")
        pulumi.set(__self__, "query_options", query_options)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[_builtins.str]:
        """
        The datacenter the keys are being read from to.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Optional[Sequence['outputs.GetCatalogServiceQueryOptionResult']]:
        return pulumi.get(self, "query_options")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetCatalogServiceServiceResult']:
        """
        A list of nodes and details about each endpoint advertising a
        service.  Each element in the list is a map of attributes that correspond to
        each individual node.  The list of per-node attributes is detailed below.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        The name of the tag used to filter the list of nodes in `service`.
        """
        return pulumi.get(self, "tag")


class AwaitableGetCatalogServiceResult(GetCatalogServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogServiceResult(
            datacenter=self.datacenter,
            filter=self.filter,
            id=self.id,
            name=self.name,
            query_options=self.query_options,
            services=self.services,
            tag=self.tag)


def get_catalog_service(datacenter: Optional[_builtins.str] = None,
                        filter: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        query_options: Optional[Sequence[Union['GetCatalogServiceQueryOptionArgs', 'GetCatalogServiceQueryOptionArgsDict']]] = None,
                        tag: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogServiceResult:
    """
    `Service` provides details about a specific Consul service in a
    given datacenter.  The results include a list of nodes advertising the specified
    service, the node's IP address, port number, node ID, etc.  By specifying a
    different datacenter in the `query_options` it is possible to retrieve a list of
    services from a different WAN-attached Consul datacenter.

    This data source is different from the `get_services` (plural) data
    source, which provides a summary of the current Consul services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul
    import pulumi_example as example
    import pulumi_std as std

    read_consul_dc1 = consul.get_service(name="consul",
        datacenter="dc1")
    # Set the description to a whitespace delimited list of the node names
    app = example.index.Resource("app", description=std.join(separator= ,
        input=nodes).result)
    ```


    :param _builtins.str datacenter: The Consul datacenter to query.  Defaults to the
           same value found in `query_options` parameter specified below, or if that is
           empty, the `datacenter` value found in the Consul agent that this provider is
           configured to talk to.
    :param _builtins.str name: The service name to select.
    :param Sequence[Union['GetCatalogServiceQueryOptionArgs', 'GetCatalogServiceQueryOptionArgsDict']] query_options: See below.
    :param _builtins.str tag: A single tag that can be used to filter the list of nodes
           to return based on a single matching tag..
    """
    pulumi.log.warn("""get_catalog_service is deprecated: getCatalogService has been deprecated in favor of getService""")
    __args__ = dict()
    __args__['datacenter'] = datacenter
    __args__['filter'] = filter
    __args__['name'] = name
    __args__['queryOptions'] = query_options
    __args__['tag'] = tag
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getCatalogService:getCatalogService', __args__, opts=opts, typ=GetCatalogServiceResult).value

    return AwaitableGetCatalogServiceResult(
        datacenter=pulumi.get(__ret__, 'datacenter'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        query_options=pulumi.get(__ret__, 'query_options'),
        services=pulumi.get(__ret__, 'services'),
        tag=pulumi.get(__ret__, 'tag'))
def get_catalog_service_output(datacenter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[_builtins.str]] = None,
                               query_options: Optional[pulumi.Input[Optional[Sequence[Union['GetCatalogServiceQueryOptionArgs', 'GetCatalogServiceQueryOptionArgsDict']]]]] = None,
                               tag: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCatalogServiceResult]:
    """
    `Service` provides details about a specific Consul service in a
    given datacenter.  The results include a list of nodes advertising the specified
    service, the node's IP address, port number, node ID, etc.  By specifying a
    different datacenter in the `query_options` it is possible to retrieve a list of
    services from a different WAN-attached Consul datacenter.

    This data source is different from the `get_services` (plural) data
    source, which provides a summary of the current Consul services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul
    import pulumi_example as example
    import pulumi_std as std

    read_consul_dc1 = consul.get_service(name="consul",
        datacenter="dc1")
    # Set the description to a whitespace delimited list of the node names
    app = example.index.Resource("app", description=std.join(separator= ,
        input=nodes).result)
    ```


    :param _builtins.str datacenter: The Consul datacenter to query.  Defaults to the
           same value found in `query_options` parameter specified below, or if that is
           empty, the `datacenter` value found in the Consul agent that this provider is
           configured to talk to.
    :param _builtins.str name: The service name to select.
    :param Sequence[Union['GetCatalogServiceQueryOptionArgs', 'GetCatalogServiceQueryOptionArgsDict']] query_options: See below.
    :param _builtins.str tag: A single tag that can be used to filter the list of nodes
           to return based on a single matching tag..
    """
    pulumi.log.warn("""get_catalog_service is deprecated: getCatalogService has been deprecated in favor of getService""")
    __args__ = dict()
    __args__['datacenter'] = datacenter
    __args__['filter'] = filter
    __args__['name'] = name
    __args__['queryOptions'] = query_options
    __args__['tag'] = tag
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('consul:index/getCatalogService:getCatalogService', __args__, opts=opts, typ=GetCatalogServiceResult)
    return __ret__.apply(lambda __response__: GetCatalogServiceResult(
        datacenter=pulumi.get(__response__, 'datacenter'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        query_options=pulumi.get(__response__, 'query_options'),
        services=pulumi.get(__response__, 'services'),
        tag=pulumi.get(__response__, 'tag')))
