# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 node: pulumi.Input[_builtins.str],
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 checks: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCheckArgs']]]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_tag_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 weights: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] node: The name of the node the to register the service on.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the address of the node.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] enable_tag_override: Specifies to disable the anti-entropy feature for this service's tags. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: A map of arbitrary KV metadata linked to the service instance.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the service within.
        :param pulumi.Input[_builtins.str] partition: The partition the service is associated with.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[_builtins.str] service_id: If the service ID is not provided, it will be defaulted to the value of the `name` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul, but can be used to distinguish between services or nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]] weights: Object that configures how the service responds to DNS SRV requests based on the service's health status. You can specify one or more of the following states and configure an integer value indicating its weight: `passing`, `warning`.
        """
        pulumi.set(__self__, "node", node)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if checks is not None:
            pulumi.set(__self__, "checks", checks)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if enable_tag_override is not None:
            pulumi.set(__self__, "enable_tag_override", enable_tag_override)
        if external is not None:
            warnings.warn("""The external field has been deprecated and does nothing.""", DeprecationWarning)
            pulumi.log.warn("""external is deprecated: The external field has been deprecated and does nothing.""")
        if external is not None:
            pulumi.set(__self__, "external", external)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weights is not None:
            pulumi.set(__self__, "weights", weights)

    @_builtins.property
    @pulumi.getter
    def node(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the node the to register the service on.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the service. Defaults to the address of the node.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCheckArgs']]]]:
        return pulumi.get(self, "checks")

    @checks.setter
    def checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCheckArgs']]]]):
        pulumi.set(self, "checks", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter(name="enableTagOverride")
    def enable_tag_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies to disable the anti-entropy feature for this service's tags. Defaults to `false`.
        """
        return pulumi.get(self, "enable_tag_override")

    @enable_tag_override.setter
    def enable_tag_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tag_override", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The external field has been deprecated and does nothing.""")
    def external(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary KV metadata linked to the service instance.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to create the service within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partition the service is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the service.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the service ID is not provided, it will be defaulted to the value of the `name` attribute.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of values that are opaque to Consul, but can be used to distinguish between services or nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def weights(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]]:
        """
        Object that configures how the service responds to DNS SRV requests based on the service's health status. You can specify one or more of the following states and configure an integer value indicating its weight: `passing`, `warning`.
        """
        return pulumi.get(self, "weights")

    @weights.setter
    def weights(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "weights", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 checks: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCheckArgs']]]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_tag_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 weights: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the address of the node.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] enable_tag_override: Specifies to disable the anti-entropy feature for this service's tags. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: A map of arbitrary KV metadata linked to the service instance.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the service within.
        :param pulumi.Input[_builtins.str] node: The name of the node the to register the service on.
        :param pulumi.Input[_builtins.str] partition: The partition the service is associated with.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[_builtins.str] service_id: If the service ID is not provided, it will be defaulted to the value of the `name` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul, but can be used to distinguish between services or nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]] weights: Object that configures how the service responds to DNS SRV requests based on the service's health status. You can specify one or more of the following states and configure an integer value indicating its weight: `passing`, `warning`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if checks is not None:
            pulumi.set(__self__, "checks", checks)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if enable_tag_override is not None:
            pulumi.set(__self__, "enable_tag_override", enable_tag_override)
        if external is not None:
            warnings.warn("""The external field has been deprecated and does nothing.""", DeprecationWarning)
            pulumi.log.warn("""external is deprecated: The external field has been deprecated and does nothing.""")
        if external is not None:
            pulumi.set(__self__, "external", external)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weights is not None:
            pulumi.set(__self__, "weights", weights)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the service. Defaults to the address of the node.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCheckArgs']]]]:
        return pulumi.get(self, "checks")

    @checks.setter
    def checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCheckArgs']]]]):
        pulumi.set(self, "checks", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter(name="enableTagOverride")
    def enable_tag_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies to disable the anti-entropy feature for this service's tags. Defaults to `false`.
        """
        return pulumi.get(self, "enable_tag_override")

    @enable_tag_override.setter
    def enable_tag_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tag_override", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The external field has been deprecated and does nothing.""")
    def external(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary KV metadata linked to the service instance.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to create the service within.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def node(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the node the to register the service on.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partition the service is associated with.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port of the service.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the service ID is not provided, it will be defaulted to the value of the `name` attribute.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of values that are opaque to Consul, but can be used to distinguish between services or nodes.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def weights(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]]:
        """
        Object that configures how the service responds to DNS SRV requests based on the service's health status. You can specify one or more of the following states and configure an integer value indicating its weight: `passing`, `warning`.
        """
        return pulumi.get(self, "weights")

    @weights.setter
    def weights(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "weights", value)


@pulumi.type_token("consul:index/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCheckArgs', 'ServiceCheckArgsDict']]]]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_tag_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 weights: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]] = None,
                 __props__=None):
        """
        A high-level resource for creating a Service in Consul in the Consul catalog. This
        is appropriate for registering [external services](https://www.consul.io/docs/guides/external.html) and
        can be used to create services addressable by Consul that cannot be registered
        with a [local agent](https://www.consul.io/docs/agent/basics.html).

        > **NOTE:** If a Consul agent is running on the node where this service is
        registered, it is not recommended to use this resource as the service will be
        removed during the next [anti-entropy synchronization](https://www.consul.io/docs/architecture/anti-entropy).

        ## Example Usage

        Creating a new node with the service:

        ```python
        import pulumi
        import pulumi_consul as consul

        compute = consul.Node("compute",
            name="compute-google",
            address="www.google.com")
        google = consul.Service("google",
            name="google",
            node=compute.name,
            port=80,
            tags=["tag0"])
        ```

        Utilizing an existing known node:

        ```python
        import pulumi
        import pulumi_consul as consul

        google = consul.Service("google",
            name="google",
            node="google",
            port=443)
        ```

        Register a health-check:

        ```python
        import pulumi
        import pulumi_consul as consul

        redis = consul.Service("redis",
            name="redis",
            node="redis",
            port=6379,
            checks=[{
                "check_id": "service:redis1",
                "name": "Redis health check",
                "status": "passing",
                "http": "https://www.hashicorptest.com",
                "tls_skip_verify": False,
                "method": "PUT",
                "interval": "5s",
                "timeout": "1s",
                "deregister_critical_service_after": "30s",
                "headers": [
                    {
                        "name": "foo",
                        "values": ["test"],
                    },
                    {
                        "name": "bar",
                        "values": ["test"],
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the address of the node.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] enable_tag_override: Specifies to disable the anti-entropy feature for this service's tags. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: A map of arbitrary KV metadata linked to the service instance.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the service within.
        :param pulumi.Input[_builtins.str] node: The name of the node the to register the service on.
        :param pulumi.Input[_builtins.str] partition: The partition the service is associated with.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[_builtins.str] service_id: If the service ID is not provided, it will be defaulted to the value of the `name` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul, but can be used to distinguish between services or nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]] weights: Object that configures how the service responds to DNS SRV requests based on the service's health status. You can specify one or more of the following states and configure an integer value indicating its weight: `passing`, `warning`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A high-level resource for creating a Service in Consul in the Consul catalog. This
        is appropriate for registering [external services](https://www.consul.io/docs/guides/external.html) and
        can be used to create services addressable by Consul that cannot be registered
        with a [local agent](https://www.consul.io/docs/agent/basics.html).

        > **NOTE:** If a Consul agent is running on the node where this service is
        registered, it is not recommended to use this resource as the service will be
        removed during the next [anti-entropy synchronization](https://www.consul.io/docs/architecture/anti-entropy).

        ## Example Usage

        Creating a new node with the service:

        ```python
        import pulumi
        import pulumi_consul as consul

        compute = consul.Node("compute",
            name="compute-google",
            address="www.google.com")
        google = consul.Service("google",
            name="google",
            node=compute.name,
            port=80,
            tags=["tag0"])
        ```

        Utilizing an existing known node:

        ```python
        import pulumi
        import pulumi_consul as consul

        google = consul.Service("google",
            name="google",
            node="google",
            port=443)
        ```

        Register a health-check:

        ```python
        import pulumi
        import pulumi_consul as consul

        redis = consul.Service("redis",
            name="redis",
            node="redis",
            port=6379,
            checks=[{
                "check_id": "service:redis1",
                "name": "Redis health check",
                "status": "passing",
                "http": "https://www.hashicorptest.com",
                "tls_skip_verify": False,
                "method": "PUT",
                "interval": "5s",
                "timeout": "1s",
                "deregister_critical_service_after": "30s",
                "headers": [
                    {
                        "name": "foo",
                        "values": ["test"],
                    },
                    {
                        "name": "bar",
                        "values": ["test"],
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCheckArgs', 'ServiceCheckArgsDict']]]]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_tag_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 external: Optional[pulumi.Input[_builtins.bool]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 weights: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["checks"] = checks
            __props__.__dict__["datacenter"] = datacenter
            __props__.__dict__["enable_tag_override"] = enable_tag_override
            __props__.__dict__["external"] = external
            __props__.__dict__["meta"] = meta
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            if node is None and not opts.urn:
                raise TypeError("Missing required property 'node'")
            __props__.__dict__["node"] = node
            __props__.__dict__["partition"] = partition
            __props__.__dict__["port"] = port
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["weights"] = weights
        super(Service, __self__).__init__(
            'consul:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            checks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCheckArgs', 'ServiceCheckArgsDict']]]]] = None,
            datacenter: Optional[pulumi.Input[_builtins.str]] = None,
            enable_tag_override: Optional[pulumi.Input[_builtins.bool]] = None,
            external: Optional[pulumi.Input[_builtins.bool]] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            node: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            weights: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The address of the service. Defaults to the address of the node.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.bool] enable_tag_override: Specifies to disable the anti-entropy feature for this service's tags. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: A map of arbitrary KV metadata linked to the service instance.
        :param pulumi.Input[_builtins.str] name: The name of the service.
        :param pulumi.Input[_builtins.str] namespace: The namespace to create the service within.
        :param pulumi.Input[_builtins.str] node: The name of the node the to register the service on.
        :param pulumi.Input[_builtins.str] partition: The partition the service is associated with.
        :param pulumi.Input[_builtins.int] port: The port of the service.
        :param pulumi.Input[_builtins.str] service_id: If the service ID is not provided, it will be defaulted to the value of the `name` attribute.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of values that are opaque to Consul, but can be used to distinguish between services or nodes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.int]]] weights: Object that configures how the service responds to DNS SRV requests based on the service's health status. You can specify one or more of the following states and configure an integer value indicating its weight: `passing`, `warning`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["address"] = address
        __props__.__dict__["checks"] = checks
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["enable_tag_override"] = enable_tag_override
        __props__.__dict__["external"] = external
        __props__.__dict__["meta"] = meta
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["node"] = node
        __props__.__dict__["partition"] = partition
        __props__.__dict__["port"] = port
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["weights"] = weights
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The address of the service. Defaults to the address of the node.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def checks(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceCheck']]]:
        return pulumi.get(self, "checks")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[_builtins.str]:
        """
        The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter(name="enableTagOverride")
    def enable_tag_override(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies to disable the anti-entropy feature for this service's tags. Defaults to `false`.
        """
        return pulumi.get(self, "enable_tag_override")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The external field has been deprecated and does nothing.""")
    def external(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of arbitrary KV metadata linked to the service instance.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to create the service within.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def node(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the node the to register the service on.
        """
        return pulumi.get(self, "node")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The partition the service is associated with.
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The port of the service.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        If the service ID is not provided, it will be defaulted to the value of the `name` attribute.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of values that are opaque to Consul, but can be used to distinguish between services or nodes.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def weights(self) -> pulumi.Output[Optional[Mapping[str, _builtins.int]]]:
        """
        Object that configures how the service responds to DNS SRV requests based on the service's health status. You can specify one or more of the following states and configure an integer value indicating its weight: `passing`, `warning`.
        """
        return pulumi.get(self, "weights")

