# -*- coding: utf-8 -*-
from setuptools import setup, find_packages

setup(
    name='strucgap',
    version='1.1.4',
    description='Structural and site-specific Glycoproteomics Analysis Platform',
    long_description=open('README.md', encoding='utf-8').read(),
    long_description_content_type='text/markdown',
    author='Muyao Yang',
    author_email='Muyao_Yang@proton.me',
    url='https://github.com/your-username/StrucGAP',
    packages=find_packages(),
    install_requires=[
        'pandas',
        'numpy',
        'scipy',
        'statsmodels',
        'scikit-learn',
        'xgboost',
        'tqdm',
        'gprofiler-official',
        'umap-learn',
        'matplotlib', 
        'Pillow',
        'PyComplexHeatmap',
        'cairosvg',
        'PyMuPDF',
        'gseapy',
        'networkx',
        'palettable',
        'plotly',
        'pyecharts',
        'pyecharts-snapshot',
        'reportlab',
        'requests',
        'seaborn',
        'snapshot-phantomjs',
        'svglib',
        'upsetplot',
        'venn',
        'werkzeug',
        'sphinx-autodoc-typehints',
        'renku-sphinx-theme',

    ],
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: MIT License',
    ],
    python_requires='>=3.7',
)
