# VegasAfterglow Logo Assets

This directory contains the official logo assets for the VegasAfterglow project.

## Logo Files

- `logo.svg` - Full vector logo with text (primary logo)
- `logo_small.svg` - Simplified vector logo for small sizes (icon/favicon)

## Logo Design Elements

The VegasAfterglow logo represents:

1. **Gamma-ray Burst Afterglow**: 
   - Central burst (yellow-orange) 
   - Expanding radiation waves (blue/purple/pink concentric circles)
   - Directional jets (curved yellow lines)

2. **Speed & Computational Efficiency**: 
   - Multiple lightning bolt symbols (teal) representing ultra-fast computation
   - Speed lines in background suggesting rapid movement
   - "ms" (milliseconds) indicator highlighting the extremely fast processing time
   - Enhanced binary code elements with background highlighting for visibility
   - Circuit-like paths suggesting optimized algorithms
   - CPU/GPU-like rectangular elements representing parallel processing

3. **Scientific/Technical Nature**:
   - Precise geometric elements
   - Physics-inspired design

## Usage Guidelines

- Maintain the color scheme when displaying the logo
- Keep the logo proportional when resizing
- Ensure adequate spacing around the logo
- The simplified logo (logo_small.svg) is preferred for sizes below 100px

## Integration with README

You can add the logo to your README.md file using a table layout for side-by-side content:

```markdown
<table border="0">
<tr>
<td width="40%" align="center">
<img src="assets/logo.svg" alt="VegasAfterglow Logo" width="300"/>
</td>
<td width="60%">
<!-- Your content here -->
</td>
</tr>
</table>
```

## Colors

Primary colors used in the logo:

- Dark Background: #1a1a2e
- Burst Yellow-Orange: #ff9e00, #ffcc00
- Wave Blues/Purples: #3282b8, #5c6cff, #bb86fc
- Wave Pink: #ff5e78
- Speed & Computational Elements: #00ffcc (bright teal)
- Text: #ffffff 