import os
from typing import Any, Callable, Literal, NamedTuple, Optional, overload

import serial

def stdout_write_bytes(b: bytes) -> None: ...

class TransportError(Exception): ...

class dir_result(NamedTuple):
    name: str
    st_mode: int
    st_ino: int
    st_size: int

class SerialTransport:
    device_name: str
    in_raw_repl: bool
    serial: serial.Serial

    def __init__(
        self,
        device: str,
        baudrate: int = 115200,
        wait: int = 0,
        exclusive: bool = True,
    ) -> None: ...
    def close(self) -> None: ...
    def enter_raw_repl(self, soft_reset: bool = True) -> None: ...
    def exit_raw_repl(self) -> None: ...
    def read_until(
        self,
        min_num_bytes: int,
        ending: bytes,
        timeout: int = 10,
        data_consumer: Optional[Callable[[bytes], None]] = None,
    ) -> bytes: ...
    def exec(
        self,
        command: str,
        data_consumer: Optional[Callable[[bytes], None]] = None,
    ) -> bytes: ...
    @overload
    def eval(self, expression: str, parse: Literal[False]) -> bytes: ...
    @overload
    def eval(self, expression: str, parse: bool = False) -> Any: ...
    def fs_listdir(self, src: str = "") -> list[dir_result]: ...
    def fs_stat(self, src: str) -> os.stat_result: ...
    def fs_cat(self, src: str, chunk_size: int = 256) -> None: ...
    def fs_readfile(self, src: str, chunk_size: int = 256) -> bytes: ...
    def fs_writefile(self, dest: str, data: bytes, chunk_size: int = 256) -> None: ...
    def fs_cp(
        self,
        src: str,
        dest: str,
        chunk_size: int = 256,
        progress_callback: Optional[Callable[[int, int], None]] = None,
    ) -> None: ...
    def fs_get(
        self,
        src: str,
        dest: str,
        chunk_size: int = 256,
        progress_callback: Optional[Callable[[int, int], None]] = None,
    ) -> None: ...
    def fs_put(
        self,
        src: str,
        dest: str,
        chunk_size: int = 256,
        progress_callback: Optional[Callable[[int, int], None]] = None,
    ) -> None: ...
    def fs_mkdir(self, dir: str) -> None: ...
    def fs_rmdir(self, dir: str) -> None: ...
    def fs_rmfile(self, dir: str) -> None: ...
    def fs_rm(self, dir: str) -> None: ...
    def fs_touchfile(self, dir: str) -> None: ...
    def fs_touch(self, dir: str) -> None: ...
    def mount_local(self, path: str, unsafe_links: bool = False) -> None: ...
