# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic

from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .currency import Currency
from .extended_subscription_response_model_billing_period import ExtendedSubscriptionResponseModelBillingPeriod
from .extended_subscription_response_model_character_refresh_period import (
    ExtendedSubscriptionResponseModelCharacterRefreshPeriod,
)
from .invoice import Invoice
from .subscription_status import SubscriptionStatus


class Subscription(UncheckedBaseModel):
    tier: str
    character_count: int
    character_limit: int
    can_extend_character_limit: bool
    allowed_to_extend_character_limit: bool
    next_character_count_reset_unix: int
    voice_limit: int
    max_voice_add_edits: typing.Optional[int] = None
    voice_add_edit_counter: typing.Optional[int] = None
    professional_voice_limit: int
    can_extend_voice_limit: bool
    can_use_instant_voice_cloning: bool
    can_use_professional_voice_cloning: bool
    currency: typing.Optional[Currency] = None
    status: typing.Optional[SubscriptionStatus] = None
    billing_period: typing.Optional[ExtendedSubscriptionResponseModelBillingPeriod] = None
    character_refresh_period: typing.Optional[ExtendedSubscriptionResponseModelCharacterRefreshPeriod] = None
    next_invoice: typing.Optional[Invoice] = None
    has_open_invoices: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
