# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic

from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .fine_tuning_response import FineTuningResponse
from .voice_response_model_safety_control import VoiceResponseModelSafetyControl
from .voice_sample import VoiceSample
from .voice_settings import VoiceSettings
from .voice_sharing_response import VoiceSharingResponse
from .voice_verification_response import VoiceVerificationResponse


class Voice(UncheckedBaseModel):
    voice_id: str
    name: typing.Optional[str] = None
    samples: typing.Optional[typing.List[VoiceSample]] = None
    category: typing.Optional[str] = None
    fine_tuning: typing.Optional[FineTuningResponse] = None
    labels: typing.Optional[typing.Dict[str, str]] = None
    description: typing.Optional[str] = None
    preview_url: typing.Optional[str] = None
    available_for_tiers: typing.Optional[typing.List[str]] = None
    settings: typing.Optional[VoiceSettings] = None
    sharing: typing.Optional[VoiceSharingResponse] = None
    high_quality_base_model_ids: typing.Optional[typing.List[str]] = None
    safety_control: typing.Optional[VoiceResponseModelSafetyControl] = None
    voice_verification: typing.Optional[VoiceVerificationResponse] = None
    owner_id: typing.Optional[str] = None
    permission_on_resource: typing.Optional[str] = None
    is_legacy: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
