# generated by datamodel-codegen:
#   filename:  https://api.repromptai.com/v1/reprompt/openapi.json
#   timestamp: 2025-08-20T04:03:43+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Literal, Optional

from pydantic import AwareDatetime, BaseModel, ConfigDict, Field


class AddressDetails(BaseModel):
    full_address: Optional[str] = Field(None, description="Full formatted address string", title="Full Address")
    unit_number: Optional[str] = Field(
        None, description="An apartment, unit, office, lot, or other secondary unit designator", title="Unit Number"
    )
    floor: Optional[str] = Field(
        None, description="Expressions indicating a floor number e.g. '3rd Floor', 'Ground Floor', etc.", title="Floor"
    )
    building: Optional[str] = Field(
        None,
        description="Building name e.g. 'Sun Hung Kai Centre', 'The Center', 'Empire State Building'",
        title="Building",
    )
    block: Optional[str] = Field(
        None,
        description="Block number, used in Singapore (SG) e.g., 'Block 329', Malaysia (MY) e.g., 'Blok A', and Indonesia (ID) e.g., 'Blok G5 No. 17'",
        title="Block",
    )
    km: Optional[str] = Field(
        None,
        description="Kilometer marker, commonly used in Malaysia (MY) e.g., 'KM 12, Jalan Cheras' and Indonesia (ID) e.g., 'KM 53, Jl. Tol Jakarta‑Cikampek'. Rarely used in Singapore. Should be parsed as a number (e.g., 'KM 75' should be parsed as '75').",
        title="Km",
    )
    house: Optional[str] = Field(None, title="House")
    street: Optional[str] = Field(None, title="Street")
    suburb: Optional[str] = Field(None, title="Suburb")
    city: Optional[str] = Field(None, title="City")
    state: Optional[str] = Field(None, title="State")
    country: Optional[str] = Field(None, title="Country")
    postalCode: Optional[str] = Field(None, title="Postalcode")


class AttributeSet(Enum):
    open_closed = "open_closed"
    core = "core"
    all = "all"


class AttributeStatusEnum(Enum):
    NOT_FOUND = "NOT FOUND"
    ADDED = "ADDED"
    VERIFIED = "VERIFIED"
    CORRECTED = "CORRECTED"
    NOT_VERIFIED = "NOT VERIFIED"
    NOT_ENRICHED = "NOT ENRICHED"
    RUN = "RUN"
    RUN_CONDITION_FAILED = "RUN_CONDITION_FAILED"
    ERROR = "ERROR"
    NOT_RUN = "NOT_RUN"


class BatchJobStatus(Enum):
    pending = "pending"
    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"
    failed = "failed"


class ConfidenceScore(Enum):
    VERY_HIGH = "VERY_HIGH"
    HIGH = "HIGH"
    MEDIUM = "MEDIUM"
    LOW = "LOW"
    NONE = "NONE"


class GeofenceRequest(BaseModel):
    place_name: Optional[str] = Field(None, description="Place name or address to search for", title="Place Name")
    latitude: Optional[float] = Field(None, description="Latitude coordinate", title="Latitude")
    longitude: Optional[float] = Field(None, description="Longitude coordinate", title="Longitude")
    zoom: Optional[int] = Field(17, description="Map zoom level (default: 17)", title="Zoom")
    feature_query: str = Field(
        ...,
        description="Description of features to detect (e.g., 'school grounds', 'buildings', 'parking lots')",
        title="Feature Query",
    )
    include_parcel: Optional[bool] = Field(
        False, description="Whether to include parcel boundary in response", title="Include Parcel"
    )
    model_name: Optional[str] = Field(
        "gemini-2.5-pro-preview-05-06", description="Gemini model to use for spatial understanding", title="Model Name"
    )
    thinking_budget: Optional[int] = Field(
        1024, description="Thinking budget for Gemini model", title="Thinking Budget"
    )


class GeofenceResponse(BaseModel):
    geojson: dict[str, Any] = Field(
        ..., description="GeoJSON FeatureCollection with detected features", title="Geojson"
    )
    metadata: Optional[dict[str, Any]] = Field(
        None, description="Additional metadata about the operation", title="Metadata"
    )


class JobConfidenceScores(BaseModel):
    open_closed_status: Optional[ConfidenceScore] = Field(
        None,
        description="Confidence score for the open/closed status of a place. VERY_HIGH (95% accuracy) indicates extremely reliable open/closed status. HIGH (90% accuracy) indicates very reliable status. MEDIUM (80% accuracy) indicates reasonably reliable status. LOW (70% accuracy) indicates limited online evidence but likely correct status.NONE indicates insufficient evidence to determine status. This happens when a place has no internet presence at all.",
    )
    phone: Optional[ConfidenceScore] = None
    website: Optional[ConfidenceScore] = None
    address: Optional[ConfidenceScore] = None
    categories: Optional[ConfidenceScore] = None
    opening_hours: Optional[ConfidenceScore] = None
    entity_type: Optional[ConfidenceScore] = None
    name: Optional[ConfidenceScore] = None
    parking_spaces: Optional[ConfidenceScore] = None
    parking_spaces_total: Optional[ConfidenceScore] = None
    parking_spaces_street: Optional[ConfidenceScore] = None
    parking_spaces_shared: Optional[ConfidenceScore] = None
    parking_spaces_dedicated: Optional[ConfidenceScore] = None
    chain: Optional[ConfidenceScore] = None
    tiktok: Optional[ConfidenceScore] = None
    price_tier: Optional[ConfidenceScore] = None
    menu: Optional[ConfidenceScore] = None
    school_geofence: Optional[ConfidenceScore] = Field(
        None,
        description="Confidence score for school geofence data. HIGH indicates OSM-based geofence with reliable school boundary data. MEDIUM indicates parcel-based geofence using property data analysis. NONE indicates no data",
    )


class JobMetadata(BaseModel):
    last_enriched: Optional[AwareDatetime] = Field(
        None, description="Timestamp of the last enrichment", title="Last Enriched"
    )
    enrichment_metadata: Optional[dict[str, dict[str, Any]]] = Field(None, title="Enrichment Metadata")
    attribute_status: dict[str, AttributeStatusEnum] = Field(..., title="Attribute Status")
    country_code: Optional[str] = Field(None, title="Country Code")


class Inputs(BaseModel):
    name: Optional[str] = Field(None, description="The name of the place.")
    full_address: Optional[str] = Field(None, description="The full address of the place.")
    latitude: Optional[float] = Field(None, description="The latitude of the place.")
    longitude: Optional[float] = Field(None, description="The longitude of the place.")


class PlaceJob(BaseModel):
    place_id: str = Field(
        ..., description="The unique identifier for the place. This is the place_id from the database."
    )
    inputs: Inputs = Field(..., description="The input place object. This is the place object that will be enriched.")
    attribute_set: Optional[str] = Field(
        None,
        description="The attribute set to enrich. This is the attribute set that will be used to enrich the place.",
    )
    attributes: Optional[list] = Field(
        None, description="The attributes to enrich. This is a list of attribute values."
    )
    refresh: Optional[bool] = Field(
        None, description="If true, will force a refresh of the place even if it has already been enriched."
    )
    prefilled_data: Optional[dict[str, Any]] = Field(
        None,
        description="Dictionary of prefilled attribute data to insert directly into the database. Keys should match attribute names.",
    )


class ReprocessJobRequest(BaseModel):
    place_ids: list[str] = Field(..., title="Place Ids")
    attributes: Optional[list[str]] = Field(None, title="Attributes")
    attribute_set: Optional[str] = Field(None, title="Attribute Set")
    refresh: Optional[bool] = Field(False, title="Refresh")
    send_pusher_updates: Optional[bool] = Field(False, title="Send Pusher Updates")
    enable_eval: Optional[bool] = Field(
        False,
        description="When true, enable evaluation mode with full LangSmith tracing (sampling rate = 1.0)",
        title="Enable Eval",
    )
    eval_id: Optional[str] = Field(
        None, description="Optional evaluation session ID for tracking evaluation batches", title="Eval Id"
    )


class StorefrontImage(BaseModel):
    url: str = Field(..., title="Url")
    title: Optional[str] = Field(None, title="Title")


class SubmittedPlaceBatchResponse(BaseModel):
    id: str = Field(
        ..., description="Unique identifier for tracking the batch", examples=["batch_2024_03_15_123456"], title="Id"
    )
    batch_name: str = Field(
        ...,
        description="User-provided name to identify the batch",
        examples=["NYC Restaurants March 2024"],
        title="Batch Name",
    )
    status: Optional[BatchJobStatus] = Field(
        BatchJobStatus.pending,
        description="Current processing status of the batch. Initially PENDING, changes to IN_PROGRESS when processing starts",
        examples=["pending"],
    )
    jobs: dict[str, Any]
    metadata: None = Field(
        None,
        description="Batch statistics and metadata. Basic stats available to all organizations, detailed stats only for Reprompt.",
    )


class UniversalPlace(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Optional[Any] = None
    input_type: Literal["place"]


class BatchJob(BaseModel):
    id: str = Field(..., title="Id")
    batch_name: str = Field(..., title="Batch Name")
    status_counts: dict[str, int] = Field(..., title="Status Counts")
    created_at: AwareDatetime = Field(..., title="Created At")
    status: BatchJobStatus
    metadata: None = None


class PlaceBatchPayload(BaseModel):
    batch_id: Optional[str] = Field(
        None,
        description="Optional unique identifier for the batch. If not provided, a new UUID will be generated. If an existing batch ID is provided, new jobs will be added to that batch.",
        title="Batch Id",
    )
    batch_name: str = Field(
        ...,
        description="The name of the batch. Only for display purposes. Recommended to use a descriptive human readable name.",
        title="Batch Name",
    )
    jobs: list[PlaceJob] = Field(
        ..., description="List of jobs to process. Maximum of 10,000 jobs per batch.", title="Jobs"
    )
    attribute_set: Optional[AttributeSet] = Field(None, description="Specifies the set of attributes to enrich.")
    attributes: Optional[list[str]] = Field(
        None,
        description="Specifies the list of attributes to enrich. If this is specified it will override the attribute_set. You cannot specify both.",
        title="Attributes",
    )
    kick_off_jobs_now: Optional[bool] = Field(
        True,
        description="Flag to determine if jobs should be kicked off immediately. Only for internal use.",
        title="Kick Off Jobs Now",
    )
    eval: Optional[bool] = Field(
        False, description="When true, enables evaluation mode with 100% LangSmith tracing sampling rate.", title="Eval"
    )


class PlaceJobResult(BaseModel):
    place_id: str = Field(..., title="Place Id")
    status: str = Field(..., title="Status")
    job_metadata: JobMetadata
    inputs: UniversalPlace = Field(..., discriminator="input_type", title="Inputs")
    outputs: dict[str, Any]
    reasoning: dict[str, Any]
    confidence_scores: Optional[JobConfidenceScores] = Field(
        None, description="Confidence scores for various attributes"
    )


class JobListResponse(BaseModel):
    jobs: list[PlaceJobResult] = Field(..., title="Jobs")
    total: int = Field(..., description="Total number of jobs available", title="Total")
    limit: int = Field(..., description="Number of jobs per page", title="Limit")
    offset: int = Field(..., description="Starting position of the current page", title="Offset")
