-- Row Level Security policies for all tables
BEGIN;
-- Content Items: public read, no insert/update/delete
ALTER TABLE public.content_items ENABLE ROW LEVEL SECURITY;
CREATE POLICY "Public can read content items" ON public.content_items
  FOR SELECT USING (true);
-- User Actions: owner only (future use)
ALTER TABLE public.user_actions ENABLE ROW LEVEL SECURITY;
CREATE POLICY "Users can read their actions" ON public.user_actions
  FOR SELECT USING (auth.uid() = user_id);
CREATE POLICY "Users can insert actions" ON public.user_actions
  FOR INSERT WITH CHECK (auth.uid() = user_id);
CREATE POLICY "Users can update their actions" ON public.user_actions
  FOR UPDATE USING (auth.uid() = user_id);
-- Action Items: only action owner (future use)
ALTER TABLE public.action_items ENABLE ROW LEVEL SECURITY;
CREATE POLICY "Users can read their action items" ON public.action_items
  FOR SELECT USING (
    EXISTS (
      SELECT 1 FROM public.user_actions a WHERE a.id = action_id AND a.user_id = auth.uid()
    )
  );
CREATE POLICY "Users can insert action items" ON public.action_items
  FOR INSERT WITH CHECK (
    EXISTS (
      SELECT 1 FROM public.user_actions a WHERE a.id = action_id AND a.user_id = auth.uid()
    )
  );
CREATE POLICY "Users can update their action items" ON public.action_items
  FOR UPDATE USING (
    EXISTS (
      SELECT 1 FROM public.user_actions a WHERE a.id = action_id AND a.user_id = auth.uid()
    )
  );
CREATE POLICY "Users can delete their action items" ON public.action_items
  FOR DELETE USING (
    EXISTS (
      SELECT 1 FROM public.user_actions a WHERE a.id = action_id AND a.user_id = auth.uid()
    )
  );
COMMIT;
