import '@/styles/globals.css';
import { Inter, Poppins } from 'next/font/google';
import dynamic from 'next/dynamic';
import type { Metadata } from 'next';
import Navbar from '@/components/Navbar';
import { UserActionsProvider } from '@/features/userActions/UserActionsContext';

const Footer = dynamic(() => import('@/components/Footer'));

export const metadata: Metadata = {
  title: {
    default: 'SaaSify - Modern SaaS Marketing',
    template: '%s | SaaSify'
  },
  description: 'Modern SaaS marketing website with features, pricing, testimonials, and more.'
};

const inter = Inter({ subsets: ['latin'], variable: '--font-inter' });
const poppins = Poppins({ weight: ['600', '700'], subsets: ['latin'], variable: '--font-poppins' });

export default function RootLayout({
  children
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en" className={`${inter.variable} ${poppins.variable} h-full`}>
      <body className="min-h-screen bg-background flex flex-col">
        <UserActionsProvider>
          <Navbar />
          <main className="flex-grow flex flex-col justify-start bg-background">
            {children}
          </main>
          <Footer />
        </UserActionsProvider>
      </body>
    </html>
  );
}
