"use client";
import dynamic from 'next/dynamic';
import { mockContent } from '@/utils/mockContent';
import FeaturesSection from '@/components/FeaturesSection';
import PricingSection from '@/components/PricingSection';
import TestimonialsSection from '@/components/TestimonialsSection';
import FAQSection from '@/components/FAQSection';
const HeroSection = dynamic(() => import('@/components/HeroSection'));
const ContentListWithSelect = dynamic(() => import('@/components/ContentListWithSelect'));

export default function HomePage() {
  return (
    <div className="w-full mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
      <HeroSection />
      <section className="mt-12">
        <ContentListWithSelect items={mockContent} />
      </section>
      <FeaturesSection />
      <PricingSection />
      <TestimonialsSection />
      <FAQSection />
    </div>
  );
}
