const FEATURES = [
  {
    icon: (
      <svg className="w-8 h-8 text-primary" fill="none" stroke="currentColor" strokeWidth="2" viewBox="0 0 24 24"><path d="M13 16h-1v-4h-1m4-4h1a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V7a2 2 0 0 1 2-2h9" /></svg>
    ),
    title: 'Real-time Insights',
    desc: 'Track your business KPIs and analytics in real time for faster decision making.'
  },
  {
    icon: (
      <svg className="w-8 h-8 text-accent" fill="none" stroke="currentColor" strokeWidth="2" viewBox="0 0 24 24"><path d="M12 8v4l3 3" /><circle cx="12" cy="12" r="10" /></svg>
    ),
    title: 'Automation',
    desc: 'Automate repetitive tasks, marketing flows, and customer journeys.'
  },
  {
    icon: (
      <svg className="w-8 h-8 text-secondary" fill="none" stroke="currentColor" strokeWidth="2" viewBox="0 0 24 24"><path d="M7 8h10M7 12h4" /><rect x="3" y="4" width="18" height="16" rx="2" /></svg>
    ),
    title: 'Easy Integrations',
    desc: 'Connect your favorite tools and unlock more value with powerful APIs.'
  },
  {
    icon: (
      <svg className="w-8 h-8 text-error" fill="none" stroke="currentColor" strokeWidth="2" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" /><path d="M10 10h4v4h-4z" /></svg>
    ),
    title: 'Advanced Security',
    desc: 'Industry leading security features to protect your data and privacy.'
  }
];

export default function FeaturesSection() {
  return (
    <section className="py-16" id="features">
      <h2 className="text-3xl font-heading font-bold text-center mb-10 text-foreground">
        Why Choose SaaSify?
      </h2>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-6xl mx-auto">
        {FEATURES.map((f, i) => (
          <div
            key={i}
            className="rounded-2xl bg-card shadow-glass flex flex-col items-center justify-center px-6 py-8 text-center hover:shadow-xl transition-shadow duration-200"
          >
            <div className="mb-4 animate-fade-in-slow">{f.icon}</div>
            <div className="text-xl font-semibold mb-2 text-primary font-heading">
              {f.title}
            </div>
            <div className="text-base text-muted-foreground">
              {f.desc}
            </div>
          </div>
        ))}
      </div>
    </section>
  );
}
