"use client";
import Link from 'next/link';
import { useEffect, useState } from 'react';
import { supabase } from '@/lib/supabaseClient';
import { UserCircleIcon } from '@heroicons/react/24/outline';

export default function NavbarAuth() {
  const [user, setUser] = useState<any>(null);
  const [loading, setLoading] = useState(true);
  
  useEffect(() => {
    let ignore = false;
    async function getUser() {
      setLoading(true);
      const { data } = await supabase.auth.getUser();
      if (!ignore) {
        setUser(data.user);
        setLoading(false);
      }
    }
    getUser();
    
    const { data: listener } = supabase.auth.onAuthStateChange(() => {
      getUser();
    });
    
    return () => {
      ignore = true;
      listener.subscription.unsubscribe();
    };
  }, []);
  
  return user ? (
    <Link 
      href="/profile" 
      className="flex items-center gap-2 px-4 py-2 rounded-lg bg-accent text-white font-semibold shadow-glass hover:bg-primary transition-colors duration-200 ml-2"
    >
      <UserCircleIcon className="w-5 h-5" />
      My Profile
    </Link>
  ) : (
    <Link 
      href="/auth" 
      className="flex items-center gap-2 px-4 py-2 rounded-lg bg-secondary text-white font-semibold shadow-glass hover:bg-primary transition-colors duration-200 ml-2"
    >
      Sign In
    </Link>
  );
}
