# CRM SaaS Application

A modern, client-facing CRM SaaS application with contact management, deal tracking, activity logs, and a kanban-style pipeline view.

## Features

- **Contact Management**: Easily manage and organize your customer contacts
- **Deal Tracking**: Track sales opportunities with a kanban-style pipeline view
- **Task Management**: Stay on top of follow-ups and activities
- **Company Management**: Organize contacts by company and track company information
- **Activity Logging**: See a history of activities and interactions
- **Modern UI**: Clean, responsive interface built with Next.js and Tailwind CSS

## Tech Stack

- **Frontend**: Next.js, React, TypeScript
- **Styling**: Tailwind CSS
- **UI Components**: Radix UI, shadcn/ui
- **Database**: Supabase (PostgreSQL)
- **Authentication**: Supabase Auth

## Authentication

This application is integrated with Supabase Authentication, providing:

- User registration with email/password
- User login and session management  
- Password reset flow
- Protected routes for authenticated users

### Authentication Setup

1. Create a Supabase project at [supabase.com](https://supabase.com)
2. Enable Email/Password authentication in the Auth settings
3. Create SQL tables for user profiles:

```sql
CREATE TABLE profiles (
  id UUID PRIMARY KEY REFERENCES auth.users(id),
  name TEXT,
  email TEXT,
  avatar_url TEXT,
  role TEXT CHECK (role IN ('admin', 'user', 'manager')),
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);
```

4. Update your environment variables in .env.local:
```
NEXT_PUBLIC_SUPABASE_URL=your-project-url
NEXT_PUBLIC_SUPABASE_ANON_KEY=your-anon-key
```

### Authentication Flow

The authentication flow includes:
- Login page (/auth/login)
- Registration page (/auth/signup)  
- Password reset (/auth/reset)
- Password update (/auth/update-password)

Protected routes require authentication and will redirect to the login page if the user is not authenticated.

## Getting Started

### Prerequisites

- Node.js 18+ and npm/pnpm/yarn
- Supabase account (for database when ready to integrate)

### Installation

1. Clone the repository
   ```bash
   git clone https://github.com/yourusername/my-crm-saas.git
   cd my-crm-saas
   ```

2. Install dependencies
   ```bash
   npm install
   # or
   yarn install
   # or
   pnpm install
   ```

3. Create a `.env.local` file in the root directory with the following variables:
   ```
   NEXT_PUBLIC_SUPABASE_URL=your-supabase-url
   NEXT_PUBLIC_SUPABASE_ANON_KEY=your-supabase-anon-key
   NEXT_PUBLIC_APP_URL=http://localhost:3000
   ```

4. Start the development server
   ```bash
   npm run dev
   # or
   yarn dev
   # or
   pnpm dev
   ```

5. Open [http://localhost:3000](http://localhost:3000) in your browser to see the application

## Current Status

This application is currently using mock data for demonstration purposes. Future versions will integrate with Supabase for real-time data storage and retrieval.

## Project Structure

- `/src/app`: Next.js App Router pages
- `/src/components`: Reusable React components
- `/src/lib`: Utility functions and mock data
- `/src/types`: TypeScript type definitions
- `/src/styles`: Global CSS styles
- `/public`: Static assets

## Upcoming Features

- Authentication and user management
- Email integration
- File attachments
- Reports and analytics
- Calendar integration
- Mobile app

## License

MIT 