"use client"

import { MainLayout } from "@/components/layout/MainLayout"
import { useAuth } from "@/components/auth/AuthProvider"
import { useRouter } from "next/navigation"
import { useEffect } from "react"

export default function DashboardLayout({
  children,
}: {
  children: React.ReactNode
}) {
  const { user, isLoading } = useAuth()
  const router = useRouter()
  
  // Extra protection to ensure user is authenticated for dashboard routes
  useEffect(() => {
    if (!isLoading && !user) {
      router.replace("/auth/login")
    }
  }, [user, isLoading, router])
  
  // Show loading state while checking authentication
  if (isLoading) {
    return (
      <div className="h-screen flex items-center justify-center">
        <div className="animate-spin h-8 w-8 border-4 border-primary border-t-transparent rounded-full"></div>
      </div>
    )
  }
  
  // Only render the dashboard layout if the user is authenticated
  if (!user) {
    return null // Prevent flashing content before redirect
  }
  
  return <MainLayout>{children}</MainLayout>
} 