"use client"

import { useState } from "react"
import { 
  BarChart, 
  BarChart3, 
  Download, 
  FilterX, 
  LineChart, 
  PieChart, 
  RefreshCw
} from "lucide-react"

import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { 
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuLabel,
  DropdownMenuSeparator,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu"

export default function ReportsPage() {
  const [timeframe, setTimeframe] = useState<'week' | 'month' | 'quarter' | 'year'>('month')
  
  return (
    <div className="p-6 space-y-8">
      <div className="flex justify-between items-start">
        <div className="space-y-2">
          <h2 className="text-3xl font-bold tracking-tight">Reports</h2>
          <p className="text-muted-foreground">
            Analyze your sales performance and customer relationships.
          </p>
        </div>
        <div className="flex items-center space-x-2">
          <Button variant="outline" size="sm">
            <RefreshCw className="h-4 w-4 mr-2" />
            Refresh
          </Button>
          <Button variant="outline" size="sm">
            <Download className="h-4 w-4 mr-2" />
            Export
          </Button>
          <DropdownMenu>
            <DropdownMenuTrigger asChild>
              <Button variant="outline" size="sm">
                <FilterX className="h-4 w-4 mr-2" />
                Filter
              </Button>
            </DropdownMenuTrigger>
            <DropdownMenuContent align="end">
              <DropdownMenuLabel>Time Period</DropdownMenuLabel>
              <DropdownMenuSeparator />
              <DropdownMenuItem onClick={() => setTimeframe('week')}>
                This Week
              </DropdownMenuItem>
              <DropdownMenuItem onClick={() => setTimeframe('month')}>
                This Month
              </DropdownMenuItem>
              <DropdownMenuItem onClick={() => setTimeframe('quarter')}>
                This Quarter
              </DropdownMenuItem>
              <DropdownMenuItem onClick={() => setTimeframe('year')}>
                This Year
              </DropdownMenuItem>
            </DropdownMenuContent>
          </DropdownMenu>
        </div>
      </div>

      <div className="grid gap-6 grid-cols-1 lg:grid-cols-2">
        {/* Sales Overview Card */}
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2">
            <CardTitle className="text-md font-medium">
              Sales Overview
            </CardTitle>
            <BarChart className="h-4 w-4 text-muted-foreground" />
          </CardHeader>
          <CardContent>
            <div className="h-[200px] w-full bg-muted/30 rounded-md flex items-center justify-center">
              <p className="text-muted-foreground text-sm">Sales chart will render here</p>
              {/* This is where an actual chart component would go */}
            </div>
            <div className="grid grid-cols-2 gap-4 pt-4">
              <div>
                <p className="text-sm font-medium">Total Sales</p>
                <p className="text-2xl font-bold">$48,743</p>
                <p className="text-xs text-green-500">↑ 12% from last {timeframe}</p>
              </div>
              <div>
                <p className="text-sm font-medium">Conversion Rate</p>
                <p className="text-2xl font-bold">24%</p>
                <p className="text-xs text-green-500">↑ 3% from last {timeframe}</p>
              </div>
            </div>
          </CardContent>
        </Card>

        {/* Deal Pipeline Card */}
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2">
            <CardTitle className="text-md font-medium">
              Deal Pipeline
            </CardTitle>
            <PieChart className="h-4 w-4 text-muted-foreground" />
          </CardHeader>
          <CardContent>
            <div className="h-[200px] w-full bg-muted/30 rounded-md flex items-center justify-center">
              <p className="text-muted-foreground text-sm">Pipeline chart will render here</p>
              {/* This is where an actual chart component would go */}
            </div>
            <div className="grid grid-cols-4 gap-2 pt-4">
              <div className="text-center">
                <div className="w-full h-2 bg-blue-500 rounded-full mb-1"></div>
                <p className="text-xs">Qualified</p>
                <p className="font-bold">5</p>
              </div>
              <div className="text-center">
                <div className="w-full h-2 bg-amber-500 rounded-full mb-1"></div>
                <p className="text-xs">Proposal</p>
                <p className="font-bold">8</p>
              </div>
              <div className="text-center">
                <div className="w-full h-2 bg-violet-500 rounded-full mb-1"></div>
                <p className="text-xs">Negotiation</p>
                <p className="font-bold">4</p>
              </div>
              <div className="text-center">
                <div className="w-full h-2 bg-green-500 rounded-full mb-1"></div>
                <p className="text-xs">Closed</p>
                <p className="font-bold">12</p>
              </div>
            </div>
          </CardContent>
        </Card>

        {/* Activity Metrics Card */}
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2">
            <CardTitle className="text-md font-medium">
              Activity Metrics
            </CardTitle>
            <BarChart3 className="h-4 w-4 text-muted-foreground" />
          </CardHeader>
          <CardContent>
            <div className="space-y-4">
              {[
                { title: "New Contacts", value: 28, growth: "+15%", color: "bg-blue-100" },
                { title: "Completed Tasks", value: 45, growth: "+23%", color: "bg-green-100" },
                { title: "Meetings Scheduled", value: 17, growth: "+5%", color: "bg-amber-100" },
                { title: "Emails Sent", value: 124, growth: "+18%", color: "bg-purple-100" },
              ].map((metric, i) => (
                <div key={i} className={`p-3 rounded-md ${metric.color} flex justify-between items-center`}>
                  <p className="font-medium">{metric.title}</p>
                  <div className="text-right">
                    <p className="text-xl font-bold">{metric.value}</p>
                    <p className="text-xs text-green-700">{metric.growth}</p>
                  </div>
                </div>
              ))}
            </div>
          </CardContent>
        </Card>

        {/* Revenue Forecast Card */}
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2">
            <CardTitle className="text-md font-medium">
              Revenue Forecast
            </CardTitle>
            <LineChart className="h-4 w-4 text-muted-foreground" />
          </CardHeader>
          <CardContent>
            <div className="h-[200px] w-full bg-muted/30 rounded-md flex items-center justify-center">
              <p className="text-muted-foreground text-sm">Forecast chart will render here</p>
              {/* This is where an actual chart component would go */}
            </div>
            <div className="grid grid-cols-3 gap-4 pt-4">
              <div>
                <p className="text-sm font-medium">Best Case</p>
                <p className="text-lg font-bold text-green-600">$85,000</p>
              </div>
              <div>
                <p className="text-sm font-medium">Most Likely</p>
                <p className="text-lg font-bold">$67,500</p>
              </div>
              <div>
                <p className="text-sm font-medium">Worst Case</p>
                <p className="text-lg font-bold text-red-600">$42,000</p>
              </div>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  )
} 