import { Card, CardContent } from "@/components/ui/card"
import ProfileCard from "@/components/profile/ProfileCard"
import { getCurrentUser, getUserProfile } from "@/lib/supabase-server"
import SettingsContent from "@/components/settings/SettingsContent"
import { redirect } from "next/navigation"

export default async function SettingsPage() {
  // Get the current user and profile (this runs on the server)
  const user = await getCurrentUser();
  console.log("Server side user:", user ? "User authenticated" : "No user found");
  
  // Redirect to login if no user is found
  if (!user) {
    redirect('/auth/login');
  }
  
  const profile = await getUserProfile(user.id);
  console.log("Server side profile:", profile ? "Profile found" : "No profile found");
  
  return <SettingsContent user={user} profile={profile} />;
} 