"use client"

import Link from "next/link"
import Image from "next/image"

export default function AuthLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <div className="min-h-screen flex flex-col">
      <div className="container flex-1 items-center justify-center grid lg:grid-cols-2 lg:px-0">
        <div className="hidden h-full bg-muted lg:block">
          <div className="h-full w-full flex items-center justify-center bg-primary/5 relative">
            <div className="w-full max-w-md px-8">
              <div className="mb-8">
                <h1 className="text-3xl font-bold">CRM SaaS</h1>
                <p className="text-lg text-muted-foreground mt-2">
                  Manage your customer relationships with ease.
                </p>
              </div>
              <div className="space-y-4">
                <div className="flex items-center gap-2">
                  <div className="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-primary"><path d="M15.5 3H5a2 2 0 0 0-2 2v14c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2V8.5L15.5 3Z"/><path d="M15 3v6h6"/></svg>
                  </div>
                  <p className="text-sm">Manage contacts and deals in one place</p>
                </div>
                <div className="flex items-center gap-2">
                  <div className="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-primary"><path d="M9.3 6.2a4.55 4.55 0 0 0 5.4 0"/><path d="M7.9 10.7c.9.8 2.4 1.3 4.1 1.3s3.2-.5 4.1-1.3"/><path d="M13.9 3.6a1.45 1.45 0 0 0-1.9-1.4c-.8.2-1.2 1.1-1 1.9.2.8 1.1 1.2 1.9 1 .2 0 .3-.1.4-.2"/><path d="M17.2 6.5c1 0 1.7-.7 1.7-1.7s-.7-1.7-1.7-1.7-1.7.7-1.7 1.7.7 1.7 1.7 1.7Z"/><path d="M21 12c0-5-4-9-9-9s-9 4-9 9 4 9 9 9a9 9 0 0 0 8.7-6.8"/><path d="M8 15h8"/><path d="M11 18h2"/></svg>
                  </div>
                  <p className="text-sm">Beautiful, intuitive dashboard</p>
                </div>
                <div className="flex items-center gap-2">
                  <div className="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-primary"><path d="M12 14v3"/><path d="M10 17h4"/><circle cx="12" cy="9" r="1"/><circle cx="19" cy="9" r="1"/><circle cx="5" cy="9" r="1"/><path d="M8.5 14.5A5 5 0 0 1 2 12"/><path d="M15.5 14.5a5 5 0 0 0 6.5-2.5"/></svg>
                  </div>
                  <p className="text-sm">Track tasks and follow-ups</p>
                </div>
              </div>
            </div>
            <div className="absolute bottom-4 left-8 right-8 bg-card p-4 rounded-md border shadow-sm">
              <p className="text-sm text-muted-foreground">
                "This CRM tool has revolutionized how our sales team operates. Everything we need in one place."
              </p>
              <div className="flex items-center gap-2 mt-2">
                <div className="h-6 w-6 rounded-full bg-muted"></div>
                <p className="text-xs font-medium">Sarah Johnson, Sales Director</p>
              </div>
            </div>
          </div>
        </div>
        <div className="lg:p-8">
          <div className="mx-auto flex w-full flex-col justify-center space-y-6 sm:w-[350px]">
            <div className="flex flex-col space-y-2 text-center">
              <div className="mb-6 flex justify-center">
                <Link href="/" className="flex items-center gap-2">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="h-6 w-6"><path d="M6 2h12l5 5v14a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1Z"/><path d="M6 16h12"/><path d="M6 20h12"/><path d="M9 8h1"/><path d="M14 8h1"/></svg>
                  <span className="font-bold text-xl">CRM SaaS</span>
                </Link>
              </div>
              {children}
            </div>
          </div>
        </div>
      </div>
    </div>
  )
} 