"use client"

import Link from "next/link"
import Image from "next/image"
import { useAuth } from "@/components/auth/AuthProvider"
import { Button } from "@/components/ui/button"
import { NavBar } from "@/components/layout/NavBar"
import { Check } from "lucide-react"

export default function Home() {
  const { user, isLoading } = useAuth()
  
  if (isLoading) {
    return (
      <div className="h-screen flex items-center justify-center">
        <div className="animate-spin h-8 w-8 border-4 border-primary border-t-transparent rounded-full"></div>
      </div>
    )
  }

  return (
    <div className="flex min-h-screen flex-col">
      {/* Navbar */}
      <NavBar />
      
      {/* Hero Section */}
      <section className="flex-1 container flex flex-col md:flex-row items-center gap-8 py-12 md:py-24">
        <div className="flex-1 space-y-4">
          <h1 className="text-4xl md:text-6xl font-bold">
            Customer Relationship Management That Works
          </h1>
          <p className="text-xl text-muted-foreground">
            Track leads, close deals, and build lasting customer relationships.
          </p>
          <div className="flex gap-4">
            {!user ? (
              <>
                <Button className="px-6 py-6" asChild>
                  <Link href="/auth/signup">Get Started</Link>
                </Button>
                <Button className="px-6 py-6 border border-input bg-background hover:bg-accent hover:text-accent-foreground" asChild>
                  <Link href="#demo">View Demo</Link>
                </Button>
              </>
            ) : (
              <Button className="px-6 py-6" asChild>
                <Link href="/dashboard">Go to Dashboard</Link>
              </Button>
            )}
          </div>
        </div>
        <div className="flex-1 flex justify-center">
          <div className="w-full max-w-md overflow-hidden rounded-lg shadow-lg border">
            <Image 
                src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?q=80&w=1000&auto=format&fit=crop" 
              alt="CRM Dashboard" 
              width={600} 
              height={400}
              className="w-full object-cover"
              priority
            />
          </div>
        </div>
      </section>
      
      {/* Features Section */}
      <section id="features" className="container py-16 md:py-24">
        <h2 className="text-3xl font-bold text-center mb-12">Features</h2>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          <div className="space-y-2">
            <div className="h-12 w-12 rounded-lg bg-primary/10 flex items-center justify-center">
              <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-primary"><path d="M17 18a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2"></path><rect width="18" height="18" x="3" y="3" rx="2"></rect><circle cx="12" cy="10" r="3"></circle></svg>
            </div>
            <h3 className="text-xl font-bold">Contact Management</h3>
            <p className="text-muted-foreground">Keep track of all your contacts and their details in one place.</p>
          </div>
          <div className="space-y-2">
            <div className="h-12 w-12 rounded-lg bg-primary/10 flex items-center justify-center">
              <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-primary"><path d="M2 7v7c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-1"></path><path d="M16 10.34V6c0-.55-.45-1-1-1H8.34"></path><path d="m2 2 5 5"></path><path d="M22 17v1c0 .55-.45 1-1 1H9c-.55 0-1-.45-1-1v-1"></path><path d="M8 13.66V18c0 .55.45 1 1 1h4.66"></path><path d="m22 22-5-5"></path></svg>
            </div>
            <h3 className="text-xl font-bold">Deal Pipeline</h3>
            <p className="text-muted-foreground">Visualize your sales pipeline with an intuitive kanban board.</p>
          </div>
          <div className="space-y-2">
            <div className="h-12 w-12 rounded-lg bg-primary/10 flex items-center justify-center">
              <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="text-primary"><rect width="18" height="18" x="3" y="3" rx="2"></rect><path d="M7 7h10"></path><path d="M7 12h2"></path><path d="M7 17h6"></path></svg>
            </div>
            <h3 className="text-xl font-bold">Task Management</h3>
            <p className="text-muted-foreground">Schedule and track your follow-ups and never miss an opportunity.</p>
          </div>
        </div>
      </section>
      
      {/* Pricing Section */}
      <section id="pricing" className="container py-16 md:py-24 bg-muted/30">
        <h2 className="text-3xl font-bold text-center mb-4">Pricing Plans</h2>
        <p className="text-center text-muted-foreground mb-12 max-w-2xl mx-auto">
          Choose the perfect plan for your business needs. All plans include a 14-day free trial.
        </p>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-5xl mx-auto">
          {/* Starter Plan */}
          <div className="bg-card rounded-lg shadow-sm border p-6 flex flex-col">
            <h3 className="text-lg font-bold">Starter</h3>
            <div className="mt-4 flex items-baseline">
              <span className="text-3xl font-bold">$19</span>
              <span className="ml-1 text-muted-foreground">/month</span>
            </div>
            <p className="mt-4 text-muted-foreground text-sm">Perfect for small businesses and freelancers.</p>
            <ul className="mt-6 space-y-3 flex-1">
              {["Up to 500 contacts", "Basic reporting", "Email integration", "1 team member"].map((feature) => (
                <li key={feature} className="flex items-start">
                  <Check className="h-5 w-5 text-green-500 shrink-0 mr-2" />
                  <span className="text-sm">{feature}</span>
                </li>
              ))}
            </ul>
            <Button className="mt-8 w-full" asChild>
              <Link href="/auth/signup?plan=starter">Get Started</Link>
            </Button>
          </div>
          
          {/* Pro Plan */}
          <div className="bg-card rounded-lg shadow-md border-2 border-primary p-6 flex flex-col relative">
            <div className="absolute top-0 right-0 bg-primary text-primary-foreground px-3 py-1 text-xs font-medium rounded-bl-lg rounded-tr-lg">
              Popular
            </div>
            <h3 className="text-lg font-bold">Professional</h3>
            <div className="mt-4 flex items-baseline">
              <span className="text-3xl font-bold">$49</span>
              <span className="ml-1 text-muted-foreground">/month</span>
            </div>
            <p className="mt-4 text-muted-foreground text-sm">Ideal for growing businesses and teams.</p>
            <ul className="mt-6 space-y-3 flex-1">
              {[
                "Up to 2,500 contacts", 
                "Advanced reporting", 
                "Email & SMS integration", 
                "5 team members",
                "Deal automation",
                "Custom fields"
              ].map((feature) => (
                <li key={feature} className="flex items-start">
                  <Check className="h-5 w-5 text-green-500 shrink-0 mr-2" />
                  <span className="text-sm">{feature}</span>
                </li>
              ))}
            </ul>
            <Button className="mt-8 w-full" asChild>
              <Link href="/auth/signup?plan=professional">Get Started</Link>
            </Button>
          </div>
          
          {/* Enterprise Plan */}
          <div className="bg-card rounded-lg shadow-sm border p-6 flex flex-col">
            <h3 className="text-lg font-bold">Enterprise</h3>
            <div className="mt-4 flex items-baseline">
              <span className="text-3xl font-bold">$99</span>
              <span className="ml-1 text-muted-foreground">/month</span>
            </div>
            <p className="mt-4 text-muted-foreground text-sm">For large organizations with advanced needs.</p>
            <ul className="mt-6 space-y-3 flex-1">
              {[
                "Unlimited contacts", 
                "Custom reporting", 
                "All integrations", 
                "Unlimited team members",
                "Full API access",
                "Dedicated support",
                "White labeling",
                "SLA guarantees"
              ].map((feature) => (
                <li key={feature} className="flex items-start">
                  <Check className="h-5 w-5 text-green-500 shrink-0 mr-2" />
                  <span className="text-sm">{feature}</span>
                </li>
              ))}
            </ul>
            <Button className="mt-8 w-full" asChild>
              <Link href="/auth/signup?plan=enterprise">Get Started</Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  )
} 