import { cookies } from 'next/headers';
import { createServerComponentClient } from '@supabase/auth-helpers-nextjs';
import { redirect } from 'next/navigation';
import ProfileCard from '@/components/profile/ProfileCard';
import { getCurrentUser, getUserProfile } from '@/lib/supabase';

export default async function ProfilePage() {
  // Get the current user and profile
  const user = await getCurrentUser();
  
  // If no user is found, redirect to login
  if (!user) {
    redirect('/auth/login');
  }
  
  // Get profile data
  const profile = await getUserProfile(user.id);

  return (
    <section className="max-w-lg mx-auto px-4 py-8 min-h-[400px] flex flex-col items-center justify-center">
      <ProfileCard user={user} profile={profile} />
    </section>
  );
} 