"use client"

import { ReactNode } from "react"
import { Sidebar } from "@/components/layout/Sidebar"
import { UserButton } from "@/components/auth/UserButton"

interface MainLayoutProps {
  children: ReactNode
}

export function MainLayout({ children }: MainLayoutProps) {
  return (
    <div className="h-full relative">
      <div className="hidden h-full md:flex md:w-72 md:flex-col md:fixed md:inset-y-0 z-[80] bg-white dark:bg-zinc-950 border-r">
        <Sidebar />
      </div>
      <main className="md:pl-72 h-full">
        <header className="sticky top-0 z-10 h-16 border-b flex items-center px-6 bg-background">
          <div className="flex-1">
            {/* Mobile menu button can go here */}
          </div>
          <div>
            <UserButton />
          </div>
        </header>
        <div className="h-[calc(100%-4rem)]">
          {children}
        </div>
      </main>
    </div>
  )
} 