"use client"

import Link from "next/link"
import { useAuth } from "@/components/auth/AuthProvider"
import { UserButton } from "@/components/auth/UserButton"
import { Button } from "@/components/ui/button"
import { Menu } from "lucide-react"
import { useState } from "react"

export function NavBar() {
  const { user } = useAuth()
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false)
  
  return (
    <header className="sticky top-0 z-50 w-full border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
      <div className="container flex h-16 items-center justify-between">
        <div className="flex items-center gap-2">
          <Link href="/" className="flex items-center gap-2">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="h-6 w-6">
              <path d="M6 2h12l5 5v14a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1Z"/>
              <path d="M6 16h12"/>
              <path d="M6 20h12"/>
              <path d="M9 8h1"/>
              <path d="M14 8h1"/>
            </svg>
            <span className="font-bold text-xl">CRM SaaS</span>
          </Link>
        </div>
        
        {/* Desktop Navigation */}
        <nav className="hidden md:flex gap-6 text-sm font-medium">
          <Link href="/#features" className="transition-colors hover:text-foreground/80">
            Features
          </Link>
          <Link href="/#pricing" className="transition-colors hover:text-foreground/80">
            Pricing
          </Link>
          {user && (
            <Link href="/dashboard" className="transition-colors hover:text-foreground/80">
              Dashboard
            </Link>
          )}
        </nav>
        
        {/* Auth Buttons or User Menu */}
        <div className="flex items-center gap-2">
          {user ? (
            <UserButton />
          ) : (
            <>
              <Link href="/auth/login" className="text-sm font-medium hover:underline">
                Sign in
              </Link>
              <Button className="ml-4" asChild>
                <Link href="/auth/signup">Sign up</Link>
              </Button>
            </>
          )}
          
          {/* Mobile Menu Button */}
          <button 
            className="md:hidden ml-2 p-2 rounded-md hover:bg-accent"
            onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
          >
            <Menu className="h-5 w-5" />
          </button>
        </div>
      </div>
      
      {/* Mobile Menu */}
      {mobileMenuOpen && (
        <div className="md:hidden py-4 px-6 space-y-4 border-t">
          <Link href="/#features" className="block py-2 font-medium">
            Features
          </Link>
          <Link href="/#pricing" className="block py-2 font-medium">
            Pricing
          </Link>
          {user && (
            <Link href="/dashboard" className="block py-2 font-medium">
              Dashboard
            </Link>
          )}
          {!user && (
            <div className="pt-2 space-y-3">
              <Button className="w-full" asChild>
                <Link href="/auth/signup">Sign up</Link>
              </Button>
              <Button className="w-full border border-input bg-background hover:bg-accent hover:text-accent-foreground" asChild>
                <Link href="/auth/login">Sign in</Link>
              </Button>
            </div>
          )}
        </div>
      )}
    </header>
  )
} 