"use client"

import Link from "next/link"
import { usePathname } from "next/navigation"
import {
  BarChart3,
  Building2,
  Contact,
  DollarSign,
  Home,
  LayoutDashboard,
  List,
  Settings,
  UsersRound,
} from "lucide-react"

import { cn } from "@/lib/utils"
import { Button } from "@/components/ui/button"

const routes = [
  {
    label: "Dashboard",
    icon: LayoutDashboard,
    href: "/dashboard",
    color: "text-sky-500",
  },
  {
    label: "Contacts",
    icon: Contact,
    href: "/contacts",
    color: "text-violet-500",
  },
  {
    label: "Deals",
    icon: DollarSign,
    href: "/deals",
    color: "text-pink-700",
  },
  {
    label: "Tasks",
    icon: List,
    href: "/tasks",
    color: "text-orange-500",
  },
  {
    label: "Companies",
    icon: Building2,
    href: "/companies",
    color: "text-emerald-500",
  },
  {
    label: "Reports",
    icon: BarChart3,
    href: "/reports",
    color: "text-blue-500",
  },
  {
    label: "Team",
    icon: UsersRound,
    href: "/team",
    color: "text-green-500",
  },
  {
    label: "Settings",
    icon: Settings,
    href: "/settings",
    color: "text-gray-500",
  },
]

export function Sidebar() {
  const pathname = usePathname()

  return (
    <div className="space-y-4 py-4 flex flex-col h-full bg-white dark:bg-zinc-950 text-zinc-900 dark:text-zinc-50 border-r">
      <div className="px-3 py-2 flex-1">
        <Link href="/dashboard" className="flex items-center pl-3 mb-10">
          <div className="relative w-8 h-8 mr-2">
            <Home className="w-8 h-8 text-primary" />
          </div>
          <h1 className="text-2xl font-bold">
            CRM<span className="text-primary">SaaS</span>
          </h1>
        </Link>
        <div className="space-y-1">
          {routes.map((route) => (
            <Button
              key={route.href}
              variant={pathname === route.href ? "default" : "ghost"}
              className={cn(
                "w-full justify-start pl-3",
                pathname === route.href
                  ? "bg-primary text-primary-foreground"
                  : "hover:bg-zinc-100 dark:hover:bg-zinc-900"
              )}
              asChild
            >
              <Link href={route.href}>
                <route.icon className={cn("h-5 w-5 mr-3", route.color)} />
                {route.label}
              </Link>
            </Button>
          ))}
        </div>
      </div>
      <div className="px-3 py-2">
        <div className="rounded-lg bg-zinc-100 dark:bg-zinc-900 p-3 flex items-center">
          <div className="flex flex-col space-y-1 flex-1">
            <p className="text-sm font-medium">Pro Plan</p>
            <div className="text-xs">
              All features unlocked
            </div>
          </div>
          <Button size="sm" className="ml-2">
            Upgrade
          </Button>
        </div>
      </div>
    </div>
  )
} 