import { Contact, Deal, Task, ActivityLog, Company, User, PipelineStage } from "@/types/crm";

// Mock Pipeline Stages
export const pipelineStages: PipelineStage[] = [
  {
    id: "qualified",
    title: "Qualified",
    color: "bg-blue-500",
    order: 1
  },
  {
    id: "proposal",
    title: "Proposal",
    color: "bg-amber-500",
    order: 2
  },
  {
    id: "negotiation",
    title: "Negotiation",
    color: "bg-violet-500",
    order: 3
  },
  {
    id: "closed",
    title: "Closed Won",
    color: "bg-green-500",
    order: 4
  }
];

// Mock Companies
export const companies: Company[] = [
  {
    id: "company-1",
    name: "Acme Corp",
    industry: "Technology",
    website: "https://acmecorp.com",
    size: "Enterprise",
    location: "New York, NY",
    createdAt: "2023-01-15T10:00:00.000Z",
    logo: "https://images.unsplash.com/photo-1568822617270-2c1579f8dfe2?q=80&w=200&h=200&auto=format&fit=crop"
  },
  {
    id: "company-2",
    name: "TechGiant Inc",
    industry: "Technology",
    website: "https://techgiant.com",
    size: "Enterprise",
    location: "San Francisco, CA",
    createdAt: "2023-02-10T14:30:00.000Z",
    logo: "https://images.unsplash.com/photo-1516321318423-f06f85e504b3?q=80&w=200&h=200&auto=format&fit=crop"
  },
  {
    id: "company-3",
    name: "SmallBusiness LLC",
    industry: "Retail",
    website: "https://smallbusiness.com",
    size: "Small",
    location: "Austin, TX",
    createdAt: "2023-03-05T09:15:00.000Z",
    logo: "https://images.unsplash.com/photo-1560179707-f14e90ef3623?q=80&w=200&h=200&auto=format&fit=crop"
  },
  {
    id: "company-4",
    name: "MegaCorp",
    industry: "Finance",
    website: "https://megacorp.com",
    size: "Enterprise",
    location: "Chicago, IL",
    createdAt: "2023-01-25T11:45:00.000Z",
    logo: "https://images.unsplash.com/photo-1579389083078-4e7018379f7e?q=80&w=200&h=200&auto=format&fit=crop"
  },
  {
    id: "company-5",
    name: "Startup Inc",
    industry: "Technology",
    website: "https://startupinc.com",
    size: "Startup",
    location: "Boston, MA",
    createdAt: "2023-04-12T16:20:00.000Z",
    logo: "https://images.unsplash.com/photo-1559136555-9303baea8ebd?q=80&w=200&h=200&auto=format&fit=crop"
  },
  {
    id: "company-6",
    name: "Local Business",
    industry: "Retail",
    website: "https://localbusiness.com",
    size: "Small",
    location: "Portland, OR",
    createdAt: "2023-02-28T13:10:00.000Z",
    logo: "https://images.unsplash.com/photo-1544717304-a2db4a7b16ee?q=80&w=200&h=200&auto=format&fit=crop"
  },
  {
    id: "company-7",
    name: "Consultancy Services",
    industry: "Consulting",
    website: "https://consultancyservices.com",
    size: "Medium",
    location: "Seattle, WA",
    createdAt: "2023-03-18T10:30:00.000Z",
    logo: "https://images.unsplash.com/photo-1542744173-8e7e53415bb0?q=80&w=200&h=200&auto=format&fit=crop"
  }
];

// Mock Contacts
export const contacts: Contact[] = [
  {
    id: "contact-1",
    name: "John Smith",
    email: "john.smith@acmecorp.com",
    phone: "(555) 123-4567",
    company: "Acme Corp",
    position: "CEO",
    lastActivity: "2 days ago",
    status: "active",
    avatar: "https://images.unsplash.com/photo-1599566150163-29194dcaad36?q=80&w=100&h=100&auto=format&fit=crop"
  },
  {
    id: "contact-2",
    name: "Sarah Johnson",
    email: "sarah.j@techgiant.com",
    phone: "(555) 987-6543",
    company: "TechGiant Inc",
    position: "CTO",
    lastActivity: "5 days ago",
    status: "active",
    avatar: "https://images.unsplash.com/photo-1494790108377-be9c29b29330?q=80&w=100&h=100&auto=format&fit=crop"
  },
  {
    id: "contact-3",
    name: "David Wilson",
    email: "david@smallbusiness.com",
    phone: "(555) 456-7890",
    company: "SmallBusiness LLC",
    position: "Owner",
    lastActivity: "1 week ago",
    status: "inactive",
    avatar: "https://images.unsplash.com/photo-1602233158242-3ba0ac4d2167?q=80&w=100&h=100&auto=format&fit=crop"
  },
  {
    id: "contact-4",
    name: "Michael Brown",
    email: "mbrown@megacorp.com",
    phone: "(555) 321-7654",
    company: "MegaCorp",
    position: "Project Manager",
    lastActivity: "Yesterday",
    status: "active",
    avatar: "https://images.unsplash.com/photo-1633332755192-727a05c4013d?q=80&w=100&h=100&auto=format&fit=crop"
  },
  {
    id: "contact-5",
    name: "Jennifer Lee",
    email: "jlee@startupinc.com",
    phone: "(555) 789-0123",
    company: "Startup Inc",
    position: "Founder",
    lastActivity: "Today",
    status: "active",
    avatar: "https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?q=80&w=100&h=100&auto=format&fit=crop"
  },
  {
    id: "contact-6",
    name: "Robert Chen",
    email: "rchen@localbusiness.com",
    phone: "(555) 234-5678",
    company: "Local Business",
    position: "Manager",
    lastActivity: "3 days ago",
    status: "active",
    avatar: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?q=80&w=100&h=100&auto=format&fit=crop"
  },
  {
    id: "contact-7",
    name: "Emily Davis",
    email: "emily@consultancy.com",
    phone: "(555) 876-5432",
    company: "Consultancy Services",
    position: "Senior Consultant",
    lastActivity: "1 month ago",
    status: "inactive",
    avatar: "https://images.unsplash.com/photo-1557296387-5358ad7997bb?q=80&w=100&h=100&auto=format&fit=crop"
  }
];

// Mock Deals
export const deals: Deal[] = [
  {
    id: "deal-1",
    title: "Enterprise Software Package",
    company: "Acme Corp",
    value: "$24,000",
    contact: "John Smith",
    stage: "qualified",
    description: "Complete software package for enterprise clients including CRM, ERP and analytics.",
    createdAt: "2023-05-01T09:00:00.000Z",
  },
  {
    id: "deal-2",
    title: "Consulting Services",
    company: "TechGiant Inc",
    value: "$15,000",
    contact: "Sarah Johnson",
    stage: "qualified",
    description: "Strategic consulting for cloud infrastructure optimization and migration.",
    createdAt: "2023-05-02T10:30:00.000Z",
  },
  {
    id: "deal-3",
    title: "Annual Support Contract",
    company: "SmallBusiness LLC",
    value: "$8,500",
    contact: "David Wilson",
    stage: "proposal",
    description: "12-month technical support and maintenance contract with 24/7 coverage.",
    createdAt: "2023-05-03T14:15:00.000Z",
  },
  {
    id: "deal-4",
    title: "Premium SaaS Subscription",
    company: "MegaCorp",
    value: "$36,000",
    contact: "Michael Brown",
    stage: "negotiation",
    description: "Enterprise-level subscription to our flagship SaaS product with custom integrations.",
    createdAt: "2023-05-04T11:45:00.000Z",
  },
  {
    id: "deal-5",
    title: "Software Implementation",
    company: "Startup Inc",
    value: "$12,800",
    contact: "Jennifer Lee",
    stage: "proposal",
    description: "Implementation of our software platform with data migration and training.",
    createdAt: "2023-05-05T13:20:00.000Z",
  },
  {
    id: "deal-6",
    title: "Hardware Upgrade",
    company: "Local Business",
    value: "$5,200",
    contact: "Robert Chen",
    stage: "closed",
    description: "Complete hardware refresh including servers, workstations, and networking equipment.",
    createdAt: "2023-05-01T15:10:00.000Z",
    closedAt: "2023-05-15T16:00:00.000Z"
  }
];

// Mock Tasks
export const tasks: Task[] = [
  {
    id: "task-1",
    title: "Follow up with John Smith",
    description: "Send proposal follow-up email",
    dueDate: "Today at 2:00 PM",
    priority: "high",
    related: "Acme Corp - Software Package",
    status: "pending",
    isExpanded: false,
    type: "email",
    createdAt: "2023-05-17T09:30:00.000Z"
  },
  {
    id: "task-2",
    title: "Prepare presentation for TechGiant Inc",
    description: "Create slides for the initial consultation meeting",
    dueDate: "Tomorrow at 10:00 AM",
    priority: "medium",
    related: "TechGiant Inc - Consulting Services",
    status: "pending",
    isExpanded: false,
    type: "meeting",
    createdAt: "2023-05-17T11:00:00.000Z"
  },
  {
    id: "task-3",
    title: "Call SmallBusiness LLC about support contract",
    description: "Discuss renewal terms and potential upgrades",
    dueDate: "May 22, 2023",
    priority: "low",
    related: "SmallBusiness LLC - Support Contract",
    status: "pending",
    isExpanded: false,
    type: "call",
    createdAt: "2023-05-16T14:15:00.000Z"
  },
  {
    id: "task-4",
    title: "Send pricing information to MegaCorp",
    description: "Detail premium tier options and volume discounts",
    dueDate: "May 20, 2023",
    priority: "high",
    related: "MegaCorp - SaaS Subscription",
    status: "completed",
    isExpanded: false,
    type: "email",
    createdAt: "2023-05-15T10:30:00.000Z",
    completedAt: "2023-05-15T16:45:00.000Z"
  },
  {
    id: "task-5",
    title: "Schedule demo with Startup Inc",
    description: "Showcase new features in our platform",
    dueDate: "May 25, 2023",
    priority: "medium",
    related: "Startup Inc - Implementation",
    status: "pending",
    isExpanded: false,
    type: "meeting",
    createdAt: "2023-05-16T09:45:00.000Z"
  }
];

// Mock Activity Logs
export const activityLogs: ActivityLog[] = [
  {
    id: "activity-1",
    type: "contact_created",
    description: "Added John Smith as a new contact",
    timestamp: "2023-05-15T09:30:00.000Z",
    user: "Current User",
    entityId: "contact-1",
    entityType: "contact"
  },
  {
    id: "activity-2",
    type: "deal_created",
    description: "Created new deal: Enterprise Software Package",
    timestamp: "2023-05-15T10:15:00.000Z",
    user: "Current User",
    entityId: "deal-1",
    entityType: "deal"
  },
  {
    id: "activity-3",
    type: "task_created",
    description: "Created follow-up task for John Smith",
    timestamp: "2023-05-15T11:00:00.000Z",
    user: "Current User",
    entityId: "task-1",
    entityType: "task"
  },
  {
    id: "activity-4",
    type: "deal_stage_changed",
    description: "Moved deal 'Consulting Services' to Proposal stage",
    timestamp: "2023-05-16T14:30:00.000Z",
    user: "Current User",
    entityId: "deal-2",
    entityType: "deal",
    metadata: {
      previousStage: "qualified",
      newStage: "proposal"
    }
  },
  {
    id: "activity-5",
    type: "contact_updated",
    description: "Updated contact information for Sarah Johnson",
    timestamp: "2023-05-16T15:45:00.000Z",
    user: "Current User",
    entityId: "contact-2",
    entityType: "contact"
  },
  {
    id: "activity-6",
    type: "task_completed",
    description: "Completed task: Send pricing information to MegaCorp",
    timestamp: "2023-05-17T09:15:00.000Z",
    user: "Current User",
    entityId: "task-4",
    entityType: "task"
  },
  {
    id: "activity-7",
    type: "deal_stage_changed",
    description: "Moved deal 'Hardware Upgrade' to Closed Won stage",
    timestamp: "2023-05-17T13:20:00.000Z",
    user: "Current User",
    entityId: "deal-6",
    entityType: "deal",
    metadata: {
      previousStage: "negotiation",
      newStage: "closed"
    }
  }
];

// Mock Users
export const users: User[] = [
  {
    id: "user-1",
    name: "Current User",
    email: "user@example.com",
    role: "admin",
    avatar: "https://images.unsplash.com/photo-1568602471122-7832951cc4c5?q=80&w=100&h=100&auto=format&fit=crop",
    lastActive: "Online"
  },
  {
    id: "user-2",
    name: "Alex Johnson",
    email: "alex@example.com",
    role: "manager",
    avatar: "https://images.unsplash.com/photo-1535713875002-d1d0cf377fde?q=80&w=100&h=100&auto=format&fit=crop",
    lastActive: "5 min ago"
  },
  {
    id: "user-3",
    name: "Maria Garcia",
    email: "maria@example.com",
    role: "user",
    avatar: "https://images.unsplash.com/photo-1580489944761-15a19d654956?q=80&w=100&h=100&auto=format&fit=crop",
    lastActive: "1 hour ago"
  }
]; 