import { createServerComponentClient } from '@supabase/auth-helpers-nextjs'
import { cookies } from 'next/headers'
import { ensureUserProfile } from './supabase'
import { Database } from '@/types/supabase'

// Helper function to get server supabase client
export function getServerSupabaseClient() {
  return createServerComponentClient<Database>({ cookies });
}

// Helper function to get authenticated user from server
export async function getCurrentUser() {
  try {
    const supabase = getServerSupabaseClient();
    const { data: { session } } = await supabase.auth.getSession();
    
    if (!session) return null;
    
    // Ensure user profile exists
    const user = session.user;
    await ensureUserProfile(user);
    
    return user;
  } catch (error) {
    console.error("Error getting current user in server component:", error);
    return null;
  }
}

// Helper function to get user profile from server
export async function getUserProfile(userId: string) {
  try {
    const supabase = getServerSupabaseClient();
    const { data, error } = await supabase
      .from('profiles')
      .select('*')
      .eq('id', userId)
      .single();
      
    if (error || !data) return null;
    
    return data;
  } catch (error) {
    console.error("Error getting user profile in server component:", error);
    return null;
  }
} 