// Contact type definition
export interface Contact {
  id: string;
  name: string;
  email: string;
  phone: string;
  company: string;
  position: string;
  lastActivity: string;
  status: 'active' | 'inactive';
  notes?: string;
  avatar?: string;
  tags?: string[];
  createdAt?: string;
  updatedAt?: string;
}

// Deal/Opportunity type definition
export interface Deal {
  id: string;
  title: string;
  company: string;
  value: string;
  contact: string;
  stage: 'qualified' | 'proposal' | 'negotiation' | 'closed';
  priority?: 'low' | 'medium' | 'high';
  createdAt?: string;
  updatedAt?: string;
  closedAt?: string;
  description?: string;
  owner?: string;
  notes?: string[];
  documents?: string[];
}

// Task/Activity type definition
export interface Task {
  id: string;
  title: string;
  description?: string;
  dueDate: string;
  priority: 'low' | 'medium' | 'high';
  related: string;
  status: 'pending' | 'completed';
  isExpanded?: boolean;
  assignedTo?: string;
  createdAt?: string;
  updatedAt?: string;
  completedAt?: string;
  type?: 'call' | 'email' | 'meeting' | 'follow-up' | 'other';
}

// Company type definition
export interface Company {
  id: string;
  name: string;
  industry?: string;
  website?: string;
  size?: string;
  location?: string;
  contacts?: string[];
  deals?: string[];
  notes?: string;
  createdAt?: string;
  updatedAt?: string;
  logo?: string;
}

// User type definition
export interface User {
  id: string;
  name: string;
  email: string;
  role: 'admin' | 'user' | 'manager';
  avatar?: string;
  createdAt?: string;
  updatedAt?: string;
  lastActive?: string;
  contacts?: string[];
  deals?: string[];
  tasks?: string[];
}

// Activity Log definition
export interface ActivityLog {
  id: string;
  type: string;
  description: string;
  timestamp: string;
  user: {
    id: string;
    name: string;
    email: string;
    avatar: string;
  };
  relatedId: string;
  relatedType: string;
}

// Pipeline stage definition
export interface PipelineStage {
  id: string;
  title: string;
  color: string;
  order: number;
}

// Dashboard stats type
export interface DashboardStats {
  totalDeals: number;
  totalValue: string;
  activeContacts: number;
  openTasks: number;
  closedDeals: number;
  conversionRate: string;
} 